/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.entity.player;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.BiomeSoundHandler;
import net.minecraft.client.audio.BubbleColumnAmbientSoundHandler;
import net.minecraft.client.audio.ElytraSound;
import net.minecraft.client.audio.IAmbientSoundHandler;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.RidingMinecartTickableSound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.audio.UnderwaterAmbientSoundHandler;
import net.minecraft.client.audio.UnderwaterAmbientSounds;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.gui.screen.CommandBlockScreen;
import net.minecraft.client.gui.screen.EditBookScreen;
import net.minecraft.client.gui.screen.EditMinecartCommandBlockScreen;
import net.minecraft.client.gui.screen.EditSignScreen;
import net.minecraft.client.gui.screen.EditStructureScreen;
import net.minecraft.client.gui.screen.JigsawScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.client.util.ClientRecipeBook;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IJumpingMount;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.entity.item.minecart.AbstractMinecartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.play.client.CAnimateHandPacket;
import net.minecraft.network.play.client.CChatMessagePacket;
import net.minecraft.network.play.client.CClientStatusPacket;
import net.minecraft.network.play.client.CCloseWindowPacket;
import net.minecraft.network.play.client.CEntityActionPacket;
import net.minecraft.network.play.client.CInputPacket;
import net.minecraft.network.play.client.CMarkRecipeSeenPacket;
import net.minecraft.network.play.client.CMoveVehiclePacket;
import net.minecraft.network.play.client.CPlayerAbilitiesPacket;
import net.minecraft.network.play.client.CPlayerDiggingPacket;
import net.minecraft.network.play.client.CPlayerPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.stats.StatisticsManager;
import net.minecraft.tags.FluidTags;
import net.minecraft.tileentity.CommandBlockLogic;
import net.minecraft.tileentity.CommandBlockTileEntity;
import net.minecraft.tileentity.JigsawTileEntity;
import net.minecraft.tileentity.SignTileEntity;
import net.minecraft.tileentity.StructureBlockTileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.MovementInput;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector2f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;

@OnlyIn(value=Dist.CLIENT)
public class ClientPlayerEntity
extends AbstractClientPlayerEntity {
    public final ClientPlayNetHandler field_71174_a;
    private final StatisticsManager field_146108_bO;
    private final ClientRecipeBook field_192036_cb;
    private final List<IAmbientSoundHandler> field_204232_cf = Lists.newArrayList();
    private int field_184845_bX = 0;
    private double field_175172_bI;
    private double field_175166_bJ;
    private double field_175167_bK;
    private float field_175164_bL;
    private float field_175165_bM;
    private boolean field_184841_cd;
    private boolean field_239203_ch_;
    private boolean field_228351_cj_;
    private boolean field_175171_bO;
    private int field_175168_bP;
    private boolean field_175169_bQ;
    private String field_142022_ce;
    public MovementInput field_71158_b;
    protected final Minecraft field_71159_c;
    protected int field_71156_d;
    public int field_71157_e;
    public float field_71154_f;
    public float field_71155_g;
    public float field_71163_h;
    public float field_71164_i;
    private int field_110320_a;
    private float field_110321_bQ;
    public float field_71086_bY;
    public float field_71080_cy;
    private boolean field_184842_cm;
    private Hand field_184843_cn;
    private boolean field_184844_co;
    private boolean field_189811_cr = true;
    private int field_189812_cs;
    private boolean field_189813_ct;
    private int field_203720_cz;
    private boolean field_228352_cx_ = true;

    public ClientPlayerEntity(Minecraft p_i232461_1_, ClientWorld p_i232461_2_, ClientPlayNetHandler p_i232461_3_, StatisticsManager p_i232461_4_, ClientRecipeBook p_i232461_5_, boolean p_i232461_6_, boolean p_i232461_7_) {
        super(p_i232461_2_, p_i232461_3_.func_175105_e());
        this.field_71159_c = p_i232461_1_;
        this.field_71174_a = p_i232461_3_;
        this.field_146108_bO = p_i232461_4_;
        this.field_192036_cb = p_i232461_5_;
        this.field_228351_cj_ = p_i232461_6_;
        this.field_175171_bO = p_i232461_7_;
        this.field_204232_cf.add((IAmbientSoundHandler)new UnderwaterAmbientSoundHandler(this, p_i232461_1_.func_147118_V()));
        this.field_204232_cf.add((IAmbientSoundHandler)new BubbleColumnAmbientSoundHandler(this));
        this.field_204232_cf.add((IAmbientSoundHandler)new BiomeSoundHandler(this, p_i232461_1_.func_147118_V(), p_i232461_2_.func_225523_d_()));
    }

    @Override
    public boolean func_70097_a(DamageSource p_70097_1_, float p_70097_2_) {
        ForgeHooks.onPlayerAttack((LivingEntity)this, (DamageSource)p_70097_1_, (float)p_70097_2_);
        return false;
    }

    @Override
    public void func_70691_i(float p_70691_1_) {
    }

    @Override
    public boolean func_184205_a(Entity p_184205_1_, boolean p_184205_2_) {
        if (!super.func_184205_a(p_184205_1_, p_184205_2_)) {
            return false;
        }
        if (p_184205_1_ instanceof AbstractMinecartEntity) {
            this.field_71159_c.func_147118_V().func_147682_a((ISound)new RidingMinecartTickableSound((PlayerEntity)this, (AbstractMinecartEntity)p_184205_1_));
        }
        if (p_184205_1_ instanceof BoatEntity) {
            this.field_70126_B = p_184205_1_.field_70177_z;
            this.field_70177_z = p_184205_1_.field_70177_z;
            this.func_70034_d(p_184205_1_.field_70177_z);
        }
        return true;
    }

    @Override
    public void func_233575_bb_() {
        super.func_233575_bb_();
        this.field_184844_co = false;
    }

    @Override
    public float func_195050_f(float p_195050_1_) {
        return this.field_70125_A;
    }

    @Override
    public float func_195046_g(float p_195046_1_) {
        return this.func_184218_aH() ? super.func_195046_g(p_195046_1_) : this.field_70177_z;
    }

    @Override
    public void func_70071_h_() {
        if (this.field_70170_p.func_175667_e(new BlockPos(this.func_226277_ct_(), 0.0, this.func_226281_cx_()))) {
            super.func_70071_h_();
            if (this.func_184218_aH()) {
                this.field_71174_a.func_147297_a(new CPlayerPacket.RotationPacket(this.field_70177_z, this.field_70125_A, this.field_70122_E));
                this.field_71174_a.func_147297_a((IPacket<?>)new CInputPacket(this.field_70702_br, this.field_191988_bg, this.field_71158_b.field_78901_c, this.field_71158_b.field_228350_h_));
                Entity entity = this.func_184208_bv();
                if (entity != this && entity.func_184186_bw()) {
                    this.field_71174_a.func_147297_a((IPacket<?>)new CMoveVehiclePacket(entity));
                }
            } else {
                this.func_175161_p();
            }
            for (IAmbientSoundHandler iambientsoundhandler : this.field_204232_cf) {
                iambientsoundhandler.func_204253_a();
            }
        }
    }

    public float func_239206_w_() {
        for (IAmbientSoundHandler iambientsoundhandler : this.field_204232_cf) {
            if (!(iambientsoundhandler instanceof BiomeSoundHandler)) continue;
            return ((BiomeSoundHandler)iambientsoundhandler).func_239523_b_();
        }
        return 0.0f;
    }

    private void func_175161_p() {
        boolean flag3;
        boolean flag = this.func_70051_ag();
        if (flag != this.field_175171_bO) {
            CEntityActionPacket.Action centityactionpacket$action = flag ? CEntityActionPacket.Action.START_SPRINTING : CEntityActionPacket.Action.STOP_SPRINTING;
            this.field_71174_a.func_147297_a((IPacket<?>)new CEntityActionPacket((Entity)this, centityactionpacket$action));
            this.field_175171_bO = flag;
        }
        if ((flag3 = this.func_225608_bj_()) != this.field_228351_cj_) {
            CEntityActionPacket.Action centityactionpacket$action1 = flag3 ? CEntityActionPacket.Action.PRESS_SHIFT_KEY : CEntityActionPacket.Action.RELEASE_SHIFT_KEY;
            this.field_71174_a.func_147297_a((IPacket<?>)new CEntityActionPacket((Entity)this, centityactionpacket$action1));
            this.field_228351_cj_ = flag3;
        }
        if (this.func_175160_A()) {
            boolean flag2;
            double d4 = this.func_226277_ct_() - this.field_175172_bI;
            double d0 = this.func_226278_cu_() - this.field_175166_bJ;
            double d1 = this.func_226281_cx_() - this.field_175167_bK;
            double d2 = this.field_70177_z - this.field_175164_bL;
            double d3 = this.field_70125_A - this.field_175165_bM;
            ++this.field_175168_bP;
            boolean flag1 = d4 * d4 + d0 * d0 + d1 * d1 > 9.0E-4 || this.field_175168_bP >= 20;
            boolean bl = flag2 = d2 != 0.0 || d3 != 0.0;
            if (this.func_184218_aH()) {
                Vector3d vector3d = this.func_213322_ci();
                this.field_71174_a.func_147297_a(new CPlayerPacket.PositionRotationPacket(vector3d.field_72450_a, -999.0, vector3d.field_72449_c, this.field_70177_z, this.field_70125_A, this.field_70122_E));
                flag1 = false;
            } else if (flag1 && flag2) {
                this.field_71174_a.func_147297_a(new CPlayerPacket.PositionRotationPacket(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.field_70177_z, this.field_70125_A, this.field_70122_E));
            } else if (flag1) {
                this.field_71174_a.func_147297_a(new CPlayerPacket.PositionPacket(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.field_70122_E));
            } else if (flag2) {
                this.field_71174_a.func_147297_a(new CPlayerPacket.RotationPacket(this.field_70177_z, this.field_70125_A, this.field_70122_E));
            } else if (this.field_184841_cd != this.field_70122_E) {
                this.field_71174_a.func_147297_a(new CPlayerPacket(this.field_70122_E));
            }
            if (flag1) {
                this.field_175172_bI = this.func_226277_ct_();
                this.field_175166_bJ = this.func_226278_cu_();
                this.field_175167_bK = this.func_226281_cx_();
                this.field_175168_bP = 0;
            }
            if (flag2) {
                this.field_175164_bL = this.field_70177_z;
                this.field_175165_bM = this.field_70125_A;
            }
            this.field_184841_cd = this.field_70122_E;
            this.field_189811_cr = this.field_71159_c.field_71474_y.field_189989_R;
        }
    }

    @Override
    public boolean func_225609_n_(boolean p_225609_1_) {
        CPlayerDiggingPacket.Action cplayerdiggingpacket$action = p_225609_1_ ? CPlayerDiggingPacket.Action.DROP_ALL_ITEMS : CPlayerDiggingPacket.Action.DROP_ITEM;
        this.field_71174_a.func_147297_a((IPacket<?>)new CPlayerDiggingPacket(cplayerdiggingpacket$action, BlockPos.field_177992_a, Direction.DOWN));
        return this.field_71071_by.func_70298_a(this.field_71071_by.field_70461_c, p_225609_1_ && !this.field_71071_by.func_70448_g().func_190926_b() ? this.field_71071_by.func_70448_g().func_190916_E() : 1) != ItemStack.field_190927_a;
    }

    public void func_71165_d(String p_71165_1_) {
        this.field_71174_a.func_147297_a(new CChatMessagePacket(p_71165_1_));
    }

    @Override
    public void func_184609_a(Hand p_184609_1_) {
        super.func_184609_a(p_184609_1_);
        this.field_71174_a.func_147297_a((IPacket<?>)new CAnimateHandPacket(p_184609_1_));
    }

    @Override
    public void func_71004_bE() {
        this.field_71174_a.func_147297_a((IPacket<?>)new CClientStatusPacket(CClientStatusPacket.State.PERFORM_RESPAWN));
    }

    @Override
    protected void func_70665_d(DamageSource p_70665_1_, float p_70665_2_) {
        if (!this.func_180431_b(p_70665_1_)) {
            this.func_70606_j(this.func_110143_aJ() - p_70665_2_);
        }
    }

    @Override
    public void func_71053_j() {
        this.field_71174_a.func_147297_a(new CCloseWindowPacket(this.field_71070_bA.field_75152_c));
        this.func_175159_q();
    }

    public void func_175159_q() {
        this.field_71071_by.func_70437_b(ItemStack.field_190927_a);
        super.func_71053_j();
        this.field_71159_c.func_147108_a(null);
    }

    public void func_71150_b(float p_71150_1_) {
        if (this.field_175169_bQ) {
            float f = this.func_110143_aJ() - p_71150_1_;
            if (f <= 0.0f) {
                this.func_70606_j(p_71150_1_);
                if (f < 0.0f) {
                    this.field_70172_ad = 10;
                }
            } else {
                this.field_110153_bc = f;
                this.func_70606_j(this.func_110143_aJ());
                this.field_70172_ad = 20;
                this.func_70665_d(DamageSource.field_76377_j, f);
                this.field_70737_aN = this.field_70738_aO = 10;
            }
        } else {
            this.func_70606_j(p_71150_1_);
            this.field_175169_bQ = true;
        }
    }

    @Override
    public void func_71016_p() {
        this.field_71174_a.func_147297_a((IPacket<?>)new CPlayerAbilitiesPacket(this.field_71075_bZ));
    }

    @Override
    public boolean func_175144_cb() {
        return true;
    }

    @Override
    public boolean func_230491_ea_() {
        return !this.field_71075_bZ.field_75100_b && super.func_230491_ea_();
    }

    @Override
    public boolean func_230269_aK_() {
        return !this.field_71075_bZ.field_75100_b && super.func_230269_aK_();
    }

    @Override
    public boolean func_230490_cK_() {
        return !this.field_71075_bZ.field_75100_b && super.func_230490_cK_();
    }

    protected void func_110318_g() {
        this.field_71174_a.func_147297_a((IPacket<?>)new CEntityActionPacket((Entity)this, CEntityActionPacket.Action.START_RIDING_JUMP, MathHelper.func_76141_d((float)(this.func_110319_bJ() * 100.0f))));
    }

    public void func_175163_u() {
        this.field_71174_a.func_147297_a((IPacket<?>)new CEntityActionPacket((Entity)this, CEntityActionPacket.Action.OPEN_INVENTORY));
    }

    public void func_175158_f(String p_175158_1_) {
        this.field_142022_ce = p_175158_1_;
    }

    public String func_142021_k() {
        return this.field_142022_ce;
    }

    public StatisticsManager func_146107_m() {
        return this.field_146108_bO;
    }

    public ClientRecipeBook func_199507_B() {
        return this.field_192036_cb;
    }

    public void func_193103_a(IRecipe<?> p_193103_1_) {
        if (this.field_192036_cb.func_194076_e(p_193103_1_)) {
            this.field_192036_cb.func_194074_f(p_193103_1_);
            this.field_71174_a.func_147297_a((IPacket<?>)new CMarkRecipeSeenPacket(p_193103_1_));
        }
    }

    @Override
    protected int func_184840_I() {
        return this.field_184845_bX;
    }

    public void func_184839_n(int p_184839_1_) {
        this.field_184845_bX = p_184839_1_;
    }

    @Override
    public void func_146105_b(ITextComponent p_146105_1_, boolean p_146105_2_) {
        if (p_146105_2_) {
            this.field_71159_c.field_71456_v.func_175188_a(p_146105_1_, false);
        } else {
            this.field_71159_c.field_71456_v.func_146158_b().func_146227_a(p_146105_1_);
        }
    }

    private void func_244389_i(double p_244389_1_, double p_244389_3_) {
        BlockPos blockpos = new BlockPos(p_244389_1_, this.func_226278_cu_(), p_244389_3_);
        if (this.func_205027_h(blockpos)) {
            Direction[] adirection;
            double d0 = p_244389_1_ - (double)blockpos.func_177958_n();
            double d1 = p_244389_3_ - (double)blockpos.func_177952_p();
            Direction direction = null;
            double d2 = Double.MAX_VALUE;
            for (Direction direction1 : adirection = new Direction[]{Direction.WEST, Direction.EAST, Direction.NORTH, Direction.SOUTH}) {
                double d4;
                double d3 = direction1.func_176740_k().func_196051_a(d0, 0.0, d1);
                double d = d4 = direction1.func_176743_c() == Direction.AxisDirection.POSITIVE ? 1.0 - d3 : d3;
                if (!(d4 < d2) || this.func_205027_h(blockpos.func_177972_a(direction1))) continue;
                d2 = d4;
                direction = direction1;
            }
            if (direction != null) {
                Vector3d vector3d = this.func_213322_ci();
                if (direction.func_176740_k() == Direction.Axis.X) {
                    this.func_213293_j(0.1 * (double)direction.func_82601_c(), vector3d.field_72448_b, vector3d.field_72449_c);
                } else {
                    this.func_213293_j(vector3d.field_72450_a, vector3d.field_72448_b, 0.1 * (double)direction.func_82599_e());
                }
            }
        }
    }

    private boolean func_205027_h(BlockPos p_205027_1_) {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        AxisAlignedBB axisalignedbb1 = new AxisAlignedBB(p_205027_1_.func_177958_n(), axisalignedbb.field_72338_b, p_205027_1_.func_177952_p(), (double)p_205027_1_.func_177958_n() + 1.0, axisalignedbb.field_72337_e, (double)p_205027_1_.func_177952_p() + 1.0).func_186664_h(1.0E-7);
        return !this.field_70170_p.func_242405_a(this, axisalignedbb1, (p_243494_1_, p_243494_2_) -> p_243494_1_.func_229980_m_((IBlockReader)((Object)this.field_70170_p), (BlockPos)p_243494_2_));
    }

    @Override
    public void func_70031_b(boolean p_70031_1_) {
        super.func_70031_b(p_70031_1_);
        this.field_71157_e = 0;
    }

    public void func_71152_a(float p_71152_1_, int p_71152_2_, int p_71152_3_) {
        this.field_71106_cc = p_71152_1_;
        this.field_71067_cb = p_71152_2_;
        this.field_71068_ca = p_71152_3_;
    }

    @Override
    public void func_145747_a(ITextComponent p_145747_1_, UUID p_145747_2_) {
        this.field_71159_c.field_71456_v.func_146158_b().func_146227_a(p_145747_1_);
    }

    @Override
    public void func_70103_a(byte p_70103_1_) {
        if (p_70103_1_ >= 24 && p_70103_1_ <= 28) {
            this.func_184839_n(p_70103_1_ - 24);
        } else {
            super.func_70103_a(p_70103_1_);
        }
    }

    public void func_228355_a_(boolean p_228355_1_) {
        this.field_228352_cx_ = p_228355_1_;
    }

    public boolean func_228353_F_() {
        return this.field_228352_cx_;
    }

    @Override
    public void func_184185_a(SoundEvent p_184185_1_, float p_184185_2_, float p_184185_3_) {
        PlaySoundAtEntityEvent event = ForgeEventFactory.onPlaySoundAtEntity((Entity)this, (SoundEvent)p_184185_1_, (SoundCategory)this.func_184176_by(), (float)p_184185_2_, (float)p_184185_3_);
        if (event.isCanceled() || event.getSound() == null) {
            return;
        }
        p_184185_1_ = event.getSound();
        p_184185_2_ = event.getVolume();
        p_184185_3_ = event.getPitch();
        this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), p_184185_1_, this.func_184176_by(), p_184185_2_, p_184185_3_, false);
    }

    @Override
    public void func_213823_a(SoundEvent p_213823_1_, SoundCategory p_213823_2_, float p_213823_3_, float p_213823_4_) {
        this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), p_213823_1_, p_213823_2_, p_213823_3_, p_213823_4_, false);
    }

    @Override
    public boolean func_70613_aW() {
        return true;
    }

    @Override
    public void func_184598_c(Hand p_184598_1_) {
        ItemStack itemstack = this.func_184586_b(p_184598_1_);
        if (!itemstack.func_190926_b() && !this.func_184587_cr()) {
            super.func_184598_c(p_184598_1_);
            this.field_184842_cm = true;
            this.field_184843_cn = p_184598_1_;
        }
    }

    @Override
    public boolean func_184587_cr() {
        return this.field_184842_cm;
    }

    @Override
    public void func_184602_cy() {
        super.func_184602_cy();
        this.field_184842_cm = false;
    }

    @Override
    public Hand func_184600_cs() {
        return this.field_184843_cn;
    }

    @Override
    public void func_184206_a(DataParameter<?> p_184206_1_) {
        super.func_184206_a(p_184206_1_);
        if (field_184621_as.equals(p_184206_1_)) {
            Hand hand;
            boolean flag = ((Byte)this.field_70180_af.func_187225_a(field_184621_as) & 1) > 0;
            Hand hand2 = hand = ((Byte)this.field_70180_af.func_187225_a(field_184621_as) & 2) > 0 ? Hand.OFF_HAND : Hand.MAIN_HAND;
            if (flag && !this.field_184842_cm) {
                this.func_184598_c(hand);
            } else if (!flag && this.field_184842_cm) {
                this.func_184602_cy();
            }
        }
        if (field_184240_ax.equals(p_184206_1_) && this.func_184613_cA() && !this.field_189813_ct) {
            this.field_71159_c.func_147118_V().func_147682_a((ISound)new ElytraSound(this));
        }
    }

    public boolean func_110317_t() {
        Entity entity = this.func_184187_bx();
        return this.func_184218_aH() && entity instanceof IJumpingMount && ((IJumpingMount)entity).func_184776_b();
    }

    public float func_110319_bJ() {
        return this.field_110321_bQ;
    }

    @Override
    public void func_175141_a(SignTileEntity p_175141_1_) {
        this.field_71159_c.func_147108_a((Screen)new EditSignScreen(p_175141_1_));
    }

    @Override
    public void func_184809_a(CommandBlockLogic p_184809_1_) {
        this.field_71159_c.func_147108_a((Screen)new EditMinecartCommandBlockScreen(p_184809_1_));
    }

    @Override
    public void func_184824_a(CommandBlockTileEntity p_184824_1_) {
        this.field_71159_c.func_147108_a((Screen)new CommandBlockScreen(p_184824_1_));
    }

    @Override
    public void func_189807_a(StructureBlockTileEntity p_189807_1_) {
        this.field_71159_c.func_147108_a((Screen)new EditStructureScreen(p_189807_1_));
    }

    @Override
    public void func_213826_a(JigsawTileEntity p_213826_1_) {
        this.field_71159_c.func_147108_a((Screen)new JigsawScreen(p_213826_1_));
    }

    @Override
    public void func_184814_a(ItemStack p_184814_1_, Hand p_184814_2_) {
        Item item = p_184814_1_.func_77973_b();
        if (item == Items.field_151099_bA) {
            this.field_71159_c.func_147108_a((Screen)new EditBookScreen((PlayerEntity)this, p_184814_1_, p_184814_2_));
        }
    }

    @Override
    public void func_71009_b(Entity p_71009_1_) {
        this.field_71159_c.field_71452_i.func_199282_a(p_71009_1_, (IParticleData)ParticleTypes.field_197614_g);
    }

    @Override
    public void func_71047_c(Entity p_71047_1_) {
        this.field_71159_c.field_71452_i.func_199282_a(p_71047_1_, (IParticleData)ParticleTypes.field_197622_o);
    }

    @Override
    public boolean func_225608_bj_() {
        return this.field_71158_b != null && this.field_71158_b.field_228350_h_;
    }

    @Override
    public boolean func_213453_ef() {
        return this.field_239203_ch_;
    }

    public boolean func_228354_I_() {
        return this.func_213453_ef() || this.func_213300_bk();
    }

    @Override
    public void func_70626_be() {
        super.func_70626_be();
        if (this.func_175160_A()) {
            this.field_70702_br = this.field_71158_b.field_78902_a;
            this.field_191988_bg = this.field_71158_b.field_192832_b;
            this.field_70703_bu = this.field_71158_b.field_78901_c;
            this.field_71163_h = this.field_71154_f;
            this.field_71164_i = this.field_71155_g;
            this.field_71155_g = (float)((double)this.field_71155_g + (double)(this.field_70125_A - this.field_71155_g) * 0.5);
            this.field_71154_f = (float)((double)this.field_71154_f + (double)(this.field_70177_z - this.field_71154_f) * 0.5);
        }
    }

    protected boolean func_175160_A() {
        return this.field_71159_c.func_175606_aa() == this;
    }

    @Override
    public void func_70636_d() {
        ItemStack itemstack;
        boolean flag4;
        ++this.field_71157_e;
        if (this.field_71156_d > 0) {
            --this.field_71156_d;
        }
        this.func_213839_ed();
        boolean flag = this.field_71158_b.field_78901_c;
        boolean flag1 = this.field_71158_b.field_228350_h_;
        boolean flag2 = this.func_223110_ee();
        this.field_239203_ch_ = !this.field_71075_bZ.field_75100_b && !this.func_203007_ba() && this.func_213298_c(Pose.CROUCHING) && (this.func_225608_bj_() || !this.func_70608_bn() && !this.func_213298_c(Pose.STANDING));
        this.field_71158_b.func_225607_a_(this.func_228354_I_());
        ForgeHooksClient.onInputUpdate((PlayerEntity)this, (MovementInput)this.field_71158_b);
        this.field_71159_c.func_193032_ao().func_193293_a(this.field_71158_b);
        if (this.func_184587_cr() && !this.func_184218_aH()) {
            this.field_71158_b.field_78902_a *= 0.2f;
            this.field_71158_b.field_192832_b *= 0.2f;
            this.field_71156_d = 0;
        }
        boolean flag3 = false;
        if (this.field_189812_cs > 0) {
            --this.field_189812_cs;
            flag3 = true;
            this.field_71158_b.field_78901_c = true;
        }
        if (!this.field_70145_X) {
            this.func_244389_i(this.func_226277_ct_() - (double)this.func_213311_cf() * 0.35, this.func_226281_cx_() + (double)this.func_213311_cf() * 0.35);
            this.func_244389_i(this.func_226277_ct_() - (double)this.func_213311_cf() * 0.35, this.func_226281_cx_() - (double)this.func_213311_cf() * 0.35);
            this.func_244389_i(this.func_226277_ct_() + (double)this.func_213311_cf() * 0.35, this.func_226281_cx_() - (double)this.func_213311_cf() * 0.35);
            this.func_244389_i(this.func_226277_ct_() + (double)this.func_213311_cf() * 0.35, this.func_226281_cx_() + (double)this.func_213311_cf() * 0.35);
        }
        if (flag1) {
            this.field_71156_d = 0;
        }
        boolean bl = flag4 = (float)this.func_71024_bL().func_75116_a() > 6.0f || this.field_71075_bZ.field_75101_c;
        if (!(!this.field_70122_E && !this.func_204231_K() || flag1 || flag2 || !this.func_223110_ee() || this.func_70051_ag() || !flag4 || this.func_184587_cr() || this.func_70644_a(Effects.field_76440_q))) {
            if (this.field_71156_d <= 0 && !this.field_71159_c.field_71474_y.field_151444_V.func_151470_d()) {
                this.field_71156_d = 7;
            } else {
                this.func_70031_b(true);
            }
        }
        if (!this.func_70051_ag() && (!this.func_70090_H() || this.func_204231_K()) && this.func_223110_ee() && flag4 && !this.func_184587_cr() && !this.func_70644_a(Effects.field_76440_q) && this.field_71159_c.field_71474_y.field_151444_V.func_151470_d()) {
            this.func_70031_b(true);
        }
        if (this.func_70051_ag()) {
            boolean flag6;
            boolean flag5 = !this.field_71158_b.func_223135_b() || !flag4;
            boolean bl2 = flag6 = flag5 || this.field_70123_F || this.func_70090_H() && !this.func_204231_K();
            if (this.func_203007_ba()) {
                if (!this.field_70122_E && !this.field_71158_b.field_228350_h_ && flag5 || !this.func_70090_H()) {
                    this.func_70031_b(false);
                }
            } else if (flag6) {
                this.func_70031_b(false);
            }
        }
        boolean flag7 = false;
        if (this.field_71075_bZ.field_75101_c) {
            if (this.field_71159_c.field_71442_b.func_178887_k()) {
                if (!this.field_71075_bZ.field_75100_b) {
                    this.field_71075_bZ.field_75100_b = true;
                    flag7 = true;
                    this.func_71016_p();
                }
            } else if (!flag && this.field_71158_b.field_78901_c && !flag3) {
                if (this.field_71101_bC == 0) {
                    this.field_71101_bC = 7;
                } else if (!this.func_203007_ba()) {
                    this.field_71075_bZ.field_75100_b = !this.field_71075_bZ.field_75100_b;
                    flag7 = true;
                    this.func_71016_p();
                    this.field_71101_bC = 0;
                }
            }
        }
        if (this.field_71158_b.field_78901_c && !flag7 && !flag && !this.field_71075_bZ.field_75100_b && !this.func_184218_aH() && !this.func_70617_f_() && (itemstack = this.func_184582_a(EquipmentSlotType.CHEST)).canElytraFly(this) && this.func_226566_ei_()) {
            this.field_71174_a.func_147297_a((IPacket<?>)new CEntityActionPacket((Entity)this, CEntityActionPacket.Action.START_FALL_FLYING));
        }
        this.field_189813_ct = this.func_184613_cA();
        if (this.func_70090_H() && this.field_71158_b.field_228350_h_ && this.func_241208_cS_()) {
            this.func_203010_cG();
        }
        if (this.func_208600_a(FluidTags.field_206959_a)) {
            int i = this.func_175149_v() ? 10 : 1;
            this.field_203720_cz = MathHelper.func_76125_a((int)(this.field_203720_cz + i), (int)0, (int)600);
        } else if (this.field_203720_cz > 0) {
            this.func_208600_a(FluidTags.field_206959_a);
            this.field_203720_cz = MathHelper.func_76125_a((int)(this.field_203720_cz - 10), (int)0, (int)600);
        }
        if (this.field_71075_bZ.field_75100_b && this.func_175160_A()) {
            int j = 0;
            if (this.field_71158_b.field_228350_h_) {
                --j;
            }
            if (this.field_71158_b.field_78901_c) {
                ++j;
            }
            if (j != 0) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, (float)j * this.field_71075_bZ.func_75093_a() * 3.0f, 0.0));
            }
        }
        if (this.func_110317_t()) {
            IJumpingMount ijumpingmount = (IJumpingMount)this.func_184187_bx();
            if (this.field_110320_a < 0) {
                ++this.field_110320_a;
                if (this.field_110320_a == 0) {
                    this.field_110321_bQ = 0.0f;
                }
            }
            if (flag && !this.field_71158_b.field_78901_c) {
                this.field_110320_a = -10;
                ijumpingmount.func_110206_u(MathHelper.func_76141_d((float)(this.func_110319_bJ() * 100.0f)));
                this.func_110318_g();
            } else if (!flag && this.field_71158_b.field_78901_c) {
                this.field_110320_a = 0;
                this.field_110321_bQ = 0.0f;
            } else if (flag) {
                ++this.field_110320_a;
                this.field_110321_bQ = this.field_110320_a < 10 ? (float)this.field_110320_a * 0.1f : 0.8f + 2.0f / (float)(this.field_110320_a - 9) * 0.1f;
            }
        } else {
            this.field_110321_bQ = 0.0f;
        }
        super.func_70636_d();
        if (this.field_70122_E && this.field_71075_bZ.field_75100_b && !this.field_71159_c.field_71442_b.func_178887_k()) {
            this.field_71075_bZ.field_75100_b = false;
            this.func_71016_p();
        }
    }

    private void func_213839_ed() {
        this.field_71080_cy = this.field_71086_bY;
        if (this.field_71087_bX) {
            if (this.field_71159_c.field_71462_r != null && !this.field_71159_c.field_71462_r.func_231177_au__()) {
                if (this.field_71159_c.field_71462_r instanceof ContainerScreen) {
                    this.func_71053_j();
                }
                this.field_71159_c.func_147108_a(null);
            }
            if (this.field_71086_bY == 0.0f) {
                this.field_71159_c.func_147118_V().func_147682_a((ISound)SimpleSound.func_239532_b_((SoundEvent)SoundEvents.field_187814_ei, (float)(this.field_70146_Z.nextFloat() * 0.4f + 0.8f), (float)0.25f));
            }
            this.field_71086_bY += 0.0125f;
            if (this.field_71086_bY >= 1.0f) {
                this.field_71086_bY = 1.0f;
            }
            this.field_71087_bX = false;
        } else if (this.func_70644_a(Effects.field_76431_k) && this.func_70660_b(Effects.field_76431_k).func_76459_b() > 60) {
            this.field_71086_bY += 0.006666667f;
            if (this.field_71086_bY > 1.0f) {
                this.field_71086_bY = 1.0f;
            }
        } else {
            if (this.field_71086_bY > 0.0f) {
                this.field_71086_bY -= 0.05f;
            }
            if (this.field_71086_bY < 0.0f) {
                this.field_71086_bY = 0.0f;
            }
        }
        this.func_184173_H();
    }

    @Override
    public void func_70098_U() {
        super.func_70098_U();
        this.field_184844_co = false;
        if (this.func_184187_bx() instanceof BoatEntity) {
            BoatEntity boatentity = (BoatEntity)this.func_184187_bx();
            boatentity.func_184442_a(this.field_71158_b.field_187257_e, this.field_71158_b.field_187258_f, this.field_71158_b.field_187255_c, this.field_71158_b.field_187256_d);
            this.field_184844_co |= this.field_71158_b.field_187257_e || this.field_71158_b.field_187258_f || this.field_71158_b.field_187255_c || this.field_71158_b.field_187256_d;
        }
    }

    public boolean func_184838_M() {
        return this.field_184844_co;
    }

    @Override
    @Nullable
    public EffectInstance func_184596_c(@Nullable Effect p_184596_1_) {
        if (p_184596_1_ == Effects.field_76431_k) {
            this.field_71080_cy = 0.0f;
            this.field_71086_bY = 0.0f;
        }
        return super.func_184596_c(p_184596_1_);
    }

    @Override
    public void func_213315_a(MoverType p_213315_1_, Vector3d p_213315_2_) {
        double d0 = this.func_226277_ct_();
        double d1 = this.func_226281_cx_();
        super.func_213315_a(p_213315_1_, p_213315_2_);
        this.func_189810_i((float)(this.func_226277_ct_() - d0), (float)(this.func_226281_cx_() - d1));
    }

    public boolean func_189809_N() {
        return this.field_189811_cr;
    }

    protected void func_189810_i(float p_189810_1_, float p_189810_2_) {
        if (this.func_228356_eG_()) {
            Vector3d vector3d = this.func_213303_ch();
            Vector3d vector3d1 = vector3d.func_72441_c(p_189810_1_, 0.0, p_189810_2_);
            Vector3d vector3d2 = new Vector3d(p_189810_1_, 0.0, p_189810_2_);
            float f = this.func_70689_ay();
            float f1 = (float)vector3d2.func_189985_c();
            if (f1 <= 0.001f) {
                Vector2f vector2f = this.field_71158_b.func_190020_b();
                float f2 = f * vector2f.field_189982_i;
                float f3 = f * vector2f.field_189983_j;
                float f4 = MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180)));
                float f5 = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)));
                vector3d2 = new Vector3d(f2 * f5 - f3 * f4, vector3d2.field_72448_b, f3 * f5 + f2 * f4);
                f1 = (float)vector3d2.func_189985_c();
                if (f1 <= 0.001f) {
                    return;
                }
            }
            float f12 = MathHelper.func_226165_i_((float)f1);
            Vector3d vector3d12 = vector3d2.func_186678_a(f12);
            Vector3d vector3d13 = this.func_189651_aD();
            float f13 = (float)(vector3d13.field_72450_a * vector3d12.field_72450_a + vector3d13.field_72449_c * vector3d12.field_72449_c);
            if (!(f13 < -0.15f)) {
                BlockState blockstate1;
                ISelectionContext iselectioncontext = ISelectionContext.func_216374_a(this);
                BlockPos blockpos = new BlockPos(this.func_226277_ct_(), this.func_174813_aQ().field_72337_e, this.func_226281_cx_());
                BlockState blockstate = this.field_70170_p.func_180495_p(blockpos);
                if (blockstate.func_215685_b((IBlockReader)((Object)this.field_70170_p), blockpos, iselectioncontext).func_197766_b() && (blockstate1 = this.field_70170_p.func_180495_p(blockpos = blockpos.func_177984_a())).func_215685_b((IBlockReader)((Object)this.field_70170_p), blockpos, iselectioncontext).func_197766_b()) {
                    float f14;
                    float f6 = 7.0f;
                    float f7 = 1.2f;
                    if (this.func_70644_a(Effects.field_76430_j)) {
                        f7 += (float)(this.func_70660_b(Effects.field_76430_j).func_76458_c() + 1) * 0.75f;
                    }
                    float f8 = Math.max(f * 7.0f, 1.0f / f12);
                    Vector3d vector3d4 = vector3d1.func_178787_e(vector3d12.func_186678_a(f8));
                    float f9 = this.func_213311_cf();
                    float f10 = this.func_213302_cg();
                    AxisAlignedBB axisalignedbb = new AxisAlignedBB(vector3d, vector3d4.func_72441_c(0.0, f10, 0.0)).func_72314_b(f9, 0.0, f9);
                    Vector3d lvt_19_1_ = vector3d.func_72441_c(0.0, 0.51f, 0.0);
                    vector3d4 = vector3d4.func_72441_c(0.0, 0.51f, 0.0);
                    Vector3d vector3d5 = vector3d12.func_72431_c(new Vector3d(0.0, 1.0, 0.0));
                    Vector3d vector3d6 = vector3d5.func_186678_a(f9 * 0.5f);
                    Vector3d vector3d7 = lvt_19_1_.func_178788_d(vector3d6);
                    Vector3d vector3d8 = vector3d4.func_178788_d(vector3d6);
                    Vector3d vector3d9 = lvt_19_1_.func_178787_e(vector3d6);
                    Vector3d vector3d10 = vector3d4.func_178787_e(vector3d6);
                    Iterator iterator = this.field_70170_p.func_234867_d_(this, axisalignedbb, p_239205_0_ -> true).flatMap(p_212329_0_ -> p_212329_0_.func_197756_d().stream()).iterator();
                    float f11 = Float.MIN_VALUE;
                    while (iterator.hasNext()) {
                        AxisAlignedBB axisalignedbb1 = (AxisAlignedBB)iterator.next();
                        if (!axisalignedbb1.func_189973_a(vector3d7, vector3d8) && !axisalignedbb1.func_189973_a(vector3d9, vector3d10)) continue;
                        f11 = (float)axisalignedbb1.field_72337_e;
                        Vector3d vector3d11 = axisalignedbb1.func_189972_c();
                        BlockPos blockpos1 = new BlockPos(vector3d11);
                        int i = 1;
                        while ((float)i < f7) {
                            BlockState blockstate3;
                            BlockPos blockpos2 = blockpos1.func_177981_b(i);
                            BlockState blockstate2 = this.field_70170_p.func_180495_p(blockpos2);
                            VoxelShape voxelshape = blockstate2.func_215685_b((IBlockReader)((Object)this.field_70170_p), blockpos2, iselectioncontext);
                            if (!voxelshape.func_197766_b() && (double)(f11 = (float)voxelshape.func_197758_c(Direction.Axis.Y) + (float)blockpos2.func_177956_o()) - this.func_226278_cu_() > (double)f7) {
                                return;
                            }
                            if (i > 1 && !(blockstate3 = this.field_70170_p.func_180495_p(blockpos = blockpos.func_177984_a())).func_215685_b((IBlockReader)((Object)this.field_70170_p), blockpos, iselectioncontext).func_197766_b()) {
                                return;
                            }
                            ++i;
                        }
                        break block0;
                    }
                    if (f11 != Float.MIN_VALUE && !((f14 = (float)((double)f11 - this.func_226278_cu_())) <= 0.5f) && !(f14 > f7)) {
                        this.field_189812_cs = 1;
                    }
                }
            }
        }
    }

    private boolean func_228356_eG_() {
        return this.func_189809_N() && this.field_189812_cs <= 0 && this.field_70122_E && !this.func_226565_dV_() && !this.func_184218_aH() && this.func_228357_eH_() && (double)this.func_226269_ah_() >= 1.0;
    }

    private boolean func_228357_eH_() {
        Vector2f vector2f = this.field_71158_b.func_190020_b();
        return vector2f.field_189982_i != 0.0f || vector2f.field_189983_j != 0.0f;
    }

    private boolean func_223110_ee() {
        double d0 = 0.8;
        return this.func_204231_K() ? this.field_71158_b.func_223135_b() : (double)this.field_71158_b.field_192832_b >= 0.8;
    }

    public float func_203719_J() {
        if (!this.func_208600_a(FluidTags.field_206959_a)) {
            return 0.0f;
        }
        float f = 600.0f;
        float f1 = 100.0f;
        if ((float)this.field_203720_cz >= 600.0f) {
            return 1.0f;
        }
        float f2 = MathHelper.func_76131_a((float)((float)this.field_203720_cz / 100.0f), (float)0.0f, (float)1.0f);
        float f3 = (float)this.field_203720_cz < 100.0f ? 0.0f : MathHelper.func_76131_a((float)(((float)this.field_203720_cz - 100.0f) / 500.0f), (float)0.0f, (float)1.0f);
        return f2 * 0.6f + f3 * 0.39999998f;
    }

    @Override
    public boolean func_204231_K() {
        return this.field_204230_bP;
    }

    @Override
    protected boolean func_204229_de() {
        boolean flag = this.field_204230_bP;
        boolean flag1 = super.func_204229_de();
        if (this.func_175149_v()) {
            return this.field_204230_bP;
        }
        if (!flag && flag1) {
            this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_204326_e, SoundCategory.AMBIENT, 1.0f, 1.0f, false);
            this.field_71159_c.func_147118_V().func_147682_a((ISound)new UnderwaterAmbientSounds.UnderWaterSound(this));
        }
        if (flag && !flag1) {
            this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_204327_f, SoundCategory.AMBIENT, 1.0f, 1.0f, false);
        }
        return this.field_204230_bP;
    }

    @Override
    public Vector3d func_241843_o(float p_241843_1_) {
        if (this.field_71159_c.field_71474_y.func_243230_g().func_243192_a()) {
            float f = MathHelper.func_219799_g((float)(p_241843_1_ * 0.5f), (float)this.field_70177_z, (float)this.field_70126_B) * ((float)Math.PI / 180);
            float f1 = MathHelper.func_219799_g((float)(p_241843_1_ * 0.5f), (float)this.field_70125_A, (float)this.field_70127_C) * ((float)Math.PI / 180);
            double d0 = this.func_184591_cq() == HandSide.RIGHT ? -1.0 : 1.0;
            Vector3d vector3d = new Vector3d(0.39 * d0, -0.6, 0.3);
            return vector3d.func_178789_a(-f1).func_178785_b(-f).func_178787_e(this.func_174824_e(p_241843_1_));
        }
        return super.func_241843_o(p_241843_1_);
    }

    public void updateSyncFields(ClientPlayerEntity old) {
        this.field_175172_bI = old.field_175172_bI;
        this.field_175166_bJ = old.field_175166_bJ;
        this.field_175167_bK = old.field_175167_bK;
        this.field_175164_bL = old.field_175164_bL;
        this.field_175165_bM = old.field_175165_bM;
        this.field_184841_cd = old.field_184841_cd;
        this.field_228351_cj_ = old.field_228351_cj_;
        this.field_175171_bO = old.field_175171_bO;
        this.field_175168_bP = old.field_175168_bP;
    }
}

