/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screen;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.datafixers.util.Pair;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import java.util.List;
import java.util.OptionalLong;
import java.util.Random;
import java.util.concurrent.Executor;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.BiomeGeneratorTypeScreens;
import net.minecraft.client.gui.screen.ConfirmScreen;
import net.minecraft.client.gui.screen.DirtMessageScreen;
import net.minecraft.client.gui.screen.EditGamerulesScreen;
import net.minecraft.client.gui.screen.PackScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.WorldOptionsScreen;
import net.minecraft.client.gui.toasts.SystemToast;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.command.Commands;
import net.minecraft.resources.DataPackRegistries;
import net.minecraft.resources.FolderPackFinder;
import net.minecraft.resources.IPackFinder;
import net.minecraft.resources.IPackNameDecorator;
import net.minecraft.resources.ResourcePackList;
import net.minecraft.resources.ServerPackFinder;
import net.minecraft.util.FileUtil;
import net.minecraft.util.Util;
import net.minecraft.util.datafix.codec.DatapackCodec;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.GameRules;
import net.minecraft.world.GameType;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.gen.settings.DimensionGeneratorSettings;
import net.minecraft.world.storage.FolderName;
import net.minecraft.world.storage.SaveFormat;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fml.packs.ResourcePackLoader;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class CreateWorldScreen
extends Screen {
    private static final Logger field_238935_p_ = LogManager.getLogger();
    private static final ITextComponent field_243417_q = new TranslationTextComponent("selectWorld.gameMode");
    private static final ITextComponent field_243418_r = new TranslationTextComponent("selectWorld.enterSeed");
    private static final ITextComponent field_243419_s = new TranslationTextComponent("selectWorld.seedInfo");
    private static final ITextComponent field_243420_t = new TranslationTextComponent("selectWorld.enterName");
    private static final ITextComponent field_243421_u = new TranslationTextComponent("selectWorld.resultFolder");
    private static final ITextComponent field_243422_v = new TranslationTextComponent("selectWorld.allowCommands.info");
    private final Screen field_146332_f;
    private TextFieldWidget field_146333_g;
    private String field_146336_i;
    private GameMode field_228197_f_ = GameMode.SURVIVAL;
    @Nullable
    private GameMode field_228198_g_;
    private Difficulty field_238936_v_ = Difficulty.NORMAL;
    private Difficulty field_238937_w_ = Difficulty.NORMAL;
    private boolean field_146340_t;
    private boolean field_146339_u;
    public boolean field_146337_w;
    protected DatapackCodec field_238933_b_;
    @Nullable
    private Path field_238928_A_;
    @Nullable
    private ResourcePackList field_243416_G;
    private boolean field_146344_y;
    private Button field_195355_B;
    private Button field_146343_z;
    private Button field_238929_E_;
    private Button field_146324_A;
    private Button field_238930_G_;
    private Button field_238931_H_;
    private Button field_146321_E;
    private ITextComponent field_146323_G;
    private ITextComponent field_146328_H;
    private String field_146330_J;
    private GameRules field_238932_M_ = new GameRules();
    public final WorldOptionsScreen field_238934_c_;

    public CreateWorldScreen(@Nullable Screen p_i242064_1_, WorldSettings p_i242064_2_, DimensionGeneratorSettings p_i242064_3_, @Nullable Path p_i242064_4_, DatapackCodec p_i242064_5_, DynamicRegistries.Impl p_i242064_6_) {
        this(p_i242064_1_, p_i242064_5_, new WorldOptionsScreen(p_i242064_6_, p_i242064_3_, BiomeGeneratorTypeScreens.func_239079_a_(p_i242064_3_), OptionalLong.of(p_i242064_3_.func_236221_b_())));
        this.field_146330_J = p_i242064_2_.func_234947_a_();
        this.field_146340_t = p_i242064_2_.func_234956_e_();
        this.field_146339_u = true;
        this.field_238937_w_ = this.field_238936_v_ = p_i242064_2_.func_234955_d_();
        this.field_238932_M_.func_234899_a_(p_i242064_2_.func_234957_f_(), null);
        if (p_i242064_2_.func_234954_c_()) {
            this.field_228197_f_ = GameMode.HARDCORE;
        } else if (p_i242064_2_.func_234953_b_().func_77144_e()) {
            this.field_228197_f_ = GameMode.SURVIVAL;
        } else if (p_i242064_2_.func_234953_b_().func_77145_d()) {
            this.field_228197_f_ = GameMode.CREATIVE;
        }
        this.field_238928_A_ = p_i242064_4_;
    }

    public static CreateWorldScreen func_243425_a(@Nullable Screen p_243425_0_) {
        DynamicRegistries.Impl dynamicregistries$impl = DynamicRegistries.func_239770_b_();
        return new CreateWorldScreen(p_243425_0_, DatapackCodec.field_234880_a_, new WorldOptionsScreen(dynamicregistries$impl, ForgeHooksClient.getDefaultWorldType().map(type -> type.func_241220_a_(dynamicregistries$impl, new Random().nextLong(), true, false)).orElseGet(() -> DimensionGeneratorSettings.func_242751_a(dynamicregistries$impl.func_243612_b(Registry.field_239698_ad_), dynamicregistries$impl.func_243612_b(Registry.field_239720_u_), dynamicregistries$impl.func_243612_b(Registry.field_243549_ar))), ForgeHooksClient.getDefaultWorldType(), OptionalLong.empty()));
    }

    private CreateWorldScreen(@Nullable Screen p_i242063_1_, DatapackCodec p_i242063_2_, WorldOptionsScreen p_i242063_3_) {
        super((ITextComponent)((Object)new TranslationTextComponent("selectWorld.create")));
        this.field_146332_f = p_i242063_1_;
        this.field_146330_J = I18n.func_135052_a("selectWorld.newWorld", new Object[0]);
        this.field_238933_b_ = p_i242063_2_;
        this.field_238934_c_ = p_i242063_3_;
    }

    @Override
    public void func_231023_e_() {
        this.field_146333_g.func_146178_a();
        this.field_238934_c_.func_231023_e_();
    }

    @Override
    protected void func_231160_c_() {
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        this.field_146333_g = new TextFieldWidget(this.field_230712_o_, this.field_230708_k_ / 2 - 100, 60, 200, 20, (ITextComponent)((Object)new TranslationTextComponent("selectWorld.enterName"))){

            protected IFormattableTextComponent func_230442_c_() {
                return super.func_230442_c_().func_240702_b_(". ").func_230529_a_((ITextComponent)((Object)new TranslationTextComponent("selectWorld.resultFolder"))).func_240702_b_(" ").func_240702_b_(CreateWorldScreen.this.field_146336_i);
            }
        };
        this.field_146333_g.func_146180_a(this.field_146330_J);
        this.field_146333_g.func_212954_a(p_214319_1_ -> {
            this.field_146330_J = p_214319_1_;
            this.field_195355_B.field_230693_o_ = !this.field_146333_g.func_146179_b().isEmpty();
            this.func_146314_g();
        });
        this.field_230705_e_.add(this.field_146333_g);
        int i = this.field_230708_k_ / 2 - 155;
        int j = this.field_230708_k_ / 2 + 5;
        this.field_146343_z = this.func_230480_a_(new Button(i, 100, 150, 20, StringTextComponent.field_240750_d_, p_214316_1_ -> {
            switch (this.field_228197_f_) {
                case SURVIVAL: {
                    this.func_228200_a_(GameMode.HARDCORE);
                    break;
                }
                case HARDCORE: {
                    this.func_228200_a_(GameMode.CREATIVE);
                    break;
                }
                case CREATIVE: {
                    this.func_228200_a_(GameMode.SURVIVAL);
                }
            }
            p_214316_1_.func_230994_c_(250);
        }){

            public ITextComponent func_230458_i_() {
                return new TranslationTextComponent("options.generic_value", new Object[]{field_243417_q, new TranslationTextComponent("selectWorld.gameMode." + CreateWorldScreen.this.field_228197_f_.field_228217_e_)});
            }

            protected IFormattableTextComponent func_230442_c_() {
                return super.func_230442_c_().func_240702_b_(". ").func_230529_a_(CreateWorldScreen.this.field_146323_G).func_240702_b_(" ").func_230529_a_(CreateWorldScreen.this.field_146328_H);
            }
        });
        this.field_238929_E_ = this.func_230480_a_(new Button(j, 100, 150, 20, (ITextComponent)((Object)new TranslationTextComponent("options.difficulty")), p_238956_1_ -> {
            this.field_238937_w_ = this.field_238936_v_ = this.field_238936_v_.func_233536_d_();
            p_238956_1_.func_230994_c_(250);
        }){

            public ITextComponent func_230458_i_() {
                return new TranslationTextComponent("options.difficulty").func_240702_b_(": ").func_230529_a_(CreateWorldScreen.this.field_238937_w_.func_199285_b());
            }
        });
        this.field_146321_E = this.func_230480_a_(new Button(i, 151, 150, 20, (ITextComponent)((Object)new TranslationTextComponent("selectWorld.allowCommands")), p_214322_1_ -> {
            this.field_146339_u = true;
            this.field_146340_t = !this.field_146340_t;
            p_214322_1_.func_230994_c_(250);
        }){

            public ITextComponent func_230458_i_() {
                return DialogTexts.func_244281_a((ITextComponent)super.func_230458_i_(), (CreateWorldScreen.this.field_146340_t && !CreateWorldScreen.this.field_146337_w ? 1 : 0) != 0);
            }

            protected IFormattableTextComponent func_230442_c_() {
                return super.func_230442_c_().func_240702_b_(". ").func_230529_a_((ITextComponent)((Object)new TranslationTextComponent("selectWorld.allowCommands.info")));
            }
        });
        this.field_238931_H_ = this.func_230480_a_(new Button(j, 151, 150, 20, (ITextComponent)((Object)new TranslationTextComponent("selectWorld.dataPacks")), p_214320_1_ -> this.func_238958_v_()));
        this.field_238930_G_ = this.func_230480_a_(new Button(i, 185, 150, 20, (ITextComponent)((Object)new TranslationTextComponent("selectWorld.gameRules")), p_214312_1_ -> this.field_230706_i_.func_147108_a((Screen)new EditGamerulesScreen(this.field_238932_M_.func_234905_b_(), p_238946_1_ -> {
            this.field_230706_i_.func_147108_a(this);
            p_238946_1_.ifPresent(p_238941_1_ -> {
                this.field_238932_M_ = p_238941_1_;
            });
        }))));
        this.field_238934_c_.func_239048_a_(this, this.field_230706_i_, this.field_230712_o_);
        this.field_146324_A = this.func_230480_a_(new Button(j, 185, 150, 20, (ITextComponent)((Object)new TranslationTextComponent("selectWorld.moreWorldOptions")), p_214321_1_ -> this.func_146315_i()));
        this.field_195355_B = this.func_230480_a_(new Button(i, this.field_230709_l_ - 28, 150, 20, (ITextComponent)((Object)new TranslationTextComponent("selectWorld.create")), p_214318_1_ -> this.func_195352_j()));
        this.field_195355_B.field_230693_o_ = !this.field_146330_J.isEmpty();
        this.func_230480_a_(new Button(j, this.field_230709_l_ - 28, 150, 20, DialogTexts.field_240633_d_, p_214317_1_ -> this.func_243430_k()));
        this.func_238955_g_();
        this.func_212928_a((IGuiEventListener)this.field_146333_g);
        this.func_228200_a_(this.field_228197_f_);
        this.func_146314_g();
    }

    private void func_228199_a_() {
        this.field_146323_G = new TranslationTextComponent("selectWorld.gameMode." + this.field_228197_f_.field_228217_e_ + ".line1");
        this.field_146328_H = new TranslationTextComponent("selectWorld.gameMode." + this.field_228197_f_.field_228217_e_ + ".line2");
    }

    private void func_146314_g() {
        this.field_146336_i = this.field_146333_g.func_146179_b().trim();
        if (this.field_146336_i.isEmpty()) {
            this.field_146336_i = "World";
        }
        try {
            this.field_146336_i = FileUtil.func_214992_a((Path)this.field_230706_i_.func_71359_d().func_215781_c(), (String)this.field_146336_i, (String)"");
        }
        catch (Exception exception1) {
            this.field_146336_i = "World";
            try {
                this.field_146336_i = FileUtil.func_214992_a((Path)this.field_230706_i_.func_71359_d().func_215781_c(), (String)this.field_146336_i, (String)"");
            }
            catch (Exception exception) {
                throw new RuntimeException("Could not create save folder", exception);
            }
        }
    }

    @Override
    public void func_231164_f_() {
        this.field_230706_i_.field_195559_v.func_197967_a(false);
    }

    private void func_195352_j() {
        this.field_230706_i_.func_241562_c_((Screen)new DirtMessageScreen((ITextComponent)((Object)new TranslationTextComponent("createWorld.preparing"))));
        if (this.func_238960_x_()) {
            WorldSettings worldsettings;
            this.func_243432_s();
            DimensionGeneratorSettings dimensiongeneratorsettings = this.field_238934_c_.func_239054_a_(this.field_146337_w);
            if (dimensiongeneratorsettings.func_236227_h_()) {
                GameRules gamerules = new GameRules();
                gamerules.func_223585_a(GameRules.field_223607_j).func_223570_a(false, null);
                worldsettings = new WorldSettings(this.field_146333_g.func_146179_b().trim(), GameType.SPECTATOR, false, Difficulty.PEACEFUL, true, gamerules, DatapackCodec.field_234880_a_);
            } else {
                worldsettings = new WorldSettings(this.field_146333_g.func_146179_b().trim(), this.field_228197_f_.field_228218_f_, this.field_146337_w, this.field_238937_w_, this.field_146340_t && !this.field_146337_w, this.field_238932_M_, this.field_238933_b_);
            }
            this.field_230706_i_.func_238192_a_(this.field_146336_i, worldsettings, this.field_238934_c_.func_239055_b_(), dimensiongeneratorsettings);
        }
    }

    private void func_146315_i() {
        this.func_146316_a(!this.field_146344_y);
    }

    private void func_228200_a_(GameMode p_228200_1_) {
        if (!this.field_146339_u) {
            boolean bl = this.field_146340_t = p_228200_1_ == GameMode.CREATIVE;
        }
        if (p_228200_1_ == GameMode.HARDCORE) {
            this.field_146337_w = true;
            this.field_146321_E.field_230693_o_ = false;
            this.field_238934_c_.field_239027_a_.field_230693_o_ = false;
            this.field_238937_w_ = Difficulty.HARD;
            this.field_238929_E_.field_230693_o_ = false;
        } else {
            this.field_146337_w = false;
            this.field_146321_E.field_230693_o_ = true;
            this.field_238934_c_.field_239027_a_.field_230693_o_ = true;
            this.field_238937_w_ = this.field_238936_v_;
            this.field_238929_E_.field_230693_o_ = true;
        }
        this.field_228197_f_ = p_228200_1_;
        this.func_228199_a_();
    }

    public void func_238955_g_() {
        this.func_146316_a(this.field_146344_y);
    }

    private void func_146316_a(boolean p_146316_1_) {
        this.field_146344_y = p_146316_1_;
        this.field_146343_z.field_230694_p_ = !this.field_146344_y;
        boolean bl = this.field_238929_E_.field_230694_p_ = !this.field_146344_y;
        if (this.field_238934_c_.func_239042_a_()) {
            this.field_238931_H_.field_230694_p_ = false;
            this.field_146343_z.field_230693_o_ = false;
            if (this.field_228198_g_ == null) {
                this.field_228198_g_ = this.field_228197_f_;
            }
            this.func_228200_a_(GameMode.DEBUG);
            this.field_146321_E.field_230694_p_ = false;
        } else {
            this.field_146343_z.field_230693_o_ = true;
            if (this.field_228198_g_ != null) {
                this.func_228200_a_(this.field_228198_g_);
            }
            this.field_146321_E.field_230694_p_ = !this.field_146344_y;
            this.field_238931_H_.field_230694_p_ = !this.field_146344_y;
        }
        this.field_238934_c_.func_239059_b_(this.field_146344_y);
        this.field_146333_g.func_146189_e(!this.field_146344_y);
        if (this.field_146344_y) {
            this.field_146324_A.func_238482_a_(DialogTexts.field_240632_c_);
        } else {
            this.field_146324_A.func_238482_a_((ITextComponent)((Object)new TranslationTextComponent("selectWorld.moreWorldOptions")));
        }
        this.field_238930_G_.field_230694_p_ = !this.field_146344_y;
    }

    @Override
    public boolean func_231046_a_(int p_231046_1_, int p_231046_2_, int p_231046_3_) {
        if (super.func_231046_a_(p_231046_1_, p_231046_2_, p_231046_3_)) {
            return true;
        }
        if (p_231046_1_ != 257 && p_231046_1_ != 335) {
            return false;
        }
        this.func_195352_j();
        return true;
    }

    @Override
    public void func_231175_as__() {
        if (this.field_146344_y) {
            this.func_146316_a(false);
        } else {
            this.func_243430_k();
        }
    }

    public void func_243430_k() {
        this.field_230706_i_.func_147108_a(this.field_146332_f);
        this.func_243432_s();
    }

    private void func_243432_s() {
        if (this.field_243416_G != null) {
            this.field_243416_G.close();
        }
        this.func_238959_w_();
    }

    @Override
    public void func_230430_a_(MatrixStack p_230430_1_, int p_230430_2_, int p_230430_3_, float p_230430_4_) {
        this.func_230446_a_(p_230430_1_);
        CreateWorldScreen.func_238472_a_((MatrixStack)p_230430_1_, (FontRenderer)this.field_230712_o_, (ITextComponent)this.field_230704_d_, (int)(this.field_230708_k_ / 2), (int)20, (int)-1);
        if (this.field_146344_y) {
            CreateWorldScreen.func_238475_b_((MatrixStack)p_230430_1_, (FontRenderer)this.field_230712_o_, (ITextComponent)field_243418_r, (int)(this.field_230708_k_ / 2 - 100), (int)47, (int)-6250336);
            CreateWorldScreen.func_238475_b_((MatrixStack)p_230430_1_, (FontRenderer)this.field_230712_o_, (ITextComponent)field_243419_s, (int)(this.field_230708_k_ / 2 - 100), (int)85, (int)-6250336);
            this.field_238934_c_.func_230430_a_(p_230430_1_, p_230430_2_, p_230430_3_, p_230430_4_);
        } else {
            CreateWorldScreen.func_238475_b_((MatrixStack)p_230430_1_, (FontRenderer)this.field_230712_o_, (ITextComponent)field_243420_t, (int)(this.field_230708_k_ / 2 - 100), (int)47, (int)-6250336);
            CreateWorldScreen.func_238475_b_((MatrixStack)p_230430_1_, (FontRenderer)this.field_230712_o_, (ITextComponent)new StringTextComponent("").func_230529_a_(field_243421_u).func_240702_b_(" ").func_240702_b_(this.field_146336_i), (int)(this.field_230708_k_ / 2 - 100), (int)85, (int)-6250336);
            this.field_146333_g.func_230430_a_(p_230430_1_, p_230430_2_, p_230430_3_, p_230430_4_);
            CreateWorldScreen.func_238475_b_((MatrixStack)p_230430_1_, (FontRenderer)this.field_230712_o_, (ITextComponent)this.field_146323_G, (int)(this.field_230708_k_ / 2 - 150), (int)122, (int)-6250336);
            CreateWorldScreen.func_238475_b_((MatrixStack)p_230430_1_, (FontRenderer)this.field_230712_o_, (ITextComponent)this.field_146328_H, (int)(this.field_230708_k_ / 2 - 150), (int)134, (int)-6250336);
            if (this.field_146321_E.field_230694_p_) {
                CreateWorldScreen.func_238475_b_((MatrixStack)p_230430_1_, (FontRenderer)this.field_230712_o_, (ITextComponent)field_243422_v, (int)(this.field_230708_k_ / 2 - 150), (int)172, (int)-6250336);
            }
        }
        super.func_230430_a_(p_230430_1_, p_230430_2_, p_230430_3_, p_230430_4_);
    }

    @Override
    protected <T extends IGuiEventListener> T func_230481_d_(T p_230481_1_) {
        return super.func_230481_d_(p_230481_1_);
    }

    @Override
    protected <T extends Widget> T func_230480_a_(T p_230480_1_) {
        return super.func_230480_a_(p_230480_1_);
    }

    @Nullable
    protected Path func_238957_j_() {
        if (this.field_238928_A_ == null) {
            try {
                this.field_238928_A_ = Files.createTempDirectory("mcworld-", new FileAttribute[0]);
            }
            catch (IOException ioexception) {
                field_238935_p_.warn("Failed to create temporary dir", (Throwable)ioexception);
                SystemToast.func_238539_c_((Minecraft)this.field_230706_i_, (String)this.field_146336_i);
                this.func_243430_k();
            }
        }
        return this.field_238928_A_;
    }

    private void func_238958_v_() {
        Pair<File, ResourcePackList> pair = this.func_243423_B();
        if (pair != null) {
            this.field_230706_i_.func_147108_a(new PackScreen(this, (ResourcePackList)pair.getSecond(), this::func_241621_a_, (File)pair.getFirst(), (ITextComponent)((Object)new TranslationTextComponent("dataPack.title"))));
        }
    }

    private void func_241621_a_(ResourcePackList p_241621_1_) {
        ImmutableList list = ImmutableList.copyOf(p_241621_1_.func_232621_d_());
        List list1 = (List)p_241621_1_.func_232616_b_().stream().filter(arg_0 -> CreateWorldScreen.lambda$tryApplyNewDataPacks$13((List)list, arg_0)).collect(ImmutableList.toImmutableList());
        DatapackCodec datapackcodec = new DatapackCodec((List<String>)list, list1);
        if (list.equals(this.field_238933_b_.func_234884_a_())) {
            this.field_238933_b_ = datapackcodec;
        } else {
            this.field_230706_i_.func_212871_a_(() -> this.field_230706_i_.func_147108_a((Screen)new DirtMessageScreen((ITextComponent)((Object)new TranslationTextComponent("dataPack.validation.working")))));
            DataPackRegistries.func_240961_a_(p_241621_1_.func_232623_f_(), Commands.EnvironmentType.INTEGRATED, 2, Util.func_215072_e(), (Executor)((Object)this.field_230706_i_)).handle((p_241623_2_, p_241623_3_) -> {
                if (p_241623_3_ != null) {
                    field_238935_p_.warn("Failed to validate datapack", p_241623_3_);
                    this.field_230706_i_.func_212871_a_(() -> this.field_230706_i_.func_147108_a((Screen)new ConfirmScreen(p_241630_1_ -> {
                        if (p_241630_1_) {
                            this.func_238958_v_();
                        } else {
                            this.field_238933_b_ = DatapackCodec.field_234880_a_;
                            this.field_230706_i_.func_147108_a(this);
                        }
                    }, (ITextComponent)((Object)new TranslationTextComponent("dataPack.validation.failed")), StringTextComponent.field_240750_d_, (ITextComponent)((Object)new TranslationTextComponent("dataPack.validation.back")), (ITextComponent)((Object)new TranslationTextComponent("dataPack.validation.reset")))));
                } else {
                    this.field_230706_i_.func_212871_a_(() -> {
                        this.field_238933_b_ = datapackcodec;
                        this.field_238934_c_.func_243447_a((DataPackRegistries)p_241623_2_);
                        p_241623_2_.close();
                        this.field_230706_i_.func_147108_a(this);
                    });
                }
                return null;
            });
        }
    }

    private void func_238959_w_() {
        if (this.field_238928_A_ != null) {
            try (Stream<Path> stream = Files.walk(this.field_238928_A_, new FileVisitOption[0]);){
                stream.sorted(Comparator.reverseOrder()).forEach(p_238948_0_ -> {
                    try {
                        Files.delete(p_238948_0_);
                    }
                    catch (IOException ioexception1) {
                        field_238935_p_.warn("Failed to remove temporary file {}", p_238948_0_, (Object)ioexception1);
                    }
                });
            }
            catch (IOException ioexception) {
                field_238935_p_.warn("Failed to list temporary dir {}", (Object)this.field_238928_A_);
            }
            this.field_238928_A_ = null;
        }
    }

    private static void func_238945_a_(Path p_238945_0_, Path p_238945_1_, Path p_238945_2_) {
        try {
            Util.func_240984_a_(p_238945_0_, p_238945_1_, p_238945_2_);
        }
        catch (IOException ioexception) {
            field_238935_p_.warn("Failed to copy datapack file from {} to {}", (Object)p_238945_2_, (Object)p_238945_1_);
            throw new DatapackException(ioexception);
        }
    }

    private boolean func_238960_x_() {
        if (this.field_238928_A_ != null) {
            try (SaveFormat.LevelSave saveformat$levelsave = this.field_230706_i_.func_71359_d().func_237274_c_(this.field_146336_i);
                 Stream<Path> stream = Files.walk(this.field_238928_A_, new FileVisitOption[0]);){
                Path path = saveformat$levelsave.func_237285_a_(FolderName.field_237251_g_);
                Files.createDirectories(path, new FileAttribute[0]);
                stream.filter(p_238942_1_ -> !p_238942_1_.equals(this.field_238928_A_)).forEach(p_238949_2_ -> CreateWorldScreen.func_238945_a_(this.field_238928_A_, path, p_238949_2_));
            }
            catch (IOException | DatapackException ioexception) {
                field_238935_p_.warn("Failed to copy datapacks to world {}", (Object)this.field_146336_i, (Object)ioexception);
                SystemToast.func_238539_c_((Minecraft)this.field_230706_i_, (String)this.field_146336_i);
                this.func_243430_k();
                return false;
            }
        }
        return true;
    }

    @Nullable
    public static Path func_238943_a_(Path p_238943_0_, Minecraft p_238943_1_) {
        MutableObject mutableobject = new MutableObject();
        try (Stream<Path> stream = Files.walk(p_238943_0_, new FileVisitOption[0]);){
            stream.filter(p_238944_1_ -> !p_238944_1_.equals(p_238943_0_)).forEach(p_238947_2_ -> {
                Path path = (Path)mutableobject.getValue();
                if (path == null) {
                    try {
                        path = Files.createTempDirectory("mcworld-", new FileAttribute[0]);
                    }
                    catch (IOException ioexception1) {
                        field_238935_p_.warn("Failed to create temporary dir");
                        throw new DatapackException(ioexception1);
                    }
                    mutableobject.setValue((Object)path);
                }
                CreateWorldScreen.func_238945_a_(p_238943_0_, path, p_238947_2_);
            });
        }
        catch (IOException | DatapackException ioexception) {
            field_238935_p_.warn("Failed to copy datapacks from world {}", (Object)p_238943_0_, (Object)ioexception);
            SystemToast.func_238539_c_((Minecraft)p_238943_1_, (String)p_238943_0_.toString());
            return null;
        }
        return (Path)mutableobject.getValue();
    }

    @Nullable
    private Pair<File, ResourcePackList> func_243423_B() {
        Path path = this.func_238957_j_();
        if (path != null) {
            File file1 = path.toFile();
            if (this.field_243416_G == null) {
                this.field_243416_G = new ResourcePackList(new IPackFinder[]{new ServerPackFinder(), new FolderPackFinder(file1, IPackNameDecorator.field_232625_a_)});
                ResourcePackLoader.loadResourcePacks((ResourcePackList)this.field_243416_G, ServerLifecycleHooks::buildPackFinder);
                this.field_243416_G.func_198983_a();
            }
            this.field_243416_G.func_198985_a(this.field_238933_b_.func_234884_a_());
            return Pair.of((Object)file1, (Object)this.field_243416_G);
        }
        return null;
    }

    private static /* synthetic */ boolean lambda$tryApplyNewDataPacks$13(List list, String p_241626_1_) {
        return !list.contains(p_241626_1_);
    }

    @OnlyIn(value=Dist.CLIENT)
    static enum GameMode {
        SURVIVAL("survival", GameType.SURVIVAL),
        HARDCORE("hardcore", GameType.SURVIVAL),
        CREATIVE("creative", GameType.CREATIVE),
        DEBUG("spectator", GameType.SPECTATOR);

        private final String field_228217_e_;
        private final GameType field_228218_f_;

        private GameMode(String p_i225940_3_, GameType p_i225940_4_) {
            this.field_228217_e_ = p_i225940_3_;
            this.field_228218_f_ = p_i225940_4_;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static class DatapackException
    extends RuntimeException {
        public DatapackException(Throwable p_i232309_1_) {
            super(p_i232309_1_);
        }
    }
}

