/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity.layers;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IDyeableArmorItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;

@OnlyIn(value=Dist.CLIENT)
public class BipedArmorLayer<T extends LivingEntity, M extends BipedModel<T>, A extends BipedModel<T>>
extends LayerRenderer<T, M> {
    private static final Map<String, ResourceLocation> field_177191_j = Maps.newHashMap();
    private final A field_177189_c;
    private final A field_177186_d;

    public BipedArmorLayer(IEntityRenderer<T, M> p_i50936_1_, A p_i50936_2_, A p_i50936_3_) {
        super(p_i50936_1_);
        this.field_177189_c = p_i50936_2_;
        this.field_177186_d = p_i50936_3_;
    }

    @Override
    public void func_225628_a_(MatrixStack p_225628_1_, IRenderTypeBuffer p_225628_2_, int p_225628_3_, T p_225628_4_, float p_225628_5_, float p_225628_6_, float p_225628_7_, float p_225628_8_, float p_225628_9_, float p_225628_10_) {
        this.func_241739_a_(p_225628_1_, p_225628_2_, p_225628_4_, EquipmentSlotType.CHEST, p_225628_3_, this.func_241736_a_(EquipmentSlotType.CHEST));
        this.func_241739_a_(p_225628_1_, p_225628_2_, p_225628_4_, EquipmentSlotType.LEGS, p_225628_3_, this.func_241736_a_(EquipmentSlotType.LEGS));
        this.func_241739_a_(p_225628_1_, p_225628_2_, p_225628_4_, EquipmentSlotType.FEET, p_225628_3_, this.func_241736_a_(EquipmentSlotType.FEET));
        this.func_241739_a_(p_225628_1_, p_225628_2_, p_225628_4_, EquipmentSlotType.HEAD, p_225628_3_, this.func_241736_a_(EquipmentSlotType.HEAD));
    }

    private void func_241739_a_(MatrixStack p_241739_1_, IRenderTypeBuffer p_241739_2_, T p_241739_3_, EquipmentSlotType p_241739_4_, int p_241739_5_, A p_241739_6_) {
        ArmorItem armoritem;
        ItemStack itemstack = ((LivingEntity)p_241739_3_).func_184582_a(p_241739_4_);
        if (itemstack.func_77973_b() instanceof ArmorItem && (armoritem = (ArmorItem)itemstack.func_77973_b()).func_185083_B_() == p_241739_4_) {
            p_241739_6_ = this.getArmorModelHook(p_241739_3_, itemstack, p_241739_4_, p_241739_6_);
            ((BipedModel)this.func_215332_c()).func_217148_a(p_241739_6_);
            this.func_188359_a(p_241739_6_, p_241739_4_);
            boolean flag = this.func_188363_b(p_241739_4_);
            boolean flag1 = itemstack.func_77962_s();
            if (armoritem instanceof IDyeableArmorItem) {
                int i = ((IDyeableArmorItem)armoritem).func_200886_f(itemstack);
                float f = (float)(i >> 16 & 0xFF) / 255.0f;
                float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                float f2 = (float)(i & 0xFF) / 255.0f;
                this.renderModel(p_241739_1_, p_241739_2_, p_241739_5_, flag1, p_241739_6_, f, f1, f2, this.getArmorResource((Entity)p_241739_3_, itemstack, p_241739_4_, null));
                this.renderModel(p_241739_1_, p_241739_2_, p_241739_5_, flag1, p_241739_6_, 1.0f, 1.0f, 1.0f, this.getArmorResource((Entity)p_241739_3_, itemstack, p_241739_4_, "overlay"));
            } else {
                this.renderModel(p_241739_1_, p_241739_2_, p_241739_5_, flag1, p_241739_6_, 1.0f, 1.0f, 1.0f, this.getArmorResource((Entity)p_241739_3_, itemstack, p_241739_4_, null));
            }
        }
    }

    protected void func_188359_a(A p_188359_1_, EquipmentSlotType p_188359_2_) {
        p_188359_1_.func_178719_a(false);
        switch (p_188359_2_) {
            case HEAD: {
                ((BipedModel)p_188359_1_).field_78116_c.field_78806_j = true;
                ((BipedModel)p_188359_1_).field_178720_f.field_78806_j = true;
                break;
            }
            case CHEST: {
                ((BipedModel)p_188359_1_).field_78115_e.field_78806_j = true;
                ((BipedModel)p_188359_1_).field_178723_h.field_78806_j = true;
                ((BipedModel)p_188359_1_).field_178724_i.field_78806_j = true;
                break;
            }
            case LEGS: {
                ((BipedModel)p_188359_1_).field_78115_e.field_78806_j = true;
                ((BipedModel)p_188359_1_).field_178721_j.field_78806_j = true;
                ((BipedModel)p_188359_1_).field_178722_k.field_78806_j = true;
                break;
            }
            case FEET: {
                ((BipedModel)p_188359_1_).field_178721_j.field_78806_j = true;
                ((BipedModel)p_188359_1_).field_178722_k.field_78806_j = true;
            }
        }
    }

    private void func_241738_a_(MatrixStack p_241738_1_, IRenderTypeBuffer p_241738_2_, int p_241738_3_, ArmorItem p_241738_4_, boolean p_241738_5_, A p_241738_6_, boolean p_241738_7_, float p_241738_8_, float p_241738_9_, float p_241738_10_, @Nullable String p_241738_11_) {
        this.renderModel(p_241738_1_, p_241738_2_, p_241738_3_, p_241738_5_, p_241738_6_, p_241738_8_, p_241738_9_, p_241738_10_, this.func_241737_a_(p_241738_4_, p_241738_7_, p_241738_11_));
    }

    private void renderModel(MatrixStack p_241738_1_, IRenderTypeBuffer p_241738_2_, int p_241738_3_, boolean p_241738_5_, A p_241738_6_, float p_241738_8_, float p_241738_9_, float p_241738_10_, ResourceLocation armorResource) {
        IVertexBuilder ivertexbuilder = ItemRenderer.func_239386_a_(p_241738_2_, RenderType.func_239263_a_(armorResource), false, p_241738_5_);
        p_241738_6_.func_225598_a_(p_241738_1_, ivertexbuilder, p_241738_3_, OverlayTexture.field_229196_a_, p_241738_8_, p_241738_9_, p_241738_10_, 1.0f);
    }

    private A func_241736_a_(EquipmentSlotType p_241736_1_) {
        return this.func_188363_b(p_241736_1_) ? this.field_177189_c : this.field_177186_d;
    }

    private boolean func_188363_b(EquipmentSlotType p_188363_1_) {
        return p_188363_1_ == EquipmentSlotType.LEGS;
    }

    @Deprecated
    private ResourceLocation func_241737_a_(ArmorItem p_241737_1_, boolean p_241737_2_, @Nullable String p_241737_3_) {
        String s = "textures/models/armor/" + p_241737_1_.func_200880_d().func_200897_d() + "_layer_" + (p_241737_2_ ? 2 : 1) + (p_241737_3_ == null ? "" : "_" + p_241737_3_) + ".png";
        return field_177191_j.computeIfAbsent(s, ResourceLocation::new);
    }

    protected A getArmorModelHook(T entity, ItemStack itemStack, EquipmentSlotType slot, A model) {
        return (A)ForgeHooksClient.getArmorModel(entity, (ItemStack)itemStack, (EquipmentSlotType)slot, model);
    }

    public ResourceLocation getArmorResource(Entity entity, ItemStack stack, EquipmentSlotType slot, @Nullable String type) {
        ArmorItem item = (ArmorItem)stack.func_77973_b();
        String texture = item.func_200880_d().func_200897_d();
        String domain = "minecraft";
        int idx = texture.indexOf(58);
        if (idx != -1) {
            domain = texture.substring(0, idx);
            texture = texture.substring(idx + 1);
        }
        String s1 = String.format("%s:textures/models/armor/%s_layer_%d%s.png", domain, texture, this.func_188363_b(slot) ? 2 : 1, type == null ? "" : String.format("_%s", type));
        ResourceLocation resourcelocation = field_177191_j.get(s1 = ForgeHooksClient.getArmorTexture((Entity)entity, (ItemStack)stack, (String)s1, (EquipmentSlotType)slot, (String)type));
        if (resourcelocation == null) {
            resourcelocation = new ResourceLocation(s1);
            field_177191_j.put(s1, resourcelocation);
        }
        return resourcelocation;
    }
}

