/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.crash;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.CrashReportExtender;

public class CrashReportCategory {
    private final CrashReport field_85078_a;
    private final String field_85076_b;
    private final List<Entry> field_85077_c = Lists.newArrayList();
    private StackTraceElement[] field_85075_d = new StackTraceElement[0];

    public CrashReportCategory(CrashReport p_i1353_1_, String p_i1353_2_) {
        this.field_85078_a = p_i1353_1_;
        this.field_85076_b = p_i1353_2_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static String func_85074_a(double p_85074_0_, double p_85074_2_, double p_85074_4_) {
        return String.format(Locale.ROOT, "%.2f,%.2f,%.2f - %s", p_85074_0_, p_85074_2_, p_85074_4_, CrashReportCategory.func_180522_a(new BlockPos(p_85074_0_, p_85074_2_, p_85074_4_)));
    }

    public static String func_180522_a(BlockPos p_180522_0_) {
        return CrashReportCategory.func_184876_a(p_180522_0_.func_177958_n(), p_180522_0_.func_177956_o(), p_180522_0_.func_177952_p());
    }

    public static String func_184876_a(int p_184876_0_, int p_184876_1_, int p_184876_2_) {
        StringBuilder stringbuilder = new StringBuilder();
        try {
            stringbuilder.append(String.format("World: (%d,%d,%d)", p_184876_0_, p_184876_1_, p_184876_2_));
        }
        catch (Throwable throwable2) {
            stringbuilder.append("(Error finding world loc)");
        }
        stringbuilder.append(", ");
        try {
            int i = p_184876_0_ >> 4;
            int j = p_184876_2_ >> 4;
            int k = p_184876_0_ & 0xF;
            int l = p_184876_1_ >> 4;
            int i1 = p_184876_2_ & 0xF;
            int j1 = i << 4;
            int k1 = j << 4;
            int l1 = (i + 1 << 4) - 1;
            int i2 = (j + 1 << 4) - 1;
            stringbuilder.append(String.format("Chunk: (at %d,%d,%d in %d,%d; contains blocks %d,0,%d to %d,255,%d)", k, l, i1, i, j, j1, k1, l1, i2));
        }
        catch (Throwable throwable1) {
            stringbuilder.append("(Error finding chunk loc)");
        }
        stringbuilder.append(", ");
        try {
            int k2 = p_184876_0_ >> 9;
            int l2 = p_184876_2_ >> 9;
            int i3 = k2 << 5;
            int j3 = l2 << 5;
            int k3 = (k2 + 1 << 5) - 1;
            int l3 = (l2 + 1 << 5) - 1;
            int i4 = k2 << 9;
            int j4 = l2 << 9;
            int k4 = (k2 + 1 << 9) - 1;
            int j2 = (l2 + 1 << 9) - 1;
            stringbuilder.append(String.format("Region: (%d,%d; contains chunks %d,%d to %d,%d, blocks %d,0,%d to %d,255,%d)", k2, l2, i3, j3, k3, l3, i4, j4, k4, j2));
        }
        catch (Throwable throwable) {
            stringbuilder.append("(Error finding world loc)");
        }
        return stringbuilder.toString();
    }

    public CrashReportCategory func_189529_a(String p_189529_1_, ICrashReportDetail<String> p_189529_2_) {
        try {
            this.func_71507_a(p_189529_1_, p_189529_2_.call());
        }
        catch (Throwable throwable) {
            this.func_71499_a(p_189529_1_, throwable);
        }
        return this;
    }

    public CrashReportCategory func_71507_a(String p_71507_1_, Object p_71507_2_) {
        this.field_85077_c.add(new Entry(p_71507_1_, p_71507_2_));
        return this;
    }

    public void func_71499_a(String p_71499_1_, Throwable p_71499_2_) {
        this.func_71507_a(p_71499_1_, p_71499_2_);
    }

    public int func_85073_a(int p_85073_1_) {
        StackTraceElement[] astacktraceelement = Thread.currentThread().getStackTrace();
        if (astacktraceelement.length <= 0) {
            return 0;
        }
        int len = astacktraceelement.length - 3 - p_85073_1_;
        if (len <= 0) {
            len = astacktraceelement.length;
        }
        this.field_85075_d = new StackTraceElement[len];
        System.arraycopy(astacktraceelement, astacktraceelement.length - len, this.field_85075_d, 0, this.field_85075_d.length);
        return this.field_85075_d.length;
    }

    public boolean func_85069_a(StackTraceElement p_85069_1_, StackTraceElement p_85069_2_) {
        if (this.field_85075_d.length != 0 && p_85069_1_ != null) {
            StackTraceElement stacktraceelement = this.field_85075_d[0];
            if (stacktraceelement.isNativeMethod() == p_85069_1_.isNativeMethod() && stacktraceelement.getClassName().equals(p_85069_1_.getClassName()) && stacktraceelement.getFileName().equals(p_85069_1_.getFileName()) && stacktraceelement.getMethodName().equals(p_85069_1_.getMethodName())) {
                if (p_85069_2_ != null != this.field_85075_d.length > 1) {
                    return false;
                }
                if (p_85069_2_ != null && !this.field_85075_d[1].equals(p_85069_2_)) {
                    return false;
                }
                this.field_85075_d[0] = p_85069_1_;
                return true;
            }
            return false;
        }
        return false;
    }

    public void func_85070_b(int p_85070_1_) {
        StackTraceElement[] astacktraceelement = new StackTraceElement[this.field_85075_d.length - p_85070_1_];
        System.arraycopy(this.field_85075_d, 0, astacktraceelement, 0, astacktraceelement.length);
        this.field_85075_d = astacktraceelement;
    }

    public void func_85072_a(StringBuilder p_85072_1_) {
        p_85072_1_.append("-- ").append(this.field_85076_b).append(" --\n");
        p_85072_1_.append("Details:");
        for (Entry crashreportcategory$entry : this.field_85077_c) {
            p_85072_1_.append("\n\t");
            p_85072_1_.append(crashreportcategory$entry.func_85089_a());
            p_85072_1_.append(": ");
            p_85072_1_.append(crashreportcategory$entry.func_85090_b());
        }
        if (this.field_85075_d != null && this.field_85075_d.length > 0) {
            p_85072_1_.append("\nStacktrace:");
            p_85072_1_.append(CrashReportExtender.generateEnhancedStackTrace((StackTraceElement[])this.field_85075_d));
        }
    }

    public StackTraceElement[] func_147152_a() {
        return this.field_85075_d;
    }

    public void applyStackTrace(Throwable t) {
        this.field_85075_d = t.getStackTrace();
    }

    public static void func_175750_a(CrashReportCategory p_175750_0_, BlockPos p_175750_1_, @Nullable BlockState p_175750_2_) {
        if (p_175750_2_ != null) {
            p_175750_0_.func_189529_a("Block", (ICrashReportDetail<String>)((ICrashReportDetail)p_175750_2_::toString));
        }
        p_175750_0_.func_189529_a("Block location", (ICrashReportDetail<String>)((ICrashReportDetail)() -> CrashReportCategory.func_180522_a(p_175750_1_)));
    }

    static class Entry {
        private final String field_85092_a;
        private final String field_85091_b;

        public Entry(String p_i1352_1_, @Nullable Object p_i1352_2_) {
            this.field_85092_a = p_i1352_1_;
            if (p_i1352_2_ == null) {
                this.field_85091_b = "~~NULL~~";
            } else if (p_i1352_2_ instanceof Throwable) {
                Throwable throwable = (Throwable)p_i1352_2_;
                this.field_85091_b = "~~ERROR~~ " + throwable.getClass().getSimpleName() + ": " + throwable.getMessage();
            } else {
                this.field_85091_b = p_i1352_2_.toString();
            }
        }

        public String func_85089_a() {
            return this.field_85092_a;
        }

        public String func_85090_b() {
            return this.field_85091_b;
        }
    }
}

