/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mohistmc.util.i18n.i18n;
import com.mojang.datafixers.util.Pair;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.data.loot.BlockLootTables;
import net.minecraft.data.loot.ChestLootTables;
import net.minecraft.data.loot.EntityLootTables;
import net.minecraft.data.loot.FishingLootTables;
import net.minecraft.data.loot.GiftLootTables;
import net.minecraft.loot.LootParameterSet;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.loot.LootTables;
import net.minecraft.loot.PiglinBarteringAddition;
import net.minecraft.loot.ValidationTracker;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LootTableProvider
implements IDataProvider {
    private static final Logger field_218441_b = LogManager.getLogger();
    private static final Gson field_218442_c = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final DataGenerator field_218443_d;
    private final List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> field_218444_e = ImmutableList.of((Object)Pair.of(FishingLootTables::new, (Object)LootParameterSets.field_216262_c), (Object)Pair.of(ChestLootTables::new, (Object)LootParameterSets.field_216261_b), (Object)Pair.of(EntityLootTables::new, (Object)LootParameterSets.field_216263_d), (Object)Pair.of(BlockLootTables::new, (Object)LootParameterSets.field_216267_h), (Object)Pair.of(PiglinBarteringAddition::new, (Object)LootParameterSets.field_237453_h_), (Object)Pair.of(GiftLootTables::new, (Object)LootParameterSets.field_216264_e));

    public LootTableProvider(DataGenerator p_i50789_1_) {
        this.field_218443_d = p_i50789_1_;
    }

    public void func_200398_a(DirectoryCache p_200398_1_) {
        Path path = this.field_218443_d.func_200391_b();
        HashMap map = Maps.newHashMap();
        this.getTables().forEach(p_218438_1_ -> ((Consumer)((Supplier)p_218438_1_.getFirst()).get()).accept((p_218437_2_, p_218437_3_) -> {
            if (map.put(p_218437_2_, p_218437_3_.func_216039_a((LootParameterSet)p_218438_1_.getSecond()).func_216038_b()) != null) {
                throw new IllegalStateException("Duplicate loot table " + p_218437_2_);
            }
        }));
        ValidationTracker validationtracker = new ValidationTracker(LootParameterSets.field_216266_g, p_229442_0_ -> null, map::get);
        this.validate(map, validationtracker);
        Multimap multimap = validationtracker.func_227527_a_();
        if (!multimap.isEmpty()) {
            multimap.forEach((p_229440_0_, p_229440_1_) -> field_218441_b.warn("Found validation problem in " + p_229440_0_ + ": " + p_229440_1_));
            throw new IllegalStateException("Failed to validate loot tables, see logs");
        }
        map.forEach((p_229441_2_, p_229441_3_) -> {
            Path path1 = LootTableProvider.func_218439_a(path, p_229441_2_);
            try {
                IDataProvider.func_218426_a((Gson)field_218442_c, (DirectoryCache)p_200398_1_, (JsonElement)LootTableManager.func_215301_a(p_229441_3_), (Path)path1);
            }
            catch (IOException ioexception) {
                field_218441_b.error(i18n.get((String)"loottableprovider.1", (Object[])new Object[]{path1, ioexception}));
            }
        });
    }

    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> getTables() {
        return this.field_218444_e;
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationTracker validationtracker) {
        for (ResourceLocation resourcelocation : Sets.difference((Set)LootTables.func_215796_a(), map.keySet())) {
            validationtracker.func_227530_a_("Missing built-in table: " + resourcelocation);
        }
        map.forEach((p_218436_2_, p_218436_3_) -> LootTableManager.func_227508_a_(validationtracker, p_218436_2_, p_218436_3_));
    }

    private static Path func_218439_a(Path p_218439_0_, ResourceLocation p_218439_1_) {
        return p_218439_0_.resolve("data/" + p_218439_1_.func_110624_b() + "/loot_tables/" + p_218439_1_.func_110623_a() + ".json");
    }

    public String func_200397_b() {
        return "LootTables";
    }
}

