/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.data;

import com.google.common.collect.Lists;
import com.mohistmc.util.i18n.i18n;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.util.Util;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SNBTToNBTConverter
implements IDataProvider {
    @Nullable
    private static final Path field_240514_b_ = null;
    private static final Logger field_200424_a = LogManager.getLogger();
    private final DataGenerator field_200425_b;
    private final List<ITransformer> field_225370_d = Lists.newArrayList();

    public SNBTToNBTConverter(DataGenerator p_i48257_1_) {
        this.field_200425_b = p_i48257_1_;
    }

    public SNBTToNBTConverter func_225369_a(ITransformer p_225369_1_) {
        this.field_225370_d.add(p_225369_1_);
        return this;
    }

    private CompoundNBT func_225368_a(String p_225368_1_, CompoundNBT p_225368_2_) {
        CompoundNBT compoundnbt = p_225368_2_;
        for (ITransformer snbttonbtconverter$itransformer : this.field_225370_d) {
            compoundnbt = snbttonbtconverter$itransformer.func_225371_a(p_225368_1_, compoundnbt);
        }
        return compoundnbt;
    }

    public void func_200398_a(DirectoryCache p_200398_1_) throws IOException {
        Path path = this.field_200425_b.func_200391_b();
        ArrayList list = Lists.newArrayList();
        for (Path path1 : this.field_200425_b.func_200389_a()) {
            Files.walk(path1, new FileVisitOption[0]).filter(p_200422_0_ -> p_200422_0_.toString().endsWith(".snbt")).forEach(p_229447_3_ -> list.add(CompletableFuture.supplyAsync(() -> this.func_229446_a_((Path)p_229447_3_, this.func_200423_a(path1, (Path)p_229447_3_)), Util.func_215072_e())));
        }
        Util.func_215079_b(list).join().stream().filter(Objects::nonNull).forEach(p_229445_3_ -> this.func_229444_a_(p_200398_1_, (TaskResult)p_229445_3_, path));
    }

    public String func_200397_b() {
        return "SNBT -> NBT";
    }

    private String func_200423_a(Path p_200423_1_, Path p_200423_2_) {
        String s = p_200423_1_.relativize(p_200423_2_).toString().replaceAll("\\\\", "/");
        return s.substring(0, s.length() - ".snbt".length());
    }

    @Nullable
    private TaskResult func_229446_a_(Path p_229446_1_, String p_229446_2_) {
        block10: {
            TaskResult taskResult;
            block9: {
                BufferedReader bufferedreader = Files.newBufferedReader(p_229446_1_);
                try {
                    String s = IOUtils.toString((Reader)bufferedreader);
                    CompoundNBT compoundnbt = this.func_225368_a(p_229446_2_, JsonToNBT.func_180713_a(s));
                    ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
                    CompressedStreamTools.func_74799_a(compoundnbt, bytearrayoutputstream);
                    byte[] abyte = bytearrayoutputstream.toByteArray();
                    String s1 = field_208307_a.hashBytes(abyte).toString();
                    String s2 = field_240514_b_ != null ? compoundnbt.func_199850_a("    ", 0).getString() + "\n" : null;
                    taskResult = new TaskResult(p_229446_2_, abyte, s2, s1);
                    if (bufferedreader == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (bufferedreader != null) {
                            try {
                                bufferedreader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (CommandSyntaxException commandsyntaxexception) {
                        field_200424_a.error(i18n.get((String)"snbttonbtconverter.1", (Object[])new Object[]{p_229446_2_, p_229446_1_, commandsyntaxexception}));
                        break block10;
                    }
                    catch (IOException ioexception) {
                        field_200424_a.error(i18n.get((String)"snbttonbtconverter.2", (Object[])new Object[]{p_229446_2_, p_229446_1_, ioexception}));
                    }
                }
                bufferedreader.close();
            }
            return taskResult;
        }
        return null;
    }

    private void func_229444_a_(DirectoryCache p_229444_1_, TaskResult p_229444_2_, Path p_229444_3_) {
        if (p_229444_2_.field_240515_c_ != null) {
            Path path = field_240514_b_.resolve(p_229444_2_.field_229449_a_ + ".snbt");
            try {
                FileUtils.write((File)path.toFile(), (CharSequence)p_229444_2_.field_240515_c_, (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException ioexception) {
                field_200424_a.error(i18n.get((String)"snbttonbtconverter.3", (Object[])new Object[]{p_229444_2_.field_229449_a_, path, ioexception}));
            }
        }
        Path path1 = p_229444_3_.resolve(p_229444_2_.field_229449_a_ + ".nbt");
        try {
            if (!Objects.equals(p_229444_1_.func_208323_a(path1), p_229444_2_.field_229451_c_) || !Files.exists(path1, new LinkOption[0])) {
                Files.createDirectories(path1.getParent(), new FileAttribute[0]);
                try (OutputStream outputstream = Files.newOutputStream(path1, new OpenOption[0]);){
                    outputstream.write(p_229444_2_.field_229450_b_);
                }
            }
            p_229444_1_.func_208316_a(path1, p_229444_2_.field_229451_c_);
        }
        catch (IOException ioexception1) {
            field_200424_a.error(i18n.get((String)"snbttonbtconverter.4", (Object[])new Object[]{p_229444_2_.field_229449_a_, path1, ioexception1}));
        }
    }

    static class TaskResult {
        private final String field_229449_a_;
        private final byte[] field_229450_b_;
        @Nullable
        private final String field_240515_c_;
        private final String field_229451_c_;

        public TaskResult(String p_i232551_1_, byte[] p_i232551_2_, @Nullable String p_i232551_3_, String p_i232551_4_) {
            this.field_229449_a_ = p_i232551_1_;
            this.field_229450_b_ = p_i232551_2_;
            this.field_240515_c_ = p_i232551_3_;
            this.field_229451_c_ = p_i232551_4_;
        }
    }

    @FunctionalInterface
    public static interface ITransformer {
        public CompoundNBT func_225371_a(String var1, CompoundNBT var2);
    }
}

