/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.dispenser;

import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.dispenser.IPosition;
import net.minecraft.dispenser.ProxyBlockSource;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_16_R3.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_16_R3.util.CraftVector;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class DefaultDispenseItemBehavior
implements IDispenseItemBehavior {
    @Override
    public final net.minecraft.item.ItemStack dispense(IBlockSource p_dispense_1_, net.minecraft.item.ItemStack p_dispense_2_) {
        net.minecraft.item.ItemStack itemstack = this.func_82487_b(p_dispense_1_, p_dispense_2_);
        this.func_82485_a(p_dispense_1_);
        this.func_82489_a(p_dispense_1_, (Direction)((Object)p_dispense_1_.func_189992_e().func_177229_b(DispenserBlock.field_176441_a)));
        return itemstack;
    }

    protected net.minecraft.item.ItemStack func_82487_b(IBlockSource p_82487_1_, net.minecraft.item.ItemStack p_82487_2_) {
        Direction direction = (Direction)((Object)p_82487_1_.func_189992_e().func_177229_b(DispenserBlock.field_176441_a));
        net.minecraft.item.ItemStack itemstack = p_82487_2_.func_77979_a(1);
        if (!DefaultDispenseItemBehavior.doDispense(p_82487_1_.func_197524_h(), itemstack, 6, direction, p_82487_1_)) {
            itemstack.func_190917_f(1);
        }
        return p_82487_2_;
    }

    public static void func_82486_a(World p_82486_0_, net.minecraft.item.ItemStack p_82486_1_, int p_82486_2_, Direction p_82486_3_, IPosition p_82486_4_) {
        DefaultDispenseItemBehavior.doDispenseInternal(p_82486_0_, p_82486_1_, p_82486_2_, p_82486_3_, (IBlockSource)new ProxyBlockSource((ServerWorld)p_82486_0_, new BlockPos(p_82486_4_.func_82615_a(), p_82486_4_.func_82617_b(), p_82486_4_.func_82616_c())), p_82486_4_);
    }

    public static boolean doDispense(World worldIn, net.minecraft.item.ItemStack stack, int speed, Direction facing, IBlockSource source) {
        return DefaultDispenseItemBehavior.doDispenseInternal(worldIn, stack, speed, facing, source, DispenserBlock.func_149939_a(source));
    }

    private static boolean doDispenseInternal(World worldIn, net.minecraft.item.ItemStack stack, int speed, Direction facing, IBlockSource source, IPosition position) {
        if (stack.func_190926_b()) {
            return true;
        }
        double d0 = position.func_82615_a();
        double d1 = position.func_82617_b();
        double d2 = position.func_82616_c();
        d1 = facing.func_176740_k() == Direction.Axis.Y ? (d1 -= 0.125) : (d1 -= 0.15625);
        ItemEntity itementity = new ItemEntity(worldIn, d0, d1, d2, stack);
        double d3 = worldIn.field_73012_v.nextDouble() * 0.1 + 0.2;
        itementity.func_213293_j(worldIn.field_73012_v.nextGaussian() * (double)0.0075f * (double)speed + (double)facing.func_82601_c() * d3, worldIn.field_73012_v.nextGaussian() * (double)0.0075f * (double)speed + (double)0.2f, worldIn.field_73012_v.nextGaussian() * (double)0.0075f * (double)speed + (double)facing.func_82599_e() * d3);
        Block block = worldIn.getWorld().getBlockAt(source.func_180699_d().func_177958_n(), source.func_180699_d().func_177956_o(), source.func_180699_d().func_177952_p());
        CraftItemStack craftItem = CraftItemStack.asCraftMirror((net.minecraft.item.ItemStack)stack);
        BlockDispenseEvent event = new BlockDispenseEvent(block, (ItemStack)craftItem.clone(), CraftVector.toBukkit((Vector3d)itementity.func_213322_ci()));
        if (!DispenserBlock.eventFired) {
            worldIn.getCBServer().getPluginManager().callEvent((Event)event);
        }
        if (event.isCancelled()) {
            return false;
        }
        itementity.func_92058_a(CraftItemStack.asNMSCopy((ItemStack)event.getItem()));
        itementity.func_213317_d(CraftVector.toNMS((Vector)event.getVelocity()));
        if (!event.getItem().getType().equals((Object)craftItem.getType())) {
            net.minecraft.item.ItemStack eventStack = CraftItemStack.asNMSCopy((ItemStack)event.getItem());
            IDispenseItemBehavior idispensebehavior = DispenserBlock.field_149943_a.get((Object)eventStack.func_77973_b());
            if (idispensebehavior != IDispenseItemBehavior.field_223216_a_ && idispensebehavior.getClass() != DefaultDispenseItemBehavior.class) {
                idispensebehavior.dispense(source, eventStack);
            } else {
                worldIn.func_217376_c(itementity);
            }
            return false;
        }
        worldIn.func_217376_c(itementity);
        return true;
    }

    protected void func_82485_a(IBlockSource p_82485_1_) {
        p_82485_1_.func_197524_h().func_217379_c(1000, p_82485_1_.func_180699_d(), 0);
    }

    protected void func_82489_a(IBlockSource p_82489_1_, Direction p_82489_2_) {
        p_82489_1_.func_197524_h().func_217379_c(2000, p_82489_1_.func_180699_d(), p_82489_2_.func_176745_a());
    }
}

