/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.ai.attributes;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ModifiableAttributeInstance {
    private final Attribute field_111136_b;
    private final Map<AttributeModifier.Operation, Set<AttributeModifier>> field_111137_c = Maps.newEnumMap(AttributeModifier.Operation.class);
    private final Map<UUID, AttributeModifier> field_233757_c_ = new Object2ObjectArrayMap();
    private final Set<AttributeModifier> field_111135_e = new ObjectArraySet();
    private double field_233759_e_;
    private boolean field_233760_f_ = true;
    private double field_233761_g_;
    private final Consumer<ModifiableAttributeInstance> field_233762_h_;

    public ModifiableAttributeInstance(Attribute p_i231501_1_, Consumer<ModifiableAttributeInstance> p_i231501_2_) {
        this.field_111136_b = p_i231501_1_;
        this.field_233762_h_ = p_i231501_2_;
        this.field_233759_e_ = p_i231501_1_.func_111110_b();
    }

    public Attribute func_111123_a() {
        return this.field_111136_b;
    }

    public double func_111125_b() {
        return this.field_233759_e_;
    }

    public void func_111128_a(double p_111128_1_) {
        if (p_111128_1_ != this.field_233759_e_) {
            this.field_233759_e_ = p_111128_1_;
            this.func_233771_d_();
        }
    }

    public Set<AttributeModifier> func_225504_a_(AttributeModifier.Operation p_225504_1_) {
        return this.field_111137_c.computeIfAbsent(p_225504_1_, p_233768_0_ -> Sets.newHashSet());
    }

    public Set<AttributeModifier> func_225505_c_() {
        return ImmutableSet.copyOf(this.field_233757_c_.values());
    }

    @Nullable
    public AttributeModifier func_111127_a(UUID p_111127_1_) {
        return this.field_233757_c_.get(p_111127_1_);
    }

    public boolean func_180374_a(AttributeModifier p_180374_1_) {
        return this.field_233757_c_.get(p_180374_1_.func_111167_a()) != null;
    }

    public void func_111121_a(AttributeModifier p_111121_1_) {
        AttributeModifier attributemodifier = this.field_233757_c_.putIfAbsent(p_111121_1_.func_111167_a(), p_111121_1_);
        if (attributemodifier != null) {
            throw new IllegalArgumentException("Modifier is already applied on this attribute!");
        }
        this.func_225504_a_(p_111121_1_.func_220375_c()).add(p_111121_1_);
        this.func_233771_d_();
    }

    public void func_233767_b_(AttributeModifier p_233767_1_) {
        this.func_111121_a(p_233767_1_);
    }

    public void func_233769_c_(AttributeModifier p_233769_1_) {
        this.func_111121_a(p_233769_1_);
        this.field_111135_e.add(p_233769_1_);
    }

    protected void func_233771_d_() {
        this.field_233760_f_ = true;
        this.field_233762_h_.accept(this);
    }

    public void func_111124_b(AttributeModifier p_111124_1_) {
        this.func_225504_a_(p_111124_1_.func_220375_c()).remove(p_111124_1_);
        this.field_233757_c_.remove(p_111124_1_.func_111167_a());
        this.field_111135_e.remove(p_111124_1_);
        this.func_233771_d_();
    }

    public void func_188479_b(UUID p_188479_1_) {
        AttributeModifier attributemodifier = this.func_111127_a(p_188479_1_);
        if (attributemodifier != null) {
            this.func_111124_b(attributemodifier);
        }
    }

    public boolean func_233770_c_(UUID p_233770_1_) {
        AttributeModifier attributemodifier = this.func_111127_a(p_233770_1_);
        if (attributemodifier != null && this.field_111135_e.contains(attributemodifier)) {
            this.func_111124_b(attributemodifier);
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_142049_d() {
        for (AttributeModifier attributemodifier : this.func_225505_c_()) {
            this.func_111124_b(attributemodifier);
        }
    }

    public double func_111126_e() {
        if (this.field_233760_f_) {
            this.field_233761_g_ = this.func_111129_g();
            this.field_233760_f_ = false;
        }
        return this.field_233761_g_;
    }

    private double func_111129_g() {
        double d0 = this.func_111125_b();
        for (AttributeModifier attributemodifier : this.func_220370_b(AttributeModifier.Operation.ADDITION)) {
            d0 += attributemodifier.func_111164_d();
        }
        double d1 = d0;
        for (AttributeModifier attributemodifier1 : this.func_220370_b(AttributeModifier.Operation.MULTIPLY_BASE)) {
            d1 += d0 * attributemodifier1.func_111164_d();
        }
        for (AttributeModifier attributemodifier2 : this.func_220370_b(AttributeModifier.Operation.MULTIPLY_TOTAL)) {
            d1 *= 1.0 + attributemodifier2.func_111164_d();
        }
        return this.field_111136_b.func_111109_a(d1);
    }

    private Collection<AttributeModifier> func_220370_b(AttributeModifier.Operation p_220370_1_) {
        return this.field_111137_c.getOrDefault((Object)p_220370_1_, Collections.emptySet());
    }

    public void func_233763_a_(ModifiableAttributeInstance p_233763_1_) {
        this.field_233759_e_ = p_233763_1_.field_233759_e_;
        this.field_233757_c_.clear();
        this.field_233757_c_.putAll(p_233763_1_.field_233757_c_);
        this.field_111135_e.clear();
        this.field_111135_e.addAll(p_233763_1_.field_111135_e);
        this.field_111137_c.clear();
        p_233763_1_.field_111137_c.forEach((p_233764_1_, p_233764_2_) -> this.func_225504_a_((AttributeModifier.Operation)((Object)p_233764_1_)).addAll((Collection<AttributeModifier>)p_233764_2_));
        this.func_233771_d_();
    }

    public CompoundNBT func_233772_g_() {
        CompoundNBT compoundnbt = new CompoundNBT();
        compoundnbt.func_74778_a("Name", Registry.field_239692_aP_.func_177774_c(this.field_111136_b).toString());
        compoundnbt.func_74780_a("Base", this.field_233759_e_);
        if (!this.field_111135_e.isEmpty()) {
            ListNBT listnbt = new ListNBT();
            for (AttributeModifier attributemodifier : this.field_111135_e) {
                listnbt.add((Object)attributemodifier.func_233801_e_());
            }
            compoundnbt.func_218657_a("Modifiers", (INBT)listnbt);
        }
        return compoundnbt;
    }

    public void func_233765_a_(CompoundNBT p_233765_1_) {
        this.field_233759_e_ = p_233765_1_.func_74769_h("Base");
        if (p_233765_1_.func_150297_b("Modifiers", 9)) {
            ListNBT listnbt = p_233765_1_.func_150295_c("Modifiers", 10);
            for (int i = 0; i < listnbt.size(); ++i) {
                AttributeModifier attributemodifier = AttributeModifier.func_233800_a_(listnbt.func_150305_b(i));
                if (attributemodifier == null) continue;
                this.field_233757_c_.put(attributemodifier.func_111167_a(), attributemodifier);
                this.func_225504_a_(attributemodifier.func_220375_c()).add(attributemodifier);
                this.field_111135_e.add(attributemodifier);
            }
        }
        this.func_233771_d_();
    }
}

