/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LilyPadBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.client.CSteerBoatPacket;
import net.minecraft.network.play.server.SSpawnObjectPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.TeleportationRepositioner;
import net.minecraft.util.TransportationHelper;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ICollisionReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_16_R3.CraftServer;
import org.bukkit.craftbukkit.v1_16_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftEntity;
import org.bukkit.entity.Vehicle;
import org.bukkit.event.Event;
import org.bukkit.event.vehicle.VehicleDamageEvent;
import org.bukkit.event.vehicle.VehicleDestroyEvent;
import org.bukkit.event.vehicle.VehicleEntityCollisionEvent;
import org.bukkit.event.vehicle.VehicleMoveEvent;
import org.bukkit.event.vehicle.VehicleUpdateEvent;

public class BoatEntity
extends Entity {
    private static final DataParameter<Integer> field_184460_a = EntityDataManager.func_187226_a(BoatEntity.class, DataSerializers.field_187192_b);
    private static final DataParameter<Integer> field_184462_b = EntityDataManager.func_187226_a(BoatEntity.class, DataSerializers.field_187192_b);
    private static final DataParameter<Float> field_184464_c = EntityDataManager.func_187226_a(BoatEntity.class, DataSerializers.field_187193_c);
    private static final DataParameter<Integer> field_184466_d = EntityDataManager.func_187226_a(BoatEntity.class, DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> field_199704_e = EntityDataManager.func_187226_a(BoatEntity.class, DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> field_199705_f = EntityDataManager.func_187226_a(BoatEntity.class, DataSerializers.field_187198_h);
    private static final DataParameter<Integer> field_203064_g = EntityDataManager.func_187226_a(BoatEntity.class, DataSerializers.field_187192_b);
    private final float[] field_184470_f = new float[2];
    private float field_184472_g;
    private float field_184474_h;
    private float field_184475_as;
    private int field_184476_at;
    private double field_70281_h;
    private double field_184477_av;
    private double field_184478_aw;
    private double field_70273_g;
    private double field_184479_ay;
    private boolean field_184480_az;
    private boolean field_184459_aA;
    private boolean field_184461_aB;
    private boolean field_184463_aC;
    private double field_184465_aD;
    private float field_184467_aE;
    private Status field_184469_aF;
    private Status field_184471_aG;
    private double field_184473_aH;
    private boolean field_203059_aM;
    private boolean field_203060_aN;
    private float field_203061_aO;
    private float field_203062_aP;
    private float field_203063_aQ;
    public double maxSpeed = 0.4;
    public double occupiedDeceleration = 0.2;
    public double unoccupiedDeceleration = -1.0;
    public boolean landBoats = false;
    private Location lastLocation;

    public BoatEntity(EntityType<? extends BoatEntity> p_i50129_1_, World p_i50129_2_) {
        super(p_i50129_1_, p_i50129_2_);
        this.field_70156_m = true;
    }

    public BoatEntity(World p_i1705_1_, double p_i1705_2_, double p_i1705_4_, double p_i1705_6_) {
        this((EntityType<? extends BoatEntity>)EntityType.field_200793_g, p_i1705_1_);
        this.func_70107_b(p_i1705_2_, p_i1705_4_, p_i1705_6_);
        this.func_213317_d(Vector3d.field_186680_a);
        this.field_70169_q = p_i1705_2_;
        this.field_70167_r = p_i1705_4_;
        this.field_70166_s = p_i1705_6_;
    }

    @Override
    protected float func_213316_a(Pose p_213316_1_, EntitySize p_213316_2_) {
        return p_213316_2_.field_220316_b;
    }

    @Override
    protected boolean func_225502_at_() {
        return false;
    }

    @Override
    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(field_184460_a, 0);
        this.field_70180_af.func_187214_a(field_184462_b, 1);
        this.field_70180_af.func_187214_a(field_184464_c, Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(field_184466_d, Type.OAK.ordinal());
        this.field_70180_af.func_187214_a(field_199704_e, false);
        this.field_70180_af.func_187214_a(field_199705_f, false);
        this.field_70180_af.func_187214_a(field_203064_g, 0);
    }

    @Override
    public boolean func_241849_j(Entity p_241849_1_) {
        return BoatEntity.func_242378_a(this, p_241849_1_);
    }

    public static boolean func_242378_a(Entity p_242378_0_, Entity p_242378_1_) {
        return (p_242378_1_.func_241845_aY() || p_242378_1_.func_70104_M()) && !p_242378_0_.func_184223_x(p_242378_1_);
    }

    @Override
    public boolean func_241845_aY() {
        return true;
    }

    @Override
    public boolean func_70104_M() {
        return true;
    }

    @Override
    protected Vector3d func_241839_a(Direction.Axis p_241839_1_, TeleportationRepositioner.Result p_241839_2_) {
        return LivingEntity.func_242288_h(super.func_241839_a(p_241839_1_, p_241839_2_));
    }

    @Override
    public double func_70042_X() {
        return -0.1;
    }

    @Override
    public boolean func_70097_a(DamageSource p_70097_1_, float p_70097_2_) {
        if (this.func_180431_b(p_70097_1_)) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            boolean flag;
            Vehicle vehicle = (Vehicle)this.getBukkitEntity();
            CraftEntity attacker = p_70097_1_.func_76346_g() == null ? null : p_70097_1_.func_76346_g().getBukkitEntity();
            VehicleDamageEvent event = new VehicleDamageEvent(vehicle, (org.bukkit.entity.Entity)attacker, (double)p_70097_2_);
            this.field_70170_p.getCBServer().getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return false;
            }
            this.func_70269_c(-this.func_70267_i());
            this.func_70265_b(10);
            this.func_70266_a(this.func_70271_g() + p_70097_2_ * 10.0f);
            this.func_70018_K();
            boolean bl = flag = p_70097_1_.func_76346_g() instanceof PlayerEntity && ((PlayerEntity)p_70097_1_.func_76346_g()).field_71075_bZ.field_75098_d;
            if (flag || this.func_70271_g() > 40.0f) {
                VehicleDestroyEvent destroyEvent = new VehicleDestroyEvent(vehicle, (org.bukkit.entity.Entity)attacker);
                this.field_70170_p.getCBServer().getPluginManager().callEvent((Event)destroyEvent);
                if (destroyEvent.isCancelled()) {
                    this.func_70266_a(40.0f);
                    return true;
                }
                if (!flag && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
                    this.func_199703_a(this.func_184455_j());
                }
                this.func_70106_y();
            }
            return true;
        }
        return true;
    }

    @Override
    public void func_203002_i(boolean p_203002_1_) {
        if (!this.field_70170_p.field_72995_K) {
            this.field_203059_aM = true;
            this.field_203060_aN = p_203002_1_;
            if (this.func_203058_B() == 0) {
                this.func_203055_e(60);
            }
        }
        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_218422_X, this.func_226277_ct_() + (double)this.field_70146_Z.nextFloat(), this.func_226278_cu_() + 0.7, this.func_226281_cx_() + (double)this.field_70146_Z.nextFloat(), 0.0, 0.0, 0.0);
        if (this.field_70146_Z.nextInt(20) == 0) {
            this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.func_184181_aa(), this.func_184176_by(), 1.0f, 0.8f + 0.4f * this.field_70146_Z.nextFloat(), false);
        }
    }

    @Override
    public void func_70108_f(Entity p_70108_1_) {
        if (p_70108_1_ instanceof BoatEntity) {
            if (p_70108_1_.func_174813_aQ().field_72338_b < this.func_174813_aQ().field_72337_e) {
                if (!this.func_184223_x(p_70108_1_)) {
                    VehicleEntityCollisionEvent event = new VehicleEntityCollisionEvent((Vehicle)this.getBukkitEntity(), (org.bukkit.entity.Entity)p_70108_1_.getBukkitEntity());
                    this.field_70170_p.getCBServer().getPluginManager().callEvent((Event)event);
                    if (event.isCancelled()) {
                        return;
                    }
                }
                super.func_70108_f(p_70108_1_);
            }
        } else if (p_70108_1_.func_174813_aQ().field_72338_b <= this.func_174813_aQ().field_72338_b) {
            if (!this.func_184223_x(p_70108_1_)) {
                VehicleEntityCollisionEvent event = new VehicleEntityCollisionEvent((Vehicle)this.getBukkitEntity(), (org.bukkit.entity.Entity)p_70108_1_.getBukkitEntity());
                this.field_70170_p.getCBServer().getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return;
                }
            }
            super.func_70108_f(p_70108_1_);
        }
    }

    public Item func_184455_j() {
        switch (this.func_184453_r()) {
            default: {
                return Items.field_151124_az;
            }
            case SPRUCE: {
                return Items.field_185150_aH;
            }
            case BIRCH: {
                return Items.field_185151_aI;
            }
            case JUNGLE: {
                return Items.field_185152_aJ;
            }
            case ACACIA: {
                return Items.field_185153_aK;
            }
            case DARK_OAK: 
        }
        return Items.field_185154_aL;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_70057_ab() {
        this.func_70269_c(-this.func_70267_i());
        this.func_70265_b(10);
        this.func_70266_a(this.func_70271_g() * 11.0f);
    }

    @Override
    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_180426_a(double p_180426_1_, double p_180426_3_, double p_180426_5_, float p_180426_7_, float p_180426_8_, int p_180426_9_, boolean p_180426_10_) {
        this.field_70281_h = p_180426_1_;
        this.field_184477_av = p_180426_3_;
        this.field_184478_aw = p_180426_5_;
        this.field_70273_g = p_180426_7_;
        this.field_184479_ay = p_180426_8_;
        this.field_184476_at = 10;
    }

    @Override
    public Direction func_184172_bi() {
        return this.func_174811_aO().func_176746_e();
    }

    @Override
    public void func_70071_h_() {
        this.field_184471_aG = this.field_184469_aF;
        this.field_184469_aF = this.func_184449_t();
        this.field_184474_h = this.field_184469_aF != Status.UNDER_WATER && this.field_184469_aF != Status.UNDER_FLOWING_WATER ? 0.0f : (this.field_184474_h += 1.0f);
        if (!this.field_70170_p.field_72995_K && this.field_184474_h >= 60.0f) {
            this.func_184226_ay();
        }
        if (this.func_70268_h() > 0) {
            this.func_70265_b(this.func_70268_h() - 1);
        }
        if (this.func_70271_g() > 0.0f) {
            this.func_70266_a(this.func_70271_g() - 1.0f);
        }
        super.func_70071_h_();
        this.func_184447_s();
        if (this.func_184186_bw()) {
            if (this.func_184188_bt().isEmpty() || !(this.func_184188_bt().get(0) instanceof PlayerEntity)) {
                this.func_184445_a(false, false);
            }
            this.func_184450_w();
            if (this.field_70170_p.field_72995_K) {
                this.func_184443_x();
                this.field_70170_p.func_184135_a((IPacket<?>)new CSteerBoatPacket(this.func_184457_a(0), this.func_184457_a(1)));
            }
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        } else {
            this.func_213317_d(Vector3d.field_186680_a);
        }
        CraftServer server = this.field_70170_p.getCBServer();
        CraftWorld bworld = this.field_70170_p.getWorld();
        Location to = new Location((org.bukkit.World)bworld, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.field_70177_z, this.field_70125_A);
        Vehicle vehicle = (Vehicle)this.getBukkitEntity();
        server.getPluginManager().callEvent((Event)new VehicleUpdateEvent(vehicle));
        if (this.lastLocation != null && !this.lastLocation.equals((Object)to)) {
            VehicleMoveEvent event = new VehicleMoveEvent(vehicle, this.lastLocation, to);
            server.getPluginManager().callEvent((Event)event);
        }
        this.lastLocation = vehicle.getLocation();
        this.func_203057_r();
        for (int i = 0; i <= 1; ++i) {
            if (this.func_184457_a(i)) {
                SoundEvent soundevent;
                if (!this.func_174814_R() && (double)(this.field_184470_f[i] % ((float)Math.PI * 2)) <= 0.7853981852531433 && ((double)this.field_184470_f[i] + (double)0.3926991f) % 6.2831854820251465 >= 0.7853981852531433 && (soundevent = this.func_193047_k()) != null) {
                    Vector3d vector3d = this.func_70676_i(1.0f);
                    double d0 = i == 1 ? -vector3d.field_72449_c : vector3d.field_72449_c;
                    double d1 = i == 1 ? vector3d.field_72450_a : -vector3d.field_72450_a;
                    this.field_70170_p.func_184148_a(null, this.func_226277_ct_() + d0, this.func_226278_cu_(), this.func_226281_cx_() + d1, soundevent, this.func_184176_by(), 1.0f, 0.8f + 0.4f * this.field_70146_Z.nextFloat());
                }
                this.field_184470_f[i] = (float)((double)this.field_184470_f[i] + (double)0.3926991f);
                continue;
            }
            this.field_184470_f[i] = 0.0f;
        }
        this.func_145775_I();
        List<Entity> list = this.field_70170_p.func_175674_a(this, this.func_174813_aQ().func_72314_b(0.2f, -0.01f, 0.2f), EntityPredicates.func_200823_a(this));
        if (!list.isEmpty()) {
            boolean flag = !this.field_70170_p.field_72995_K && !(this.func_184179_bs() instanceof PlayerEntity);
            for (int j = 0; j < list.size(); ++j) {
                Entity entity = list.get(j);
                if (entity.func_184196_w(this)) continue;
                if (flag && this.func_184188_bt().size() < 2 && !entity.func_184218_aH() && entity.func_213311_cf() < this.func_213311_cf() && entity instanceof LivingEntity && !(entity instanceof WaterMobEntity) && !(entity instanceof PlayerEntity)) {
                    entity.func_184220_m(this);
                    continue;
                }
                this.func_70108_f(entity);
            }
        }
    }

    private void func_203057_r() {
        if (this.field_70170_p.field_72995_K) {
            int i = this.func_203058_B();
            this.field_203061_aO = i > 0 ? (this.field_203061_aO += 0.05f) : (this.field_203061_aO -= 0.1f);
            this.field_203061_aO = MathHelper.func_76131_a((float)this.field_203061_aO, (float)0.0f, (float)1.0f);
            this.field_203063_aQ = this.field_203062_aP;
            this.field_203062_aP = 10.0f * (float)Math.sin(0.5f * (float)this.field_70170_p.func_82737_E()) * this.field_203061_aO;
        } else {
            int k;
            if (!this.field_203059_aM) {
                this.func_203055_e(0);
            }
            if ((k = this.func_203058_B()) > 0) {
                this.func_203055_e(--k);
                int j = 60 - k - 1;
                if (j > 0 && k == 0) {
                    this.func_203055_e(0);
                    Vector3d vector3d = this.func_213322_ci();
                    if (this.field_203060_aN) {
                        this.func_213317_d(vector3d.func_72441_c(0.0, -0.7, 0.0));
                        this.func_184226_ay();
                    } else {
                        this.func_213293_j(vector3d.field_72450_a, this.func_205708_a(PlayerEntity.class) ? 2.7 : 0.6, vector3d.field_72449_c);
                    }
                }
                this.field_203059_aM = false;
            }
        }
    }

    @Nullable
    protected SoundEvent func_193047_k() {
        switch (this.func_184449_t()) {
            case IN_WATER: 
            case UNDER_WATER: 
            case UNDER_FLOWING_WATER: {
                return SoundEvents.field_193779_I;
            }
            case ON_LAND: {
                return SoundEvents.field_193778_H;
            }
        }
        return null;
    }

    private void func_184447_s() {
        if (this.func_184186_bw()) {
            this.field_184476_at = 0;
            this.func_213312_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        }
        if (this.field_184476_at > 0) {
            double d0 = this.func_226277_ct_() + (this.field_70281_h - this.func_226277_ct_()) / (double)this.field_184476_at;
            double d1 = this.func_226278_cu_() + (this.field_184477_av - this.func_226278_cu_()) / (double)this.field_184476_at;
            double d2 = this.func_226281_cx_() + (this.field_184478_aw - this.func_226281_cx_()) / (double)this.field_184476_at;
            double d3 = MathHelper.func_76138_g((double)(this.field_70273_g - (double)this.field_70177_z));
            this.field_70177_z = (float)((double)this.field_70177_z + d3 / (double)this.field_184476_at);
            this.field_70125_A = (float)((double)this.field_70125_A + (this.field_184479_ay - (double)this.field_70125_A) / (double)this.field_184476_at);
            --this.field_184476_at;
            this.func_70107_b(d0, d1, d2);
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
        }
    }

    public void func_184445_a(boolean p_184445_1_, boolean p_184445_2_) {
        this.field_70180_af.func_187227_b(field_199704_e, p_184445_1_);
        this.field_70180_af.func_187227_b(field_199705_f, p_184445_2_);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_184448_a(int p_184448_1_, float p_184448_2_) {
        return this.func_184457_a(p_184448_1_) ? (float)MathHelper.func_151238_b((double)((double)this.field_184470_f[p_184448_1_] - (double)0.3926991f), (double)this.field_184470_f[p_184448_1_], (double)p_184448_2_) : 0.0f;
    }

    private Status func_184449_t() {
        Status boatentity$status = this.func_184444_v();
        if (boatentity$status != null) {
            this.field_184465_aD = this.func_174813_aQ().field_72337_e;
            return boatentity$status;
        }
        if (this.func_184446_u()) {
            return Status.IN_WATER;
        }
        float f = this.func_184441_l();
        if (f > 0.0f) {
            this.field_184467_aE = f;
            return Status.ON_LAND;
        }
        return Status.IN_AIR;
    }

    public float func_184451_k() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        int i = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int j = MathHelper.func_76143_f((double)axisalignedbb.field_72336_d);
        int k = MathHelper.func_76128_c((double)axisalignedbb.field_72337_e);
        int l = MathHelper.func_76143_f((double)(axisalignedbb.field_72337_e - this.field_184473_aH));
        int i1 = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int j1 = MathHelper.func_76143_f((double)axisalignedbb.field_72334_f);
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        block0: for (int k1 = k; k1 < l; ++k1) {
            float f = 0.0f;
            for (int l1 = i; l1 < j; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos$mutable.func_181079_c(l1, k1, i2);
                    FluidState fluidstate = this.field_70170_p.func_204610_c(blockpos$mutable);
                    if (fluidstate.func_206884_a(FluidTags.field_206959_a)) {
                        f = Math.max(f, fluidstate.func_215679_a((IBlockReader)((Object)this.field_70170_p), blockpos$mutable));
                    }
                    if (f >= 1.0f) continue block0;
                }
            }
            if (!(f < 1.0f)) continue;
            return (float)blockpos$mutable.func_177956_o() + f;
        }
        return l + 1;
    }

    public float func_184441_l() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        AxisAlignedBB axisalignedbb1 = new AxisAlignedBB(axisalignedbb.field_72340_a, axisalignedbb.field_72338_b - 0.001, axisalignedbb.field_72339_c, axisalignedbb.field_72336_d, axisalignedbb.field_72338_b, axisalignedbb.field_72334_f);
        int i = MathHelper.func_76128_c((double)axisalignedbb1.field_72340_a) - 1;
        int j = MathHelper.func_76143_f((double)axisalignedbb1.field_72336_d) + 1;
        int k = MathHelper.func_76128_c((double)axisalignedbb1.field_72338_b) - 1;
        int l = MathHelper.func_76143_f((double)axisalignedbb1.field_72337_e) + 1;
        int i1 = MathHelper.func_76128_c((double)axisalignedbb1.field_72339_c) - 1;
        int j1 = MathHelper.func_76143_f((double)axisalignedbb1.field_72334_f) + 1;
        VoxelShape voxelshape = VoxelShapes.func_197881_a(axisalignedbb1);
        float f = 0.0f;
        int k1 = 0;
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int l1 = i; l1 < j; ++l1) {
            for (int i2 = i1; i2 < j1; ++i2) {
                int j2 = (l1 != i && l1 != j - 1 ? 0 : 1) + (i2 != i1 && i2 != j1 - 1 ? 0 : 1);
                if (j2 == 2) continue;
                for (int k2 = k; k2 < l; ++k2) {
                    if (j2 > 0 && (k2 == k || k2 == l - 1)) continue;
                    blockpos$mutable.func_181079_c(l1, k2, i2);
                    BlockState blockstate = this.field_70170_p.func_180495_p(blockpos$mutable);
                    if (blockstate.func_177230_c() instanceof LilyPadBlock || !VoxelShapes.func_197879_c(blockstate.func_196952_d((IBlockReader)((Object)this.field_70170_p), blockpos$mutable).func_197751_a((double)l1, (double)k2, (double)i2), voxelshape, IBooleanFunction.field_223238_i_)) continue;
                    f += blockstate.getSlipperiness((IWorldReader)((Object)this.field_70170_p), blockpos$mutable, this);
                    ++k1;
                }
            }
        }
        return f / (float)k1;
    }

    private boolean func_184446_u() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        int i = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int j = MathHelper.func_76143_f((double)axisalignedbb.field_72336_d);
        int k = MathHelper.func_76128_c((double)axisalignedbb.field_72338_b);
        int l = MathHelper.func_76143_f((double)(axisalignedbb.field_72338_b + 0.001));
        int i1 = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int j1 = MathHelper.func_76143_f((double)axisalignedbb.field_72334_f);
        boolean flag = false;
        this.field_184465_aD = Double.MIN_VALUE;
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos$mutable.func_181079_c(k1, l1, i2);
                    FluidState fluidstate = this.field_70170_p.func_204610_c(blockpos$mutable);
                    if (!fluidstate.func_206884_a(FluidTags.field_206959_a)) continue;
                    float f = (float)l1 + fluidstate.func_215679_a((IBlockReader)((Object)this.field_70170_p), blockpos$mutable);
                    this.field_184465_aD = Math.max((double)f, this.field_184465_aD);
                    flag |= axisalignedbb.field_72338_b < (double)f;
                }
            }
        }
        return flag;
    }

    @Nullable
    private Status func_184444_v() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        double d0 = axisalignedbb.field_72337_e + 0.001;
        int i = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int j = MathHelper.func_76143_f((double)axisalignedbb.field_72336_d);
        int k = MathHelper.func_76128_c((double)axisalignedbb.field_72337_e);
        int l = MathHelper.func_76143_f((double)d0);
        int i1 = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int j1 = MathHelper.func_76143_f((double)axisalignedbb.field_72334_f);
        boolean flag = false;
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos$mutable.func_181079_c(k1, l1, i2);
                    FluidState fluidstate = this.field_70170_p.func_204610_c(blockpos$mutable);
                    if (!fluidstate.func_206884_a(FluidTags.field_206959_a) || !(d0 < (double)((float)blockpos$mutable.func_177956_o() + fluidstate.func_215679_a((IBlockReader)((Object)this.field_70170_p), blockpos$mutable)))) continue;
                    if (!fluidstate.func_206889_d()) {
                        return Status.UNDER_FLOWING_WATER;
                    }
                    flag = true;
                }
            }
        }
        return flag ? Status.UNDER_WATER : null;
    }

    private void func_184450_w() {
        double d0 = -0.04f;
        double d1 = this.func_189652_ae() ? 0.0 : (double)-0.04f;
        double d2 = 0.0;
        this.field_184472_g = 0.05f;
        if (this.field_184471_aG == Status.IN_AIR && this.field_184469_aF != Status.IN_AIR && this.field_184469_aF != Status.ON_LAND) {
            this.field_184465_aD = this.func_226283_e_(1.0);
            this.func_70107_b(this.func_226277_ct_(), (double)(this.func_184451_k() - this.func_213302_cg()) + 0.101, this.func_226281_cx_());
            this.func_213317_d(this.func_213322_ci().func_216372_d(1.0, 0.0, 1.0));
            this.field_184473_aH = 0.0;
            this.field_184469_aF = Status.IN_WATER;
        } else {
            if (this.field_184469_aF == Status.IN_WATER) {
                d2 = (this.field_184465_aD - this.func_226278_cu_()) / (double)this.func_213302_cg();
                this.field_184472_g = 0.9f;
            } else if (this.field_184469_aF == Status.UNDER_FLOWING_WATER) {
                d1 = -7.0E-4;
                this.field_184472_g = 0.9f;
            } else if (this.field_184469_aF == Status.UNDER_WATER) {
                d2 = 0.01f;
                this.field_184472_g = 0.45f;
            } else if (this.field_184469_aF == Status.IN_AIR) {
                this.field_184472_g = 0.9f;
            } else if (this.field_184469_aF == Status.ON_LAND) {
                this.field_184472_g = this.field_184467_aE;
                if (this.func_184179_bs() instanceof PlayerEntity) {
                    this.field_184467_aE /= 2.0f;
                }
            }
            Vector3d vector3d = this.func_213322_ci();
            this.func_213293_j(vector3d.field_72450_a * (double)this.field_184472_g, vector3d.field_72448_b + d1, vector3d.field_72449_c * (double)this.field_184472_g);
            this.field_184475_as *= this.field_184472_g;
            if (d2 > 0.0) {
                Vector3d vector3d1 = this.func_213322_ci();
                this.func_213293_j(vector3d1.field_72450_a, (vector3d1.field_72448_b + d2 * 0.06153846016296973) * 0.75, vector3d1.field_72449_c);
            }
        }
    }

    private void func_184443_x() {
        if (this.func_184207_aI()) {
            float f = 0.0f;
            if (this.field_184480_az) {
                this.field_184475_as -= 1.0f;
            }
            if (this.field_184459_aA) {
                this.field_184475_as += 1.0f;
            }
            if (this.field_184459_aA != this.field_184480_az && !this.field_184461_aB && !this.field_184463_aC) {
                f += 0.005f;
            }
            this.field_70177_z += this.field_184475_as;
            if (this.field_184461_aB) {
                f += 0.04f;
            }
            if (this.field_184463_aC) {
                f -= 0.005f;
            }
            this.func_213317_d(this.func_213322_ci().func_72441_c(MathHelper.func_76126_a((float)(-this.field_70177_z * ((float)Math.PI / 180))) * f, 0.0, MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * f));
            this.func_184445_a(this.field_184459_aA && !this.field_184480_az || this.field_184461_aB, this.field_184480_az && !this.field_184459_aA || this.field_184461_aB);
        }
    }

    @Override
    public void func_184232_k(Entity p_184232_1_) {
        if (this.func_184196_w(p_184232_1_)) {
            float f = 0.0f;
            float f1 = (float)((this.field_70128_L ? (double)0.01f : this.func_70042_X()) + p_184232_1_.func_70033_W());
            if (this.func_184188_bt().size() > 1) {
                int i = this.func_184188_bt().indexOf(p_184232_1_);
                f = i == 0 ? 0.2f : -0.6f;
                if (p_184232_1_ instanceof AnimalEntity) {
                    f = (float)((double)f + 0.2);
                }
            }
            Vector3d vector3d = new Vector3d(f, 0.0, 0.0).func_178785_b(-this.field_70177_z * ((float)Math.PI / 180) - 1.5707964f);
            p_184232_1_.func_70107_b(this.func_226277_ct_() + vector3d.field_72450_a, this.func_226278_cu_() + (double)f1, this.func_226281_cx_() + vector3d.field_72449_c);
            p_184232_1_.field_70177_z += this.field_184475_as;
            p_184232_1_.func_70034_d(p_184232_1_.func_70079_am() + this.field_184475_as);
            this.func_184454_a(p_184232_1_);
            if (p_184232_1_ instanceof AnimalEntity && this.func_184188_bt().size() > 1) {
                int j = p_184232_1_.func_145782_y() % 2 == 0 ? 90 : 270;
                p_184232_1_.func_181013_g(((AnimalEntity)p_184232_1_).field_70761_aq + (float)j);
                p_184232_1_.func_70034_d(p_184232_1_.func_70079_am() + (float)j);
            }
        }
    }

    @Override
    public Vector3d func_230268_c_(LivingEntity p_230268_1_) {
        double d1;
        Vector3d vector3d = BoatEntity.func_233559_a_(this.func_213311_cf() * MathHelper.field_180189_a, p_230268_1_.func_213311_cf(), this.field_70177_z);
        double d0 = this.func_226277_ct_() + vector3d.field_72450_a;
        BlockPos blockpos = new BlockPos(d0, this.func_174813_aQ().field_72337_e, d1 = this.func_226281_cx_() + vector3d.field_72449_c);
        BlockPos blockpos1 = blockpos.func_177977_b();
        if (!this.field_70170_p.func_201671_F(blockpos1)) {
            double d2 = (double)blockpos.func_177956_o() + this.field_70170_p.func_242403_h(blockpos);
            double d3 = (double)blockpos.func_177956_o() + this.field_70170_p.func_242403_h(blockpos1);
            for (Pose pose : p_230268_1_.func_230297_ef_()) {
                Vector3d vector3d1 = TransportationHelper.func_242381_a((ICollisionReader)this.field_70170_p, (double)d0, (double)d2, (double)d1, (LivingEntity)p_230268_1_, (Pose)pose);
                if (vector3d1 != null) {
                    p_230268_1_.func_213301_b(pose);
                    return vector3d1;
                }
                Vector3d vector3d2 = TransportationHelper.func_242381_a((ICollisionReader)this.field_70170_p, (double)d0, (double)d3, (double)d1, (LivingEntity)p_230268_1_, (Pose)pose);
                if (vector3d2 == null) continue;
                p_230268_1_.func_213301_b(pose);
                return vector3d2;
            }
        }
        return super.func_230268_c_(p_230268_1_);
    }

    protected void func_184454_a(Entity p_184454_1_) {
        p_184454_1_.func_181013_g(this.field_70177_z);
        float f = MathHelper.func_76142_g((float)(p_184454_1_.field_70177_z - this.field_70177_z));
        float f1 = MathHelper.func_76131_a((float)f, (float)-105.0f, (float)105.0f);
        p_184454_1_.field_70126_B += f1 - f;
        p_184454_1_.field_70177_z += f1 - f;
        p_184454_1_.func_70034_d(p_184454_1_.field_70177_z);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_184190_l(Entity p_184190_1_) {
        this.func_184454_a(p_184190_1_);
    }

    @Override
    protected void func_213281_b(CompoundNBT p_213281_1_) {
        p_213281_1_.func_74778_a("Type", this.func_184453_r().func_184980_a());
    }

    @Override
    protected void func_70037_a(CompoundNBT p_70037_1_) {
        if (p_70037_1_.func_150297_b("Type", 8)) {
            this.func_184458_a(Type.func_184981_a(p_70037_1_.func_74779_i("Type")));
        }
    }

    @Override
    public ActionResultType func_184230_a(PlayerEntity p_184230_1_, Hand p_184230_2_) {
        if (p_184230_1_.func_226563_dT_()) {
            return ActionResultType.PASS;
        }
        if (this.field_184474_h < 60.0f) {
            if (!this.field_70170_p.field_72995_K) {
                return p_184230_1_.func_184220_m(this) ? ActionResultType.CONSUME : ActionResultType.PASS;
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    @Override
    protected void func_184231_a(double p_184231_1_, boolean p_184231_3_, BlockState p_184231_4_, BlockPos p_184231_5_) {
        this.field_184473_aH = this.func_213322_ci().field_72448_b;
        if (!this.func_184218_aH()) {
            if (p_184231_3_) {
                if (this.field_70143_R > 3.0f) {
                    if (this.field_184469_aF != Status.ON_LAND) {
                        this.field_70143_R = 0.0f;
                        return;
                    }
                    this.func_225503_b_(this.field_70143_R, 1.0f);
                    if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
                        Vehicle vehicle = (Vehicle)this.getBukkitEntity();
                        VehicleDestroyEvent destroyEvent = new VehicleDestroyEvent(vehicle, null);
                        this.field_70170_p.getCBServer().getPluginManager().callEvent((Event)destroyEvent);
                        if (!destroyEvent.isCancelled()) {
                            this.func_70106_y();
                            if (this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
                                for (int i = 0; i < 3; ++i) {
                                    this.func_199703_a(this.func_184453_r().func_195933_b());
                                }
                                for (int j = 0; j < 2; ++j) {
                                    this.func_199703_a(Items.field_151055_y);
                                }
                            }
                        }
                    }
                }
                this.field_70143_R = 0.0f;
            } else if (!this.field_70170_p.func_204610_c(this.func_233580_cy_().func_177977_b()).func_206884_a(FluidTags.field_206959_a) && p_184231_1_ < 0.0) {
                this.field_70143_R = (float)((double)this.field_70143_R - p_184231_1_);
            }
        }
    }

    public boolean func_184457_a(int p_184457_1_) {
        return this.field_70180_af.func_187225_a(p_184457_1_ == 0 ? field_199704_e : field_199705_f) != false && this.func_184179_bs() != null;
    }

    public void func_70266_a(float p_70266_1_) {
        this.field_70180_af.func_187227_b(field_184464_c, Float.valueOf(p_70266_1_));
    }

    public float func_70271_g() {
        return this.field_70180_af.func_187225_a(field_184464_c).floatValue();
    }

    public void func_70265_b(int p_70265_1_) {
        this.field_70180_af.func_187227_b(field_184460_a, p_70265_1_);
    }

    public int func_70268_h() {
        return this.field_70180_af.func_187225_a(field_184460_a);
    }

    private void func_203055_e(int p_203055_1_) {
        this.field_70180_af.func_187227_b(field_203064_g, p_203055_1_);
    }

    private int func_203058_B() {
        return this.field_70180_af.func_187225_a(field_203064_g);
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_203056_b(float p_203056_1_) {
        return MathHelper.func_219799_g((float)p_203056_1_, (float)this.field_203063_aQ, (float)this.field_203062_aP);
    }

    public void func_70269_c(int p_70269_1_) {
        this.field_70180_af.func_187227_b(field_184462_b, p_70269_1_);
    }

    public int func_70267_i() {
        return this.field_70180_af.func_187225_a(field_184462_b);
    }

    public void func_184458_a(Type p_184458_1_) {
        this.field_70180_af.func_187227_b(field_184466_d, p_184458_1_.ordinal());
    }

    public Type func_184453_r() {
        return Type.func_184979_a(this.field_70180_af.func_187225_a(field_184466_d));
    }

    @Override
    protected boolean func_184219_q(Entity p_184219_1_) {
        return this.func_184188_bt().size() < 2 && !this.func_208600_a(FluidTags.field_206959_a);
    }

    @Override
    @Nullable
    public Entity func_184179_bs() {
        List<Entity> list = this.func_184188_bt();
        return list.isEmpty() ? null : list.get(0);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_184442_a(boolean p_184442_1_, boolean p_184442_2_, boolean p_184442_3_, boolean p_184442_4_) {
        this.field_184480_az = p_184442_1_;
        this.field_184459_aA = p_184442_2_;
        this.field_184461_aB = p_184442_3_;
        this.field_184463_aC = p_184442_4_;
    }

    @Override
    public IPacket<?> func_213297_N() {
        return new SSpawnObjectPacket((Entity)this);
    }

    @Override
    public boolean func_204231_K() {
        return this.field_184469_aF == Status.UNDER_WATER || this.field_184469_aF == Status.UNDER_FLOWING_WATER;
    }

    @Override
    protected void func_184200_o(Entity passenger) {
        super.func_184200_o(passenger);
        if (this.func_184186_bw() && this.field_184476_at > 0) {
            this.field_184476_at = 0;
            this.func_70080_a(this.field_70281_h, this.field_184477_av, this.field_184478_aw, (float)this.field_70273_g, (float)this.field_184479_ay);
        }
    }

    public static enum Type {
        OAK(Blocks.field_196662_n, "oak"),
        SPRUCE(Blocks.field_196664_o, "spruce"),
        BIRCH(Blocks.field_196666_p, "birch"),
        JUNGLE(Blocks.field_196668_q, "jungle"),
        ACACIA(Blocks.field_196670_r, "acacia"),
        DARK_OAK(Blocks.field_196672_s, "dark_oak");

        private final String field_184990_g;
        private final Block field_195934_h;

        private Type(Block p_i48146_3_, String p_i48146_4_) {
            this.field_184990_g = p_i48146_4_;
            this.field_195934_h = p_i48146_3_;
        }

        public String func_184980_a() {
            return this.field_184990_g;
        }

        public Block func_195933_b() {
            return this.field_195934_h;
        }

        public String toString() {
            return this.field_184990_g;
        }

        public static Type func_184979_a(int p_184979_0_) {
            Type[] aboatentity$type = Type.values();
            if (p_184979_0_ < 0 || p_184979_0_ >= aboatentity$type.length) {
                p_184979_0_ = 0;
            }
            return aboatentity$type[p_184979_0_];
        }

        public static Type func_184981_a(String p_184981_0_) {
            Type[] aboatentity$type = Type.values();
            for (int i = 0; i < aboatentity$type.length; ++i) {
                if (!aboatentity$type[i].func_184980_a().equals(p_184981_0_)) continue;
                return aboatentity$type[i];
            }
            return aboatentity$type[0];
        }
    }

    public static enum Status {
        IN_WATER,
        UNDER_WATER,
        UNDER_FLOWING_WATER,
        ON_LAND,
        IN_AIR;

    }
}

