/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.item;

import com.mohistmc.util.i18n.i18n;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.RedstoneDiodeBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.item.HangingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.FilledMapItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SSpawnObjectPacket;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapData;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bukkit.craftbukkit.v1_16_R3.event.CraftEventFactory;

public class ItemFrameEntity
extends HangingEntity {
    private static final Logger field_195052_c = LogManager.getLogger();
    private static final DataParameter<ItemStack> field_184525_c = EntityDataManager.func_187226_a(ItemFrameEntity.class, DataSerializers.field_187196_f);
    private static final DataParameter<Integer> field_184526_d = EntityDataManager.func_187226_a(ItemFrameEntity.class, DataSerializers.field_187192_b);
    public float field_82337_e = 1.0f;
    public boolean field_234259_an_;

    public ItemFrameEntity(EntityType<? extends ItemFrameEntity> p_i50224_1_, World p_i50224_2_) {
        super((EntityType<? extends HangingEntity>)p_i50224_1_, p_i50224_2_);
    }

    public ItemFrameEntity(World p_i45852_1_, BlockPos p_i45852_2_, Direction p_i45852_3_) {
        super(EntityType.field_200766_F, p_i45852_1_, p_i45852_2_);
        this.func_174859_a(p_i45852_3_);
    }

    @Override
    protected float func_213316_a(Pose p_213316_1_, EntitySize p_213316_2_) {
        return 0.0f;
    }

    @Override
    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(field_184525_c, ItemStack.field_190927_a);
        this.func_184212_Q().func_187214_a(field_184526_d, 0);
    }

    @Override
    public void func_174859_a(Direction p_174859_1_) {
        Validate.notNull((Object)((Object)p_174859_1_));
        this.field_174860_b = p_174859_1_;
        if (p_174859_1_.func_176740_k().func_176722_c()) {
            this.field_70125_A = 0.0f;
            this.field_70177_z = this.field_174860_b.func_176736_b() * 90;
        } else {
            this.field_70125_A = -90 * p_174859_1_.func_176743_c().func_179524_a();
            this.field_70177_z = 0.0f;
        }
        this.field_70127_C = this.field_70125_A;
        this.field_70126_B = this.field_70177_z;
        this.func_174856_o();
    }

    @Override
    protected void func_174856_o() {
        if (this.field_174860_b != null) {
            this.func_174826_a(ItemFrameEntity.calculateBoundingBox(this, this.field_174861_a, this.field_174860_b, this.func_82329_d(), this.func_82330_g()));
        }
    }

    public static AxisAlignedBB calculateBoundingBox(@Nullable Entity entity, BlockPos blockPosition, Direction direction, int width, int height) {
        double d0 = 0.46875;
        double d1 = (double)blockPosition.func_177958_n() + 0.5 - (double)direction.func_82601_c() * 0.46875;
        double d2 = (double)blockPosition.func_177956_o() + 0.5 - (double)direction.func_96559_d() * 0.46875;
        double d3 = (double)blockPosition.func_177952_p() + 0.5 - (double)direction.func_82599_e() * 0.46875;
        if (entity != null) {
            entity.func_226288_n_(d1, d2, d3);
        }
        double d4 = width;
        double d5 = height;
        double d6 = width;
        Direction.Axis direction$axis = direction.func_176740_k();
        switch (direction$axis) {
            case X: {
                d4 = 1.0;
                break;
            }
            case Y: {
                d5 = 1.0;
                break;
            }
            case Z: {
                d6 = 1.0;
            }
        }
        return new AxisAlignedBB(d1 - (d4 /= 32.0), d2 - (d5 /= 32.0), d3 - (d6 /= 32.0), d1 + d4, d2 + d5, d3 + d6);
    }

    @Override
    public boolean func_70518_d() {
        if (this.field_234259_an_) {
            return true;
        }
        if (!this.field_70170_p.func_226669_j_(this)) {
            return false;
        }
        BlockState blockstate = this.field_70170_p.func_180495_p(this.field_174861_a.func_177972_a(this.field_174860_b.func_176734_d()));
        return blockstate.func_185904_a().func_76220_a() || this.field_174860_b.func_176740_k().func_176722_c() && RedstoneDiodeBlock.func_185546_B(blockstate) ? this.field_70170_p.func_175674_a(this, this.func_174813_aQ(), field_184524_c).isEmpty() : false;
    }

    @Override
    public void func_213315_a(MoverType p_213315_1_, Vector3d p_213315_2_) {
        if (!this.field_234259_an_) {
            super.func_213315_a(p_213315_1_, p_213315_2_);
        }
    }

    @Override
    public void func_70024_g(double p_70024_1_, double p_70024_3_, double p_70024_5_) {
        if (!this.field_234259_an_) {
            super.func_70024_g(p_70024_1_, p_70024_3_, p_70024_5_);
        }
    }

    @Override
    public float func_70111_Y() {
        return 0.0f;
    }

    @Override
    public void func_174812_G() {
        this.func_110131_b(this.func_82335_i());
        super.func_174812_G();
    }

    @Override
    public boolean func_70097_a(DamageSource p_70097_1_, float p_70097_2_) {
        if (this.field_234259_an_) {
            return p_70097_1_ != DamageSource.field_76380_i && !p_70097_1_.func_180136_u() ? false : super.func_70097_a(p_70097_1_, p_70097_2_);
        }
        if (this.func_180431_b(p_70097_1_)) {
            return false;
        }
        if (!p_70097_1_.func_94541_c() && !this.func_82335_i().func_190926_b()) {
            if (!this.field_70170_p.field_72995_K) {
                if (CraftEventFactory.handleNonLivingEntityDamageEvent((Entity)this, (DamageSource)p_70097_1_, (double)p_70097_2_, (boolean)false) || this.field_70128_L) {
                    return true;
                }
                this.func_146065_b(p_70097_1_.func_76346_g(), false);
                this.func_184185_a(SoundEvents.field_187629_cO, 1.0f, 1.0f);
            }
            return true;
        }
        return super.func_70097_a(p_70097_1_, p_70097_2_);
    }

    @Override
    public int func_82329_d() {
        return 12;
    }

    @Override
    public int func_82330_g() {
        return 12;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double p_70112_1_) {
        double d0 = 16.0;
        return p_70112_1_ < (d0 = d0 * 64.0 * ItemFrameEntity.func_184183_bd()) * d0;
    }

    @Override
    public void func_110128_b(@Nullable Entity p_110128_1_) {
        this.func_184185_a(SoundEvents.field_187623_cM, 1.0f, 1.0f);
        this.func_146065_b(p_110128_1_, true);
    }

    @Override
    public void func_184523_o() {
        this.func_184185_a(SoundEvents.field_187626_cN, 1.0f, 1.0f);
    }

    private void func_146065_b(@Nullable Entity p_146065_1_, boolean p_146065_2_) {
        if (!this.field_234259_an_) {
            ItemStack itemstack = this.func_82335_i();
            this.func_82334_a(ItemStack.field_190927_a);
            if (!this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
                if (p_146065_1_ == null) {
                    this.func_110131_b(itemstack);
                }
            } else {
                if (p_146065_1_ instanceof PlayerEntity) {
                    PlayerEntity playerentity = (PlayerEntity)p_146065_1_;
                    if (playerentity.field_71075_bZ.field_75098_d) {
                        this.func_110131_b(itemstack);
                        return;
                    }
                }
                if (p_146065_2_) {
                    this.func_199703_a(Items.field_151160_bD);
                }
                if (!itemstack.func_190926_b()) {
                    itemstack = itemstack.func_77946_l();
                    this.func_110131_b(itemstack);
                    if (this.field_70146_Z.nextFloat() < this.field_82337_e) {
                        this.func_199701_a_(itemstack);
                    }
                }
            }
        }
    }

    private void func_110131_b(ItemStack p_110131_1_) {
        if (p_110131_1_.func_77973_b() == Items.field_151098_aY) {
            MapData mapdata = FilledMapItem.func_195950_a(p_110131_1_, this.field_70170_p);
            mapdata.func_212441_a(this.field_174861_a, this.func_145782_y());
            mapdata.func_76186_a(true);
        }
        p_110131_1_.func_234695_a_(null);
    }

    public ItemStack func_82335_i() {
        return this.func_184212_Q().func_187225_a(field_184525_c);
    }

    public void func_82334_a(ItemStack p_82334_1_) {
        this.func_174864_a(p_82334_1_, true);
    }

    public void func_174864_a(ItemStack p_174864_1_, boolean p_174864_2_) {
        this.setItem(p_174864_1_, p_174864_2_, true);
    }

    public void setItem(ItemStack stack, boolean p_174864_2_, boolean playSound) {
        if (!stack.func_190926_b()) {
            stack = stack.func_77946_l();
            stack.func_190920_e(1);
            stack.func_234695_a_(this);
        }
        this.func_184212_Q().func_187227_b(field_184525_c, stack);
        if (!stack.func_190926_b() && p_174864_2_ && playSound) {
            this.func_184185_a(SoundEvents.field_187620_cL, 1.0f, 1.0f);
        }
        if (p_174864_2_ && this.field_174861_a != null) {
            this.field_70170_p.func_175666_e(this.field_174861_a, Blocks.field_150350_a);
        }
    }

    @Override
    public boolean func_174820_d(int p_174820_1_, ItemStack p_174820_2_) {
        if (p_174820_1_ == 0) {
            this.func_82334_a(p_174820_2_);
            return true;
        }
        return false;
    }

    @Override
    public void func_184206_a(DataParameter<?> p_184206_1_) {
        ItemStack itemstack;
        if (p_184206_1_.equals(field_184525_c) && !(itemstack = this.func_82335_i()).func_190926_b() && itemstack.func_82836_z() != this) {
            itemstack.func_234695_a_(this);
        }
    }

    public int func_82333_j() {
        return this.func_184212_Q().func_187225_a(field_184526_d);
    }

    public void func_82336_g(int p_82336_1_) {
        this.func_174865_a(p_82336_1_, true);
    }

    private void func_174865_a(int p_174865_1_, boolean p_174865_2_) {
        this.func_184212_Q().func_187227_b(field_184526_d, p_174865_1_ % 8);
        if (p_174865_2_ && this.field_174861_a != null) {
            this.field_70170_p.func_175666_e(this.field_174861_a, Blocks.field_150350_a);
        }
    }

    @Override
    public void func_213281_b(CompoundNBT p_213281_1_) {
        super.func_213281_b(p_213281_1_);
        if (!this.func_82335_i().func_190926_b()) {
            p_213281_1_.func_218657_a("Item", this.func_82335_i().func_77955_b(new CompoundNBT()));
            p_213281_1_.func_74774_a("ItemRotation", (byte)this.func_82333_j());
            p_213281_1_.func_74776_a("ItemDropChance", this.field_82337_e);
        }
        p_213281_1_.func_74774_a("Facing", (byte)this.field_174860_b.func_176745_a());
        p_213281_1_.func_74757_a("Invisible", this.func_82150_aj());
        p_213281_1_.func_74757_a("Fixed", this.field_234259_an_);
    }

    @Override
    public void func_70037_a(CompoundNBT p_70037_1_) {
        super.func_70037_a(p_70037_1_);
        CompoundNBT compoundnbt = p_70037_1_.func_74775_l("Item");
        if (compoundnbt != null && !compoundnbt.isEmpty()) {
            ItemStack itemstack1;
            ItemStack itemstack = ItemStack.func_199557_a(compoundnbt);
            if (itemstack.func_190926_b()) {
                field_195052_c.warn(i18n.get((String)"itemframeentity.1", (Object[])new Object[]{compoundnbt}));
            }
            if (!(itemstack1 = this.func_82335_i()).func_190926_b() && !ItemStack.func_77989_b(itemstack, itemstack1)) {
                this.func_110131_b(itemstack1);
            }
            this.func_174864_a(itemstack, false);
            this.func_174865_a(p_70037_1_.func_74771_c("ItemRotation"), false);
            if (p_70037_1_.func_150297_b("ItemDropChance", 99)) {
                this.field_82337_e = p_70037_1_.func_74760_g("ItemDropChance");
            }
        }
        this.func_174859_a(Direction.func_82600_a(p_70037_1_.func_74771_c("Facing")));
        this.func_82142_c(p_70037_1_.func_74767_n("Invisible"));
        this.field_234259_an_ = p_70037_1_.func_74767_n("Fixed");
    }

    @Override
    public ActionResultType func_184230_a(PlayerEntity p_184230_1_, Hand p_184230_2_) {
        boolean flag1;
        ItemStack itemstack = p_184230_1_.func_184586_b(p_184230_2_);
        boolean flag = !this.func_82335_i().func_190926_b();
        boolean bl = flag1 = !itemstack.func_190926_b();
        if (this.field_234259_an_) {
            return ActionResultType.PASS;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (!flag) {
                if (flag1 && !this.field_70128_L) {
                    this.func_82334_a(itemstack);
                    if (!p_184230_1_.field_71075_bZ.field_75098_d) {
                        itemstack.func_190918_g(1);
                    }
                }
            } else {
                this.func_184185_a(SoundEvents.field_187632_cP, 1.0f, 1.0f);
                this.func_82336_g(this.func_82333_j() + 1);
            }
            return ActionResultType.CONSUME;
        }
        return !flag && !flag1 ? ActionResultType.PASS : ActionResultType.SUCCESS;
    }

    public int func_174866_q() {
        return this.func_82335_i().func_190926_b() ? 0 : this.func_82333_j() % 8 + 1;
    }

    @Override
    public IPacket<?> func_213297_N() {
        return new SSpawnObjectPacket((Entity)this, this.func_200600_R(), this.field_174860_b.func_176745_a(), this.func_174857_n());
    }
}

