/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import com.google.common.collect.Lists;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.MoveTowardsRaidGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.AbstractIllagerEntity;
import net.minecraft.entity.monster.PatrollerEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.GameRules;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.raid.Raid;
import net.minecraft.world.raid.RaidManager;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.bukkit.event.entity.EntityPotionEffectEvent;
import org.bukkit.event.entity.EntityTargetEvent;

public abstract class AbstractRaiderEntity
extends PatrollerEntity {
    protected static final DataParameter<Boolean> field_213666_c = EntityDataManager.func_187226_a(AbstractRaiderEntity.class, DataSerializers.field_187198_h);
    private static final Predicate<ItemEntity> field_213665_b = p_213647_0_ -> !p_213647_0_.func_174874_s() && p_213647_0_.func_70089_S() && ItemStack.func_77989_b(p_213647_0_.func_92059_d(), Raid.func_221312_H());
    @Nullable
    protected Raid field_213667_d;
    private int field_213668_bz;
    private boolean field_213669_bA;
    private int field_213664_bB;

    protected AbstractRaiderEntity(EntityType<? extends AbstractRaiderEntity> p_i50143_1_, World p_i50143_2_) {
        super(p_i50143_1_, p_i50143_2_);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new PromoteLeaderGoal(this, this));
        this.field_70714_bg.func_75776_a(3, (Goal)new MoveTowardsRaidGoal(this));
        this.field_70714_bg.func_75776_a(4, (Goal)new InvadeHomeGoal(this, 1.05f, 1));
        this.field_70714_bg.func_75776_a(5, (Goal)new CelebrateRaidLossGoal(this));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_213666_c, false);
    }

    public abstract void func_213660_a(int var1, boolean var2);

    public boolean func_213658_ej() {
        return this.field_213669_bA;
    }

    public void func_213644_t(boolean p_213644_1_) {
        this.field_213669_bA = p_213644_1_;
    }

    public void func_70636_d() {
        if (this.field_70170_p instanceof ServerWorld && this.func_70089_S()) {
            Raid raid = this.func_213663_ek();
            if (this.func_213658_ej()) {
                if (raid == null) {
                    Raid raid1;
                    if (this.field_70170_p.func_82737_E() % 20L == 0L && (raid1 = ((ServerWorld)this.field_70170_p).func_217475_c_(this.func_233580_cy_())) != null && RaidManager.func_215165_a(this, raid1)) {
                        raid1.func_221317_a(raid1.func_221315_l(), this, null, true);
                    }
                } else {
                    LivingEntity livingentity = this.func_70638_az();
                    if (livingentity != null && (livingentity.func_200600_R() == EntityType.field_200729_aH || livingentity.func_200600_R() == EntityType.field_200757_aw)) {
                        this.field_70708_bq = 0;
                    }
                }
            }
        }
        super.func_70636_d();
    }

    protected void func_213623_ec() {
        this.field_70708_bq += 2;
    }

    public void func_70645_a(DamageSource p_70645_1_) {
        if (this.field_70170_p instanceof ServerWorld) {
            Entity entity = p_70645_1_.func_76346_g();
            Raid raid = this.func_213663_ek();
            if (raid != null) {
                if (this.func_213630_eb()) {
                    raid.func_221296_c(this.func_213642_em());
                }
                if (entity != null && entity.func_200600_R() == EntityType.field_200729_aH) {
                    raid.func_221311_a(entity);
                }
                raid.func_221322_a(this, false);
            }
            if (this.func_213630_eb() && raid == null && ((ServerWorld)this.field_70170_p).func_217475_c_(this.func_233580_cy_()) == null) {
                ItemStack itemstack = this.func_184582_a(EquipmentSlotType.HEAD);
                PlayerEntity playerentity = null;
                if (entity instanceof PlayerEntity) {
                    playerentity = (PlayerEntity)entity;
                } else if (entity instanceof WolfEntity) {
                    WolfEntity wolfentity = (WolfEntity)((Object)entity);
                    LivingEntity livingentity = wolfentity.func_70902_q();
                    if (wolfentity.func_70909_n() && livingentity instanceof PlayerEntity) {
                        playerentity = (PlayerEntity)livingentity;
                    }
                }
                if (!itemstack.func_190926_b() && ItemStack.func_77989_b(itemstack, Raid.func_221312_H()) && playerentity != null) {
                    EffectInstance effectinstance1 = playerentity.func_70660_b(Effects.field_220309_E);
                    int i = 1;
                    if (effectinstance1 != null) {
                        i += effectinstance1.func_76458_c();
                        playerentity.func_184596_c(Effects.field_220309_E);
                    } else {
                        --i;
                    }
                    i = MathHelper.func_76125_a((int)i, (int)0, (int)4);
                    EffectInstance effectinstance = new EffectInstance(Effects.field_220309_E, 120000, i, false, false, true);
                    if (!this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223621_x)) {
                        playerentity.addEffect(effectinstance, EntityPotionEffectEvent.Cause.PATROL_CAPTAIN);
                    }
                }
            }
        }
        super.func_70645_a(p_70645_1_);
    }

    public boolean func_213634_ed() {
        return !this.func_213657_el();
    }

    public void func_213652_a(@Nullable Raid p_213652_1_) {
        this.field_213667_d = p_213652_1_;
    }

    @Nullable
    public Raid func_213663_ek() {
        return this.field_213667_d;
    }

    public boolean func_213657_el() {
        return this.func_213663_ek() != null && this.func_213663_ek().func_221333_v();
    }

    public void func_213651_a(int p_213651_1_) {
        this.field_213668_bz = p_213651_1_;
    }

    public int func_213642_em() {
        return this.field_213668_bz;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_213656_en() {
        return this.field_70180_af.func_187225_a(field_213666_c);
    }

    public void func_213655_u(boolean p_213655_1_) {
        this.field_70180_af.func_187227_b(field_213666_c, p_213655_1_);
    }

    public void func_213281_b(CompoundNBT p_213281_1_) {
        super.func_213281_b(p_213281_1_);
        p_213281_1_.func_74768_a("Wave", this.field_213668_bz);
        p_213281_1_.func_74757_a("CanJoinRaid", this.field_213669_bA);
        if (this.field_213667_d != null) {
            p_213281_1_.func_74768_a("RaidId", this.field_213667_d.func_221325_u());
        }
    }

    public void func_70037_a(CompoundNBT p_70037_1_) {
        super.func_70037_a(p_70037_1_);
        this.field_213668_bz = p_70037_1_.func_74762_e("Wave");
        this.field_213669_bA = p_70037_1_.func_74767_n("CanJoinRaid");
        if (p_70037_1_.func_150297_b("RaidId", 3)) {
            if (this.field_70170_p instanceof ServerWorld) {
                this.field_213667_d = ((ServerWorld)this.field_70170_p).func_217452_C().func_215167_a(p_70037_1_.func_74762_e("RaidId"));
            }
            if (this.field_213667_d != null) {
                this.field_213667_d.func_221300_a(this.field_213668_bz, this, false);
                if (this.func_213630_eb()) {
                    this.field_213667_d.func_221324_a(this.field_213668_bz, this);
                }
            }
        }
    }

    protected void func_175445_a(ItemEntity p_175445_1_) {
        boolean flag;
        ItemStack itemstack = p_175445_1_.func_92059_d();
        boolean bl = flag = this.func_213657_el() && this.func_213663_ek().func_221332_b(this.func_213642_em()) != null;
        if (this.func_213657_el() && !flag && ItemStack.func_77989_b(itemstack, Raid.func_221312_H())) {
            EquipmentSlotType equipmentslottype = EquipmentSlotType.HEAD;
            ItemStack itemstack1 = this.func_184582_a(equipmentslottype);
            double d0 = this.func_205712_c(equipmentslottype);
            if (!itemstack1.func_190926_b() && (double)Math.max(this.field_70146_Z.nextFloat() - 0.1f, 0.0f) < d0) {
                this.func_199701_a_(itemstack1);
            }
            this.func_233630_a_(p_175445_1_);
            this.func_184201_a(equipmentslottype, itemstack);
            this.func_71001_a(p_175445_1_, itemstack.func_190916_E());
            p_175445_1_.func_70106_y();
            this.func_213663_ek().func_221324_a(this.func_213642_em(), this);
            this.func_213635_r(true);
        } else {
            super.func_175445_a(p_175445_1_);
        }
    }

    public boolean func_213397_c(double p_213397_1_) {
        return this.func_213663_ek() == null ? super.func_213397_c(p_213397_1_) : false;
    }

    public boolean func_213392_I() {
        return super.func_213392_I() || this.func_213663_ek() != null;
    }

    public int func_213661_eo() {
        return this.field_213664_bB;
    }

    public void func_213653_b(int p_213653_1_) {
        this.field_213664_bB = p_213653_1_;
    }

    public boolean func_70097_a(DamageSource p_70097_1_, float p_70097_2_) {
        if (this.func_213657_el()) {
            this.func_213663_ek().func_221320_q();
        }
        return super.func_70097_a(p_70097_1_, p_70097_2_);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld p_213386_1_, DifficultyInstance p_213386_2_, SpawnReason p_213386_3_, @Nullable ILivingEntityData p_213386_4_, @Nullable CompoundNBT p_213386_5_) {
        this.func_213644_t(this.func_200600_R() != EntityType.field_200759_ay || p_213386_3_ != SpawnReason.NATURAL);
        return super.func_213386_a(p_213386_1_, p_213386_2_, p_213386_3_, p_213386_4_, p_213386_5_);
    }

    public abstract SoundEvent func_213654_dW();

    public static class PromoteLeaderGoal<T extends AbstractRaiderEntity>
    extends Goal {
        private final T field_220856_b;
        final /* synthetic */ AbstractRaiderEntity field_220855_a;

        public PromoteLeaderGoal(T p_i50572_2_) {
            this.field_220855_a = this$0;
            this.field_220856_b = p_i50572_2_;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            Raid raid = ((AbstractRaiderEntity)((Object)this.field_220856_b)).func_213663_ek();
            if (((AbstractRaiderEntity)((Object)this.field_220856_b)).func_213657_el() && !((AbstractRaiderEntity)((Object)this.field_220856_b)).func_213663_ek().func_221319_a() && this.field_220856_b.func_213637_dY() && !ItemStack.func_77989_b(this.field_220856_b.func_184582_a(EquipmentSlotType.HEAD), Raid.func_221312_H())) {
                List<ItemEntity> list;
                AbstractRaiderEntity abstractraiderentity = raid.func_221332_b(((AbstractRaiderEntity)((Object)this.field_220856_b)).func_213642_em());
                if (!(abstractraiderentity != null && abstractraiderentity.func_70089_S() || (list = ((AbstractRaiderEntity)((Object)this.field_220856_b)).field_70170_p.func_175647_a(ItemEntity.class, this.field_220856_b.func_174813_aQ().func_72314_b(16.0, 8.0, 16.0), field_213665_b)).isEmpty())) {
                    return this.field_220856_b.func_70661_as().func_75497_a(list.get(0), 1.15f);
                }
                return false;
            }
            return false;
        }

        public void func_75246_d() {
            List<ItemEntity> list;
            if (this.field_220856_b.func_70661_as().func_208485_j().func_218137_a(this.field_220856_b.func_213303_ch(), 1.414) && !(list = ((AbstractRaiderEntity)((Object)this.field_220856_b)).field_70170_p.func_175647_a(ItemEntity.class, this.field_220856_b.func_174813_aQ().func_72314_b(4.0, 4.0, 4.0), field_213665_b)).isEmpty()) {
                ((AbstractRaiderEntity)((Object)this.field_220856_b)).func_175445_a(list.get(0));
            }
        }
    }

    static class InvadeHomeGoal
    extends Goal {
        private final AbstractRaiderEntity field_220864_a;
        private final double field_220865_b;
        private BlockPos field_220866_c;
        private final List<BlockPos> field_220867_d = Lists.newArrayList();
        private final int field_220868_e;
        private boolean field_220869_f;

        public InvadeHomeGoal(AbstractRaiderEntity p_i50570_1_, double p_i50570_2_, int p_i50570_4_) {
            this.field_220864_a = p_i50570_1_;
            this.field_220865_b = p_i50570_2_;
            this.field_220868_e = p_i50570_4_;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            this.func_220861_j();
            return this.func_220862_g() && this.func_220863_h() && this.field_220864_a.func_70638_az() == null;
        }

        private boolean func_220862_g() {
            return this.field_220864_a.func_213657_el() && !this.field_220864_a.func_213663_ek().func_221319_a();
        }

        private boolean func_220863_h() {
            ServerWorld serverworld = (ServerWorld)this.field_220864_a.field_70170_p;
            BlockPos blockpos = this.field_220864_a.func_233580_cy_();
            Optional optional = serverworld.func_217443_B().func_219163_a(p_220859_0_ -> p_220859_0_ == PointOfInterestType.field_221069_q, this::func_220860_a, PointOfInterestManager.Status.ANY, blockpos, 48, this.field_220864_a.field_70146_Z);
            if (!optional.isPresent()) {
                return false;
            }
            this.field_220866_c = ((BlockPos)optional.get()).func_185334_h();
            return true;
        }

        public boolean func_75253_b() {
            if (this.field_220864_a.func_70661_as().func_75500_f()) {
                return false;
            }
            return this.field_220864_a.func_70638_az() == null && !this.field_220866_c.func_218137_a(this.field_220864_a.func_213303_ch(), this.field_220864_a.func_213311_cf() + (float)this.field_220868_e) && !this.field_220869_f;
        }

        public void func_75251_c() {
            if (this.field_220866_c.func_218137_a(this.field_220864_a.func_213303_ch(), this.field_220868_e)) {
                this.field_220867_d.add(this.field_220866_c);
            }
        }

        public void func_75249_e() {
            super.func_75249_e();
            this.field_220864_a.func_213332_m(0);
            this.field_220864_a.func_70661_as().func_75492_a(this.field_220866_c.func_177958_n(), this.field_220866_c.func_177956_o(), this.field_220866_c.func_177952_p(), this.field_220865_b);
            this.field_220869_f = false;
        }

        public void func_75246_d() {
            if (this.field_220864_a.func_70661_as().func_75500_f()) {
                Vector3d vector3d = Vector3d.func_237492_c_(this.field_220866_c);
                Vector3d vector3d1 = RandomPositionGenerator.func_203155_a((CreatureEntity)((Object)this.field_220864_a), (int)16, (int)7, (Vector3d)vector3d, (double)0.3141592741012573);
                if (vector3d1 == null) {
                    vector3d1 = RandomPositionGenerator.func_75464_a((CreatureEntity)((Object)this.field_220864_a), (int)8, (int)7, (Vector3d)vector3d);
                }
                if (vector3d1 == null) {
                    this.field_220869_f = true;
                    return;
                }
                this.field_220864_a.func_70661_as().func_75492_a(vector3d1.field_72450_a, vector3d1.field_72448_b, vector3d1.field_72449_c, this.field_220865_b);
            }
        }

        private boolean func_220860_a(BlockPos p_220860_1_) {
            for (BlockPos blockpos : this.field_220867_d) {
                if (!Objects.equals(p_220860_1_, blockpos)) continue;
                return false;
            }
            return true;
        }

        private void func_220861_j() {
            if (this.field_220867_d.size() > 2) {
                this.field_220867_d.remove(0);
            }
        }
    }

    public class FindTargetGoal
    extends Goal {
        private final AbstractRaiderEntity field_220853_c;
        private final float field_220854_d;
        public final EntityPredicate field_220851_a = new EntityPredicate().func_221013_a(8.0).func_221009_d().func_221008_a().func_221011_b().func_221014_c().func_221010_e();

        public FindTargetGoal(AbstractIllagerEntity p_i50573_2_, float p_i50573_3_) {
            this.field_220853_c = p_i50573_2_;
            this.field_220854_d = p_i50573_3_ * p_i50573_3_;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            LivingEntity livingentity = this.field_220853_c.func_70643_av();
            return this.field_220853_c.func_213663_ek() == null && this.field_220853_c.func_213633_ef() && this.field_220853_c.func_70638_az() != null && !this.field_220853_c.func_213398_dR() && (livingentity == null || livingentity.func_200600_R() != EntityType.field_200729_aH);
        }

        public void func_75249_e() {
            super.func_75249_e();
            this.field_220853_c.func_70661_as().func_75499_g();
            for (AbstractRaiderEntity abstractraiderentity : this.field_220853_c.field_70170_p.func_217374_a(AbstractRaiderEntity.class, this.field_220851_a, (LivingEntity)((Object)this.field_220853_c), this.field_220853_c.func_174813_aQ().func_72314_b(8.0, 8.0, 8.0))) {
                abstractraiderentity.setGoalTarget(this.field_220853_c.func_70638_az(), EntityTargetEvent.TargetReason.FOLLOW_LEADER, true);
            }
        }

        public void func_75251_c() {
            super.func_75251_c();
            LivingEntity livingentity = this.field_220853_c.func_70638_az();
            if (livingentity != null) {
                for (AbstractRaiderEntity abstractraiderentity : this.field_220853_c.field_70170_p.func_217374_a(AbstractRaiderEntity.class, this.field_220851_a, (LivingEntity)((Object)this.field_220853_c), this.field_220853_c.func_174813_aQ().func_72314_b(8.0, 8.0, 8.0))) {
                    abstractraiderentity.setGoalTarget(livingentity, EntityTargetEvent.TargetReason.FOLLOW_LEADER, true);
                    abstractraiderentity.func_213395_q(true);
                }
                this.field_220853_c.func_213395_q(true);
            }
        }

        public void func_75246_d() {
            LivingEntity livingentity = this.field_220853_c.func_70638_az();
            if (livingentity != null) {
                if (this.field_220853_c.func_70068_e(livingentity) > (double)this.field_220854_d) {
                    this.field_220853_c.func_70671_ap().func_75651_a((Entity)livingentity, 30.0f, 30.0f);
                    if (this.field_220853_c.field_70146_Z.nextInt(50) == 0) {
                        this.field_220853_c.func_70642_aH();
                    }
                } else {
                    this.field_220853_c.func_213395_q(true);
                }
                super.func_75246_d();
            }
        }
    }

    public class CelebrateRaidLossGoal
    extends Goal {
        private final AbstractRaiderEntity field_220858_b;

        CelebrateRaidLossGoal(AbstractRaiderEntity p_i50571_2_) {
            this.field_220858_b = p_i50571_2_;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            Raid raid = this.field_220858_b.func_213663_ek();
            return this.field_220858_b.func_70089_S() && this.field_220858_b.func_70638_az() == null && raid != null && raid.func_221336_f();
        }

        public void func_75249_e() {
            this.field_220858_b.func_213655_u(true);
            super.func_75249_e();
        }

        public void func_75251_c() {
            this.field_220858_b.func_213655_u(false);
            super.func_75251_c();
        }

        public void func_75246_d() {
            if (!this.field_220858_b.func_174814_R() && this.field_220858_b.field_70146_Z.nextInt(100) == 0) {
                AbstractRaiderEntity.this.func_184185_a(AbstractRaiderEntity.this.func_213654_dW(), AbstractRaiderEntity.this.func_70599_aP(), AbstractRaiderEntity.this.func_70647_i());
            }
            if (!this.field_220858_b.func_184218_aH() && this.field_220858_b.field_70146_Z.nextInt(50) == 0) {
                this.field_220858_b.func_70683_ar().func_75660_a();
            }
            super.func_75246_d();
        }
    }
}

