/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.passive;

import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.eventbus.api.Event;
import org.bukkit.craftbukkit.v1_16_R3.event.CraftEventFactory;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityBreedEvent;
import org.bukkit.event.entity.EntityEnterLoveModeEvent;

public abstract class AnimalEntity
extends AgeableEntity {
    public int field_70881_d;
    public UUID field_146084_br;
    public ItemStack breedItem;

    protected AnimalEntity(EntityType<? extends AnimalEntity> p_i48568_1_, World p_i48568_2_) {
        super((EntityType<? extends AgeableEntity>)p_i48568_1_, p_i48568_2_);
        this.func_184644_a(PathNodeType.DANGER_FIRE, 16.0f);
        this.func_184644_a(PathNodeType.DAMAGE_FIRE, -1.0f);
    }

    @Override
    protected void func_70619_bc() {
        if (this.func_70874_b() != 0) {
            this.field_70881_d = 0;
        }
        super.func_70619_bc();
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_70874_b() != 0) {
            this.field_70881_d = 0;
        }
        if (this.field_70881_d > 0) {
            --this.field_70881_d;
            if (this.field_70881_d % 10 == 0) {
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197633_z, this.func_226282_d_(1.0), this.func_226279_cv_() + 0.5, this.func_226287_g_(1.0), d0, d1, d2);
            }
        }
    }

    @Override
    public boolean func_70097_a(DamageSource p_70097_1_, float p_70097_2_) {
        if (this.func_180431_b(p_70097_1_)) {
            return false;
        }
        this.field_70881_d = 0;
        return super.func_70097_a(p_70097_1_, p_70097_2_);
    }

    @Override
    public float func_205022_a(BlockPos p_205022_1_, IWorldReader p_205022_2_) {
        return p_205022_2_.func_180495_p(p_205022_1_.func_177977_b()).func_203425_a(Blocks.field_196658_i) ? 10.0f : p_205022_2_.func_205052_D(p_205022_1_) - 0.5f;
    }

    @Override
    public void func_213281_b(CompoundNBT p_213281_1_) {
        super.func_213281_b(p_213281_1_);
        p_213281_1_.func_74768_a("InLove", this.field_70881_d);
        if (this.field_146084_br != null) {
            p_213281_1_.func_186854_a("LoveCause", this.field_146084_br);
        }
    }

    @Override
    public double func_70033_W() {
        return 0.14;
    }

    @Override
    public void func_70037_a(CompoundNBT p_70037_1_) {
        super.func_70037_a(p_70037_1_);
        this.field_70881_d = p_70037_1_.func_74762_e("InLove");
        this.field_146084_br = p_70037_1_.func_186855_b("LoveCause") ? p_70037_1_.func_186857_a("LoveCause") : null;
    }

    public static boolean func_223316_b(EntityType<? extends AnimalEntity> p_223316_0_, IWorld p_223316_1_, SpawnReason p_223316_2_, BlockPos p_223316_3_, Random p_223316_4_) {
        return p_223316_1_.func_180495_p(p_223316_3_.func_177977_b()).func_203425_a(Blocks.field_196658_i) && p_223316_1_.func_226659_b_(p_223316_3_, 0) > 8;
    }

    @Override
    public int func_70627_aG() {
        return 120;
    }

    @Override
    public boolean func_213397_c(double p_213397_1_) {
        return false;
    }

    @Override
    protected int func_70693_a(PlayerEntity p_70693_1_) {
        return 1 + this.field_70170_p.field_73012_v.nextInt(3);
    }

    public boolean func_70877_b(ItemStack p_70877_1_) {
        return p_70877_1_.func_77973_b() == Items.field_151015_O;
    }

    @Override
    public ActionResultType func_230254_b_(PlayerEntity p_230254_1_, Hand p_230254_2_) {
        ItemStack itemstack = p_230254_1_.func_184586_b(p_230254_2_);
        if (this.func_70877_b(itemstack)) {
            int i = this.func_70874_b();
            if (!this.field_70170_p.field_72995_K && i == 0 && this.func_204701_dC()) {
                this.func_175505_a(p_230254_1_, itemstack);
                this.func_146082_f(p_230254_1_);
                return ActionResultType.SUCCESS;
            }
            if (this.func_70631_g_()) {
                this.func_175505_a(p_230254_1_, itemstack);
                this.func_175501_a((int)((float)(-i / 20) * 0.1f), true);
                return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
            }
            if (this.field_70170_p.field_72995_K) {
                return ActionResultType.CONSUME;
            }
        }
        return super.func_230254_b_(p_230254_1_, p_230254_2_);
    }

    protected void func_175505_a(PlayerEntity p_175505_1_, ItemStack p_175505_2_) {
        if (!p_175505_1_.field_71075_bZ.field_75098_d) {
            p_175505_2_.func_190918_g(1);
        }
    }

    public boolean func_204701_dC() {
        return this.field_70881_d <= 0;
    }

    public void func_146082_f(@Nullable PlayerEntity p_146082_1_) {
        EntityEnterLoveModeEvent entityEnterLoveModeEvent = CraftEventFactory.callEntityEnterLoveModeEvent((PlayerEntity)p_146082_1_, (AnimalEntity)this, (int)600);
        if (entityEnterLoveModeEvent.isCancelled()) {
            return;
        }
        this.field_70881_d = entityEnterLoveModeEvent.getTicksInLove();
        if (p_146082_1_ != null) {
            this.field_146084_br = p_146082_1_.func_110124_au();
            this.breedItem = p_146082_1_.field_71071_by.func_70448_g();
        }
        this.field_70170_p.func_72960_a(this, (byte)18);
    }

    public void func_204700_e(int p_204700_1_) {
        this.field_70881_d = p_204700_1_;
    }

    public int func_234178_eO_() {
        return this.field_70881_d;
    }

    @Nullable
    public ServerPlayerEntity func_191993_do() {
        if (this.field_146084_br == null) {
            return null;
        }
        PlayerEntity playerentity = this.field_70170_p.func_217371_b(this.field_146084_br);
        return playerentity instanceof ServerPlayerEntity ? (ServerPlayerEntity)playerentity : null;
    }

    public boolean func_70880_s() {
        return this.field_70881_d > 0;
    }

    public void func_70875_t() {
        this.field_70881_d = 0;
    }

    public boolean func_70878_b(AnimalEntity p_70878_1_) {
        if (p_70878_1_ == this) {
            return false;
        }
        if (p_70878_1_.getClass() != this.getClass()) {
            return false;
        }
        return this.func_70880_s() && p_70878_1_.func_70880_s();
    }

    public void func_234177_a_(ServerWorld p_234177_1_, AnimalEntity p_234177_2_) {
        AgeableEntity ageableentity = this.func_241840_a(p_234177_1_, p_234177_2_);
        BabyEntitySpawnEvent event = new BabyEntitySpawnEvent((MobEntity)this, (MobEntity)p_234177_2_, ageableentity);
        boolean cancelled = MinecraftForge.EVENT_BUS.post((Event)event);
        ageableentity = event.getChild();
        if (cancelled) {
            this.func_70873_a(6000);
            p_234177_2_.func_70873_a(6000);
            this.func_70875_t();
            p_234177_2_.func_70875_t();
            return;
        }
        if (ageableentity != null) {
            ServerPlayerEntity serverplayerentity;
            if (ageableentity instanceof TameableEntity && ((TameableEntity)ageableentity).func_70909_n()) {
                ageableentity.field_82179_bU = true;
            }
            if ((serverplayerentity = this.func_191993_do()) == null && p_234177_2_.func_191993_do() != null) {
                serverplayerentity = p_234177_2_.func_191993_do();
            }
            ageableentity.func_82227_f(true);
            ageableentity.func_70012_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0f, 0.0f);
            int experience = this.func_70681_au().nextInt(7) + 1;
            EntityBreedEvent entityBreedEvent = CraftEventFactory.callEntityBreedEvent((LivingEntity)ageableentity, (LivingEntity)this, (LivingEntity)p_234177_2_, (LivingEntity)serverplayerentity, (ItemStack)this.breedItem, (int)experience);
            if (entityBreedEvent.isCancelled()) {
                return;
            }
            experience = entityBreedEvent.getExperience();
            if (serverplayerentity != null) {
                serverplayerentity.func_195066_a(Stats.field_151186_x);
                CriteriaTriggers.field_192134_n.func_192168_a(serverplayerentity, this, p_234177_2_, ageableentity);
            }
            this.func_70873_a(6000);
            p_234177_2_.func_70873_a(6000);
            this.func_70875_t();
            p_234177_2_.func_70875_t();
            p_234177_1_.dummyFreshEntitySpawn = true;
            p_234177_1_.func_242417_l(ageableentity);
            p_234177_1_.dummyFreshEntitySpawn = false;
            p_234177_1_.addEntity(ageableentity, CreatureSpawnEvent.SpawnReason.BREEDING);
            p_234177_1_.func_72960_a(this, (byte)18);
            if (p_234177_1_.func_82736_K().func_223586_b(GameRules.field_223602_e) && experience > 0) {
                p_234177_1_.func_217376_c(new ExperienceOrbEntity(p_234177_1_, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), experience));
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte p_70103_1_) {
        if (p_70103_1_ == 18) {
            for (int i = 0; i < 7; ++i) {
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197633_z, this.func_226282_d_(1.0), this.func_226279_cv_() + 0.5, this.func_226287_g_(1.0), d0, d1, d2);
            }
        } else {
            super.func_70103_a(p_70103_1_);
        }
    }
}

