/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.passive;

import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.DolphinLookController;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.BreatheAirGoal;
import net.minecraft.entity.ai.goal.DolphinJumpGoal;
import net.minecraft.entity.ai.goal.FindWaterGoal;
import net.minecraft.entity.ai.goal.FollowBoatGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.GuardianEntity;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathType;
import net.minecraft.pathfinding.SwimmerPathNavigator;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.feature.structure.OceanRuinConfig;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.bukkit.craftbukkit.v1_16_R3.event.CraftEventFactory;
import org.bukkit.event.entity.EntityPotionEffectEvent;

public class DolphinEntity
extends WaterMobEntity {
    private static final DataParameter<BlockPos> field_208014_b = EntityDataManager.func_187226_a(DolphinEntity.class, DataSerializers.field_187200_j);
    private static final DataParameter<Boolean> field_208013_bB = EntityDataManager.func_187226_a(DolphinEntity.class, DataSerializers.field_187198_h);
    private static final DataParameter<Integer> field_211138_bB = EntityDataManager.func_187226_a(DolphinEntity.class, DataSerializers.field_187192_b);
    private static final EntityPredicate field_213810_bA = new EntityPredicate().func_221013_a(10.0).func_221011_b().func_221008_a().func_221014_c();
    public static final Predicate<ItemEntity> field_205025_a = p_205023_0_ -> !p_205023_0_.func_174874_s() && p_205023_0_.func_70089_S() && p_205023_0_.func_70090_H();

    public DolphinEntity(EntityType<? extends DolphinEntity> p_i50275_1_, World p_i50275_2_) {
        super(p_i50275_1_, p_i50275_2_);
        this.field_70765_h = new MoveHelperController(this);
        this.field_70749_g = new DolphinLookController((MobEntity)((Object)this), 10);
        this.func_98053_h(true);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld p_213386_1_, DifficultyInstance p_213386_2_, SpawnReason p_213386_3_, @Nullable ILivingEntityData p_213386_4_, @Nullable CompoundNBT p_213386_5_) {
        this.func_70050_g(this.func_205010_bg());
        this.field_70125_A = 0.0f;
        return super.func_213386_a(p_213386_1_, p_213386_2_, p_213386_3_, p_213386_4_, p_213386_5_);
    }

    public boolean func_70648_aU() {
        return false;
    }

    protected void func_209207_l(int p_209207_1_) {
    }

    public void func_208012_g(BlockPos p_208012_1_) {
        this.field_70180_af.func_187227_b(field_208014_b, p_208012_1_);
    }

    public BlockPos func_208010_l() {
        return this.field_70180_af.func_187225_a(field_208014_b);
    }

    public boolean func_208011_dD() {
        return this.field_70180_af.func_187225_a(field_208013_bB);
    }

    public void func_208008_s(boolean p_208008_1_) {
        this.field_70180_af.func_187227_b(field_208013_bB, p_208008_1_);
    }

    public int func_211136_dB() {
        return this.field_70180_af.func_187225_a(field_211138_bB);
    }

    public void func_211137_b(int p_211137_1_) {
        this.field_70180_af.func_187227_b(field_211138_bB, p_211137_1_);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_208014_b, BlockPos.field_177992_a);
        this.field_70180_af.func_187214_a(field_208013_bB, false);
        this.field_70180_af.func_187214_a(field_211138_bB, 2400);
    }

    public void func_213281_b(CompoundNBT p_213281_1_) {
        super.func_213281_b(p_213281_1_);
        p_213281_1_.func_74768_a("TreasurePosX", this.func_208010_l().func_177958_n());
        p_213281_1_.func_74768_a("TreasurePosY", this.func_208010_l().func_177956_o());
        p_213281_1_.func_74768_a("TreasurePosZ", this.func_208010_l().func_177952_p());
        p_213281_1_.func_74757_a("GotFish", this.func_208011_dD());
        p_213281_1_.func_74768_a("Moistness", this.func_211136_dB());
    }

    public void func_70037_a(CompoundNBT p_70037_1_) {
        int i = p_70037_1_.func_74762_e("TreasurePosX");
        int j = p_70037_1_.func_74762_e("TreasurePosY");
        int k = p_70037_1_.func_74762_e("TreasurePosZ");
        this.func_208012_g(new BlockPos(i, j, k));
        super.func_70037_a(p_70037_1_);
        this.func_208008_s(p_70037_1_.func_74767_n("GotFish"));
        this.func_211137_b(p_70037_1_.func_74762_e("Moistness"));
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new BreatheAirGoal((CreatureEntity)((Object)this)));
        this.field_70714_bg.func_75776_a(0, (Goal)new FindWaterGoal((CreatureEntity)((Object)this)));
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimToTreasureGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new SwimWithPlayerGoal(this, 4.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new RandomSwimmingGoal((CreatureEntity)((Object)this), 1.0, 10));
        this.field_70714_bg.func_75776_a(4, (Goal)new LookRandomlyGoal((MobEntity)((Object)this)));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookAtGoal((MobEntity)((Object)this), PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(5, (Goal)new DolphinJumpGoal(this, 10));
        this.field_70714_bg.func_75776_a(6, (Goal)new MeleeAttackGoal((CreatureEntity)((Object)this), 1.2f, true));
        this.field_70714_bg.func_75776_a(8, (Goal)new PlayWithItemsGoal());
        this.field_70714_bg.func_75776_a(8, (Goal)new FollowBoatGoal((CreatureEntity)((Object)this)));
        this.field_70714_bg.func_75776_a(9, (Goal)new AvoidEntityGoal((CreatureEntity)((Object)this), GuardianEntity.class, 8.0f, 1.0, 1.0));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)((Object)this), GuardianEntity.class).func_220794_a(new Class[0]));
    }

    public static AttributeModifierMap.MutableAttribute func_234190_eK_() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 10.0).func_233815_a_(Attributes.field_233821_d_, 1.2f).func_233815_a_(Attributes.field_233823_f_, 3.0);
    }

    protected PathNavigator func_175447_b(World p_175447_1_) {
        return new SwimmerPathNavigator((MobEntity)((Object)this), p_175447_1_);
    }

    public boolean func_70652_k(Entity p_70652_1_) {
        boolean flag = p_70652_1_.func_70097_a(DamageSource.func_76358_a((LivingEntity)((Object)this)), (int)this.func_233637_b_(Attributes.field_233823_f_));
        if (flag) {
            this.func_174815_a((LivingEntity)((Object)this), p_70652_1_);
            this.func_184185_a(SoundEvents.field_205205_aV, 1.0f, 1.0f);
        }
        return flag;
    }

    public int func_205010_bg() {
        return 4800;
    }

    protected int func_207300_l(int p_207300_1_) {
        return this.func_205010_bg();
    }

    protected float func_213348_b(Pose p_213348_1_, EntitySize p_213348_2_) {
        return 0.3f;
    }

    public int func_70646_bf() {
        return 1;
    }

    public int func_184649_cE() {
        return 1;
    }

    protected boolean func_184228_n(Entity p_184228_1_) {
        return true;
    }

    public boolean func_213365_e(ItemStack p_213365_1_) {
        EquipmentSlotType equipmentslottype = MobEntity.func_184640_d(p_213365_1_);
        if (!this.func_184582_a(equipmentslottype).func_190926_b()) {
            return false;
        }
        return equipmentslottype == EquipmentSlotType.MAINHAND && super.func_213365_e(p_213365_1_);
    }

    protected void func_175445_a(ItemEntity p_175445_1_) {
        ItemStack itemstack;
        if (this.func_184582_a(EquipmentSlotType.MAINHAND).func_190926_b() && this.func_175448_a(itemstack = p_175445_1_.func_92059_d())) {
            if (CraftEventFactory.callEntityPickupItemEvent((Entity)((Object)this), (ItemEntity)p_175445_1_, (int)0, (boolean)false).isCancelled()) {
                return;
            }
            itemstack = p_175445_1_.func_92059_d();
            this.func_233630_a_(p_175445_1_);
            this.func_184201_a(EquipmentSlotType.MAINHAND, itemstack);
            this.field_82174_bp[EquipmentSlotType.MAINHAND.func_188454_b()] = 2.0f;
            this.func_71001_a(p_175445_1_, itemstack.func_190916_E());
            p_175445_1_.func_70106_y();
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_175446_cd()) {
            this.func_70050_g(this.func_205010_bg());
        } else {
            if (this.func_203008_ap()) {
                this.func_211137_b(2400);
            } else {
                this.func_211137_b(this.func_211136_dB() - 1);
                if (this.func_211136_dB() <= 0) {
                    this.func_70097_a(DamageSource.field_205132_u, 1.0f);
                }
                if (this.field_70122_E) {
                    this.func_213317_d(this.func_213322_ci().func_72441_c((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 0.2f, 0.5, (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 0.2f));
                    this.field_70177_z = this.field_70146_Z.nextFloat() * 360.0f;
                    this.field_70122_E = false;
                    this.field_70160_al = true;
                }
            }
            if (this.field_70170_p.field_72995_K && this.func_70090_H() && this.func_213322_ci().func_189985_c() > 0.03) {
                Vector3d vector3d = this.func_70676_i(0.0f);
                float f = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * 0.3f;
                float f1 = MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))) * 0.3f;
                float f2 = 1.2f - this.field_70146_Z.nextFloat() * 0.7f;
                for (int i = 0; i < 2; ++i) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_206864_X, this.func_226277_ct_() - vector3d.field_72450_a * (double)f2 + (double)f, this.func_226278_cu_() - vector3d.field_72448_b, this.func_226281_cx_() - vector3d.field_72449_c * (double)f2 + (double)f1, 0.0, 0.0, 0.0);
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_206864_X, this.func_226277_ct_() - vector3d.field_72450_a * (double)f2 - (double)f, this.func_226278_cu_() - vector3d.field_72448_b, this.func_226281_cx_() - vector3d.field_72449_c * (double)f2 - (double)f1, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte p_70103_1_) {
        if (p_70103_1_ == 38) {
            this.func_208401_a((IParticleData)ParticleTypes.field_197632_y);
        } else {
            super.func_70103_a(p_70103_1_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void func_208401_a(IParticleData p_208401_1_) {
        for (int i = 0; i < 7; ++i) {
            double d0 = this.field_70146_Z.nextGaussian() * 0.01;
            double d1 = this.field_70146_Z.nextGaussian() * 0.01;
            double d2 = this.field_70146_Z.nextGaussian() * 0.01;
            this.field_70170_p.func_195594_a(p_208401_1_, this.func_226282_d_(1.0), this.func_226279_cv_() + 0.2, this.func_226287_g_(1.0), d0, d1, d2);
        }
    }

    protected ActionResultType func_230254_b_(PlayerEntity p_230254_1_, Hand p_230254_2_) {
        ItemStack itemstack = p_230254_1_.func_184586_b(p_230254_2_);
        if (!itemstack.func_190926_b() && itemstack.func_77973_b().func_206844_a(ItemTags.field_206964_G)) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_184185_a(SoundEvents.field_205207_aX, 1.0f, 1.0f);
            }
            this.func_208008_s(true);
            if (!p_230254_1_.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        return super.func_230254_b_(p_230254_1_, p_230254_2_);
    }

    public static boolean func_223364_b(EntityType<DolphinEntity> p_223364_0_, IWorld p_223364_1_, SpawnReason p_223364_2_, BlockPos p_223364_3_, Random p_223364_4_) {
        if (p_223364_3_.func_177956_o() > 45 && p_223364_3_.func_177956_o() < p_223364_1_.func_181545_F()) {
            Optional optional = p_223364_1_.func_242406_i(p_223364_3_);
            return (!Objects.equals(optional, Optional.of(Biomes.field_76771_b)) || !Objects.equals(optional, Optional.of(Biomes.field_150575_M))) && p_223364_1_.func_204610_c(p_223364_3_).func_206884_a(FluidTags.field_206959_a);
        }
        return false;
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return SoundEvents.field_205208_aY;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_205206_aW;
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        return this.func_70090_H() ? SoundEvents.field_205204_aU : SoundEvents.field_205203_aT;
    }

    protected SoundEvent func_184181_aa() {
        return SoundEvents.field_205212_bc;
    }

    protected SoundEvent func_184184_Z() {
        return SoundEvents.field_205211_bb;
    }

    protected boolean func_208006_dE() {
        BlockPos blockpos = this.func_70661_as().func_208485_j();
        return blockpos != null ? blockpos.func_218137_a(this.func_213303_ch(), 12.0) : false;
    }

    public void func_213352_e(Vector3d p_213352_1_) {
        if (this.func_70613_aW() && this.func_70090_H()) {
            this.func_213309_a(this.func_70689_ay(), p_213352_1_);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.9));
            if (this.func_70638_az() == null) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.005, 0.0));
            }
        } else {
            super.func_213352_e(p_213352_1_);
        }
    }

    public boolean func_184652_a(PlayerEntity p_184652_1_) {
        return true;
    }

    static class SwimWithPlayerGoal
    extends Goal {
        private final DolphinEntity field_206834_a;
        private final double field_206835_b;
        private PlayerEntity field_206836_c;

        SwimWithPlayerGoal(DolphinEntity p_i48994_1_, double p_i48994_2_) {
            this.field_206834_a = p_i48994_1_;
            this.field_206835_b = p_i48994_2_;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            this.field_206836_c = this.field_206834_a.field_70170_p.func_217370_a(field_213810_bA, (LivingEntity)((Object)this.field_206834_a));
            if (this.field_206836_c == null) {
                return false;
            }
            return this.field_206836_c.func_203007_ba() && this.field_206834_a.func_70638_az() != this.field_206836_c;
        }

        public boolean func_75253_b() {
            return this.field_206836_c != null && this.field_206836_c.func_203007_ba() && this.field_206834_a.func_70068_e(this.field_206836_c) < 256.0;
        }

        public void func_75249_e() {
            this.field_206836_c.addEffect(new EffectInstance(Effects.field_206827_D, 100), EntityPotionEffectEvent.Cause.DOLPHIN);
        }

        public void func_75251_c() {
            this.field_206836_c = null;
            this.field_206834_a.func_70661_as().func_75499_g();
        }

        public void func_75246_d() {
            this.field_206834_a.func_70671_ap().func_75651_a((Entity)this.field_206836_c, (float)(this.field_206834_a.func_184649_cE() + 20), (float)this.field_206834_a.func_70646_bf());
            if (this.field_206834_a.func_70068_e(this.field_206836_c) < 6.25) {
                this.field_206834_a.func_70661_as().func_75499_g();
            } else {
                this.field_206834_a.func_70661_as().func_75497_a(this.field_206836_c, this.field_206835_b);
            }
            if (this.field_206836_c.func_203007_ba() && this.field_206836_c.field_70170_p.field_73012_v.nextInt(6) == 0) {
                this.field_206836_c.addEffect(new EffectInstance(Effects.field_206827_D, 100), EntityPotionEffectEvent.Cause.DOLPHIN);
            }
        }
    }

    static class SwimToTreasureGoal
    extends Goal {
        private final DolphinEntity field_208057_a;
        private boolean field_208058_b;

        SwimToTreasureGoal(DolphinEntity p_i49344_1_) {
            this.field_208057_a = p_i49344_1_;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean func_220685_C_() {
            return false;
        }

        public boolean func_75250_a() {
            return this.field_208057_a.func_208011_dD() && this.field_208057_a.func_70086_ai() >= 100 && this.field_208057_a.field_70170_p.getWorld().canGenerateStructures();
        }

        public boolean func_75253_b() {
            BlockPos blockpos = this.field_208057_a.func_208010_l();
            return !new BlockPos((double)blockpos.func_177958_n(), this.field_208057_a.func_226278_cu_(), (double)blockpos.func_177952_p()).func_218137_a(this.field_208057_a.func_213303_ch(), 4.0) && !this.field_208058_b && this.field_208057_a.func_70086_ai() >= 100;
        }

        public void func_75249_e() {
            if (this.field_208057_a.field_70170_p instanceof ServerWorld) {
                ServerWorld serverworld = (ServerWorld)this.field_208057_a.field_70170_p;
                this.field_208058_b = false;
                this.field_208057_a.func_70661_as().func_75499_g();
                BlockPos blockpos = this.field_208057_a.func_233580_cy_();
                Structure<OceanRuinConfig> structure = (double)serverworld.field_73012_v.nextFloat() >= 0.5 ? Structure.field_236377_m_ : Structure.field_236373_i_;
                BlockPos blockpos1 = serverworld.func_241117_a_(structure, blockpos, 50, false);
                if (blockpos1 == null) {
                    Structure<Object> structure1 = ((Object)structure).equals(Structure.field_236377_m_) ? Structure.field_236373_i_ : Structure.field_236377_m_;
                    BlockPos blockpos2 = serverworld.func_241117_a_(structure1, blockpos, 50, false);
                    if (blockpos2 == null) {
                        this.field_208058_b = true;
                        return;
                    }
                    this.field_208057_a.func_208012_g(blockpos2);
                } else {
                    this.field_208057_a.func_208012_g(blockpos1);
                }
                serverworld.func_72960_a((Entity)((Object)this.field_208057_a), (byte)38);
            }
        }

        public void func_75251_c() {
            BlockPos blockpos = this.field_208057_a.func_208010_l();
            if (new BlockPos((double)blockpos.func_177958_n(), this.field_208057_a.func_226278_cu_(), (double)blockpos.func_177952_p()).func_218137_a(this.field_208057_a.func_213303_ch(), 4.0) || this.field_208058_b) {
                this.field_208057_a.func_208008_s(false);
            }
        }

        public void func_75246_d() {
            World world = this.field_208057_a.field_70170_p;
            if (this.field_208057_a.func_208006_dE() || this.field_208057_a.func_70661_as().func_75500_f()) {
                BlockPos blockpos;
                Vector3d vector3d = Vector3d.func_237489_a_(this.field_208057_a.func_208010_l());
                Vector3d vector3d1 = RandomPositionGenerator.func_203155_a((CreatureEntity)((Object)this.field_208057_a), (int)16, (int)1, (Vector3d)vector3d, (double)0.3926991f);
                if (vector3d1 == null) {
                    vector3d1 = RandomPositionGenerator.func_75464_a((CreatureEntity)((Object)this.field_208057_a), (int)8, (int)4, (Vector3d)vector3d);
                }
                if (!(vector3d1 == null || world.func_204610_c(blockpos = new BlockPos(vector3d1)).func_206884_a(FluidTags.field_206959_a) && world.func_180495_p(blockpos).func_196957_g((IBlockReader)((Object)world), blockpos, PathType.WATER))) {
                    vector3d1 = RandomPositionGenerator.func_75464_a((CreatureEntity)((Object)this.field_208057_a), (int)8, (int)5, (Vector3d)vector3d);
                }
                if (vector3d1 == null) {
                    this.field_208058_b = true;
                    return;
                }
                this.field_208057_a.func_70671_ap().func_75650_a(vector3d1.field_72450_a, vector3d1.field_72448_b, vector3d1.field_72449_c, (float)(this.field_208057_a.func_184649_cE() + 20), (float)this.field_208057_a.func_70646_bf());
                this.field_208057_a.func_70661_as().func_75492_a(vector3d1.field_72450_a, vector3d1.field_72448_b, vector3d1.field_72449_c, 1.3);
                if (world.field_73012_v.nextInt(80) == 0) {
                    world.func_72960_a((Entity)((Object)this.field_208057_a), (byte)38);
                }
            }
        }
    }

    class PlayWithItemsGoal
    extends Goal {
        private int field_205154_b;

        private PlayWithItemsGoal() {
        }

        public boolean func_75250_a() {
            if (this.field_205154_b > DolphinEntity.this.field_70173_aa) {
                return false;
            }
            List<ItemEntity> list = DolphinEntity.this.field_70170_p.func_175647_a(ItemEntity.class, DolphinEntity.this.func_174813_aQ().func_72314_b(8.0, 8.0, 8.0), field_205025_a);
            return !list.isEmpty() || !DolphinEntity.this.func_184582_a(EquipmentSlotType.MAINHAND).func_190926_b();
        }

        public void func_75249_e() {
            List<ItemEntity> list = DolphinEntity.this.field_70170_p.func_175647_a(ItemEntity.class, DolphinEntity.this.func_174813_aQ().func_72314_b(8.0, 8.0, 8.0), field_205025_a);
            if (!list.isEmpty()) {
                DolphinEntity.this.func_70661_as().func_75497_a(list.get(0), 1.2f);
                DolphinEntity.this.func_184185_a(SoundEvents.field_205210_ba, 1.0f, 1.0f);
            }
            this.field_205154_b = 0;
        }

        public void func_75251_c() {
            ItemStack itemstack = DolphinEntity.this.func_184582_a(EquipmentSlotType.MAINHAND);
            if (!itemstack.func_190926_b()) {
                this.func_220810_a(itemstack);
                DolphinEntity.this.func_184201_a(EquipmentSlotType.MAINHAND, ItemStack.field_190927_a);
                this.field_205154_b = DolphinEntity.this.field_70173_aa + DolphinEntity.this.field_70146_Z.nextInt(100);
            }
        }

        public void func_75246_d() {
            List<ItemEntity> list = DolphinEntity.this.field_70170_p.func_175647_a(ItemEntity.class, DolphinEntity.this.func_174813_aQ().func_72314_b(8.0, 8.0, 8.0), field_205025_a);
            ItemStack itemstack = DolphinEntity.this.func_184582_a(EquipmentSlotType.MAINHAND);
            if (!itemstack.func_190926_b()) {
                this.func_220810_a(itemstack);
                DolphinEntity.this.func_184201_a(EquipmentSlotType.MAINHAND, ItemStack.field_190927_a);
            } else if (!list.isEmpty()) {
                DolphinEntity.this.func_70661_as().func_75497_a(list.get(0), 1.2f);
            }
        }

        private void func_220810_a(ItemStack p_220810_1_) {
            if (!p_220810_1_.func_190926_b()) {
                double d0 = DolphinEntity.this.func_226280_cw_() - (double)0.3f;
                ItemEntity itementity = new ItemEntity(DolphinEntity.this.field_70170_p, DolphinEntity.this.func_226277_ct_(), d0, DolphinEntity.this.func_226281_cx_(), p_220810_1_);
                itementity.func_174867_a(40);
                itementity.func_200216_c(DolphinEntity.this.func_110124_au());
                float f = 0.3f;
                float f1 = DolphinEntity.this.field_70146_Z.nextFloat() * ((float)Math.PI * 2);
                float f2 = 0.02f * DolphinEntity.this.field_70146_Z.nextFloat();
                itementity.func_213293_j(0.3f * -MathHelper.func_76126_a((float)(DolphinEntity.this.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(DolphinEntity.this.field_70125_A * ((float)Math.PI / 180))) + MathHelper.func_76134_b((float)f1) * f2, 0.3f * MathHelper.func_76126_a((float)(DolphinEntity.this.field_70125_A * ((float)Math.PI / 180))) * 1.5f, 0.3f * MathHelper.func_76134_b((float)(DolphinEntity.this.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(DolphinEntity.this.field_70125_A * ((float)Math.PI / 180))) + MathHelper.func_76126_a((float)f1) * f2);
                DolphinEntity.this.field_70170_p.func_217376_c(itementity);
            }
        }
    }

    static class MoveHelperController
    extends MovementController {
        private final DolphinEntity field_205138_i;

        public MoveHelperController(DolphinEntity p_i48945_1_) {
            super((MobEntity)((Object)p_i48945_1_));
            this.field_205138_i = p_i48945_1_;
        }

        public void func_75641_c() {
            if (this.field_205138_i.func_70090_H()) {
                this.field_205138_i.func_213317_d(this.field_205138_i.func_213322_ci().func_72441_c(0.0, 0.005, 0.0));
            }
            if (this.field_188491_h == MovementController.Action.MOVE_TO && !this.field_205138_i.func_70661_as().func_75500_f()) {
                double d2;
                double d1;
                double d0 = this.field_75646_b - this.field_205138_i.func_226277_ct_();
                double d3 = d0 * d0 + (d1 = this.field_75647_c - this.field_205138_i.func_226278_cu_()) * d1 + (d2 = this.field_75644_d - this.field_205138_i.func_226281_cx_()) * d2;
                if (d3 < 2.500000277905201E-7) {
                    this.field_75648_a.func_191989_p(0.0f);
                } else {
                    float f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
                    this.field_205138_i.field_70761_aq = this.field_205138_i.field_70177_z = this.func_75639_a(this.field_205138_i.field_70177_z, f, 10.0f);
                    this.field_205138_i.field_70759_as = this.field_205138_i.field_70177_z;
                    float f1 = (float)(this.field_75645_e * this.field_205138_i.func_233637_b_(Attributes.field_233821_d_));
                    if (this.field_205138_i.func_70090_H()) {
                        this.field_205138_i.func_70659_e(f1 * 0.02f);
                        float f2 = -((float)(MathHelper.func_181159_b((double)d1, (double)MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2))) * 57.2957763671875));
                        f2 = MathHelper.func_76131_a((float)MathHelper.func_76142_g((float)f2), (float)-85.0f, (float)85.0f);
                        this.field_205138_i.field_70125_A = this.func_75639_a(this.field_205138_i.field_70125_A, f2, 5.0f);
                        float f3 = MathHelper.func_76134_b((float)(this.field_205138_i.field_70125_A * ((float)Math.PI / 180)));
                        float f4 = MathHelper.func_76126_a((float)(this.field_205138_i.field_70125_A * ((float)Math.PI / 180)));
                        this.field_205138_i.field_191988_bg = f3 * f1;
                        this.field_205138_i.field_70701_bs = -f4 * f1;
                    } else {
                        this.field_205138_i.func_70659_e(f1 * 0.1f);
                    }
                }
            } else {
                this.field_205138_i.func_70659_e(0.0f);
                this.field_205138_i.func_184646_p(0.0f);
                this.field_205138_i.func_70657_f(0.0f);
                this.field_205138_i.func_191989_p(0.0f);
            }
        }
    }
}

