/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.passive;

import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effects;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SquidEntity
extends WaterMobEntity {
    public float field_70861_d;
    public float field_70862_e;
    public float field_70859_f;
    public float field_70860_g;
    public float field_70867_h;
    public float field_70868_i;
    public float field_70866_j;
    public float field_70865_by;
    private float field_70863_bz;
    private float field_70864_bA;
    private float field_70871_bB;
    private float field_70872_bC;
    private float field_70869_bD;
    private float field_70870_bE;

    public SquidEntity(EntityType<? extends SquidEntity> p_i50243_1_, World p_i50243_2_) {
        super(p_i50243_1_, p_i50243_2_);
        this.field_70146_Z.setSeed(this.func_145782_y());
        this.field_70864_bA = 1.0f / (this.field_70146_Z.nextFloat() + 1.0f) * 0.2f;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new MoveRandomGoal(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new FleeGoal());
    }

    public static AttributeModifierMap.MutableAttribute func_234227_m_() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 10.0);
    }

    protected float func_213348_b(Pose p_213348_1_, EntitySize p_213348_2_) {
        return p_213348_2_.field_220316_b * 0.5f;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187829_fQ;
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return SoundEvents.field_187833_fS;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187831_fR;
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    protected boolean func_225502_at_() {
        return false;
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.field_70862_e = this.field_70861_d;
        this.field_70860_g = this.field_70859_f;
        this.field_70868_i = this.field_70867_h;
        this.field_70865_by = this.field_70866_j;
        this.field_70867_h += this.field_70864_bA;
        if ((double)this.field_70867_h > Math.PI * 2) {
            if (this.field_70170_p.field_72995_K) {
                this.field_70867_h = (float)Math.PI * 2;
            } else {
                this.field_70867_h = (float)((double)this.field_70867_h - Math.PI * 2);
                if (this.field_70146_Z.nextInt(10) == 0) {
                    this.field_70864_bA = 1.0f / (this.field_70146_Z.nextFloat() + 1.0f) * 0.2f;
                }
                this.field_70170_p.func_72960_a((Entity)((Object)this), (byte)19);
            }
        }
        if (this.func_203005_aq()) {
            if (this.field_70867_h < (float)Math.PI) {
                float f = this.field_70867_h / (float)Math.PI;
                this.field_70866_j = MathHelper.func_76126_a((float)(f * f * (float)Math.PI)) * (float)Math.PI * 0.25f;
                if ((double)f > 0.75) {
                    this.field_70863_bz = 1.0f;
                    this.field_70871_bB = 1.0f;
                } else {
                    this.field_70871_bB *= 0.8f;
                }
            } else {
                this.field_70866_j = 0.0f;
                this.field_70863_bz *= 0.9f;
                this.field_70871_bB *= 0.99f;
            }
            if (!this.field_70170_p.field_72995_K) {
                this.func_213293_j(this.field_70872_bC * this.field_70863_bz, this.field_70869_bD * this.field_70863_bz, this.field_70870_bE * this.field_70863_bz);
            }
            Vector3d vector3d = this.func_213322_ci();
            float f1 = MathHelper.func_76133_a((double)SquidEntity.func_213296_b((Vector3d)vector3d));
            this.field_70761_aq += (-((float)MathHelper.func_181159_b((double)vector3d.field_72450_a, (double)vector3d.field_72449_c)) * 57.295776f - this.field_70761_aq) * 0.1f;
            this.field_70177_z = this.field_70761_aq;
            this.field_70859_f = (float)((double)this.field_70859_f + Math.PI * (double)this.field_70871_bB * 1.5);
            this.field_70861_d += (-((float)MathHelper.func_181159_b((double)f1, (double)vector3d.field_72448_b)) * 57.295776f - this.field_70861_d) * 0.1f;
        } else {
            this.field_70866_j = MathHelper.func_76135_e((float)MathHelper.func_76126_a((float)this.field_70867_h)) * (float)Math.PI * 0.25f;
            if (!this.field_70170_p.field_72995_K) {
                double d0 = this.func_213322_ci().field_72448_b;
                if (this.func_70644_a(Effects.field_188424_y)) {
                    d0 = 0.05 * (double)(this.func_70660_b(Effects.field_188424_y).func_76458_c() + 1);
                } else if (!this.func_189652_ae()) {
                    d0 -= 0.08;
                }
                this.func_213293_j(0.0, d0 * (double)0.98f, 0.0);
            }
            this.field_70861_d = (float)((double)this.field_70861_d + (double)(-90.0f - this.field_70861_d) * 0.02);
        }
    }

    public boolean func_70097_a(DamageSource p_70097_1_, float p_70097_2_) {
        if (super.func_70097_a(p_70097_1_, p_70097_2_) && this.func_70643_av() != null) {
            this.func_203039_dq();
            return true;
        }
        return false;
    }

    private Vector3d func_207400_b(Vector3d p_207400_1_) {
        Vector3d vector3d = p_207400_1_.func_178789_a(this.field_70862_e * ((float)Math.PI / 180));
        return vector3d.func_178785_b(-this.field_70760_ar * ((float)Math.PI / 180));
    }

    private void func_203039_dq() {
        this.func_184185_a(SoundEvents.field_203639_hT, this.func_70599_aP(), this.func_70647_i());
        Vector3d vector3d = this.func_207400_b(new Vector3d(0.0, -1.0, 0.0)).func_72441_c(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        for (int i = 0; i < 30; ++i) {
            Vector3d vector3d1 = this.func_207400_b(new Vector3d((double)this.field_70146_Z.nextFloat() * 0.6 - 0.3, -1.0, (double)this.field_70146_Z.nextFloat() * 0.6 - 0.3));
            Vector3d vector3d2 = vector3d1.func_186678_a(0.3 + (double)(this.field_70146_Z.nextFloat() * 2.0f));
            ((ServerWorld)this.field_70170_p).func_195598_a(ParticleTypes.field_203219_V, vector3d.field_72450_a, vector3d.field_72448_b + 0.5, vector3d.field_72449_c, 0, vector3d2.field_72450_a, vector3d2.field_72448_b, vector3d2.field_72449_c, 0.1f);
        }
    }

    public void func_213352_e(Vector3d p_213352_1_) {
        this.func_213315_a(MoverType.SELF, this.func_213322_ci());
    }

    public static boolean func_223365_b(EntityType<SquidEntity> p_223365_0_, IWorld p_223365_1_, SpawnReason p_223365_2_, BlockPos p_223365_3_, Random p_223365_4_) {
        return (double)p_223365_3_.func_177956_o() > p_223365_1_.getMinecraftWorld().spigotConfig.squidSpawnRangeMin && p_223365_3_.func_177956_o() < p_223365_1_.func_181545_F();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte p_70103_1_) {
        if (p_70103_1_ == 19) {
            this.field_70867_h = 0.0f;
        } else {
            super.func_70103_a(p_70103_1_);
        }
    }

    public void func_175568_b(float p_175568_1_, float p_175568_2_, float p_175568_3_) {
        this.field_70872_bC = p_175568_1_;
        this.field_70869_bD = p_175568_2_;
        this.field_70870_bE = p_175568_3_;
    }

    public boolean func_175567_n() {
        return this.field_70872_bC != 0.0f || this.field_70869_bD != 0.0f || this.field_70870_bE != 0.0f;
    }

    class MoveRandomGoal
    extends Goal {
        private final SquidEntity field_179476_a;

        public MoveRandomGoal(SquidEntity p_i48823_2_) {
            this.field_179476_a = p_i48823_2_;
        }

        public boolean func_75250_a() {
            return true;
        }

        public void func_75246_d() {
            int i = this.field_179476_a.func_70654_ax();
            if (i > 100) {
                this.field_179476_a.func_175568_b(0.0f, 0.0f, 0.0f);
            } else if (this.field_179476_a.func_70681_au().nextInt(50) == 0 || !this.field_179476_a.field_70171_ac || !this.field_179476_a.func_175567_n()) {
                float f = this.field_179476_a.func_70681_au().nextFloat() * ((float)Math.PI * 2);
                float f1 = MathHelper.func_76134_b((float)f) * 0.2f;
                float f2 = -0.1f + this.field_179476_a.func_70681_au().nextFloat() * 0.2f;
                float f3 = MathHelper.func_76126_a((float)f) * 0.2f;
                this.field_179476_a.func_175568_b(f1, f2, f3);
            }
        }
    }

    class FleeGoal
    extends Goal {
        private int field_203125_b;

        private FleeGoal() {
        }

        public boolean func_75250_a() {
            LivingEntity livingentity = SquidEntity.this.func_70643_av();
            if (SquidEntity.this.func_70090_H() && livingentity != null) {
                return SquidEntity.this.func_70068_e(livingentity) < 100.0;
            }
            return false;
        }

        public void func_75249_e() {
            this.field_203125_b = 0;
        }

        public void func_75246_d() {
            ++this.field_203125_b;
            LivingEntity livingentity = SquidEntity.this.func_70643_av();
            if (livingentity != null) {
                Vector3d vector3d = new Vector3d(SquidEntity.this.func_226277_ct_() - livingentity.func_226277_ct_(), SquidEntity.this.func_226278_cu_() - livingentity.func_226278_cu_(), SquidEntity.this.func_226281_cx_() - livingentity.func_226281_cx_());
                BlockState blockstate = SquidEntity.this.field_70170_p.func_180495_p(new BlockPos(SquidEntity.this.func_226277_ct_() + vector3d.field_72450_a, SquidEntity.this.func_226278_cu_() + vector3d.field_72448_b, SquidEntity.this.func_226281_cx_() + vector3d.field_72449_c));
                FluidState fluidstate = SquidEntity.this.field_70170_p.func_204610_c(new BlockPos(SquidEntity.this.func_226277_ct_() + vector3d.field_72450_a, SquidEntity.this.func_226278_cu_() + vector3d.field_72448_b, SquidEntity.this.func_226281_cx_() + vector3d.field_72449_c));
                if (fluidstate.func_206884_a(FluidTags.field_206959_a) || blockstate.func_196958_f()) {
                    double d0 = vector3d.func_72433_c();
                    if (d0 > 0.0) {
                        vector3d.func_72432_b();
                        float f = 3.0f;
                        if (d0 > 5.0) {
                            f = (float)((double)f - (d0 - 5.0) / 5.0);
                        }
                        if (f > 0.0f) {
                            vector3d = vector3d.func_186678_a(f);
                        }
                    }
                    if (blockstate.func_196958_f()) {
                        vector3d = vector3d.func_178786_a(0.0, vector3d.field_72448_b, 0.0);
                    }
                    SquidEntity.this.func_175568_b((float)vector3d.field_72450_a / 20.0f, (float)vector3d.field_72448_b / 20.0f, (float)vector3d.field_72449_c / 20.0f);
                }
                if (this.field_203125_b % 10 == 5) {
                    SquidEntity.this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, SquidEntity.this.func_226277_ct_(), SquidEntity.this.func_226278_cu_(), SquidEntity.this.func_226281_cx_(), 0.0, 0.0, 0.0);
                }
            }
        }
    }
}

