/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.passive.fish;

import io.papermc.paper.event.entity.PufferFishStateChangeEvent;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.passive.fish.AbstractFishEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SChangeGameStatePacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import org.bukkit.entity.PufferFish;
import org.bukkit.event.entity.EntityPotionEffectEvent;

public class PufferfishEntity
extends AbstractFishEntity {
    private static final DataParameter<Integer> field_203716_b = EntityDataManager.func_187226_a(PufferfishEntity.class, DataSerializers.field_187192_b);
    private int field_203717_c;
    private int field_203718_bx;
    private static final Predicate<LivingEntity> field_205724_bA = p_210139_0_ -> {
        if (p_210139_0_ == null) {
            return false;
        }
        if (!(p_210139_0_ instanceof PlayerEntity) || !p_210139_0_.func_175149_v() && !((PlayerEntity)p_210139_0_).func_184812_l_()) {
            return p_210139_0_.func_70668_bt() != CreatureAttribute.field_203100_e;
        }
        return false;
    };

    public PufferfishEntity(EntityType<? extends PufferfishEntity> p_i50248_1_, World p_i50248_2_) {
        super(p_i50248_1_, p_i50248_2_);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_203716_b, 0);
    }

    public int func_203715_dA() {
        return this.field_70180_af.func_187225_a(field_203716_b);
    }

    public void func_203714_a(int p_203714_1_) {
        this.field_70180_af.func_187227_b(field_203716_b, p_203714_1_);
    }

    public void func_184206_a(DataParameter<?> p_184206_1_) {
        if (field_203716_b.equals(p_184206_1_)) {
            this.func_213323_x_();
        }
        super.func_184206_a(p_184206_1_);
    }

    @Override
    public void func_213281_b(CompoundNBT p_213281_1_) {
        super.func_213281_b(p_213281_1_);
        p_213281_1_.func_74768_a("PuffState", this.func_203715_dA());
    }

    @Override
    public void func_70037_a(CompoundNBT p_70037_1_) {
        super.func_70037_a(p_70037_1_);
        this.func_203714_a(p_70037_1_.func_74762_e("PuffState"));
    }

    @Override
    protected ItemStack func_203707_dx() {
        return new ItemStack(Items.field_203795_aL);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new PuffGoal(this));
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K && this.func_70089_S() && this.func_70613_aW()) {
            if (this.field_203717_c > 0) {
                boolean increase = true;
                if (this.func_203715_dA() == 0) {
                    if (new PufferFishStateChangeEvent((PufferFish)this.getBukkitEntity(), 1).callEvent()) {
                        this.func_184185_a(SoundEvents.field_203826_go, this.func_70599_aP(), this.func_70647_i());
                        this.func_203714_a(1);
                    } else {
                        increase = false;
                    }
                } else if (this.field_203717_c > 40 && this.func_203715_dA() == 1) {
                    if (new PufferFishStateChangeEvent((PufferFish)this.getBukkitEntity(), 2).callEvent()) {
                        this.func_184185_a(SoundEvents.field_203826_go, this.func_70599_aP(), this.func_70647_i());
                        this.func_203714_a(2);
                    } else {
                        increase = false;
                    }
                }
                if (increase) {
                    ++this.field_203717_c;
                }
            } else if (this.func_203715_dA() != 0) {
                boolean increase = true;
                if (this.field_203718_bx > 60 && this.func_203715_dA() == 2) {
                    if (new PufferFishStateChangeEvent((PufferFish)this.getBukkitEntity(), 1).callEvent()) {
                        this.func_184185_a(SoundEvents.field_203825_gn, this.func_70599_aP(), this.func_70647_i());
                        this.func_203714_a(1);
                    } else {
                        increase = false;
                    }
                } else if (this.field_203718_bx > 100 && this.func_203715_dA() == 1) {
                    if (new PufferFishStateChangeEvent((PufferFish)this.getBukkitEntity(), 0).callEvent()) {
                        this.func_184185_a(SoundEvents.field_203825_gn, this.func_70599_aP(), this.func_70647_i());
                        this.func_203714_a(0);
                    } else {
                        increase = false;
                    }
                }
                if (increase) {
                    ++this.field_203718_bx;
                }
            }
        }
        super.func_70071_h_();
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_70089_S() && this.func_203715_dA() > 0) {
            for (MobEntity mobEntity : this.field_70170_p.func_175647_a(MobEntity.class, this.func_174813_aQ().func_186662_g(0.3), field_205724_bA)) {
                if (!mobEntity.func_70089_S()) continue;
                this.func_205719_a(mobEntity);
            }
        }
    }

    private void func_205719_a(MobEntity p_205719_1_) {
        int i = this.func_203715_dA();
        if (p_205719_1_.func_70097_a(DamageSource.func_76358_a((LivingEntity)((Object)this)), 1 + i)) {
            p_205719_1_.addEffect(new EffectInstance(Effects.field_76436_u, 60 * i, 0), EntityPotionEffectEvent.Cause.ATTACK);
            this.func_184185_a(SoundEvents.field_203830_gs, 1.0f, 1.0f);
        }
    }

    public void func_70100_b_(PlayerEntity p_70100_1_) {
        int i = this.func_203715_dA();
        if (p_70100_1_ instanceof ServerPlayerEntity && i > 0 && p_70100_1_.func_70097_a(DamageSource.func_76358_a((LivingEntity)((Object)this)), 1 + i)) {
            if (!this.func_174814_R()) {
                ((ServerPlayerEntity)p_70100_1_).field_71135_a.func_147359_a((IPacket<?>)new SChangeGameStatePacket(SChangeGameStatePacket.field_241773_j_, 0.0f));
            }
            p_70100_1_.addEffect(new EffectInstance(Effects.field_76436_u, 60 * i, 0), EntityPotionEffectEvent.Cause.ATTACK);
        }
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_203824_gm;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_203827_gp;
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return SoundEvents.field_203829_gr;
    }

    @Override
    protected SoundEvent func_203701_dz() {
        return SoundEvents.field_203828_gq;
    }

    public EntitySize func_213305_a(Pose p_213305_1_) {
        return super.func_213305_a(p_213305_1_).func_220313_a(PufferfishEntity.func_213806_q(this.func_203715_dA()));
    }

    private static float func_213806_q(int p_213806_0_) {
        switch (p_213806_0_) {
            case 0: {
                return 0.5f;
            }
            case 1: {
                return 0.7f;
            }
        }
        return 1.0f;
    }

    static class PuffGoal
    extends Goal {
        private final PufferfishEntity field_203789_a;

        public PuffGoal(PufferfishEntity p_i48861_1_) {
            this.field_203789_a = p_i48861_1_;
        }

        public boolean func_75250_a() {
            List<LivingEntity> list = this.field_203789_a.field_70170_p.func_175647_a(LivingEntity.class, this.field_203789_a.func_174813_aQ().func_186662_g(2.0), field_205724_bA);
            return !list.isEmpty();
        }

        public void func_75249_e() {
            this.field_203789_a.field_203717_c = 1;
            this.field_203789_a.field_203718_bx = 0;
        }

        public void func_75251_c() {
            this.field_203789_a.field_203717_c = 0;
        }

        public boolean func_75253_b() {
            List<LivingEntity> list = this.field_203789_a.field_70170_p.func_175647_a(LivingEntity.class, this.field_203789_a.func_174813_aQ().func_186662_g(2.0), field_205724_bA);
            return !list.isEmpty();
        }
    }
}

