/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.projectile;

import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class ProjectileHelper {
    public static RayTraceResult func_234618_a_(Entity p_234618_0_, Predicate<Entity> p_234618_1_) {
        EntityRayTraceResult raytraceresult1;
        Vector3d vector3d2;
        Vector3d vector3d = p_234618_0_.func_213322_ci();
        World world = p_234618_0_.field_70170_p;
        Vector3d vector3d1 = p_234618_0_.func_213303_ch();
        BlockRayTraceResult raytraceresult = world.func_217299_a(new RayTraceContext(vector3d1, vector3d2 = vector3d1.func_178787_e(vector3d), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, p_234618_0_));
        if (raytraceresult.func_216346_c() != RayTraceResult.Type.MISS) {
            vector3d2 = raytraceresult.func_216347_e();
        }
        if ((raytraceresult1 = ProjectileHelper.func_221269_a(world, p_234618_0_, vector3d1, vector3d2, p_234618_0_.func_174813_aQ().func_216361_a(p_234618_0_.func_213322_ci()).func_186662_g(1.0), p_234618_1_)) != null) {
            raytraceresult = raytraceresult1;
        }
        return raytraceresult;
    }

    @Nullable
    @OnlyIn(value=Dist.CLIENT)
    public static EntityRayTraceResult func_221273_a(Entity p_221273_0_, Vector3d p_221273_1_, Vector3d p_221273_2_, AxisAlignedBB p_221273_3_, Predicate<Entity> p_221273_4_, double p_221273_5_) {
        World world = p_221273_0_.field_70170_p;
        double d0 = p_221273_5_;
        Entity entity = null;
        Vector3d vector3d = null;
        for (Entity entity1 : world.func_175674_a(p_221273_0_, p_221273_3_, p_221273_4_)) {
            Vector3d vector3d1;
            double d1;
            AxisAlignedBB axisalignedbb = entity1.func_174813_aQ().func_186662_g(entity1.func_70111_Y());
            Optional<Vector3d> optional = axisalignedbb.func_216365_b(p_221273_1_, p_221273_2_);
            if (axisalignedbb.func_72318_a(p_221273_1_)) {
                if (!(d0 >= 0.0)) continue;
                entity = entity1;
                vector3d = optional.orElse(p_221273_1_);
                d0 = 0.0;
                continue;
            }
            if (!optional.isPresent() || !((d1 = p_221273_1_.func_72436_e(vector3d1 = optional.get())) < d0) && d0 != 0.0) continue;
            if (entity1.func_184208_bv() == p_221273_0_.func_184208_bv() && !entity1.canRiderInteract()) {
                if (d0 != 0.0) continue;
                entity = entity1;
                vector3d = vector3d1;
                continue;
            }
            entity = entity1;
            vector3d = vector3d1;
            d0 = d1;
        }
        return entity == null ? null : new EntityRayTraceResult(entity, vector3d);
    }

    @Nullable
    public static EntityRayTraceResult func_221269_a(World p_221269_0_, Entity p_221269_1_, Vector3d p_221269_2_, Vector3d p_221269_3_, AxisAlignedBB p_221269_4_, Predicate<Entity> p_221269_5_) {
        double d0 = Double.MAX_VALUE;
        Entity entity = null;
        for (Entity entity1 : p_221269_0_.func_175674_a(p_221269_1_, p_221269_4_, p_221269_5_)) {
            double d1;
            AxisAlignedBB axisalignedbb = entity1.func_174813_aQ().func_186662_g(0.3f);
            Optional<Vector3d> optional = axisalignedbb.func_216365_b(p_221269_2_, p_221269_3_);
            if (!optional.isPresent() || !((d1 = p_221269_2_.func_72436_e(optional.get())) < d0)) continue;
            entity = entity1;
            d0 = d1;
        }
        return entity == null ? null : new EntityRayTraceResult(entity);
    }

    public static final void func_188803_a(Entity p_188803_0_, float p_188803_1_) {
        Vector3d vector3d = p_188803_0_.func_213322_ci();
        if (vector3d.func_189985_c() != 0.0) {
            float f = MathHelper.func_76133_a((double)Entity.func_213296_b(vector3d));
            p_188803_0_.field_70177_z = (float)(MathHelper.func_181159_b((double)vector3d.field_72449_c, (double)vector3d.field_72450_a) * 57.2957763671875) + 90.0f;
            p_188803_0_.field_70125_A = (float)(MathHelper.func_181159_b((double)f, (double)vector3d.field_72448_b) * 57.2957763671875) - 90.0f;
            while (p_188803_0_.field_70125_A - p_188803_0_.field_70127_C < -180.0f) {
                p_188803_0_.field_70127_C -= 360.0f;
            }
            while (p_188803_0_.field_70125_A - p_188803_0_.field_70127_C >= 180.0f) {
                p_188803_0_.field_70127_C += 360.0f;
            }
            while (p_188803_0_.field_70177_z - p_188803_0_.field_70126_B < -180.0f) {
                p_188803_0_.field_70126_B -= 360.0f;
            }
            while (p_188803_0_.field_70177_z - p_188803_0_.field_70126_B >= 180.0f) {
                p_188803_0_.field_70126_B += 360.0f;
            }
            p_188803_0_.field_70125_A = MathHelper.func_219799_g((float)p_188803_1_, (float)p_188803_0_.field_70127_C, (float)p_188803_0_.field_70125_A);
            p_188803_0_.field_70177_z = MathHelper.func_219799_g((float)p_188803_1_, (float)p_188803_0_.field_70126_B, (float)p_188803_0_.field_70177_z);
        }
    }

    @Deprecated
    public static Hand func_221274_a(LivingEntity p_221274_0_, Item p_221274_1_) {
        return p_221274_0_.func_184614_ca().func_77973_b() == p_221274_1_ ? Hand.MAIN_HAND : Hand.OFF_HAND;
    }

    public static Hand getWeaponHoldingHand(LivingEntity livingEntity, Predicate<Item> itemPredicate) {
        return itemPredicate.test(livingEntity.func_184614_ca().func_77973_b()) ? Hand.MAIN_HAND : Hand.OFF_HAND;
    }

    public static AbstractArrowEntity func_221272_a(LivingEntity p_221272_0_, ItemStack p_221272_1_, float p_221272_2_) {
        ArrowItem arrowitem = (ArrowItem)(p_221272_1_.func_77973_b() instanceof ArrowItem ? p_221272_1_.func_77973_b() : Items.field_151032_g);
        AbstractArrowEntity abstractarrowentity = arrowitem.func_200887_a(p_221272_0_.field_70170_p, p_221272_1_, p_221272_0_);
        abstractarrowentity.func_190547_a(p_221272_0_, p_221272_2_);
        if (p_221272_1_.func_77973_b() == Items.field_185167_i && abstractarrowentity instanceof ArrowEntity) {
            ((ArrowEntity)abstractarrowentity).func_184555_a(p_221272_1_);
        }
        return abstractarrowentity;
    }
}

