/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.inventory;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.inventory.IRecipeHelperPopulator;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.NonNullList;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftHumanEntity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.InventoryHolder;

public class Inventory
implements IInventory,
IRecipeHelperPopulator {
    private final int field_70481_b;
    private final NonNullList<ItemStack> field_70482_c;
    private List<IInventoryChangedListener> field_70480_d;
    public List<HumanEntity> transaction = new ArrayList<HumanEntity>();
    private int maxStack = 64;
    protected InventoryHolder bukkitOwner;

    @Override
    public List<ItemStack> getContents() {
        return this.field_70482_c;
    }

    @Override
    public void onOpen(CraftHumanEntity who) {
        this.transaction.add((HumanEntity)who);
    }

    @Override
    public void onClose(CraftHumanEntity who) {
        this.transaction.remove(who);
    }

    @Override
    public List<HumanEntity> getViewers() {
        return this.transaction;
    }

    @Override
    public InventoryHolder getOwner() {
        return this.bukkitOwner;
    }

    @Override
    public int func_70297_j_() {
        return this.maxStack;
    }

    @Override
    public void setMaxStackSize(int size) {
        this.maxStack = size;
    }

    @Override
    public Location getLocation() {
        return null;
    }

    public Inventory(Inventory original) {
        this(original.field_70481_b);
        for (int slot = 0; slot < original.field_70481_b; ++slot) {
            this.field_70482_c.set(slot, original.field_70482_c.get(slot).func_77946_l());
        }
    }

    public Inventory(int p_i50397_1_) {
        this(p_i50397_1_, null);
    }

    public Inventory(int numSlots, InventoryHolder owner) {
        this.bukkitOwner = owner;
        this.field_70481_b = numSlots;
        this.field_70482_c = NonNullList.func_191197_a(numSlots, ItemStack.field_190927_a);
    }

    public Inventory(ItemStack ... p_i50398_1_) {
        this.field_70481_b = p_i50398_1_.length;
        this.field_70482_c = NonNullList.func_193580_a(ItemStack.field_190927_a, p_i50398_1_);
    }

    public void func_110134_a(IInventoryChangedListener p_110134_1_) {
        if (this.field_70480_d == null) {
            this.field_70480_d = Lists.newArrayList();
        }
        this.field_70480_d.add(p_110134_1_);
    }

    public void func_110132_b(IInventoryChangedListener p_110132_1_) {
        this.field_70480_d.remove(p_110132_1_);
    }

    @Override
    public ItemStack func_70301_a(int p_70301_1_) {
        return p_70301_1_ >= 0 && p_70301_1_ < this.field_70482_c.size() ? this.field_70482_c.get(p_70301_1_) : ItemStack.field_190927_a;
    }

    public List<ItemStack> func_233543_f_() {
        List<ItemStack> list = this.field_70482_c.stream().filter(p_233544_0_ -> !p_233544_0_.func_190926_b()).collect(Collectors.toList());
        this.func_174888_l();
        return list;
    }

    @Override
    public ItemStack func_70298_a(int p_70298_1_, int p_70298_2_) {
        ItemStack itemstack = ItemStackHelper.func_188382_a(this.field_70482_c, (int)p_70298_1_, (int)p_70298_2_);
        if (!itemstack.func_190926_b()) {
            this.func_70296_d();
        }
        return itemstack;
    }

    public ItemStack func_223374_a(Item p_223374_1_, int p_223374_2_) {
        ItemStack itemstack = new ItemStack(p_223374_1_, 0);
        for (int i = this.field_70481_b - 1; i >= 0; --i) {
            ItemStack itemstack1 = this.func_70301_a(i);
            if (!((Object)((Object)itemstack1.func_77973_b())).equals((Object)p_223374_1_)) continue;
            int j = p_223374_2_ - itemstack.func_190916_E();
            ItemStack itemstack2 = itemstack1.func_77979_a(j);
            itemstack.func_190917_f(itemstack2.func_190916_E());
            if (itemstack.func_190916_E() == p_223374_2_) break;
        }
        if (!itemstack.func_190926_b()) {
            this.func_70296_d();
        }
        return itemstack;
    }

    public ItemStack func_174894_a(ItemStack p_174894_1_) {
        ItemStack itemstack = p_174894_1_.func_77946_l();
        this.func_223372_c(itemstack);
        if (itemstack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        this.func_223375_b(itemstack);
        return itemstack.func_190926_b() ? ItemStack.field_190927_a : itemstack;
    }

    public boolean func_233541_b_(ItemStack p_233541_1_) {
        boolean flag = false;
        for (ItemStack itemstack : this.field_70482_c) {
            if (!itemstack.func_190926_b() && (!this.func_233540_a_(itemstack, p_233541_1_) || itemstack.func_190916_E() >= itemstack.func_77976_d())) continue;
            flag = true;
            break;
        }
        return flag;
    }

    @Override
    public ItemStack func_70304_b(int p_70304_1_) {
        ItemStack itemstack = this.field_70482_c.get(p_70304_1_);
        if (itemstack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        this.field_70482_c.set(p_70304_1_, ItemStack.field_190927_a);
        return itemstack;
    }

    @Override
    public void func_70299_a(int p_70299_1_, ItemStack p_70299_2_) {
        this.field_70482_c.set(p_70299_1_, p_70299_2_);
        if (!p_70299_2_.func_190926_b() && p_70299_2_.func_190916_E() > this.func_70297_j_()) {
            p_70299_2_.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    @Override
    public int func_70302_i_() {
        return this.field_70481_b;
    }

    @Override
    public boolean func_191420_l() {
        for (ItemStack itemstack : this.field_70482_c) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void func_70296_d() {
        if (this.field_70480_d != null) {
            for (IInventoryChangedListener iinventorychangedlistener : this.field_70480_d) {
                iinventorychangedlistener.func_76316_a((IInventory)this);
            }
        }
    }

    @Override
    public boolean func_70300_a(PlayerEntity p_70300_1_) {
        return true;
    }

    public void func_174888_l() {
        this.field_70482_c.clear();
        this.func_70296_d();
    }

    public void func_194018_a(RecipeItemHelper p_194018_1_) {
        for (ItemStack itemstack : this.field_70482_c) {
            p_194018_1_.func_194112_a(itemstack);
        }
    }

    public String toString() {
        return this.field_70482_c.stream().filter(p_223371_0_ -> !p_223371_0_.func_190926_b()).collect(Collectors.toList()).toString();
    }

    private void func_223375_b(ItemStack p_223375_1_) {
        for (int i = 0; i < this.field_70481_b; ++i) {
            ItemStack itemstack = this.func_70301_a(i);
            if (!itemstack.func_190926_b()) continue;
            this.func_70299_a(i, p_223375_1_.func_77946_l());
            p_223375_1_.func_190920_e(0);
            return;
        }
    }

    private void func_223372_c(ItemStack p_223372_1_) {
        for (int i = 0; i < this.field_70481_b; ++i) {
            ItemStack itemstack = this.func_70301_a(i);
            if (!this.func_233540_a_(itemstack, p_223372_1_)) continue;
            this.func_223373_a(p_223372_1_, itemstack);
            if (!p_223372_1_.func_190926_b()) continue;
            return;
        }
    }

    private boolean func_233540_a_(ItemStack p_233540_1_, ItemStack p_233540_2_) {
        return p_233540_1_.func_77973_b() == p_233540_2_.func_77973_b() && ItemStack.func_77970_a(p_233540_1_, p_233540_2_);
    }

    private void func_223373_a(ItemStack p_223373_1_, ItemStack p_223373_2_) {
        int i = Math.min(this.func_70297_j_(), p_223373_2_.func_77976_d());
        int j = Math.min(p_223373_1_.func_190916_E(), i - p_223373_2_.func_190916_E());
        if (j > 0) {
            p_223373_2_.func_190917_f(j);
            p_223373_1_.func_190918_g(j);
            this.func_70296_d();
        }
    }

    public void func_70486_a(ListNBT p_70486_1_) {
        for (int i = 0; i < p_70486_1_.size(); ++i) {
            ItemStack itemstack = ItemStack.func_199557_a(p_70486_1_.func_150305_b(i));
            if (itemstack.func_190926_b()) continue;
            this.func_174894_a(itemstack);
        }
    }

    public ListNBT func_70487_g() {
        ListNBT listnbt = new ListNBT();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack itemstack = this.func_70301_a(i);
            if (itemstack.func_190926_b()) continue;
            listnbt.add((Object)itemstack.func_77955_b(new CompoundNBT()));
        }
        return listnbt;
    }
}

