/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item.crafting;

import com.google.common.collect.Lists;
import com.mohistmc.util.i18n.i18n;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.RecipeBook;
import net.minecraft.item.crafting.RecipeBookStatus;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SRecipeBookPacket;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bukkit.craftbukkit.v1_16_R3.event.CraftEventFactory;

public class ServerRecipeBook
extends RecipeBook {
    private static final Logger field_192828_d = LogManager.getLogger();

    public int func_197926_a(Collection<IRecipe<?>> p_197926_1_, ServerPlayerEntity p_197926_2_) {
        ArrayList list = Lists.newArrayList();
        int i = 0;
        for (IRecipe<?> irecipe : p_197926_1_) {
            ResourceLocation resourcelocation = irecipe.func_199560_c();
            if (this.field_194077_a.contains(resourcelocation) || irecipe.func_192399_d() || !CraftEventFactory.handlePlayerRecipeListUpdateEvent((PlayerEntity)p_197926_2_, (ResourceLocation)resourcelocation)) continue;
            this.func_209118_a(resourcelocation);
            this.func_209120_c(resourcelocation);
            list.add(resourcelocation);
            CriteriaTriggers.field_192126_f.func_192225_a(p_197926_2_, irecipe);
            ++i;
        }
        this.func_194081_a(SRecipeBookPacket.State.ADD, p_197926_2_, list);
        return i;
    }

    public int func_197925_b(Collection<IRecipe<?>> p_197925_1_, ServerPlayerEntity p_197925_2_) {
        ArrayList list = Lists.newArrayList();
        int i = 0;
        for (IRecipe<?> irecipe : p_197925_1_) {
            ResourceLocation resourcelocation = irecipe.func_199560_c();
            if (!this.field_194077_a.contains(resourcelocation)) continue;
            this.func_209119_b(resourcelocation);
            list.add(resourcelocation);
            ++i;
        }
        this.func_194081_a(SRecipeBookPacket.State.REMOVE, p_197925_2_, list);
        return i;
    }

    private void func_194081_a(SRecipeBookPacket.State p_194081_1_, ServerPlayerEntity p_194081_2_, List<ResourceLocation> p_194081_3_) {
        if (p_194081_2_.field_71135_a == null) {
            return;
        }
        p_194081_2_.field_71135_a.func_147359_a((IPacket<?>)new SRecipeBookPacket(p_194081_1_, p_194081_3_, Collections.emptyList(), this.func_242139_a()));
    }

    public CompoundNBT func_192824_e() {
        CompoundNBT compoundnbt = new CompoundNBT();
        this.func_242139_a().func_242160_b(compoundnbt);
        ListNBT listnbt = new ListNBT();
        for (ResourceLocation resourcelocation : this.field_194077_a) {
            listnbt.add((Object)StringNBT.func_229705_a_(resourcelocation.toString()));
        }
        compoundnbt.func_218657_a("recipes", (INBT)listnbt);
        ListNBT listnbt1 = new ListNBT();
        for (ResourceLocation resourcelocation1 : this.field_194078_b) {
            listnbt1.add((Object)StringNBT.func_229705_a_(resourcelocation1.toString()));
        }
        compoundnbt.func_218657_a("toBeDisplayed", (INBT)listnbt1);
        return compoundnbt;
    }

    public void func_192825_a(CompoundNBT p_192825_1_, RecipeManager p_192825_2_) {
        this.func_242140_a(RecipeBookStatus.func_242154_a((CompoundNBT)p_192825_1_));
        ListNBT listnbt = p_192825_1_.func_150295_c("recipes", 8);
        this.func_223417_a_(listnbt, this::func_194073_a, p_192825_2_);
        ListNBT listnbt1 = p_192825_1_.func_150295_c("toBeDisplayed", 8);
        this.func_223417_a_(listnbt1, this::func_193825_e, p_192825_2_);
    }

    private void func_223417_a_(ListNBT p_223417_1_, Consumer<IRecipe<?>> p_223417_2_, RecipeManager p_223417_3_) {
        for (int i = 0; i < p_223417_1_.size(); ++i) {
            String s = p_223417_1_.func_150307_f(i);
            try {
                ResourceLocation resourcelocation = new ResourceLocation(s);
                Optional<IRecipe<?>> optional = p_223417_3_.func_215367_a(resourcelocation);
                if (!optional.isPresent()) {
                    field_192828_d.error(i18n.get((String)"serverrecipebook.1", (Object[])new Object[]{resourcelocation}));
                    continue;
                }
                p_223417_2_.accept(optional.get());
                continue;
            }
            catch (ResourceLocationException resourcelocationexception) {
                field_192828_d.error(i18n.get((String)"serverrecipebook.2", (Object[])new Object[]{s}));
            }
        }
    }

    public void func_192826_c(ServerPlayerEntity p_192826_1_) {
        p_192826_1_.field_71135_a.func_147359_a((IPacket<?>)new SRecipeBookPacket(SRecipeBookPacket.State.INIT, (Collection)this.field_194077_a, (Collection)this.field_194078_b, this.func_242139_a()));
    }
}

