/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import net.minecraft.nbt.ByteArrayNBT;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.INBTType;
import net.minecraft.nbt.IntArrayNBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.LongArrayNBT;
import net.minecraft.nbt.LongNBT;
import net.minecraft.nbt.NumberNBT;
import net.minecraft.nbt.ShortNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.text.TranslationTextComponent;

public class JsonToNBT {
    public static final SimpleCommandExceptionType field_197657_a = new SimpleCommandExceptionType((Message)new TranslationTextComponent("argument.nbt.trailing"));
    public static final SimpleCommandExceptionType field_197658_b = new SimpleCommandExceptionType((Message)new TranslationTextComponent("argument.nbt.expected.key"));
    public static final SimpleCommandExceptionType field_197659_c = new SimpleCommandExceptionType((Message)new TranslationTextComponent("argument.nbt.expected.value"));
    public static final Dynamic2CommandExceptionType field_197660_d = new Dynamic2CommandExceptionType((p_208775_0_, p_208775_1_) -> new TranslationTextComponent("argument.nbt.list.mixed", p_208775_0_, p_208775_1_));
    public static final Dynamic2CommandExceptionType field_197661_e = new Dynamic2CommandExceptionType((p_208774_0_, p_208774_1_) -> new TranslationTextComponent("argument.nbt.array.mixed", p_208774_0_, p_208774_1_));
    public static final DynamicCommandExceptionType field_197662_f = new DynamicCommandExceptionType(p_208773_0_ -> new TranslationTextComponent("argument.nbt.array.invalid", p_208773_0_));
    private static final Pattern field_193615_a = Pattern.compile("[-+]?(?:[0-9]+[.]|[0-9]*[.][0-9]+)(?:e[-+]?[0-9]+)?", 2);
    private static final Pattern field_193616_b = Pattern.compile("[-+]?(?:[0-9]+[.]?|[0-9]*[.][0-9]+)(?:e[-+]?[0-9]+)?d", 2);
    private static final Pattern field_193617_c = Pattern.compile("[-+]?(?:[0-9]+[.]?|[0-9]*[.][0-9]+)(?:e[-+]?[0-9]+)?f", 2);
    private static final Pattern field_193618_d = Pattern.compile("[-+]?(?:0|[1-9][0-9]*)b", 2);
    private static final Pattern field_193619_e = Pattern.compile("[-+]?(?:0|[1-9][0-9]*)l", 2);
    private static final Pattern field_193620_f = Pattern.compile("[-+]?(?:0|[1-9][0-9]*)s", 2);
    private static final Pattern field_193621_g = Pattern.compile("[-+]?(?:0|[1-9][0-9]*)");
    private final StringReader field_197663_n;

    public static CompoundNBT func_180713_a(String p_180713_0_) throws CommandSyntaxException {
        return new JsonToNBT(new StringReader(p_180713_0_)).func_193609_a();
    }

    @VisibleForTesting
    CompoundNBT func_193609_a() throws CommandSyntaxException {
        CompoundNBT compoundnbt = this.func_193593_f();
        this.field_197663_n.skipWhitespace();
        if (this.field_197663_n.canRead()) {
            throw field_197657_a.createWithContext((ImmutableStringReader)this.field_197663_n);
        }
        return compoundnbt;
    }

    public JsonToNBT(StringReader p_i47948_1_) {
        this.field_197663_n = p_i47948_1_;
    }

    protected String func_193601_b() throws CommandSyntaxException {
        this.field_197663_n.skipWhitespace();
        if (!this.field_197663_n.canRead()) {
            throw field_197658_b.createWithContext((ImmutableStringReader)this.field_197663_n);
        }
        return this.field_197663_n.readString();
    }

    protected INBT func_193611_c() throws CommandSyntaxException {
        this.field_197663_n.skipWhitespace();
        int i = this.field_197663_n.getCursor();
        if (StringReader.isQuotedStringStart((char)this.field_197663_n.peek())) {
            return StringNBT.func_229705_a_(this.field_197663_n.readQuotedString());
        }
        String s = this.field_197663_n.readUnquotedString();
        if (s.isEmpty()) {
            this.field_197663_n.setCursor(i);
            throw field_197659_c.createWithContext((ImmutableStringReader)this.field_197663_n);
        }
        return this.func_193596_c(s);
    }

    public INBT func_193596_c(String p_193596_1_) {
        try {
            if (field_193617_c.matcher(p_193596_1_).matches()) {
                return FloatNBT.func_229689_a_((float)Float.parseFloat(p_193596_1_.substring(0, p_193596_1_.length() - 1)));
            }
            if (field_193618_d.matcher(p_193596_1_).matches()) {
                return ByteNBT.func_229671_a_((byte)Byte.parseByte(p_193596_1_.substring(0, p_193596_1_.length() - 1)));
            }
            if (field_193619_e.matcher(p_193596_1_).matches()) {
                return LongNBT.func_229698_a_((long)Long.parseLong(p_193596_1_.substring(0, p_193596_1_.length() - 1)));
            }
            if (field_193620_f.matcher(p_193596_1_).matches()) {
                return ShortNBT.func_229701_a_((short)Short.parseShort(p_193596_1_.substring(0, p_193596_1_.length() - 1)));
            }
            if (field_193621_g.matcher(p_193596_1_).matches()) {
                return IntNBT.func_229692_a_((int)Integer.parseInt(p_193596_1_));
            }
            if (field_193616_b.matcher(p_193596_1_).matches()) {
                return DoubleNBT.func_229684_a_((double)Double.parseDouble(p_193596_1_.substring(0, p_193596_1_.length() - 1)));
            }
            if (field_193615_a.matcher(p_193596_1_).matches()) {
                return DoubleNBT.func_229684_a_((double)Double.parseDouble(p_193596_1_));
            }
            if ("true".equalsIgnoreCase(p_193596_1_)) {
                return ByteNBT.field_229670_c_;
            }
            if ("false".equalsIgnoreCase(p_193596_1_)) {
                return ByteNBT.field_229669_b_;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return StringNBT.func_229705_a_(p_193596_1_);
    }

    public INBT func_193610_d() throws CommandSyntaxException {
        this.field_197663_n.skipWhitespace();
        if (!this.field_197663_n.canRead()) {
            throw field_197659_c.createWithContext((ImmutableStringReader)this.field_197663_n);
        }
        char c0 = this.field_197663_n.peek();
        if (c0 == '{') {
            return this.func_193593_f();
        }
        return c0 == '[' ? this.func_193605_e() : this.func_193611_c();
    }

    protected INBT func_193605_e() throws CommandSyntaxException {
        return this.field_197663_n.canRead(3) && !StringReader.isQuotedStringStart((char)this.field_197663_n.peek(1)) && this.field_197663_n.peek(2) == ';' ? this.func_193606_k() : this.func_193600_j();
    }

    public CompoundNBT func_193593_f() throws CommandSyntaxException {
        this.func_193604_b('{');
        CompoundNBT compoundnbt = new CompoundNBT();
        this.field_197663_n.skipWhitespace();
        while (this.field_197663_n.canRead() && this.field_197663_n.peek() != '}') {
            int i = this.field_197663_n.getCursor();
            String s = this.func_193601_b();
            if (s.isEmpty()) {
                this.field_197663_n.setCursor(i);
                throw field_197658_b.createWithContext((ImmutableStringReader)this.field_197663_n);
            }
            this.func_193604_b(':');
            compoundnbt.func_218657_a(s, this.func_193610_d());
            if (!this.func_193613_m()) break;
            if (this.field_197663_n.canRead()) continue;
            throw field_197658_b.createWithContext((ImmutableStringReader)this.field_197663_n);
        }
        this.func_193604_b('}');
        return compoundnbt;
    }

    private INBT func_193600_j() throws CommandSyntaxException {
        this.func_193604_b('[');
        this.field_197663_n.skipWhitespace();
        if (!this.field_197663_n.canRead()) {
            throw field_197659_c.createWithContext((ImmutableStringReader)this.field_197663_n);
        }
        ListNBT listnbt = new ListNBT();
        INBTType inbttype = null;
        while (this.field_197663_n.peek() != ']') {
            int i = this.field_197663_n.getCursor();
            INBT inbt = this.func_193610_d();
            INBTType inbttype1 = inbt.func_225647_b_();
            if (inbttype == null) {
                inbttype = inbttype1;
            } else if (inbttype1 != inbttype) {
                this.field_197663_n.setCursor(i);
                throw field_197660_d.createWithContext((ImmutableStringReader)this.field_197663_n, (Object)inbttype1.func_225650_b_(), (Object)inbttype.func_225650_b_());
            }
            listnbt.add((Object)inbt);
            if (!this.func_193613_m()) break;
            if (this.field_197663_n.canRead()) continue;
            throw field_197659_c.createWithContext((ImmutableStringReader)this.field_197663_n);
        }
        this.func_193604_b(']');
        return listnbt;
    }

    public INBT func_193606_k() throws CommandSyntaxException {
        this.func_193604_b('[');
        int i = this.field_197663_n.getCursor();
        char c0 = this.field_197663_n.read();
        this.field_197663_n.read();
        this.field_197663_n.skipWhitespace();
        if (!this.field_197663_n.canRead()) {
            throw field_197659_c.createWithContext((ImmutableStringReader)this.field_197663_n);
        }
        if (c0 == 'B') {
            return new ByteArrayNBT(this.func_229706_a_(ByteArrayNBT.field_229667_a_, ByteNBT.field_229668_a_));
        }
        if (c0 == 'L') {
            return new LongArrayNBT(this.func_229706_a_(LongArrayNBT.field_229696_a_, LongNBT.field_229697_a_));
        }
        if (c0 == 'I') {
            return new IntArrayNBT(this.func_229706_a_(IntArrayNBT.field_229690_a_, IntNBT.field_229691_a_));
        }
        this.field_197663_n.setCursor(i);
        throw field_197662_f.createWithContext((ImmutableStringReader)this.field_197663_n, (Object)String.valueOf(c0));
    }

    private <T extends Number> List<T> func_229706_a_(INBTType<?> p_229706_1_, INBTType<?> p_229706_2_) throws CommandSyntaxException {
        ArrayList list = Lists.newArrayList();
        while (this.field_197663_n.peek() != ']') {
            int i = this.field_197663_n.getCursor();
            INBT inbt = this.func_193610_d();
            INBTType inbttype = inbt.func_225647_b_();
            if (inbttype != p_229706_2_) {
                this.field_197663_n.setCursor(i);
                throw field_197661_e.createWithContext((ImmutableStringReader)this.field_197663_n, (Object)inbttype.func_225650_b_(), (Object)p_229706_1_.func_225650_b_());
            }
            if (p_229706_2_ == ByteNBT.field_229668_a_) {
                list.add(((NumberNBT)inbt).func_150290_f());
            } else if (p_229706_2_ == LongNBT.field_229697_a_) {
                list.add(((NumberNBT)inbt).func_150291_c());
            } else {
                list.add(((NumberNBT)inbt).func_150287_d());
            }
            if (!this.func_193613_m()) break;
            if (this.field_197663_n.canRead()) continue;
            throw field_197659_c.createWithContext((ImmutableStringReader)this.field_197663_n);
        }
        this.func_193604_b(']');
        return list;
    }

    private boolean func_193613_m() {
        this.field_197663_n.skipWhitespace();
        if (this.field_197663_n.canRead() && this.field_197663_n.peek() == ',') {
            this.field_197663_n.skip();
            this.field_197663_n.skipWhitespace();
            return true;
        }
        return false;
    }

    private void func_193604_b(char p_193604_1_) throws CommandSyntaxException {
        this.field_197663_n.skipWhitespace();
        this.field_197663_n.expect(p_193604_1_);
    }
}

