/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.handshake.client;

import com.google.gson.Gson;
import com.mojang.authlib.properties.Property;
import java.io.IOException;
import java.util.Objects;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.ProtocolType;
import net.minecraft.network.handshake.IHandshakeNetHandler;
import net.minecraft.util.SharedConstants;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import org.spigotmc.SpigotConfig;

public class CHandshakePacket
implements IPacket<IHandshakeNetHandler> {
    private int field_149600_a;
    public String field_149598_b;
    public String original_ip;
    public int field_149599_c;
    private ProtocolType field_149597_d;
    private String fmlVersion = "FML2";
    private static final String EXTRA_DATA = "extraData";
    private static final Gson GSON = new Gson();

    public CHandshakePacket() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public CHandshakePacket(String p_i47613_1_, int p_i47613_2_, ProtocolType p_i47613_3_) {
        this.field_149600_a = SharedConstants.func_215069_a().getProtocolVersion();
        this.field_149598_b = p_i47613_1_;
        this.field_149599_c = p_i47613_2_;
        this.field_149597_d = p_i47613_3_;
    }

    public void func_148837_a(PacketBuffer p_148837_1_) throws IOException {
        String[] split;
        this.field_149600_a = p_148837_1_.func_150792_a();
        this.field_149598_b = p_148837_1_.func_150789_c(Short.MAX_VALUE);
        this.field_149599_c = p_148837_1_.readUnsignedShort();
        this.field_149597_d = ProtocolType.func_150760_a((int)p_148837_1_.func_150792_a());
        this.fmlVersion = NetworkHooks.getFMLVersion((String)this.field_149598_b);
        if (SpigotConfig.bungee && !Objects.equals(this.fmlVersion, "FML2") && (split = this.field_149598_b.split("\u0000")).length == 4) {
            Property[] properties;
            for (Property property : properties = (Property[])GSON.fromJson(split[3], Property[].class)) {
                if (!Objects.equals(property.getName(), EXTRA_DATA)) continue;
                String extraData = property.getValue().replace("\u0001", "\u0000");
                this.fmlVersion = NetworkHooks.getFMLVersion((String)(split[0] + extraData));
            }
        }
        this.original_ip = this.field_149598_b;
        this.field_149598_b = this.field_149598_b.split("\u0000")[0];
    }

    public void func_148840_b(PacketBuffer p_148840_1_) throws IOException {
        p_148840_1_.func_150787_b(this.field_149600_a);
        p_148840_1_.func_180714_a(this.field_149598_b + "\u0000" + "FML2" + "\u0000");
        p_148840_1_.writeShort(this.field_149599_c);
        p_148840_1_.func_150787_b(this.field_149597_d.func_150759_c());
    }

    public void func_148833_a(IHandshakeNetHandler p_148833_1_) {
        p_148833_1_.func_147383_a(this);
    }

    public ProtocolType func_149594_c() {
        return this.field_149597_d;
    }

    public int func_149595_d() {
        return this.field_149600_a;
    }

    public String getFMLVersion() {
        return this.fmlVersion;
    }
}

