/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.profiler;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mohistmc.util.i18n.i18n;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongMaps;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.profiler.DataPoint;
import net.minecraft.profiler.IProfileResult;
import net.minecraft.profiler.IProfilerSection;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.Util;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FilledProfileResult
implements IProfileResult {
    private static final Logger field_219930_a = LogManager.getLogger();
    private static final IProfilerSection field_230090_b_ = new IProfilerSection(){

        public long func_230037_a_() {
            return 0L;
        }

        public long func_230038_b_() {
            return 0L;
        }

        public Object2LongMap<String> func_230039_c_() {
            return Object2LongMaps.emptyMap();
        }
    };
    private static final Splitter field_230091_c_ = Splitter.on((char)'\u001e');
    private static final Comparator<Map.Entry<String, Section>> field_230092_d_ = Map.Entry.comparingByValue(Comparator.comparingLong(p_230096_0_ -> Section.func_230110_a_(p_230096_0_))).reversed();
    private final Map<String, ? extends IProfilerSection> field_230093_e_;
    private final long field_219932_c;
    private final int field_219933_d;
    private final long field_219934_e;
    private final int field_219935_f;
    private final int field_223509_h;

    public FilledProfileResult(Map<String, ? extends IProfilerSection> p_i50407_1_, long p_i50407_2_, int p_i50407_4_, long p_i50407_5_, int p_i50407_7_) {
        this.field_230093_e_ = p_i50407_1_;
        this.field_219932_c = p_i50407_2_;
        this.field_219933_d = p_i50407_4_;
        this.field_219934_e = p_i50407_5_;
        this.field_219935_f = p_i50407_7_;
        this.field_223509_h = p_i50407_7_ - p_i50407_4_;
    }

    private IProfilerSection func_230104_c_(String p_230104_1_) {
        IProfilerSection iprofilersection = this.field_230093_e_.get(p_230104_1_);
        return iprofilersection != null ? iprofilersection : field_230090_b_;
    }

    public List<DataPoint> func_219917_a(String p_219917_1_) {
        String s = p_219917_1_;
        IProfilerSection iprofilersection = this.func_230104_c_("root");
        long i = iprofilersection.func_230037_a_();
        IProfilerSection iprofilersection1 = this.func_230104_c_(p_219917_1_);
        long j = iprofilersection1.func_230037_a_();
        long k = iprofilersection1.func_230038_b_();
        ArrayList list = Lists.newArrayList();
        if (!p_219917_1_.isEmpty()) {
            p_219917_1_ = p_219917_1_ + '\u001e';
        }
        long l = 0L;
        for (String s1 : this.field_230093_e_.keySet()) {
            if (!FilledProfileResult.func_230097_a_(p_219917_1_, s1)) continue;
            l += this.func_230104_c_(s1).func_230037_a_();
        }
        float f = l;
        if (l < j) {
            l = j;
        }
        if (i < l) {
            i = l;
        }
        for (String s2 : this.field_230093_e_.keySet()) {
            if (!FilledProfileResult.func_230097_a_(p_219917_1_, s2)) continue;
            IProfilerSection iprofilersection2 = this.func_230104_c_(s2);
            long i1 = iprofilersection2.func_230037_a_();
            double d0 = (double)i1 * 100.0 / (double)l;
            double d1 = (double)i1 * 100.0 / (double)i;
            String s3 = s2.substring(p_219917_1_.length());
            list.add(new DataPoint(s3, d0, d1, iprofilersection2.func_230038_b_()));
        }
        if ((float)l > f) {
            list.add(new DataPoint("unspecified", (double)((float)l - f) * 100.0 / (double)l, (double)((float)l - f) * 100.0 / (double)i, k));
        }
        Collections.sort(list);
        list.add(0, new DataPoint(s, 100.0, (double)l * 100.0 / (double)i, k));
        return list;
    }

    private static boolean func_230097_a_(String p_230097_0_, String p_230097_1_) {
        return p_230097_1_.length() > p_230097_0_.length() && p_230097_1_.startsWith(p_230097_0_) && p_230097_1_.indexOf(30, p_230097_0_.length() + 1) < 0;
    }

    private Map<String, Section> func_230106_h_() {
        TreeMap map = Maps.newTreeMap();
        this.field_230093_e_.forEach((p_230101_1_, p_230101_2_) -> {
            Object2LongMap object2longmap = p_230101_2_.func_230039_c_();
            if (!object2longmap.isEmpty()) {
                List list = field_230091_c_.splitToList((CharSequence)p_230101_1_);
                object2longmap.forEach((p_230103_2_, p_230103_3_) -> map.computeIfAbsent(p_230103_2_, p_230105_0_ -> new Section()).func_230112_a_(list.iterator(), (long)p_230103_3_));
            }
        });
        return map;
    }

    public long func_219918_a() {
        return this.field_219932_c;
    }

    public int func_219922_b() {
        return this.field_219933_d;
    }

    public long func_219923_c() {
        return this.field_219934_e;
    }

    public int func_219921_d() {
        return this.field_219935_f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean func_219919_a(File p_219919_1_) {
        boolean bl;
        p_219919_1_.getParentFile().mkdirs();
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(p_219919_1_), StandardCharsets.UTF_8);
            writer.write(this.func_219929_a(this.func_219924_f(), this.func_219925_g()));
            bl = true;
        }
        catch (Throwable throwable) {
            boolean flag;
            try {
                field_219930_a.error(i18n.get((String)"filledprofileresult.1", (Object[])new Object[]{p_219919_1_, throwable}));
                flag = false;
            }
            catch (Throwable throwable2) {
                IOUtils.closeQuietly(writer);
                throw throwable2;
            }
            IOUtils.closeQuietly((Writer)writer);
            return flag;
        }
        IOUtils.closeQuietly((Writer)writer);
        return bl;
    }

    protected String func_219929_a(long p_219929_1_, int p_219929_3_) {
        StringBuilder stringbuilder = new StringBuilder();
        stringbuilder.append("---- Minecraft Profiler Results ----\n");
        stringbuilder.append("// ");
        stringbuilder.append(FilledProfileResult.func_219927_h());
        stringbuilder.append("\n\n");
        stringbuilder.append("Version: ").append(SharedConstants.func_215069_a().getId()).append('\n');
        stringbuilder.append("Time span: ").append(p_219929_1_ / 1000000L).append(" ms\n");
        stringbuilder.append("Tick span: ").append(p_219929_3_).append(" ticks\n");
        stringbuilder.append("// This is approximately ").append(String.format(Locale.ROOT, "%.2f", Float.valueOf((float)p_219929_3_ / ((float)p_219929_1_ / 1.0E9f)))).append(" ticks per second. It should be ").append(20).append(" ticks per second\n\n");
        stringbuilder.append("--- BEGIN PROFILE DUMP ---\n\n");
        this.func_219928_a(0, "root", stringbuilder);
        stringbuilder.append("--- END PROFILE DUMP ---\n\n");
        Map<String, Section> map = this.func_230106_h_();
        if (!map.isEmpty()) {
            stringbuilder.append("--- BEGIN COUNTER DUMP ---\n\n");
            this.func_230102_a_(map, stringbuilder, p_219929_3_);
            stringbuilder.append("--- END COUNTER DUMP ---\n\n");
        }
        return stringbuilder.toString();
    }

    private static StringBuilder func_230098_a_(StringBuilder p_230098_0_, int p_230098_1_) {
        p_230098_0_.append(String.format("[%02d] ", p_230098_1_));
        for (int i = 0; i < p_230098_1_; ++i) {
            p_230098_0_.append("|   ");
        }
        return p_230098_0_;
    }

    private void func_219928_a(int p_219928_1_, String p_219928_2_, StringBuilder p_219928_3_) {
        List<DataPoint> list = this.func_219917_a(p_219928_2_);
        Object2LongMap object2longmap = ((IProfilerSection)ObjectUtils.firstNonNull((Object[])new IProfilerSection[]{this.field_230093_e_.get(p_219928_2_), field_230090_b_})).func_230039_c_();
        object2longmap.forEach((p_230100_3_, p_230100_4_) -> FilledProfileResult.func_230098_a_(p_219928_3_, p_219928_1_).append('#').append((String)p_230100_3_).append(' ').append(p_230100_4_).append('/').append(p_230100_4_ / (long)this.field_223509_h).append('\n'));
        if (list.size() >= 3) {
            for (int i = 1; i < list.size(); ++i) {
                DataPoint datapoint = list.get(i);
                FilledProfileResult.func_230098_a_(p_219928_3_, p_219928_1_).append(datapoint.field_219945_c).append('(').append(datapoint.field_223511_c).append('/').append(String.format(Locale.ROOT, "%.0f", Float.valueOf((float)datapoint.field_223511_c / (float)this.field_223509_h))).append(')').append(" - ").append(String.format(Locale.ROOT, "%.2f", datapoint.field_219943_a)).append("%/").append(String.format(Locale.ROOT, "%.2f", datapoint.field_219944_b)).append("%\n");
                if ("unspecified".equals(datapoint.field_219945_c)) continue;
                try {
                    this.func_219928_a(p_219928_1_ + 1, p_219928_2_ + '\u001e' + datapoint.field_219945_c, p_219928_3_);
                    continue;
                }
                catch (Exception exception) {
                    p_219928_3_.append("[[ EXCEPTION ").append(exception).append(" ]]");
                }
            }
        }
    }

    private void func_230095_a_(int p_230095_1_, String p_230095_2_, Section p_230095_3_, int p_230095_4_, StringBuilder p_230095_5_) {
        FilledProfileResult.func_230098_a_(p_230095_5_, p_230095_1_).append(p_230095_2_).append(" total:").append(p_230095_3_.field_230107_a_).append('/').append(p_230095_3_.field_230108_b_).append(" average: ").append(p_230095_3_.field_230107_a_ / (long)p_230095_4_).append('/').append(p_230095_3_.field_230108_b_ / (long)p_230095_4_).append('\n');
        p_230095_3_.field_230109_c_.entrySet().stream().sorted(field_230092_d_).forEach(p_230094_4_ -> this.func_230095_a_(p_230095_1_ + 1, (String)p_230094_4_.getKey(), (Section)p_230094_4_.getValue(), p_230095_4_, p_230095_5_));
    }

    private void func_230102_a_(Map<String, Section> p_230102_1_, StringBuilder p_230102_2_, int p_230102_3_) {
        p_230102_1_.forEach((p_230099_3_, p_230099_4_) -> {
            p_230102_2_.append("-- Counter: ").append((String)p_230099_3_).append(" --\n");
            this.func_230095_a_(0, "root", (Section)((Section)p_230099_4_).field_230109_c_.get("root"), p_230102_3_, p_230102_2_);
            p_230102_2_.append("\n\n");
        });
    }

    private static String func_219927_h() {
        String[] astring = new String[]{"Shiny numbers!", "Am I not running fast enough? :(", "I'm working as hard as I can!", "Will I ever be good enough for you? :(", "Speedy. Zoooooom!", "Hello world", "40% better than a crash report.", "Now with extra numbers", "Now with less numbers", "Now with the same numbers", "You should add flames to things, it makes them go faster!", "Do you feel the need for... optimization?", "*cracks redstone whip*", "Maybe if you treated it better then it'll have more motivation to work faster! Poor server."};
        try {
            return astring[(int)(Util.func_211178_c() % (long)astring.length)];
        }
        catch (Throwable throwable) {
            return "Witty comment unavailable :(";
        }
    }

    public int func_219925_g() {
        return this.field_223509_h;
    }

    static class Section {
        private long field_230107_a_;
        private long field_230108_b_;
        private final Map<String, Section> field_230109_c_ = Maps.newHashMap();

        private Section() {
        }

        public void func_230112_a_(Iterator<String> p_230112_1_, long p_230112_2_) {
            this.field_230108_b_ += p_230112_2_;
            if (!p_230112_1_.hasNext()) {
                this.field_230107_a_ += p_230112_2_;
            } else {
                this.field_230109_c_.computeIfAbsent(p_230112_1_.next(), p_230111_0_ -> new Section()).func_230112_a_(p_230112_1_, p_230112_2_);
            }
        }
    }
}

