/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.resources;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mohistmc.util.i18n.i18n;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nullable;
import net.minecraft.resources.IResourcePack;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.resources.data.IMetadataSectionSerializer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class ResourcePack
implements IResourcePack {
    private static final Logger field_195772_b = LogManager.getLogger();
    public final File field_195771_a;

    public ResourcePack(File p_i1287_1_) {
        this.field_195771_a = p_i1287_1_;
    }

    private static String func_195765_c(ResourcePackType p_195765_0_, ResourceLocation p_195765_1_) {
        return String.format("%s/%s/%s", p_195765_0_.func_198956_a(), p_195765_1_.func_110624_b(), p_195765_1_.func_110623_a());
    }

    protected static String func_195767_a(File p_195767_0_, File p_195767_1_) {
        return p_195767_0_.toURI().relativize(p_195767_1_.toURI()).getPath();
    }

    @Override
    public InputStream func_195761_a(ResourcePackType p_195761_1_, ResourceLocation p_195761_2_) throws IOException {
        return this.func_195766_a(ResourcePack.func_195765_c(p_195761_1_, p_195761_2_));
    }

    @Override
    public boolean func_195764_b(ResourcePackType p_195764_1_, ResourceLocation p_195764_2_) {
        return this.func_195768_c(ResourcePack.func_195765_c(p_195764_1_, p_195764_2_));
    }

    protected abstract InputStream func_195766_a(String var1) throws IOException;

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public InputStream func_195763_b(String p_195763_1_) throws IOException {
        if (!p_195763_1_.contains("/") && !p_195763_1_.contains("\\")) {
            return this.func_195766_a(p_195763_1_);
        }
        throw new IllegalArgumentException("Root resources can only be filenames, not paths (no / allowed!)");
    }

    protected abstract boolean func_195768_c(String var1);

    protected void func_195769_d(String p_195769_1_) {
        field_195772_b.warn(i18n.get((String)"resourcepack.1", (Object[])new Object[]{p_195769_1_, this.field_195771_a}));
    }

    @Override
    @Nullable
    public <T> T func_195760_a(IMetadataSectionSerializer<T> p_195760_1_) throws IOException {
        T object;
        try (InputStream inputstream = this.func_195766_a("pack.mcmeta");){
            object = ResourcePack.func_195770_a(p_195760_1_, inputstream);
        }
        return object;
    }

    @Nullable
    public static <T> T func_195770_a(IMetadataSectionSerializer<T> p_195770_0_, InputStream p_195770_1_) {
        JsonObject jsonobject;
        try (BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(p_195770_1_, StandardCharsets.UTF_8));){
            jsonobject = JSONUtils.func_212743_a((Reader)bufferedreader);
        }
        catch (JsonParseException | IOException ioexception) {
            field_195772_b.error(i18n.get((String)"resourcepack.2", (Object[])new Object[]{p_195770_0_.func_110483_a(), ioexception}));
            return null;
        }
        if (!jsonobject.has(p_195770_0_.func_110483_a())) {
            return null;
        }
        try {
            return (T)p_195770_0_.func_195812_a(JSONUtils.func_152754_s((JsonObject)jsonobject, (String)p_195770_0_.func_110483_a()));
        }
        catch (JsonParseException jsonparseexception) {
            field_195772_b.error(i18n.get((String)"resourcepack.3", (Object[])new Object[]{p_195770_0_.func_110483_a(), jsonparseexception}));
            return null;
        }
    }

    @Override
    public String func_195762_a() {
        return this.field_195771_a.getName();
    }
}

