/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.management;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mohistmc.util.i18n.i18n;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;
import javax.annotation.Nullable;
import net.minecraft.server.management.UserListEntry;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.Util;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bukkit.Bukkit;

public abstract class UserList<K, V extends UserListEntry<K>> {
    protected static final Logger field_152693_a = LogManager.getLogger();
    private static final Gson field_232645_b_ = new GsonBuilder().setPrettyPrinting().create();
    private final File field_152695_c;
    private final Map<String, V> field_152696_d = Maps.newHashMap();

    public UserList(File p_i1144_1_) {
        this.field_152695_c = p_i1144_1_;
    }

    public File func_152691_c() {
        return this.field_152695_c;
    }

    public void func_152687_a(V p_152687_1_) {
        this.field_152696_d.put(this.func_152681_a(((UserListEntry)p_152687_1_).func_152640_f()), p_152687_1_);
        try {
            this.func_152678_f();
        }
        catch (IOException ioexception) {
            field_152693_a.warn(i18n.get((String)"userlist.1", (Object[])new Object[]{ioexception}));
        }
    }

    @Nullable
    public V func_152683_b(K p_152683_1_) {
        this.func_152680_h();
        return (V)((UserListEntry)this.field_152696_d.get(this.func_152681_a(p_152683_1_)));
    }

    public void func_152684_c(K p_152684_1_) {
        this.field_152696_d.remove(this.func_152681_a(p_152684_1_));
        try {
            this.func_152678_f();
        }
        catch (IOException ioexception) {
            field_152693_a.warn(i18n.get((String)"userlist.2", (Object[])new Object[]{ioexception}));
        }
    }

    public void func_199042_b(UserListEntry<K> p_199042_1_) {
        this.func_152684_c(p_199042_1_.func_152640_f());
    }

    public String[] func_152685_a() {
        return this.field_152696_d.keySet().toArray(new String[this.field_152696_d.size()]);
    }

    public Collection<V> getValues() {
        return this.field_152696_d.values();
    }

    public boolean func_152690_d() {
        return this.field_152696_d.size() < 1;
    }

    protected String func_152681_a(K p_152681_1_) {
        return p_152681_1_.toString();
    }

    protected boolean func_152692_d(K p_152692_1_) {
        return this.field_152696_d.containsKey(this.func_152681_a(p_152692_1_));
    }

    private void func_152680_h() {
        ArrayList list = Lists.newArrayList();
        for (UserListEntry v : this.field_152696_d.values()) {
            if (!v.func_73682_e()) continue;
            list.add(v.func_152640_f());
        }
        for (Object k : list) {
            this.field_152696_d.remove(this.func_152681_a(k));
        }
    }

    protected abstract UserListEntry<K> func_152682_a(JsonObject var1);

    public Collection<V> func_199043_f() {
        return this.field_152696_d.values();
    }

    public void func_152678_f() throws IOException {
        JsonArray jsonarray = new JsonArray();
        this.field_152696_d.values().stream().map(p_232646_0_ -> Util.func_200696_a(new JsonObject(), p_232646_0_::func_152641_a)).forEach(arg_0 -> ((JsonArray)jsonarray).add(arg_0));
        try (BufferedWriter bufferedwriter = Files.newWriter((File)this.field_152695_c, (Charset)StandardCharsets.UTF_8);){
            field_232645_b_.toJson((JsonElement)jsonarray, (Appendable)bufferedwriter);
        }
    }

    public void func_152679_g() throws IOException {
        if (this.field_152695_c.exists()) {
            try (BufferedReader bufferedreader = Files.newReader((File)this.field_152695_c, (Charset)StandardCharsets.UTF_8);){
                JsonArray jsonarray = (JsonArray)field_232645_b_.fromJson((Reader)bufferedreader, JsonArray.class);
                this.field_152696_d.clear();
                for (JsonElement jsonelement : jsonarray) {
                    JsonObject jsonobject = JSONUtils.func_151210_l((JsonElement)jsonelement, (String)"entry");
                    UserListEntry<K> userlistentry = this.func_152682_a(jsonobject);
                    if (userlistentry.func_152640_f() == null) continue;
                    this.field_152696_d.put(this.func_152681_a(userlistentry.func_152640_f()), userlistentry);
                }
            }
            catch (JsonParseException | NullPointerException ex) {
                Bukkit.getLogger().log(Level.WARNING, "Unable to read file " + this.field_152695_c + ", backing it up to {0}.backup and creating new copy.", ex);
                File backup = new File(this.field_152695_c + ".backup");
                this.field_152695_c.renameTo(backup);
                this.field_152695_c.delete();
            }
        }
    }
}

