/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.stats;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.mohistmc.util.i18n.i18n;
import com.mojang.datafixers.DataFixer;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SStatisticsPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatType;
import net.minecraft.stats.StatisticsManager;
import net.minecraft.stats.Stats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.Util;
import net.minecraft.util.datafix.DefaultTypeReferences;
import net.minecraft.util.registry.Registry;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spigotmc.SpigotConfig;

public class ServerStatisticsManager
extends StatisticsManager {
    private static final Logger field_150889_b = LogManager.getLogger();
    private final MinecraftServer field_150890_c;
    private final File field_150887_d;
    private final Set<Stat<?>> field_150888_e = Sets.newHashSet();
    private int field_150885_f = -300;

    public ServerStatisticsManager(MinecraftServer p_i45306_1_, File p_i45306_2_) {
        this.field_150890_c = p_i45306_1_;
        this.field_150887_d = p_i45306_2_;
        for (Map.Entry entry : SpigotConfig.forcedStats.entrySet()) {
            Stat<ResourceLocation> wrapper = Stats.field_199092_j.func_199076_b((ResourceLocation)entry.getKey());
            this.field_150875_a.put(wrapper, ((Integer)entry.getValue()).intValue());
        }
        if (p_i45306_2_.isFile()) {
            try {
                this.func_199062_a(p_i45306_1_.func_195563_aC(), FileUtils.readFileToString((File)p_i45306_2_));
            }
            catch (IOException ioexception) {
                field_150889_b.error(i18n.get((String)"serverstatisticsmanager.1", (Object[])new Object[]{p_i45306_2_}), (Throwable)ioexception);
            }
            catch (JsonParseException jsonparseexception) {
                field_150889_b.error(i18n.get((String)"serverstatisticsmanager.2", (Object[])new Object[]{p_i45306_2_}), (Throwable)jsonparseexception);
            }
        }
    }

    public void func_150883_b() {
        if (SpigotConfig.disableStatSaving) {
            return;
        }
        try {
            FileUtils.writeStringToFile((File)this.field_150887_d, (String)this.func_199061_b());
        }
        catch (IOException ioexception) {
            field_150889_b.error(i18n.get((String)"serverstatisticsmanager.3"), (Throwable)ioexception);
        }
    }

    @Override
    public void func_150873_a(PlayerEntity p_150873_1_, Stat<?> p_150873_2_, int p_150873_3_) {
        if (SpigotConfig.disableStatSaving) {
            return;
        }
        super.func_150873_a(p_150873_1_, p_150873_2_, p_150873_3_);
        this.field_150888_e.add(p_150873_2_);
    }

    private Set<Stat<?>> func_150878_c() {
        HashSet set = Sets.newHashSet(this.field_150888_e);
        this.field_150888_e.clear();
        return set;
    }

    public void func_199062_a(DataFixer p_199062_1_, String p_199062_2_) {
        try (JsonReader jsonreader = new JsonReader((Reader)new StringReader(p_199062_2_));){
            jsonreader.setLenient(false);
            JsonElement jsonelement = Streams.parse((JsonReader)jsonreader);
            if (jsonelement.isJsonNull()) {
                field_150889_b.error(i18n.get((String)"serverstatisticsmanager.4", (Object[])new Object[]{this.field_150887_d}));
                return;
            }
            CompoundNBT compoundnbt = ServerStatisticsManager.func_199065_a(jsonelement.getAsJsonObject());
            if (!compoundnbt.func_150297_b("DataVersion", 99)) {
                compoundnbt.func_74768_a("DataVersion", 1343);
            }
            if ((compoundnbt = NBTUtil.func_210822_a(p_199062_1_, DefaultTypeReferences.STATS, compoundnbt, compoundnbt.func_74762_e("DataVersion"))).func_150297_b("stats", 10)) {
                CompoundNBT compoundnbt1 = compoundnbt.func_74775_l("stats");
                for (String s : compoundnbt1.func_150296_c()) {
                    if (!compoundnbt1.func_150297_b(s, 10)) continue;
                    Util.func_215077_a(Registry.field_212634_w.func_241873_b(new ResourceLocation(s)), p_219731_3_ -> {
                        CompoundNBT compoundnbt2 = compoundnbt1.func_74775_l(s);
                        for (String s1 : compoundnbt2.func_150296_c()) {
                            if (compoundnbt2.func_150297_b(s1, 99)) {
                                Util.func_215077_a(this.func_219728_a((StatType)p_219731_3_, s1), p_219730_3_ -> this.field_150875_a.put(p_219730_3_, compoundnbt2.func_74762_e(s1)), () -> field_150889_b.warn(i18n.get((String)"serverstatisticsmanager.5", (Object[])new Object[]{this.field_150887_d, s1})));
                                continue;
                            }
                            field_150889_b.warn(i18n.get((String)"serverstatisticsmanager.6", (Object[])new Object[]{this.field_150887_d, compoundnbt2.func_74781_a(s1), s1}));
                        }
                    }, () -> field_150889_b.warn(i18n.get((String)"serverstatisticsmanager.7", (Object[])new Object[]{this.field_150887_d, s})));
                }
            }
        }
        catch (JsonParseException | IOException jsonparseexception) {
            field_150889_b.error(i18n.get((String)"serverstatisticsmanager.8", (Object[])new Object[]{this.field_150887_d, jsonparseexception}));
        }
    }

    private <T> Optional<Stat<T>> func_219728_a(StatType<T> p_219728_1_, String p_219728_2_) {
        return Optional.ofNullable(ResourceLocation.func_208304_a(p_219728_2_)).flatMap(p_219728_1_.func_199080_a()::func_241873_b).map(p_219728_1_::func_199076_b);
    }

    private static CompoundNBT func_199065_a(JsonObject p_199065_0_) {
        CompoundNBT compoundnbt = new CompoundNBT();
        for (Map.Entry entry : p_199065_0_.entrySet()) {
            JsonPrimitive jsonprimitive;
            JsonElement jsonelement = (JsonElement)entry.getValue();
            if (jsonelement.isJsonObject()) {
                compoundnbt.func_218657_a((String)entry.getKey(), ServerStatisticsManager.func_199065_a(jsonelement.getAsJsonObject()));
                continue;
            }
            if (!jsonelement.isJsonPrimitive() || !(jsonprimitive = jsonelement.getAsJsonPrimitive()).isNumber()) continue;
            compoundnbt.func_74768_a((String)entry.getKey(), jsonprimitive.getAsInt());
        }
        return compoundnbt;
    }

    protected String func_199061_b() {
        HashMap map = Maps.newHashMap();
        for (Object entry : this.field_150875_a.object2IntEntrySet()) {
            Stat stat = (Stat)entry.getKey();
            map.computeIfAbsent(stat.func_197921_a(), p_199064_0_ -> new JsonObject()).addProperty(ServerStatisticsManager.func_199066_b(stat).toString(), (Number)entry.getIntValue());
        }
        JsonObject jsonobject = new JsonObject();
        for (Map.Entry entry : map.entrySet()) {
            jsonobject.add(Registry.field_212634_w.func_177774_c((StatType)entry.getKey()).toString(), (JsonElement)entry.getValue());
        }
        JsonObject jsonobject1 = new JsonObject();
        jsonobject1.add("stats", (JsonElement)jsonobject);
        jsonobject1.addProperty("DataVersion", (Number)SharedConstants.func_215069_a().getWorldVersion());
        return jsonobject1.toString();
    }

    private static <T> ResourceLocation func_199066_b(Stat<T> p_199066_0_) {
        return p_199066_0_.func_197921_a().func_199080_a().func_177774_c(p_199066_0_.func_197920_b());
    }

    public void func_150877_d() {
        this.field_150888_e.addAll((Collection<Stat<?>>)this.field_150875_a.keySet());
    }

    public void func_150876_a(ServerPlayerEntity p_150876_1_) {
        int i = this.field_150890_c.func_71259_af();
        Object2IntOpenHashMap object2intmap = new Object2IntOpenHashMap();
        if (i - this.field_150885_f > 300) {
            this.field_150885_f = i;
            for (Stat<?> stat : this.func_150878_c()) {
                object2intmap.put(stat, this.func_77444_a(stat));
            }
        }
        p_150876_1_.field_71135_a.func_147359_a((IPacket<?>)new SStatisticsPacket((Object2IntMap)object2intmap));
    }
}

