/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tileentity;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ChestBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.DoubleSidedInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.ChestContainer;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.properties.ChestType;
import net.minecraft.tileentity.IChestLid;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.LockableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.bukkit.craftbukkit.v1_16_R3.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_16_R3.event.CraftEventFactory;
import org.bukkit.entity.HumanEntity;

@OnlyIn(value=Dist.CLIENT, _interface=IChestLid.class)
public class ChestTileEntity
extends LockableLootTileEntity
implements IChestLid,
ITickableTileEntity {
    private NonNullList<ItemStack> field_145985_p = NonNullList.func_191197_a(27, ItemStack.field_190927_a);
    protected float field_145989_m;
    protected float field_145986_n;
    public int field_145987_o;
    private int field_145983_q;
    private LazyOptional<IItemHandlerModifiable> chestHandler;
    public List<HumanEntity> transaction = new ArrayList<HumanEntity>();
    private int maxStack = 64;
    public boolean opened;

    protected ChestTileEntity(TileEntityType<?> p_i48287_1_) {
        super(p_i48287_1_);
    }

    public ChestTileEntity() {
        this(TileEntityType.field_200972_c);
    }

    @Override
    public int func_70302_i_() {
        return 27;
    }

    @Override
    public List<ItemStack> getContents() {
        return this.field_145985_p;
    }

    @Override
    public void onOpen(CraftHumanEntity who) {
        this.transaction.add((HumanEntity)who);
    }

    @Override
    public void onClose(CraftHumanEntity who) {
        this.transaction.remove(who);
    }

    @Override
    public List<HumanEntity> getViewers() {
        return this.transaction;
    }

    @Override
    public void setMaxStackSize(int size) {
        this.maxStack = size;
    }

    @Override
    public int func_70297_j_() {
        return this.maxStack;
    }

    @Override
    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("container.chest");
    }

    @Override
    public void func_230337_a_(BlockState p_230337_1_, CompoundNBT p_230337_2_) {
        super.func_230337_a_(p_230337_1_, p_230337_2_);
        this.field_145985_p = NonNullList.func_191197_a(this.func_70302_i_(), ItemStack.field_190927_a);
        if (!this.func_184283_b(p_230337_2_)) {
            ItemStackHelper.func_191283_b((CompoundNBT)p_230337_2_, this.field_145985_p);
        }
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT p_189515_1_) {
        super.func_189515_b(p_189515_1_);
        if (!this.func_184282_c(p_189515_1_)) {
            ItemStackHelper.func_191282_a((CompoundNBT)p_189515_1_, this.field_145985_p);
        }
        return p_189515_1_;
    }

    public void func_73660_a() {
        int i = this.field_174879_c.func_177958_n();
        int j = this.field_174879_c.func_177956_o();
        int k = this.field_174879_c.func_177952_p();
        ++this.field_145983_q;
        this.field_145987_o = ChestTileEntity.func_213977_a(this.field_145850_b, this, this.field_145983_q, i, j, k, this.field_145987_o);
        this.field_145986_n = this.field_145989_m;
        float f = 0.1f;
        if (this.opened) {
            --this.field_145987_o;
            return;
        }
        if (this.field_145987_o > 0 && this.field_145989_m == 0.0f) {
            this.func_195483_a(SoundEvents.field_187657_V);
        }
        if (this.field_145987_o == 0 && this.field_145989_m > 0.0f || this.field_145987_o > 0 && this.field_145989_m < 1.0f) {
            float f1 = this.field_145989_m;
            this.field_145989_m = this.field_145987_o > 0 ? (this.field_145989_m += 0.1f) : (this.field_145989_m -= 0.1f);
            if (this.field_145989_m > 1.0f) {
                this.field_145989_m = 1.0f;
            }
            float f2 = 0.5f;
            if (this.field_145989_m < 0.5f && f1 >= 0.5f) {
                this.func_195483_a(SoundEvents.field_187651_T);
            }
            if (this.field_145989_m < 0.0f) {
                this.field_145989_m = 0.0f;
            }
        }
    }

    public static int func_213977_a(World p_213977_0_, LockableTileEntity p_213977_1_, int p_213977_2_, int p_213977_3_, int p_213977_4_, int p_213977_5_, int p_213977_6_) {
        if (!p_213977_0_.field_72995_K && p_213977_6_ != 0 && (p_213977_2_ + p_213977_3_ + p_213977_4_ + p_213977_5_) % 200 == 0) {
            p_213977_6_ = ChestTileEntity.func_213976_a(p_213977_0_, p_213977_1_, p_213977_3_, p_213977_4_, p_213977_5_);
        }
        return p_213977_6_;
    }

    public static int func_213976_a(World p_213976_0_, LockableTileEntity p_213976_1_, int p_213976_2_, int p_213976_3_, int p_213976_4_) {
        int i = 0;
        float f = 5.0f;
        for (PlayerEntity playerentity : p_213976_0_.func_217357_a(PlayerEntity.class, new AxisAlignedBB((float)p_213976_2_ - 5.0f, (float)p_213976_3_ - 5.0f, (float)p_213976_4_ - 5.0f, (float)(p_213976_2_ + 1) + 5.0f, (float)(p_213976_3_ + 1) + 5.0f, (float)(p_213976_4_ + 1) + 5.0f))) {
            IInventory iinventory;
            if (!(playerentity.field_71070_bA instanceof ChestContainer) || (iinventory = ((ChestContainer)playerentity.field_71070_bA).func_85151_d()) != p_213976_1_ && (!(iinventory instanceof DoubleSidedInventory) || !((DoubleSidedInventory)iinventory).func_90010_a(p_213976_1_))) continue;
            ++i;
        }
        return i;
    }

    public void func_195483_a(SoundEvent p_195483_1_) {
        ChestType chesttype = this.func_195044_w().func_177229_b(ChestBlock.field_196314_b);
        if (chesttype != ChestType.LEFT) {
            double d0 = (double)this.field_174879_c.func_177958_n() + 0.5;
            double d1 = (double)this.field_174879_c.func_177956_o() + 0.5;
            double d2 = (double)this.field_174879_c.func_177952_p() + 0.5;
            if (chesttype == ChestType.RIGHT) {
                Direction direction = ChestBlock.func_196311_i(this.func_195044_w());
                d0 += (double)direction.func_82601_c() * 0.5;
                d2 += (double)direction.func_82599_e() * 0.5;
            }
            this.field_145850_b.func_184148_a(null, d0, d1, d2, p_195483_1_, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
    }

    @Override
    public boolean func_145842_c(int p_145842_1_, int p_145842_2_) {
        if (p_145842_1_ == 1) {
            this.field_145987_o = p_145842_2_;
            return true;
        }
        return super.func_145842_c(p_145842_1_, p_145842_2_);
    }

    @Override
    public void func_174889_b(PlayerEntity p_174889_1_) {
        if (!p_174889_1_.func_175149_v()) {
            int newPower;
            if (this.field_145987_o < 0) {
                this.field_145987_o = 0;
            }
            int oldPower = Math.max(0, Math.min(15, this.field_145987_o));
            ++this.field_145987_o;
            if (this.field_145850_b == null) {
                return;
            }
            if (this.func_195044_w().func_177230_c() == Blocks.field_150447_bR && oldPower != (newPower = Math.max(0, Math.min(15, this.field_145987_o)))) {
                CraftEventFactory.callRedstoneChange((World)this.field_145850_b, (BlockPos)this.field_174879_c, (int)oldPower, (int)newPower);
            }
            this.func_195482_p();
        }
    }

    @Override
    public void func_174886_c(PlayerEntity p_174886_1_) {
        if (!p_174886_1_.func_175149_v()) {
            int newPower;
            int oldPower = Math.max(0, Math.min(15, this.field_145987_o));
            --this.field_145987_o;
            if (this.func_195044_w().func_177230_c() == Blocks.field_150447_bR && oldPower != (newPower = Math.max(0, Math.min(15, this.field_145987_o)))) {
                CraftEventFactory.callRedstoneChange((World)this.field_145850_b, (BlockPos)this.field_174879_c, (int)oldPower, (int)newPower);
            }
            this.func_195482_p();
        }
    }

    protected void func_195482_p() {
        Block block = this.func_195044_w().func_177230_c();
        if (block instanceof ChestBlock) {
            if (!this.opened) {
                this.field_145850_b.func_175641_c(this.field_174879_c, block, 1, this.field_145987_o);
            }
            this.field_145850_b.func_195593_d(this.field_174879_c, block);
        }
    }

    @Override
    protected NonNullList<ItemStack> func_190576_q() {
        return this.field_145985_p;
    }

    @Override
    protected void func_199721_a(NonNullList<ItemStack> p_199721_1_) {
        this.field_145985_p = p_199721_1_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_195480_a(float p_195480_1_) {
        return MathHelper.func_219799_g((float)p_195480_1_, (float)this.field_145986_n, (float)this.field_145989_m);
    }

    public static int func_195481_a(IBlockReader p_195481_0_, BlockPos p_195481_1_) {
        TileEntity tileentity;
        BlockState blockstate = p_195481_0_.func_180495_p(p_195481_1_);
        if (blockstate.hasTileEntity() && (tileentity = p_195481_0_.func_175625_s(p_195481_1_)) instanceof ChestTileEntity) {
            return ((ChestTileEntity)tileentity).field_145987_o;
        }
        return 0;
    }

    public static void func_199722_a(ChestTileEntity p_199722_0_, ChestTileEntity p_199722_1_) {
        NonNullList<ItemStack> nonnulllist = p_199722_0_.func_190576_q();
        p_199722_0_.func_199721_a(p_199722_1_.func_190576_q());
        p_199722_1_.func_199721_a(nonnulllist);
    }

    @Override
    protected Container func_213906_a(int p_213906_1_, PlayerInventory p_213906_2_) {
        return ChestContainer.func_216992_a(p_213906_1_, p_213906_2_, this);
    }

    @Override
    public void func_145836_u() {
        super.func_145836_u();
        if (this.chestHandler != null) {
            LazyOptional<IItemHandlerModifiable> oldHandler = this.chestHandler;
            this.chestHandler = null;
            oldHandler.invalidate();
        }
    }

    @Override
    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (!this.field_145846_f && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this.chestHandler == null) {
                this.chestHandler = LazyOptional.of(this::createHandler);
            }
            return this.chestHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    private IItemHandlerModifiable createHandler() {
        BlockState state = this.func_195044_w();
        if (!(state.func_177230_c() instanceof ChestBlock)) {
            return new InvWrapper((IInventory)this);
        }
        IInventory inv = ChestBlock.func_226916_a_((ChestBlock)((Object)state.func_177230_c()), state, this.func_145831_w(), this.func_174877_v(), true);
        return new InvWrapper(inv == null ? this : inv);
    }

    @Override
    protected void invalidateCaps() {
        super.invalidateCaps();
        if (this.chestHandler != null) {
            this.chestHandler.invalidate();
        }
    }
}

