/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mohistmc.util.i18n.i18n;
import com.mojang.bridge.game.GameVersion;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.UUID;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.SharedConstants;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MinecraftVersion
implements GameVersion {
    private static final Logger field_214958_a = LogManager.getLogger();
    public static final GameVersion field_240808_a_ = new MinecraftVersion();
    private final String field_214959_b;
    private final String field_214960_c;
    private final boolean field_214961_d;
    private final int field_214962_e;
    private final int field_214963_f;
    private final int field_214964_g;
    private final Date field_214965_h;
    private final String field_214966_i;

    private MinecraftVersion() {
        this.field_214959_b = UUID.randomUUID().toString().replaceAll("-", "");
        this.field_214960_c = "1.16.5";
        this.field_214961_d = true;
        this.field_214962_e = 2586;
        this.field_214963_f = SharedConstants.func_244709_b();
        this.field_214964_g = 6;
        this.field_214965_h = new Date();
        this.field_214966_i = "1.16.5";
    }

    private MinecraftVersion(JsonObject p_i51407_1_) {
        this.field_214959_b = JSONUtils.func_151200_h((JsonObject)p_i51407_1_, (String)"id");
        this.field_214960_c = JSONUtils.func_151200_h((JsonObject)p_i51407_1_, (String)"name");
        this.field_214966_i = JSONUtils.func_151200_h((JsonObject)p_i51407_1_, (String)"release_target");
        this.field_214961_d = JSONUtils.func_151212_i((JsonObject)p_i51407_1_, (String)"stable");
        this.field_214962_e = JSONUtils.func_151203_m((JsonObject)p_i51407_1_, (String)"world_version");
        this.field_214963_f = JSONUtils.func_151203_m((JsonObject)p_i51407_1_, (String)"protocol_version");
        this.field_214964_g = JSONUtils.func_151203_m((JsonObject)p_i51407_1_, (String)"pack_version");
        this.field_214965_h = Date.from(ZonedDateTime.parse(JSONUtils.func_151200_h((JsonObject)p_i51407_1_, (String)"build_time")).toInstant());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static GameVersion func_214957_a() {
        try (InputStream inputstream = MinecraftVersion.class.getResourceAsStream("/version.json");){
            MinecraftVersion minecraftversion;
            if (inputstream == null) {
                field_214958_a.warn(i18n.get((String)"minecraftversion.1"));
                GameVersion gameVersion = field_240808_a_;
                return gameVersion;
            }
            try (InputStreamReader inputstreamreader = new InputStreamReader(inputstream);){
                minecraftversion = new MinecraftVersion(JSONUtils.func_212743_a((Reader)inputstreamreader));
            }
            MinecraftVersion minecraftVersion = minecraftversion;
            return minecraftVersion;
        }
        catch (JsonParseException | IOException ioexception) {
            throw new IllegalStateException("Game version information is corrupt", ioexception);
        }
    }

    public String getId() {
        return this.field_214959_b;
    }

    public String getName() {
        return this.field_214960_c;
    }

    public String getReleaseTarget() {
        return this.field_214966_i;
    }

    public int getWorldVersion() {
        return this.field_214962_e;
    }

    public int getProtocolVersion() {
        return this.field_214963_f;
    }

    public int getPackVersion() {
        return this.field_214964_g;
    }

    public Date getBuildTime() {
        return this.field_214965_h;
    }

    public boolean isStable() {
        return this.field_214961_d;
    }
}

