/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.DataFixerBuilder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.UnaryOperator;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.Util;
import net.minecraft.util.datafix.NamespacedSchema;
import net.minecraft.util.datafix.TypeReferences;
import net.minecraft.util.datafix.WriteAndReadDataFix;
import net.minecraft.util.datafix.fixes.AddBedTileEntity;
import net.minecraft.util.datafix.fixes.AddNewChoices;
import net.minecraft.util.datafix.fixes.AdvancementRenamer;
import net.minecraft.util.datafix.fixes.AdvancementRenamer1501;
import net.minecraft.util.datafix.fixes.ArmorStandSilent;
import net.minecraft.util.datafix.fixes.AttributesFix;
import net.minecraft.util.datafix.fixes.BannerItemColor;
import net.minecraft.util.datafix.fixes.BedItemColor;
import net.minecraft.util.datafix.fixes.BiomeIdFix;
import net.minecraft.util.datafix.fixes.BiomeName;
import net.minecraft.util.datafix.fixes.BiomeRenames;
import net.minecraft.util.datafix.fixes.BitStorageAlignFix;
import net.minecraft.util.datafix.fixes.BlockEntityBannerColor;
import net.minecraft.util.datafix.fixes.BlockEntityKeepPacked;
import net.minecraft.util.datafix.fixes.BlockEntityUUID;
import net.minecraft.util.datafix.fixes.BlockNameFlattening;
import net.minecraft.util.datafix.fixes.BlockRename;
import net.minecraft.util.datafix.fixes.BlockStateFlattenGenOptions;
import net.minecraft.util.datafix.fixes.BlockStateFlattenStructures;
import net.minecraft.util.datafix.fixes.BlockStateFlattenVillageCrops;
import net.minecraft.util.datafix.fixes.BlockStateFlatternEntities;
import net.minecraft.util.datafix.fixes.BookPagesStrictJSON;
import net.minecraft.util.datafix.fixes.CatTypeFix;
import net.minecraft.util.datafix.fixes.ChunkGenStatus;
import net.minecraft.util.datafix.fixes.ChunkLightRemoveFix;
import net.minecraft.util.datafix.fixes.ChunkPaletteFormat;
import net.minecraft.util.datafix.fixes.ChunkStatusFix;
import net.minecraft.util.datafix.fixes.ChunkStatusFix2;
import net.minecraft.util.datafix.fixes.ChunkStructuresTemplateRenameFix;
import net.minecraft.util.datafix.fixes.ColorlessShulkerEntityFix;
import net.minecraft.util.datafix.fixes.CoralFansRenameList;
import net.minecraft.util.datafix.fixes.CustomNameStringToComponentEntity;
import net.minecraft.util.datafix.fixes.CustomNameStringToComponentFixTileEntity;
import net.minecraft.util.datafix.fixes.CustomNameStringToComponentItem;
import net.minecraft.util.datafix.fixes.DyeRenameMap;
import net.minecraft.util.datafix.fixes.ElderGuardianSplit;
import net.minecraft.util.datafix.fixes.EntityArmorAndHeld;
import net.minecraft.util.datafix.fixes.EntityCatSplitFix;
import net.minecraft.util.datafix.fixes.EntityCodSalmonFix;
import net.minecraft.util.datafix.fixes.EntityHealth;
import net.minecraft.util.datafix.fixes.EntityId;
import net.minecraft.util.datafix.fixes.EntityItemFrameFacing;
import net.minecraft.util.datafix.fixes.EntityRavagerRenameFix;
import net.minecraft.util.datafix.fixes.EntityRenaming1510;
import net.minecraft.util.datafix.fixes.EntityUUID;
import net.minecraft.util.datafix.fixes.ForceVBOOn;
import net.minecraft.util.datafix.fixes.FurnaceRecipes;
import net.minecraft.util.datafix.fixes.Gossip;
import net.minecraft.util.datafix.fixes.HeightmapRenamingFix;
import net.minecraft.util.datafix.fixes.HorseSaddle;
import net.minecraft.util.datafix.fixes.HorseSplit;
import net.minecraft.util.datafix.fixes.IglooMetadataRemoval;
import net.minecraft.util.datafix.fixes.ItemFilledMapMetadata;
import net.minecraft.util.datafix.fixes.ItemIntIDToString;
import net.minecraft.util.datafix.fixes.ItemLoreComponentizeFix;
import net.minecraft.util.datafix.fixes.ItemRename;
import net.minecraft.util.datafix.fixes.ItemSpawnEggSplit;
import net.minecraft.util.datafix.fixes.ItemStackDataFlattening;
import net.minecraft.util.datafix.fixes.ItemStackEnchantmentFix;
import net.minecraft.util.datafix.fixes.ItemStackUUID;
import net.minecraft.util.datafix.fixes.JigsawProperties;
import net.minecraft.util.datafix.fixes.JigsawRotation;
import net.minecraft.util.datafix.fixes.JukeboxRecordItem;
import net.minecraft.util.datafix.fixes.KeyOptionsTranslation;
import net.minecraft.util.datafix.fixes.LWJGL3KeyOptions;
import net.minecraft.util.datafix.fixes.LeavesFix;
import net.minecraft.util.datafix.fixes.LevelDataGeneratorOptionsFix;
import net.minecraft.util.datafix.fixes.LevelUUID;
import net.minecraft.util.datafix.fixes.MapIdFix;
import net.minecraft.util.datafix.fixes.MemoryExpiry;
import net.minecraft.util.datafix.fixes.MinecartEntityTypes;
import net.minecraft.util.datafix.fixes.MissingDimensionFix;
import net.minecraft.util.datafix.fixes.NamedEntityFix;
import net.minecraft.util.datafix.fixes.NewVillageFix;
import net.minecraft.util.datafix.fixes.ObjectiveDisplayName;
import net.minecraft.util.datafix.fixes.ObjectiveRenderType;
import net.minecraft.util.datafix.fixes.OminousBannerRenameFix;
import net.minecraft.util.datafix.fixes.OminousBannerTileEntityRenameFix;
import net.minecraft.util.datafix.fixes.OptionsAddTextBackgroundFix;
import net.minecraft.util.datafix.fixes.OptionsLowerCaseLanguage;
import net.minecraft.util.datafix.fixes.PaintingDirection;
import net.minecraft.util.datafix.fixes.PaintingMotive;
import net.minecraft.util.datafix.fixes.PistonPushedBlock;
import net.minecraft.util.datafix.fixes.PlayerUUID;
import net.minecraft.util.datafix.fixes.PointOfInterestRebuild;
import net.minecraft.util.datafix.fixes.PointOfInterestReorganizationFix;
import net.minecraft.util.datafix.fixes.PotionItems;
import net.minecraft.util.datafix.fixes.PotionWater;
import net.minecraft.util.datafix.fixes.ProjectileOwner;
import net.minecraft.util.datafix.fixes.PufferfishRename;
import net.minecraft.util.datafix.fixes.RecipeRenamer;
import net.minecraft.util.datafix.fixes.RecipeRenamer1502;
import net.minecraft.util.datafix.fixes.RecipeRenamer1510;
import net.minecraft.util.datafix.fixes.RedstoneConnections;
import net.minecraft.util.datafix.fixes.RedundantChanceTags;
import net.minecraft.util.datafix.fixes.RemoveGolemGossip;
import net.minecraft.util.datafix.fixes.RenameBeehivePointOfInterest;
import net.minecraft.util.datafix.fixes.RenamedCoral;
import net.minecraft.util.datafix.fixes.RidingToPassengers;
import net.minecraft.util.datafix.fixes.SavedDataUUID;
import net.minecraft.util.datafix.fixes.ShulkerBoxEntityColor;
import net.minecraft.util.datafix.fixes.ShulkerBoxItemColor;
import net.minecraft.util.datafix.fixes.ShulkerBoxTileColor;
import net.minecraft.util.datafix.fixes.ShulkerRotation;
import net.minecraft.util.datafix.fixes.SignStrictJSON;
import net.minecraft.util.datafix.fixes.SkeletonSplit;
import net.minecraft.util.datafix.fixes.SpawnEggNames;
import net.minecraft.util.datafix.fixes.SpawnerEntityTypes;
import net.minecraft.util.datafix.fixes.StatsRenaming;
import net.minecraft.util.datafix.fixes.StriderGravity;
import net.minecraft.util.datafix.fixes.StringToUUID;
import net.minecraft.util.datafix.fixes.StructureReferenceFix;
import net.minecraft.util.datafix.fixes.SwapHandsFix;
import net.minecraft.util.datafix.fixes.SwimStatsRename;
import net.minecraft.util.datafix.fixes.TeamDisplayName;
import net.minecraft.util.datafix.fixes.TileEntityId;
import net.minecraft.util.datafix.fixes.TippedArrow;
import net.minecraft.util.datafix.fixes.TrappedChestTileEntitySplit;
import net.minecraft.util.datafix.fixes.VillagerFollowRange;
import net.minecraft.util.datafix.fixes.VillagerLevelAndXpFix;
import net.minecraft.util.datafix.fixes.VillagerProfessionFix;
import net.minecraft.util.datafix.fixes.VillagerTrades;
import net.minecraft.util.datafix.fixes.WallProperty;
import net.minecraft.util.datafix.fixes.WolfCollarColor;
import net.minecraft.util.datafix.fixes.WorldGenSettings;
import net.minecraft.util.datafix.fixes.ZombieProfToType;
import net.minecraft.util.datafix.fixes.ZombieSplit;
import net.minecraft.util.datafix.fixes.ZombieVillagerXpFix;
import net.minecraft.util.datafix.fixes.ZombifiedPiglinRename;
import net.minecraft.util.datafix.versions.V0099;
import net.minecraft.util.datafix.versions.V0100;
import net.minecraft.util.datafix.versions.V0102;
import net.minecraft.util.datafix.versions.V0106;
import net.minecraft.util.datafix.versions.V0107;
import net.minecraft.util.datafix.versions.V0135;
import net.minecraft.util.datafix.versions.V0143;
import net.minecraft.util.datafix.versions.V0501;
import net.minecraft.util.datafix.versions.V0700;
import net.minecraft.util.datafix.versions.V0701;
import net.minecraft.util.datafix.versions.V0702;
import net.minecraft.util.datafix.versions.V0703;
import net.minecraft.util.datafix.versions.V0704;
import net.minecraft.util.datafix.versions.V0705;
import net.minecraft.util.datafix.versions.V0808;
import net.minecraft.util.datafix.versions.V1022;
import net.minecraft.util.datafix.versions.V1125;
import net.minecraft.util.datafix.versions.V1451;
import net.minecraft.util.datafix.versions.V1451_1;
import net.minecraft.util.datafix.versions.V1451_2;
import net.minecraft.util.datafix.versions.V1451_3;
import net.minecraft.util.datafix.versions.V1451_4;
import net.minecraft.util.datafix.versions.V1451_5;
import net.minecraft.util.datafix.versions.V1451_6;
import net.minecraft.util.datafix.versions.V1451_7;
import net.minecraft.util.datafix.versions.V1460;
import net.minecraft.util.datafix.versions.V1466;
import net.minecraft.util.datafix.versions.V1470;
import net.minecraft.util.datafix.versions.V1481;
import net.minecraft.util.datafix.versions.V1483;
import net.minecraft.util.datafix.versions.V1486;
import net.minecraft.util.datafix.versions.V1510;
import net.minecraft.util.datafix.versions.V1800;
import net.minecraft.util.datafix.versions.V1801;
import net.minecraft.util.datafix.versions.V1904;
import net.minecraft.util.datafix.versions.V1906;
import net.minecraft.util.datafix.versions.V1909;
import net.minecraft.util.datafix.versions.V1920;
import net.minecraft.util.datafix.versions.V1928;
import net.minecraft.util.datafix.versions.V1929;
import net.minecraft.util.datafix.versions.V1931;
import net.minecraft.util.datafix.versions.V2100;
import net.minecraft.util.datafix.versions.V2501;
import net.minecraft.util.datafix.versions.V2502;
import net.minecraft.util.datafix.versions.V2505;
import net.minecraft.util.datafix.versions.V2509;
import net.minecraft.util.datafix.versions.V2519;
import net.minecraft.util.datafix.versions.V2522;
import net.minecraft.util.datafix.versions.V2551;
import net.minecraft.util.datafix.versions.V2568;

public class DataFixesManager {
    private static final BiFunction<Integer, Schema, Schema> field_207592_e = Schema::new;
    private static final BiFunction<Integer, Schema, Schema> field_207593_f = NamespacedSchema::new;
    private static final DataFixer field_210902_d = DataFixesManager.func_188279_a();

    private static DataFixer func_188279_a() {
        DataFixerBuilder datafixerbuilder = new DataFixerBuilder(SharedConstants.func_215069_a().getWorldVersion());
        DataFixesManager.func_210891_a(datafixerbuilder);
        return datafixerbuilder.build(Util.func_240991_e_());
    }

    public static DataFixer func_210901_a() {
        return field_210902_d;
    }

    private static void func_210891_a(DataFixerBuilder p_210891_0_) {
        Schema schema = p_210891_0_.addSchema(99, V0099::new);
        Schema schema1 = p_210891_0_.addSchema(100, V0100::new);
        p_210891_0_.addFixer((DataFix)new EntityArmorAndHeld(schema1, true));
        Schema schema2 = p_210891_0_.addSchema(101, field_207592_e);
        p_210891_0_.addFixer((DataFix)new SignStrictJSON(schema2, false));
        Schema schema3 = p_210891_0_.addSchema(102, V0102::new);
        p_210891_0_.addFixer((DataFix)new ItemIntIDToString(schema3, true));
        p_210891_0_.addFixer((DataFix)new PotionItems(schema3, false));
        Schema schema4 = p_210891_0_.addSchema(105, field_207592_e);
        p_210891_0_.addFixer((DataFix)new SpawnEggNames(schema4, true));
        Schema schema5 = p_210891_0_.addSchema(106, V0106::new);
        p_210891_0_.addFixer((DataFix)new SpawnerEntityTypes(schema5, true));
        Schema schema6 = p_210891_0_.addSchema(107, V0107::new);
        p_210891_0_.addFixer((DataFix)new MinecartEntityTypes(schema6, true));
        Schema schema7 = p_210891_0_.addSchema(108, field_207592_e);
        p_210891_0_.addFixer((DataFix)new StringToUUID(schema7, true));
        Schema schema8 = p_210891_0_.addSchema(109, field_207592_e);
        p_210891_0_.addFixer((DataFix)new EntityHealth(schema8, true));
        Schema schema9 = p_210891_0_.addSchema(110, field_207592_e);
        p_210891_0_.addFixer((DataFix)new HorseSaddle(schema9, true));
        Schema schema10 = p_210891_0_.addSchema(111, field_207592_e);
        p_210891_0_.addFixer((DataFix)new PaintingDirection(schema10, true));
        Schema schema11 = p_210891_0_.addSchema(113, field_207592_e);
        p_210891_0_.addFixer((DataFix)new RedundantChanceTags(schema11, true));
        Schema schema12 = p_210891_0_.addSchema(135, V0135::new);
        p_210891_0_.addFixer((DataFix)new RidingToPassengers(schema12, true));
        Schema schema13 = p_210891_0_.addSchema(143, V0143::new);
        p_210891_0_.addFixer((DataFix)new TippedArrow(schema13, true));
        Schema schema14 = p_210891_0_.addSchema(147, field_207592_e);
        p_210891_0_.addFixer((DataFix)new ArmorStandSilent(schema14, true));
        Schema schema15 = p_210891_0_.addSchema(165, field_207592_e);
        p_210891_0_.addFixer((DataFix)new BookPagesStrictJSON(schema15, true));
        Schema schema16 = p_210891_0_.addSchema(501, V0501::new);
        p_210891_0_.addFixer((DataFix)new AddNewChoices(schema16, "Add 1.10 entities fix", TypeReferences.field_211299_o));
        Schema schema17 = p_210891_0_.addSchema(502, field_207592_e);
        p_210891_0_.addFixer(ItemRename.func_207476_a((Schema)schema17, (String)"cooked_fished item renamer", p_207111_0_ -> Objects.equals(NamespacedSchema.func_206477_f((String)p_207111_0_), "minecraft:cooked_fished") ? "minecraft:cooked_fish" : p_207111_0_));
        p_210891_0_.addFixer((DataFix)new ZombieProfToType(schema17, false));
        Schema schema18 = p_210891_0_.addSchema(505, field_207592_e);
        p_210891_0_.addFixer((DataFix)new ForceVBOOn(schema18, false));
        Schema schema19 = p_210891_0_.addSchema(700, V0700::new);
        p_210891_0_.addFixer((DataFix)new ElderGuardianSplit(schema19, true));
        Schema schema20 = p_210891_0_.addSchema(701, V0701::new);
        p_210891_0_.addFixer((DataFix)new SkeletonSplit(schema20, true));
        Schema schema21 = p_210891_0_.addSchema(702, V0702::new);
        p_210891_0_.addFixer((DataFix)new ZombieSplit(schema21, true));
        Schema schema22 = p_210891_0_.addSchema(703, V0703::new);
        p_210891_0_.addFixer((DataFix)new HorseSplit(schema22, true));
        Schema schema23 = p_210891_0_.addSchema(704, V0704::new);
        p_210891_0_.addFixer((DataFix)new TileEntityId(schema23, true));
        Schema schema24 = p_210891_0_.addSchema(705, V0705::new);
        p_210891_0_.addFixer((DataFix)new EntityId(schema24, true));
        Schema schema25 = p_210891_0_.addSchema(804, field_207593_f);
        p_210891_0_.addFixer((DataFix)new BannerItemColor(schema25, true));
        Schema schema26 = p_210891_0_.addSchema(806, field_207593_f);
        p_210891_0_.addFixer((DataFix)new PotionWater(schema26, false));
        Schema schema27 = p_210891_0_.addSchema(808, V0808::new);
        p_210891_0_.addFixer((DataFix)new AddNewChoices(schema27, "added shulker box", TypeReferences.field_211294_j));
        Schema schema28 = p_210891_0_.addSchema(808, 1, field_207593_f);
        p_210891_0_.addFixer((DataFix)new ShulkerBoxEntityColor(schema28, false));
        Schema schema29 = p_210891_0_.addSchema(813, field_207593_f);
        p_210891_0_.addFixer((DataFix)new ShulkerBoxItemColor(schema29, false));
        p_210891_0_.addFixer((DataFix)new ShulkerBoxTileColor(schema29, false));
        Schema schema30 = p_210891_0_.addSchema(816, field_207593_f);
        p_210891_0_.addFixer((DataFix)new OptionsLowerCaseLanguage(schema30, false));
        Schema schema31 = p_210891_0_.addSchema(820, field_207593_f);
        p_210891_0_.addFixer(ItemRename.func_207476_a((Schema)schema31, (String)"totem item renamer", DataFixesManager.func_241299_a_("minecraft:totem", "minecraft:totem_of_undying")));
        Schema schema32 = p_210891_0_.addSchema(1022, V1022::new);
        p_210891_0_.addFixer((DataFix)new WriteAndReadDataFix(schema32, "added shoulder entities to players", TypeReferences.field_211286_b));
        Schema schema33 = p_210891_0_.addSchema(1125, V1125::new);
        p_210891_0_.addFixer((DataFix)new AddBedTileEntity(schema33, true));
        p_210891_0_.addFixer((DataFix)new BedItemColor(schema33, false));
        Schema schema34 = p_210891_0_.addSchema(1344, field_207593_f);
        p_210891_0_.addFixer((DataFix)new LWJGL3KeyOptions(schema34, false));
        Schema schema35 = p_210891_0_.addSchema(1446, field_207593_f);
        p_210891_0_.addFixer((DataFix)new KeyOptionsTranslation(schema35, false));
        Schema schema36 = p_210891_0_.addSchema(1450, field_207593_f);
        p_210891_0_.addFixer((DataFix)new BlockStateFlattenStructures(schema36, false));
        Schema schema37 = p_210891_0_.addSchema(1451, V1451::new);
        p_210891_0_.addFixer((DataFix)new AddNewChoices(schema37, "AddTrappedChestFix", TypeReferences.field_211294_j));
        Schema schema38 = p_210891_0_.addSchema(1451, 1, V1451_1::new);
        p_210891_0_.addFixer((DataFix)new ChunkPaletteFormat(schema38, true));
        Schema schema39 = p_210891_0_.addSchema(1451, 2, V1451_2::new);
        p_210891_0_.addFixer((DataFix)new PistonPushedBlock(schema39, true));
        Schema schema40 = p_210891_0_.addSchema(1451, 3, V1451_3::new);
        p_210891_0_.addFixer((DataFix)new BlockStateFlatternEntities(schema40, true));
        p_210891_0_.addFixer((DataFix)new ItemFilledMapMetadata(schema40, false));
        Schema schema41 = p_210891_0_.addSchema(1451, 4, V1451_4::new);
        p_210891_0_.addFixer((DataFix)new BlockNameFlattening(schema41, true));
        p_210891_0_.addFixer((DataFix)new ItemStackDataFlattening(schema41, false));
        Schema schema42 = p_210891_0_.addSchema(1451, 5, V1451_5::new);
        p_210891_0_.addFixer((DataFix)new AddNewChoices(schema42, "RemoveNoteBlockFlowerPotFix", TypeReferences.field_211294_j));
        p_210891_0_.addFixer((DataFix)new ItemSpawnEggSplit(schema42, false));
        p_210891_0_.addFixer((DataFix)new WolfCollarColor(schema42, false));
        p_210891_0_.addFixer((DataFix)new BlockEntityBannerColor(schema42, false));
        p_210891_0_.addFixer((DataFix)new BlockStateFlattenGenOptions(schema42, false));
        Schema schema43 = p_210891_0_.addSchema(1451, 6, V1451_6::new);
        p_210891_0_.addFixer((DataFix)new StatsRenaming(schema43, true));
        p_210891_0_.addFixer((DataFix)new JukeboxRecordItem(schema43, false));
        Schema schema44 = p_210891_0_.addSchema(1451, 7, V1451_7::new);
        p_210891_0_.addFixer((DataFix)new BlockStateFlattenVillageCrops(schema44, true));
        Schema schema45 = p_210891_0_.addSchema(1451, 7, field_207593_f);
        p_210891_0_.addFixer((DataFix)new VillagerTrades(schema45, false));
        Schema schema46 = p_210891_0_.addSchema(1456, field_207593_f);
        p_210891_0_.addFixer((DataFix)new EntityItemFrameFacing(schema46, false));
        Schema schema47 = p_210891_0_.addSchema(1458, field_207593_f);
        p_210891_0_.addFixer(new DataFix(schema47, false){

            protected TypeRewriteRule makeRule() {
                return this.fixTypeEverywhereTyped("Player CustomName", this.getInputSchema().getType(TypeReferences.field_211286_b), typed -> typed.update(DSL.remainderFinder(), CustomNameStringToComponentEntity::func_209740_a));
            }
        });
        p_210891_0_.addFixer((DataFix)new CustomNameStringToComponentEntity(schema47, false));
        p_210891_0_.addFixer((DataFix)new CustomNameStringToComponentItem(schema47, false));
        p_210891_0_.addFixer((DataFix)new CustomNameStringToComponentFixTileEntity(schema47, false));
        Schema schema48 = p_210891_0_.addSchema(1460, V1460::new);
        p_210891_0_.addFixer((DataFix)new PaintingMotive(schema48, false));
        Schema schema49 = p_210891_0_.addSchema(1466, V1466::new);
        p_210891_0_.addFixer((DataFix)new ChunkGenStatus(schema49, true));
        Schema schema50 = p_210891_0_.addSchema(1470, V1470::new);
        p_210891_0_.addFixer((DataFix)new AddNewChoices(schema50, "Add 1.13 entities fix", TypeReferences.field_211299_o));
        Schema schema51 = p_210891_0_.addSchema(1474, field_207593_f);
        p_210891_0_.addFixer((DataFix)new ColorlessShulkerEntityFix(schema51, false));
        p_210891_0_.addFixer(BlockRename.func_207437_a((Schema)schema51, (String)"Colorless shulker block fixer", p_207106_0_ -> Objects.equals(NamespacedSchema.func_206477_f((String)p_207106_0_), "minecraft:purple_shulker_box") ? "minecraft:shulker_box" : p_207106_0_));
        p_210891_0_.addFixer(ItemRename.func_207476_a((Schema)schema51, (String)"Colorless shulker item fixer", p_207101_0_ -> Objects.equals(NamespacedSchema.func_206477_f((String)p_207101_0_), "minecraft:purple_shulker_box") ? "minecraft:shulker_box" : p_207101_0_));
        Schema schema52 = p_210891_0_.addSchema(1475, field_207593_f);
        p_210891_0_.addFixer(BlockRename.func_207437_a((Schema)schema52, (String)"Flowing fixer", DataFixesManager.func_241301_a_((Map<String, String>)ImmutableMap.of((Object)"minecraft:flowing_water", (Object)"minecraft:water", (Object)"minecraft:flowing_lava", (Object)"minecraft:lava"))));
        Schema schema53 = p_210891_0_.addSchema(1480, field_207593_f);
        p_210891_0_.addFixer(BlockRename.func_207437_a((Schema)schema53, (String)"Rename coral blocks", DataFixesManager.func_241301_a_(RenamedCoral.field_204918_a)));
        p_210891_0_.addFixer(ItemRename.func_207476_a((Schema)schema53, (String)"Rename coral items", DataFixesManager.func_241301_a_(RenamedCoral.field_204918_a)));
        Schema schema54 = p_210891_0_.addSchema(1481, V1481::new);
        p_210891_0_.addFixer((DataFix)new AddNewChoices(schema54, "Add conduit", TypeReferences.field_211294_j));
        Schema schema55 = p_210891_0_.addSchema(1483, V1483::new);
        p_210891_0_.addFixer((DataFix)new PufferfishRename(schema55, true));
        p_210891_0_.addFixer(ItemRename.func_207476_a((Schema)schema55, (String)"Rename pufferfish egg item", DataFixesManager.func_241301_a_(PufferfishRename.field_207461_a)));
        Schema schema56 = p_210891_0_.addSchema(1484, field_207593_f);
        p_210891_0_.addFixer(ItemRename.func_207476_a((Schema)schema56, (String)"Rename seagrass items", DataFixesManager.func_241301_a_((Map<String, String>)ImmutableMap.of((Object)"minecraft:sea_grass", (Object)"minecraft:seagrass", (Object)"minecraft:tall_sea_grass", (Object)"minecraft:tall_seagrass"))));
        p_210891_0_.addFixer(BlockRename.func_207437_a((Schema)schema56, (String)"Rename seagrass blocks", DataFixesManager.func_241301_a_((Map<String, String>)ImmutableMap.of((Object)"minecraft:sea_grass", (Object)"minecraft:seagrass", (Object)"minecraft:tall_sea_grass", (Object)"minecraft:tall_seagrass"))));
        p_210891_0_.addFixer((DataFix)new HeightmapRenamingFix(schema56, false));
        Schema schema57 = p_210891_0_.addSchema(1486, V1486::new);
        p_210891_0_.addFixer((DataFix)new EntityCodSalmonFix(schema57, true));
        p_210891_0_.addFixer(ItemRename.func_207476_a((Schema)schema57, (String)"Rename cod/salmon egg items", DataFixesManager.func_241301_a_(EntityCodSalmonFix.field_209759_b)));
        Schema schema58 = p_210891_0_.addSchema(1487, field_207593_f);
        p_210891_0_.addFixer(ItemRename.func_207476_a((Schema)schema58, (String)"Rename prismarine_brick(s)_* blocks", DataFixesManager.func_241301_a_((Map<String, String>)ImmutableMap.of((Object)"minecraft:prismarine_bricks_slab", (Object)"minecraft:prismarine_brick_slab", (Object)"minecraft:prismarine_bricks_stairs", (Object)"minecraft:prismarine_brick_stairs"))));
        p_210891_0_.addFixer(BlockRename.func_207437_a((Schema)schema58, (String)"Rename prismarine_brick(s)_* items", DataFixesManager.func_241301_a_((Map<String, String>)ImmutableMap.of((Object)"minecraft:prismarine_bricks_slab", (Object)"minecraft:prismarine_brick_slab", (Object)"minecraft:prismarine_bricks_stairs", (Object)"minecraft:prismarine_brick_stairs"))));
        Schema schema59 = p_210891_0_.addSchema(1488, field_207593_f);
        p_210891_0_.addFixer(BlockRename.func_207437_a((Schema)schema59, (String)"Rename kelp/kelptop", DataFixesManager.func_241301_a_((Map<String, String>)ImmutableMap.of((Object)"minecraft:kelp_top", (Object)"minecraft:kelp", (Object)"minecraft:kelp", (Object)"minecraft:kelp_plant"))));
        p_210891_0_.addFixer(ItemRename.func_207476_a((Schema)schema59, (String)"Rename kelptop", DataFixesManager.func_241299_a_("minecraft:kelp_top", "minecraft:kelp")));
        p_210891_0_.addFixer((DataFix)new NamedEntityFix(schema59, false, "Command block block entity custom name fix", TypeReferences.field_211294_j, "minecraft:command_block"){

            protected Typed<?> func_207419_a(Typed<?> p_207419_1_) {
                return p_207419_1_.update(DSL.remainderFinder(), CustomNameStringToComponentEntity::func_209740_a);
            }
        });
        p_210891_0_.addFixer((DataFix)new NamedEntityFix(schema59, false, "Command block minecart custom name fix", TypeReferences.field_211299_o, "minecraft:commandblock_minecart"){

            protected Typed<?> func_207419_a(Typed<?> p_207419_1_) {
                return p_207419_1_.update(DSL.remainderFinder(), CustomNameStringToComponentEntity::func_209740_a);
            }
        });
        p_210891_0_.addFixer((DataFix)new IglooMetadataRemoval(schema59, false));
        Schema schema60 = p_210891_0_.addSchema(1490, field_207593_f);
        p_210891_0_.addFixer(BlockRename.func_207437_a((Schema)schema60, (String)"Rename melon_block", DataFixesManager.func_241299_a_("minecraft:melon_block", "minecraft:melon")));
        p_210891_0_.addFixer(ItemRename.func_207476_a((Schema)schema60, (String)"Rename melon_block/melon/speckled_melon", DataFixesManager.func_241301_a_((Map<String, String>)ImmutableMap.of((Object)"minecraft:melon_block", (Object)"minecraft:melon", (Object)"minecraft:melon", (Object)"minecraft:melon_slice", (Object)"minecraft:speckled_melon", (Object)"minecraft:glistering_melon_slice"))));
        Schema schema61 = p_210891_0_.addSchema(1492, field_207593_f);
        p_210891_0_.addFixer((DataFix)new ChunkStructuresTemplateRenameFix(schema61, false));
        Schema schema62 = p_210891_0_.addSchema(1494, field_207593_f);
        p_210891_0_.addFixer((DataFix)new ItemStackEnchantmentFix(schema62, false));
        Schema schema63 = p_210891_0_.addSchema(1496, field_207593_f);
        p_210891_0_.addFixer((DataFix)new LeavesFix(schema63, false));
        Schema schema64 = p_210891_0_.addSchema(1500, field_207593_f);
        p_210891_0_.addFixer((DataFix)new BlockEntityKeepPacked(schema64, false));
        Schema schema65 = p_210891_0_.addSchema(1501, field_207593_f);
        p_210891_0_.addFixer((DataFix)new AdvancementRenamer1501(schema65, false));
        Schema schema66 = p_210891_0_.addSchema(1502, field_207593_f);
        p_210891_0_.addFixer((DataFix)new RecipeRenamer1502(schema66, false));
        Schema schema67 = p_210891_0_.addSchema(1506, field_207593_f);
        p_210891_0_.addFixer((DataFix)new LevelDataGeneratorOptionsFix(schema67, false));
        Schema schema68 = p_210891_0_.addSchema(1510, V1510::new);
        p_210891_0_.addFixer(BlockRename.func_207437_a((Schema)schema68, (String)"Block renamening fix", DataFixesManager.func_241301_a_(EntityRenaming1510.field_210596_b)));
        p_210891_0_.addFixer(ItemRename.func_207476_a((Schema)schema68, (String)"Item renamening fix", DataFixesManager.func_241301_a_(EntityRenaming1510.field_210597_c)));
        p_210891_0_.addFixer((DataFix)new RecipeRenamer1510(schema68, false));
        p_210891_0_.addFixer((DataFix)new EntityRenaming1510(schema68, true));
        p_210891_0_.addFixer((DataFix)new SwimStatsRename(schema68, false));
        Schema schema69 = p_210891_0_.addSchema(1514, field_207593_f);
        p_210891_0_.addFixer((DataFix)new ObjectiveDisplayName(schema69, false));
        p_210891_0_.addFixer((DataFix)new TeamDisplayName(schema69, false));
        p_210891_0_.addFixer((DataFix)new ObjectiveRenderType(schema69, false));
        Schema schema70 = p_210891_0_.addSchema(1515, field_207593_f);
        p_210891_0_.addFixer(BlockRename.func_207437_a((Schema)schema70, (String)"Rename coral fan blocks", DataFixesManager.func_241301_a_(CoralFansRenameList.field_211870_a)));
        Schema schema71 = p_210891_0_.addSchema(1624, field_207593_f);
        p_210891_0_.addFixer((DataFix)new TrappedChestTileEntitySplit(schema71, false));
        Schema schema72 = p_210891_0_.addSchema(1800, V1800::new);
        p_210891_0_.addFixer((DataFix)new AddNewChoices(schema72, "Added 1.14 mobs fix", TypeReferences.field_211299_o));
        p_210891_0_.addFixer(ItemRename.func_207476_a((Schema)schema72, (String)"Rename dye items", DataFixesManager.func_241301_a_(DyeRenameMap.field_219828_a)));
        Schema schema73 = p_210891_0_.addSchema(1801, V1801::new);
        p_210891_0_.addFixer((DataFix)new AddNewChoices(schema73, "Added Illager Beast", TypeReferences.field_211299_o));
        Schema schema74 = p_210891_0_.addSchema(1802, field_207593_f);
        p_210891_0_.addFixer(BlockRename.func_207437_a((Schema)schema74, (String)"Rename sign blocks & stone slabs", DataFixesManager.func_241301_a_((Map<String, String>)ImmutableMap.of((Object)"minecraft:stone_slab", (Object)"minecraft:smooth_stone_slab", (Object)"minecraft:sign", (Object)"minecraft:oak_sign", (Object)"minecraft:wall_sign", (Object)"minecraft:oak_wall_sign"))));
        p_210891_0_.addFixer(ItemRename.func_207476_a((Schema)schema74, (String)"Rename sign item & stone slabs", DataFixesManager.func_241301_a_((Map<String, String>)ImmutableMap.of((Object)"minecraft:stone_slab", (Object)"minecraft:smooth_stone_slab", (Object)"minecraft:sign", (Object)"minecraft:oak_sign"))));
        Schema schema75 = p_210891_0_.addSchema(1803, field_207593_f);
        p_210891_0_.addFixer((DataFix)new ItemLoreComponentizeFix(schema75, false));
        Schema schema76 = p_210891_0_.addSchema(1904, V1904::new);
        p_210891_0_.addFixer((DataFix)new AddNewChoices(schema76, "Added Cats", TypeReferences.field_211299_o));
        p_210891_0_.addFixer((DataFix)new EntityCatSplitFix(schema76, false));
        Schema schema77 = p_210891_0_.addSchema(1905, field_207593_f);
        p_210891_0_.addFixer((DataFix)new ChunkStatusFix(schema77, false));
        Schema schema78 = p_210891_0_.addSchema(1906, V1906::new);
        p_210891_0_.addFixer((DataFix)new AddNewChoices(schema78, "Add POI Blocks", TypeReferences.field_211294_j));
        Schema schema79 = p_210891_0_.addSchema(1909, V1909::new);
        p_210891_0_.addFixer((DataFix)new AddNewChoices(schema79, "Add jigsaw", TypeReferences.field_211294_j));
        Schema schema80 = p_210891_0_.addSchema(1911, field_207593_f);
        p_210891_0_.addFixer((DataFix)new ChunkStatusFix2(schema80, false));
        Schema schema81 = p_210891_0_.addSchema(1917, field_207593_f);
        p_210891_0_.addFixer((DataFix)new CatTypeFix(schema81, false));
        Schema schema82 = p_210891_0_.addSchema(1918, field_207593_f);
        p_210891_0_.addFixer((DataFix)new VillagerProfessionFix(schema82, "minecraft:villager"));
        p_210891_0_.addFixer((DataFix)new VillagerProfessionFix(schema82, "minecraft:zombie_villager"));
        Schema schema83 = p_210891_0_.addSchema(1920, V1920::new);
        p_210891_0_.addFixer((DataFix)new NewVillageFix(schema83, false));
        p_210891_0_.addFixer((DataFix)new AddNewChoices(schema83, "Add campfire", TypeReferences.field_211294_j));
        Schema schema84 = p_210891_0_.addSchema(1925, field_207593_f);
        p_210891_0_.addFixer((DataFix)new MapIdFix(schema84, false));
        Schema schema85 = p_210891_0_.addSchema(1928, V1928::new);
        p_210891_0_.addFixer((DataFix)new EntityRavagerRenameFix(schema85, true));
        p_210891_0_.addFixer(ItemRename.func_207476_a((Schema)schema85, (String)"Rename ravager egg item", DataFixesManager.func_241301_a_(EntityRavagerRenameFix.field_219829_a)));
        Schema schema86 = p_210891_0_.addSchema(1929, V1929::new);
        p_210891_0_.addFixer((DataFix)new AddNewChoices(schema86, "Add Wandering Trader and Trader Llama", TypeReferences.field_211299_o));
        Schema schema87 = p_210891_0_.addSchema(1931, V1931::new);
        p_210891_0_.addFixer((DataFix)new AddNewChoices(schema87, "Added Fox", TypeReferences.field_211299_o));
        Schema schema88 = p_210891_0_.addSchema(1936, field_207593_f);
        p_210891_0_.addFixer((DataFix)new OptionsAddTextBackgroundFix(schema88, false));
        Schema schema89 = p_210891_0_.addSchema(1946, field_207593_f);
        p_210891_0_.addFixer((DataFix)new PointOfInterestReorganizationFix(schema89, false));
        Schema schema90 = p_210891_0_.addSchema(1948, field_207593_f);
        p_210891_0_.addFixer((DataFix)new OminousBannerRenameFix(schema90, false));
        Schema schema91 = p_210891_0_.addSchema(1953, field_207593_f);
        p_210891_0_.addFixer((DataFix)new OminousBannerTileEntityRenameFix(schema91, false));
        Schema schema92 = p_210891_0_.addSchema(1955, field_207593_f);
        p_210891_0_.addFixer((DataFix)new VillagerLevelAndXpFix(schema92, false));
        p_210891_0_.addFixer((DataFix)new ZombieVillagerXpFix(schema92, false));
        Schema schema93 = p_210891_0_.addSchema(1961, field_207593_f);
        p_210891_0_.addFixer((DataFix)new ChunkLightRemoveFix(schema93, false));
        Schema schema94 = p_210891_0_.addSchema(1963, field_207593_f);
        p_210891_0_.addFixer((DataFix)new RemoveGolemGossip(schema94, false));
        Schema schema95 = p_210891_0_.addSchema(2100, V2100::new);
        p_210891_0_.addFixer((DataFix)new AddNewChoices(schema95, "Added Bee and Bee Stinger", TypeReferences.field_211299_o));
        p_210891_0_.addFixer((DataFix)new AddNewChoices(schema95, "Add beehive", TypeReferences.field_211294_j));
        p_210891_0_.addFixer((DataFix)new RecipeRenamer(schema95, false, "Rename sugar recipe", DataFixesManager.func_241299_a_("minecraft:sugar", "sugar_from_sugar_cane")));
        p_210891_0_.addFixer((DataFix)new AdvancementRenamer(schema95, false, "Rename sugar recipe advancement", DataFixesManager.func_241299_a_("minecraft:recipes/misc/sugar", "minecraft:recipes/misc/sugar_from_sugar_cane")));
        Schema schema96 = p_210891_0_.addSchema(2202, field_207593_f);
        p_210891_0_.addFixer((DataFix)new BiomeIdFix(schema96, false));
        Schema schema97 = p_210891_0_.addSchema(2209, field_207593_f);
        p_210891_0_.addFixer(ItemRename.func_207476_a((Schema)schema97, (String)"Rename bee_hive item to beehive", DataFixesManager.func_241299_a_("minecraft:bee_hive", "minecraft:beehive")));
        p_210891_0_.addFixer((DataFix)new RenameBeehivePointOfInterest(schema97));
        p_210891_0_.addFixer(BlockRename.func_207437_a((Schema)schema97, (String)"Rename bee_hive block to beehive", DataFixesManager.func_241299_a_("minecraft:bee_hive", "minecraft:beehive")));
        Schema schema98 = p_210891_0_.addSchema(2211, field_207593_f);
        p_210891_0_.addFixer((DataFix)new StructureReferenceFix(schema98, false));
        Schema schema99 = p_210891_0_.addSchema(2218, field_207593_f);
        p_210891_0_.addFixer((DataFix)new PointOfInterestRebuild(schema99, false));
        Schema schema100 = p_210891_0_.addSchema(2501, V2501::new);
        p_210891_0_.addFixer((DataFix)new FurnaceRecipes(schema100, true));
        Schema schema101 = p_210891_0_.addSchema(2502, V2502::new);
        p_210891_0_.addFixer((DataFix)new AddNewChoices(schema101, "Added Hoglin", TypeReferences.field_211299_o));
        Schema schema102 = p_210891_0_.addSchema(2503, field_207593_f);
        p_210891_0_.addFixer((DataFix)new WallProperty(schema102, false));
        p_210891_0_.addFixer((DataFix)new AdvancementRenamer(schema102, false, "Composter category change", DataFixesManager.func_241299_a_("minecraft:recipes/misc/composter", "minecraft:recipes/decorations/composter")));
        Schema schema103 = p_210891_0_.addSchema(2505, V2505::new);
        p_210891_0_.addFixer((DataFix)new AddNewChoices(schema103, "Added Piglin", TypeReferences.field_211299_o));
        p_210891_0_.addFixer((DataFix)new MemoryExpiry(schema103, "minecraft:villager"));
        Schema schema104 = p_210891_0_.addSchema(2508, field_207593_f);
        p_210891_0_.addFixer(ItemRename.func_207476_a((Schema)schema104, (String)"Renamed fungi items to fungus", DataFixesManager.func_241301_a_((Map<String, String>)ImmutableMap.of((Object)"minecraft:warped_fungi", (Object)"minecraft:warped_fungus", (Object)"minecraft:crimson_fungi", (Object)"minecraft:crimson_fungus"))));
        p_210891_0_.addFixer(BlockRename.func_207437_a((Schema)schema104, (String)"Renamed fungi blocks to fungus", DataFixesManager.func_241301_a_((Map<String, String>)ImmutableMap.of((Object)"minecraft:warped_fungi", (Object)"minecraft:warped_fungus", (Object)"minecraft:crimson_fungi", (Object)"minecraft:crimson_fungus"))));
        Schema schema105 = p_210891_0_.addSchema(2509, V2509::new);
        p_210891_0_.addFixer((DataFix)new ZombifiedPiglinRename(schema105));
        p_210891_0_.addFixer(ItemRename.func_207476_a((Schema)schema105, (String)"Rename zombie pigman egg item", DataFixesManager.func_241301_a_(ZombifiedPiglinRename.field_233242_a_)));
        Schema schema106 = p_210891_0_.addSchema(2511, field_207593_f);
        p_210891_0_.addFixer((DataFix)new ProjectileOwner(schema106));
        Schema schema107 = p_210891_0_.addSchema(2514, field_207593_f);
        p_210891_0_.addFixer((DataFix)new EntityUUID(schema107));
        p_210891_0_.addFixer((DataFix)new BlockEntityUUID(schema107));
        p_210891_0_.addFixer((DataFix)new PlayerUUID(schema107));
        p_210891_0_.addFixer((DataFix)new LevelUUID(schema107));
        p_210891_0_.addFixer((DataFix)new SavedDataUUID(schema107));
        p_210891_0_.addFixer((DataFix)new ItemStackUUID(schema107));
        Schema schema108 = p_210891_0_.addSchema(2516, field_207593_f);
        p_210891_0_.addFixer((DataFix)new Gossip(schema108, "minecraft:villager"));
        p_210891_0_.addFixer((DataFix)new Gossip(schema108, "minecraft:zombie_villager"));
        Schema schema109 = p_210891_0_.addSchema(2518, field_207593_f);
        p_210891_0_.addFixer((DataFix)new JigsawProperties(schema109, false));
        p_210891_0_.addFixer((DataFix)new JigsawRotation(schema109, false));
        Schema schema110 = p_210891_0_.addSchema(2519, V2519::new);
        p_210891_0_.addFixer((DataFix)new AddNewChoices(schema110, "Added Strider", TypeReferences.field_211299_o));
        Schema schema111 = p_210891_0_.addSchema(2522, V2522::new);
        p_210891_0_.addFixer((DataFix)new AddNewChoices(schema111, "Added Zoglin", TypeReferences.field_211299_o));
        Schema schema112 = p_210891_0_.addSchema(2523, field_207593_f);
        p_210891_0_.addFixer((DataFix)new AttributesFix(schema112));
        Schema schema113 = p_210891_0_.addSchema(2527, field_207593_f);
        p_210891_0_.addFixer((DataFix)new BitStorageAlignFix(schema113));
        Schema schema114 = p_210891_0_.addSchema(2528, field_207593_f);
        p_210891_0_.addFixer(ItemRename.func_207476_a((Schema)schema114, (String)"Rename soul fire torch and soul fire lantern", DataFixesManager.func_241301_a_((Map<String, String>)ImmutableMap.of((Object)"minecraft:soul_fire_torch", (Object)"minecraft:soul_torch", (Object)"minecraft:soul_fire_lantern", (Object)"minecraft:soul_lantern"))));
        p_210891_0_.addFixer(BlockRename.func_207437_a((Schema)schema114, (String)"Rename soul fire torch and soul fire lantern", DataFixesManager.func_241301_a_((Map<String, String>)ImmutableMap.of((Object)"minecraft:soul_fire_torch", (Object)"minecraft:soul_torch", (Object)"minecraft:soul_fire_wall_torch", (Object)"minecraft:soul_wall_torch", (Object)"minecraft:soul_fire_lantern", (Object)"minecraft:soul_lantern"))));
        Schema schema115 = p_210891_0_.addSchema(2529, field_207593_f);
        p_210891_0_.addFixer((DataFix)new StriderGravity(schema115, false));
        Schema schema116 = p_210891_0_.addSchema(2531, field_207593_f);
        p_210891_0_.addFixer((DataFix)new RedstoneConnections(schema116));
        Schema schema117 = p_210891_0_.addSchema(2533, field_207593_f);
        p_210891_0_.addFixer((DataFix)new VillagerFollowRange(schema117));
        Schema schema118 = p_210891_0_.addSchema(2535, field_207593_f);
        p_210891_0_.addFixer((DataFix)new ShulkerRotation(schema118));
        Schema schema119 = p_210891_0_.addSchema(2550, field_207593_f);
        p_210891_0_.addFixer((DataFix)new WorldGenSettings(schema119));
        Schema schema120 = p_210891_0_.addSchema(2551, V2551::new);
        p_210891_0_.addFixer((DataFix)new WriteAndReadDataFix(schema120, "add types to WorldGenData", TypeReferences.field_233375_y_));
        Schema schema121 = p_210891_0_.addSchema(2552, field_207593_f);
        p_210891_0_.addFixer((DataFix)new BiomeName(schema121, false, "Nether biome rename", (Map)ImmutableMap.of((Object)"minecraft:nether", (Object)"minecraft:nether_wastes")));
        Schema schema122 = p_210891_0_.addSchema(2553, field_207593_f);
        p_210891_0_.addFixer((DataFix)new BiomeRenames(schema122, false));
        Schema schema123 = p_210891_0_.addSchema(2558, field_207593_f);
        p_210891_0_.addFixer((DataFix)new MissingDimensionFix(schema123, false));
        p_210891_0_.addFixer((DataFix)new SwapHandsFix(schema123, false, "Rename swapHands setting", "key_key.swapHands", "key_key.swapOffhand"));
        Schema schema124 = p_210891_0_.addSchema(2568, V2568::new);
        p_210891_0_.addFixer((DataFix)new AddNewChoices(schema124, "Added Piglin Brute", TypeReferences.field_211299_o));
    }

    private static UnaryOperator<String> func_241301_a_(Map<String, String> p_241301_0_) {
        return p_241302_1_ -> p_241301_0_.getOrDefault(p_241302_1_, (String)p_241302_1_);
    }

    private static UnaryOperator<String> func_241299_a_(String p_241299_0_, String p_241299_1_) {
        return p_241300_2_ -> Objects.equals(p_241300_2_, p_241299_0_) ? p_241299_1_ : p_241300_2_;
    }
}

