/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.math;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class AxisAlignedBB {
    public final double field_72340_a;
    public final double field_72338_b;
    public final double field_72339_c;
    public final double field_72336_d;
    public final double field_72337_e;
    public final double field_72334_f;

    public AxisAlignedBB(double p_i2300_1_, double p_i2300_3_, double p_i2300_5_, double p_i2300_7_, double p_i2300_9_, double p_i2300_11_) {
        this.field_72340_a = Math.min(p_i2300_1_, p_i2300_7_);
        this.field_72338_b = Math.min(p_i2300_3_, p_i2300_9_);
        this.field_72339_c = Math.min(p_i2300_5_, p_i2300_11_);
        this.field_72336_d = Math.max(p_i2300_1_, p_i2300_7_);
        this.field_72337_e = Math.max(p_i2300_3_, p_i2300_9_);
        this.field_72334_f = Math.max(p_i2300_5_, p_i2300_11_);
    }

    public AxisAlignedBB(BlockPos p_i46612_1_) {
        this(p_i46612_1_.func_177958_n(), p_i46612_1_.func_177956_o(), p_i46612_1_.func_177952_p(), p_i46612_1_.func_177958_n() + 1, p_i46612_1_.func_177956_o() + 1, p_i46612_1_.func_177952_p() + 1);
    }

    public AxisAlignedBB(BlockPos p_i45554_1_, BlockPos p_i45554_2_) {
        this(p_i45554_1_.func_177958_n(), p_i45554_1_.func_177956_o(), p_i45554_1_.func_177952_p(), p_i45554_2_.func_177958_n(), p_i45554_2_.func_177956_o(), p_i45554_2_.func_177952_p());
    }

    public AxisAlignedBB(Vector3d p_i47144_1_, Vector3d p_i47144_2_) {
        this(p_i47144_1_.field_72450_a, p_i47144_1_.field_72448_b, p_i47144_1_.field_72449_c, p_i47144_2_.field_72450_a, p_i47144_2_.field_72448_b, p_i47144_2_.field_72449_c);
    }

    public static AxisAlignedBB func_216363_a(MutableBoundingBox p_216363_0_) {
        return new AxisAlignedBB(p_216363_0_.field_78897_a, p_216363_0_.field_78895_b, p_216363_0_.field_78896_c, p_216363_0_.field_78893_d + 1, p_216363_0_.field_78894_e + 1, p_216363_0_.field_78892_f + 1);
    }

    public static AxisAlignedBB func_241549_a_(Vector3d p_241549_0_) {
        return new AxisAlignedBB(p_241549_0_.field_72450_a, p_241549_0_.field_72448_b, p_241549_0_.field_72449_c, p_241549_0_.field_72450_a + 1.0, p_241549_0_.field_72448_b + 1.0, p_241549_0_.field_72449_c + 1.0);
    }

    public double func_197745_a(Direction.Axis p_197745_1_) {
        return p_197745_1_.func_196051_a(this.field_72340_a, this.field_72338_b, this.field_72339_c);
    }

    public double func_197742_b(Direction.Axis p_197742_1_) {
        return p_197742_1_.func_196051_a(this.field_72336_d, this.field_72337_e, this.field_72334_f);
    }

    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        if (!(p_equals_1_ instanceof AxisAlignedBB)) {
            return false;
        }
        AxisAlignedBB axisalignedbb = (AxisAlignedBB)p_equals_1_;
        if (Double.compare(axisalignedbb.field_72340_a, this.field_72340_a) != 0) {
            return false;
        }
        if (Double.compare(axisalignedbb.field_72338_b, this.field_72338_b) != 0) {
            return false;
        }
        if (Double.compare(axisalignedbb.field_72339_c, this.field_72339_c) != 0) {
            return false;
        }
        if (Double.compare(axisalignedbb.field_72336_d, this.field_72336_d) != 0) {
            return false;
        }
        if (Double.compare(axisalignedbb.field_72337_e, this.field_72337_e) != 0) {
            return false;
        }
        return Double.compare(axisalignedbb.field_72334_f, this.field_72334_f) == 0;
    }

    public int hashCode() {
        long i = Double.doubleToLongBits(this.field_72340_a);
        int j = (int)(i ^ i >>> 32);
        i = Double.doubleToLongBits(this.field_72338_b);
        j = 31 * j + (int)(i ^ i >>> 32);
        i = Double.doubleToLongBits(this.field_72339_c);
        j = 31 * j + (int)(i ^ i >>> 32);
        i = Double.doubleToLongBits(this.field_72336_d);
        j = 31 * j + (int)(i ^ i >>> 32);
        i = Double.doubleToLongBits(this.field_72337_e);
        j = 31 * j + (int)(i ^ i >>> 32);
        i = Double.doubleToLongBits(this.field_72334_f);
        return 31 * j + (int)(i ^ i >>> 32);
    }

    public AxisAlignedBB func_191195_a(double p_191195_1_, double p_191195_3_, double p_191195_5_) {
        double d0 = this.field_72340_a;
        double d1 = this.field_72338_b;
        double d2 = this.field_72339_c;
        double d3 = this.field_72336_d;
        double d4 = this.field_72337_e;
        double d5 = this.field_72334_f;
        if (p_191195_1_ < 0.0) {
            d0 -= p_191195_1_;
        } else if (p_191195_1_ > 0.0) {
            d3 -= p_191195_1_;
        }
        if (p_191195_3_ < 0.0) {
            d1 -= p_191195_3_;
        } else if (p_191195_3_ > 0.0) {
            d4 -= p_191195_3_;
        }
        if (p_191195_5_ < 0.0) {
            d2 -= p_191195_5_;
        } else if (p_191195_5_ > 0.0) {
            d5 -= p_191195_5_;
        }
        return new AxisAlignedBB(d0, d1, d2, d3, d4, d5);
    }

    public AxisAlignedBB func_216361_a(Vector3d p_216361_1_) {
        return this.func_72321_a(p_216361_1_.field_72450_a, p_216361_1_.field_72448_b, p_216361_1_.field_72449_c);
    }

    public AxisAlignedBB func_72321_a(double p_72321_1_, double p_72321_3_, double p_72321_5_) {
        double d0 = this.field_72340_a;
        double d1 = this.field_72338_b;
        double d2 = this.field_72339_c;
        double d3 = this.field_72336_d;
        double d4 = this.field_72337_e;
        double d5 = this.field_72334_f;
        if (p_72321_1_ < 0.0) {
            d0 += p_72321_1_;
        } else if (p_72321_1_ > 0.0) {
            d3 += p_72321_1_;
        }
        if (p_72321_3_ < 0.0) {
            d1 += p_72321_3_;
        } else if (p_72321_3_ > 0.0) {
            d4 += p_72321_3_;
        }
        if (p_72321_5_ < 0.0) {
            d2 += p_72321_5_;
        } else if (p_72321_5_ > 0.0) {
            d5 += p_72321_5_;
        }
        return new AxisAlignedBB(d0, d1, d2, d3, d4, d5);
    }

    public AxisAlignedBB func_72314_b(double p_72314_1_, double p_72314_3_, double p_72314_5_) {
        double d0 = this.field_72340_a - p_72314_1_;
        double d1 = this.field_72338_b - p_72314_3_;
        double d2 = this.field_72339_c - p_72314_5_;
        double d3 = this.field_72336_d + p_72314_1_;
        double d4 = this.field_72337_e + p_72314_3_;
        double d5 = this.field_72334_f + p_72314_5_;
        return new AxisAlignedBB(d0, d1, d2, d3, d4, d5);
    }

    public AxisAlignedBB func_186662_g(double p_186662_1_) {
        return this.func_72314_b(p_186662_1_, p_186662_1_, p_186662_1_);
    }

    public AxisAlignedBB func_191500_a(AxisAlignedBB p_191500_1_) {
        double d0 = Math.max(this.field_72340_a, p_191500_1_.field_72340_a);
        double d1 = Math.max(this.field_72338_b, p_191500_1_.field_72338_b);
        double d2 = Math.max(this.field_72339_c, p_191500_1_.field_72339_c);
        double d3 = Math.min(this.field_72336_d, p_191500_1_.field_72336_d);
        double d4 = Math.min(this.field_72337_e, p_191500_1_.field_72337_e);
        double d5 = Math.min(this.field_72334_f, p_191500_1_.field_72334_f);
        return new AxisAlignedBB(d0, d1, d2, d3, d4, d5);
    }

    public AxisAlignedBB func_111270_a(AxisAlignedBB p_111270_1_) {
        double d0 = Math.min(this.field_72340_a, p_111270_1_.field_72340_a);
        double d1 = Math.min(this.field_72338_b, p_111270_1_.field_72338_b);
        double d2 = Math.min(this.field_72339_c, p_111270_1_.field_72339_c);
        double d3 = Math.max(this.field_72336_d, p_111270_1_.field_72336_d);
        double d4 = Math.max(this.field_72337_e, p_111270_1_.field_72337_e);
        double d5 = Math.max(this.field_72334_f, p_111270_1_.field_72334_f);
        return new AxisAlignedBB(d0, d1, d2, d3, d4, d5);
    }

    public AxisAlignedBB func_72317_d(double p_72317_1_, double p_72317_3_, double p_72317_5_) {
        return new AxisAlignedBB(this.field_72340_a + p_72317_1_, this.field_72338_b + p_72317_3_, this.field_72339_c + p_72317_5_, this.field_72336_d + p_72317_1_, this.field_72337_e + p_72317_3_, this.field_72334_f + p_72317_5_);
    }

    public AxisAlignedBB func_186670_a(BlockPos p_186670_1_) {
        return new AxisAlignedBB(this.field_72340_a + (double)p_186670_1_.func_177958_n(), this.field_72338_b + (double)p_186670_1_.func_177956_o(), this.field_72339_c + (double)p_186670_1_.func_177952_p(), this.field_72336_d + (double)p_186670_1_.func_177958_n(), this.field_72337_e + (double)p_186670_1_.func_177956_o(), this.field_72334_f + (double)p_186670_1_.func_177952_p());
    }

    public AxisAlignedBB func_191194_a(Vector3d p_191194_1_) {
        return this.func_72317_d(p_191194_1_.field_72450_a, p_191194_1_.field_72448_b, p_191194_1_.field_72449_c);
    }

    public boolean func_72326_a(AxisAlignedBB p_72326_1_) {
        return this.func_186668_a(p_72326_1_.field_72340_a, p_72326_1_.field_72338_b, p_72326_1_.field_72339_c, p_72326_1_.field_72336_d, p_72326_1_.field_72337_e, p_72326_1_.field_72334_f);
    }

    public boolean func_186668_a(double p_186668_1_, double p_186668_3_, double p_186668_5_, double p_186668_7_, double p_186668_9_, double p_186668_11_) {
        return this.field_72340_a < p_186668_7_ && this.field_72336_d > p_186668_1_ && this.field_72338_b < p_186668_9_ && this.field_72337_e > p_186668_3_ && this.field_72339_c < p_186668_11_ && this.field_72334_f > p_186668_5_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_189973_a(Vector3d p_189973_1_, Vector3d p_189973_2_) {
        return this.func_186668_a(Math.min(p_189973_1_.field_72450_a, p_189973_2_.field_72450_a), Math.min(p_189973_1_.field_72448_b, p_189973_2_.field_72448_b), Math.min(p_189973_1_.field_72449_c, p_189973_2_.field_72449_c), Math.max(p_189973_1_.field_72450_a, p_189973_2_.field_72450_a), Math.max(p_189973_1_.field_72448_b, p_189973_2_.field_72448_b), Math.max(p_189973_1_.field_72449_c, p_189973_2_.field_72449_c));
    }

    public boolean func_72318_a(Vector3d p_72318_1_) {
        return this.func_197744_e(p_72318_1_.field_72450_a, p_72318_1_.field_72448_b, p_72318_1_.field_72449_c);
    }

    public boolean func_197744_e(double p_197744_1_, double p_197744_3_, double p_197744_5_) {
        return p_197744_1_ >= this.field_72340_a && p_197744_1_ < this.field_72336_d && p_197744_3_ >= this.field_72338_b && p_197744_3_ < this.field_72337_e && p_197744_5_ >= this.field_72339_c && p_197744_5_ < this.field_72334_f;
    }

    public final double getAverageSideLength() {
        return this.func_72320_b();
    }

    public double func_72320_b() {
        double d0 = this.func_216364_b();
        double d1 = this.func_216360_c();
        double d2 = this.func_216362_d();
        return (d0 + d1 + d2) / 3.0;
    }

    public double func_216364_b() {
        return this.field_72336_d - this.field_72340_a;
    }

    public double func_216360_c() {
        return this.field_72337_e - this.field_72338_b;
    }

    public double func_216362_d() {
        return this.field_72334_f - this.field_72339_c;
    }

    public AxisAlignedBB func_186664_h(double p_186664_1_) {
        return this.func_186662_g(-p_186664_1_);
    }

    public Optional<Vector3d> func_216365_b(Vector3d p_216365_1_, Vector3d p_216365_2_) {
        double[] adouble = new double[]{1.0};
        double d0 = p_216365_2_.field_72450_a - p_216365_1_.field_72450_a;
        double d1 = p_216365_2_.field_72448_b - p_216365_1_.field_72448_b;
        double d2 = p_216365_2_.field_72449_c - p_216365_1_.field_72449_c;
        Direction direction = AxisAlignedBB.func_197741_a(this, p_216365_1_, adouble, null, d0, d1, d2);
        if (direction == null) {
            return Optional.empty();
        }
        double d3 = adouble[0];
        return Optional.of(p_216365_1_.func_72441_c(d3 * d0, d3 * d1, d3 * d2));
    }

    @Nullable
    public static BlockRayTraceResult func_197743_a(Iterable<AxisAlignedBB> p_197743_0_, Vector3d p_197743_1_, Vector3d p_197743_2_, BlockPos p_197743_3_) {
        double[] adouble = new double[]{1.0};
        Direction direction = null;
        double d0 = p_197743_2_.field_72450_a - p_197743_1_.field_72450_a;
        double d1 = p_197743_2_.field_72448_b - p_197743_1_.field_72448_b;
        double d2 = p_197743_2_.field_72449_c - p_197743_1_.field_72449_c;
        for (AxisAlignedBB axisalignedbb : p_197743_0_) {
            direction = AxisAlignedBB.func_197741_a(axisalignedbb.func_186670_a(p_197743_3_), p_197743_1_, adouble, direction, d0, d1, d2);
        }
        if (direction == null) {
            return null;
        }
        double d3 = adouble[0];
        return new BlockRayTraceResult(p_197743_1_.func_72441_c(d3 * d0, d3 * d1, d3 * d2), direction, p_197743_3_, false);
    }

    @Nullable
    private static Direction func_197741_a(AxisAlignedBB p_197741_0_, Vector3d p_197741_1_, double[] p_197741_2_, @Nullable Direction p_197741_3_, double p_197741_4_, double p_197741_6_, double p_197741_8_) {
        if (p_197741_4_ > 1.0E-7) {
            p_197741_3_ = AxisAlignedBB.func_197740_a(p_197741_2_, p_197741_3_, p_197741_4_, p_197741_6_, p_197741_8_, p_197741_0_.field_72340_a, p_197741_0_.field_72338_b, p_197741_0_.field_72337_e, p_197741_0_.field_72339_c, p_197741_0_.field_72334_f, Direction.WEST, p_197741_1_.field_72450_a, p_197741_1_.field_72448_b, p_197741_1_.field_72449_c);
        } else if (p_197741_4_ < -1.0E-7) {
            p_197741_3_ = AxisAlignedBB.func_197740_a(p_197741_2_, p_197741_3_, p_197741_4_, p_197741_6_, p_197741_8_, p_197741_0_.field_72336_d, p_197741_0_.field_72338_b, p_197741_0_.field_72337_e, p_197741_0_.field_72339_c, p_197741_0_.field_72334_f, Direction.EAST, p_197741_1_.field_72450_a, p_197741_1_.field_72448_b, p_197741_1_.field_72449_c);
        }
        if (p_197741_6_ > 1.0E-7) {
            p_197741_3_ = AxisAlignedBB.func_197740_a(p_197741_2_, p_197741_3_, p_197741_6_, p_197741_8_, p_197741_4_, p_197741_0_.field_72338_b, p_197741_0_.field_72339_c, p_197741_0_.field_72334_f, p_197741_0_.field_72340_a, p_197741_0_.field_72336_d, Direction.DOWN, p_197741_1_.field_72448_b, p_197741_1_.field_72449_c, p_197741_1_.field_72450_a);
        } else if (p_197741_6_ < -1.0E-7) {
            p_197741_3_ = AxisAlignedBB.func_197740_a(p_197741_2_, p_197741_3_, p_197741_6_, p_197741_8_, p_197741_4_, p_197741_0_.field_72337_e, p_197741_0_.field_72339_c, p_197741_0_.field_72334_f, p_197741_0_.field_72340_a, p_197741_0_.field_72336_d, Direction.UP, p_197741_1_.field_72448_b, p_197741_1_.field_72449_c, p_197741_1_.field_72450_a);
        }
        if (p_197741_8_ > 1.0E-7) {
            p_197741_3_ = AxisAlignedBB.func_197740_a(p_197741_2_, p_197741_3_, p_197741_8_, p_197741_4_, p_197741_6_, p_197741_0_.field_72339_c, p_197741_0_.field_72340_a, p_197741_0_.field_72336_d, p_197741_0_.field_72338_b, p_197741_0_.field_72337_e, Direction.NORTH, p_197741_1_.field_72449_c, p_197741_1_.field_72450_a, p_197741_1_.field_72448_b);
        } else if (p_197741_8_ < -1.0E-7) {
            p_197741_3_ = AxisAlignedBB.func_197740_a(p_197741_2_, p_197741_3_, p_197741_8_, p_197741_4_, p_197741_6_, p_197741_0_.field_72334_f, p_197741_0_.field_72340_a, p_197741_0_.field_72336_d, p_197741_0_.field_72338_b, p_197741_0_.field_72337_e, Direction.SOUTH, p_197741_1_.field_72449_c, p_197741_1_.field_72450_a, p_197741_1_.field_72448_b);
        }
        return p_197741_3_;
    }

    @Nullable
    private static Direction func_197740_a(double[] p_197740_0_, @Nullable Direction p_197740_1_, double p_197740_2_, double p_197740_4_, double p_197740_6_, double p_197740_8_, double p_197740_10_, double p_197740_12_, double p_197740_14_, double p_197740_16_, Direction p_197740_18_, double p_197740_19_, double p_197740_21_, double p_197740_23_) {
        double d0 = (p_197740_8_ - p_197740_19_) / p_197740_2_;
        double d1 = p_197740_21_ + d0 * p_197740_4_;
        double d2 = p_197740_23_ + d0 * p_197740_6_;
        if (0.0 < d0 && d0 < p_197740_0_[0] && p_197740_10_ - 1.0E-7 < d1 && d1 < p_197740_12_ + 1.0E-7 && p_197740_14_ - 1.0E-7 < d2 && d2 < p_197740_16_ + 1.0E-7) {
            p_197740_0_[0] = d0;
            return p_197740_18_;
        }
        return p_197740_1_;
    }

    public String toString() {
        return "AABB[" + this.field_72340_a + ", " + this.field_72338_b + ", " + this.field_72339_c + "] -> [" + this.field_72336_d + ", " + this.field_72337_e + ", " + this.field_72334_f + "]";
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_181656_b() {
        return Double.isNaN(this.field_72340_a) || Double.isNaN(this.field_72338_b) || Double.isNaN(this.field_72339_c) || Double.isNaN(this.field_72336_d) || Double.isNaN(this.field_72337_e) || Double.isNaN(this.field_72334_f);
    }

    public Vector3d func_189972_c() {
        return new Vector3d(MathHelper.func_219803_d((double)0.5, (double)this.field_72340_a, (double)this.field_72336_d), MathHelper.func_219803_d((double)0.5, (double)this.field_72338_b, (double)this.field_72337_e), MathHelper.func_219803_d((double)0.5, (double)this.field_72339_c, (double)this.field_72334_f));
    }

    public static AxisAlignedBB func_241550_g_(double p_241550_0_, double p_241550_2_, double p_241550_4_) {
        return new AxisAlignedBB(-p_241550_0_ / 2.0, -p_241550_2_ / 2.0, -p_241550_4_ / 2.0, p_241550_0_ / 2.0, p_241550_2_ / 2.0, p_241550_4_ / 2.0);
    }
}

