/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.math;

import com.google.common.collect.AbstractIterator;
import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.concurrent.Immutable;
import net.minecraft.dispenser.IPosition;
import net.minecraft.entity.Entity;
import net.minecraft.util.AxisRotation;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Immutable
public class BlockPos
extends Vector3i {
    public static final Codec<BlockPos> field_239578_a_ = Codec.INT_STREAM.comapFlatMap(p_239586_0_ -> Util.func_240987_a_(p_239586_0_, 3).map(p_239587_0_ -> new BlockPos(p_239587_0_[0], p_239587_0_[1], p_239587_0_[2])), p_239582_0_ -> IntStream.of(p_239582_0_.func_177958_n(), p_239582_0_.func_177956_o(), p_239582_0_.func_177952_p())).stable();
    private static final Logger field_185335_c = LogManager.getLogger();
    public static final BlockPos field_177992_a = new BlockPos(0, 0, 0);
    private static final int field_177990_b;
    private static final int field_177991_c;
    private static final int field_177989_d;
    private static final long field_177994_h;
    private static final long field_177995_i;
    private static final long field_177993_j;
    private static final int field_218292_j;
    private static final int field_218293_k;

    public BlockPos(Entity p_i46032_1_) {
        this(p_i46032_1_.func_226277_ct_(), p_i46032_1_.func_226278_cu_(), p_i46032_1_.func_226281_cx_());
    }

    public BlockPos(int p_i46030_1_, int p_i46030_2_, int p_i46030_3_) {
        super(p_i46030_1_, p_i46030_2_, p_i46030_3_);
    }

    public BlockPos(double p_i46031_1_, double p_i46031_3_, double p_i46031_5_) {
        super(p_i46031_1_, p_i46031_3_, p_i46031_5_);
    }

    public BlockPos(Vector3d p_i47100_1_) {
        this(p_i47100_1_.field_72450_a, p_i47100_1_.field_72448_b, p_i47100_1_.field_72449_c);
    }

    public BlockPos(IPosition p_i50799_1_) {
        this(p_i50799_1_.func_82615_a(), p_i50799_1_.func_82617_b(), p_i50799_1_.func_82616_c());
    }

    public BlockPos(Vector3i p_i46034_1_) {
        this(p_i46034_1_.func_177958_n(), p_i46034_1_.func_177956_o(), p_i46034_1_.func_177952_p());
    }

    public static long func_218289_a(long p_218289_0_, Direction p_218289_2_) {
        return BlockPos.func_218291_a(p_218289_0_, p_218289_2_.func_82601_c(), p_218289_2_.func_96559_d(), p_218289_2_.func_82599_e());
    }

    public static long func_218291_a(long p_218291_0_, int p_218291_2_, int p_218291_3_, int p_218291_4_) {
        return BlockPos.func_218276_a(BlockPos.func_218290_b(p_218291_0_) + p_218291_2_, BlockPos.func_218274_c(p_218291_0_) + p_218291_3_, BlockPos.func_218282_d(p_218291_0_) + p_218291_4_);
    }

    public static int func_218290_b(long p_218290_0_) {
        return (int)(p_218290_0_ << 64 - field_218293_k - field_177990_b >> 64 - field_177990_b);
    }

    public static int func_218274_c(long p_218274_0_) {
        return (int)(p_218274_0_ << 64 - field_177989_d >> 64 - field_177989_d);
    }

    public static int func_218282_d(long p_218282_0_) {
        return (int)(p_218282_0_ << 64 - field_218292_j - field_177991_c >> 64 - field_177991_c);
    }

    public static BlockPos func_218283_e(long p_218283_0_) {
        return new BlockPos(BlockPos.func_218290_b(p_218283_0_), BlockPos.func_218274_c(p_218283_0_), BlockPos.func_218282_d(p_218283_0_));
    }

    public long func_218275_a() {
        return BlockPos.func_218276_a(this.func_177958_n(), this.func_177956_o(), this.func_177952_p());
    }

    public static long func_218276_a(int p_218276_0_, int p_218276_1_, int p_218276_2_) {
        long i = 0L;
        i |= ((long)p_218276_0_ & field_177994_h) << field_218293_k;
        return (i |= ((long)p_218276_1_ & field_177995_i) << 0) | ((long)p_218276_2_ & field_177993_j) << field_218292_j;
    }

    public static long func_218288_f(long p_218288_0_) {
        return p_218288_0_ & 0xFFFFFFFFFFFFFFF0L;
    }

    public BlockPos func_177963_a(double p_177963_1_, double p_177963_3_, double p_177963_5_) {
        return p_177963_1_ == 0.0 && p_177963_3_ == 0.0 && p_177963_5_ == 0.0 ? this : new BlockPos((double)this.func_177958_n() + p_177963_1_, (double)this.func_177956_o() + p_177963_3_, (double)this.func_177952_p() + p_177963_5_);
    }

    public final BlockPos add(int i, int j, int k) {
        return this.func_177982_a(i, j, k);
    }

    public BlockPos func_177982_a(int p_177982_1_, int p_177982_2_, int p_177982_3_) {
        return p_177982_1_ == 0 && p_177982_2_ == 0 && p_177982_3_ == 0 ? this : new BlockPos(this.func_177958_n() + p_177982_1_, this.func_177956_o() + p_177982_2_, this.func_177952_p() + p_177982_3_);
    }

    public BlockPos func_177971_a(Vector3i p_177971_1_) {
        return this.func_177982_a(p_177971_1_.func_177958_n(), p_177971_1_.func_177956_o(), p_177971_1_.func_177952_p());
    }

    public BlockPos func_177973_b(Vector3i p_177973_1_) {
        return this.func_177982_a(-p_177973_1_.func_177958_n(), -p_177973_1_.func_177956_o(), -p_177973_1_.func_177952_p());
    }

    @Override
    public BlockPos func_177984_a() {
        return this.func_177972_a(Direction.UP);
    }

    @Override
    public BlockPos func_177981_b(int p_177981_1_) {
        return this.func_177967_a(Direction.UP, p_177981_1_);
    }

    @Override
    public BlockPos func_177977_b() {
        return this.func_177972_a(Direction.DOWN);
    }

    @Override
    public BlockPos func_177979_c(int p_177979_1_) {
        return this.func_177967_a(Direction.DOWN, p_177979_1_);
    }

    public BlockPos func_177978_c() {
        return this.func_177972_a(Direction.NORTH);
    }

    public BlockPos func_177964_d(int p_177964_1_) {
        return this.func_177967_a(Direction.NORTH, p_177964_1_);
    }

    public BlockPos func_177968_d() {
        return this.func_177972_a(Direction.SOUTH);
    }

    public BlockPos func_177970_e(int p_177970_1_) {
        return this.func_177967_a(Direction.SOUTH, p_177970_1_);
    }

    public BlockPos func_177976_e() {
        return this.func_177972_a(Direction.WEST);
    }

    public BlockPos func_177985_f(int p_177985_1_) {
        return this.func_177967_a(Direction.WEST, p_177985_1_);
    }

    public BlockPos func_177974_f() {
        return this.func_177972_a(Direction.EAST);
    }

    public BlockPos func_177965_g(int p_177965_1_) {
        return this.func_177967_a(Direction.EAST, p_177965_1_);
    }

    public BlockPos func_177972_a(Direction p_177972_1_) {
        return new BlockPos(this.func_177958_n() + p_177972_1_.func_82601_c(), this.func_177956_o() + p_177972_1_.func_96559_d(), this.func_177952_p() + p_177972_1_.func_82599_e());
    }

    @Override
    public BlockPos func_177967_a(Direction p_177967_1_, int p_177967_2_) {
        return p_177967_2_ == 0 ? this : new BlockPos(this.func_177958_n() + p_177967_1_.func_82601_c() * p_177967_2_, this.func_177956_o() + p_177967_1_.func_96559_d() * p_177967_2_, this.func_177952_p() + p_177967_1_.func_82599_e() * p_177967_2_);
    }

    public BlockPos func_241872_a(Direction.Axis p_241872_1_, int p_241872_2_) {
        if (p_241872_2_ == 0) {
            return this;
        }
        int i = p_241872_1_ == Direction.Axis.X ? p_241872_2_ : 0;
        int j = p_241872_1_ == Direction.Axis.Y ? p_241872_2_ : 0;
        int k = p_241872_1_ == Direction.Axis.Z ? p_241872_2_ : 0;
        return new BlockPos(this.func_177958_n() + i, this.func_177956_o() + j, this.func_177952_p() + k);
    }

    public BlockPos func_190942_a(Rotation p_190942_1_) {
        switch (p_190942_1_) {
            default: {
                return this;
            }
            case CLOCKWISE_90: {
                return new BlockPos(-this.func_177952_p(), this.func_177956_o(), this.func_177958_n());
            }
            case CLOCKWISE_180: {
                return new BlockPos(-this.func_177958_n(), this.func_177956_o(), -this.func_177952_p());
            }
            case COUNTERCLOCKWISE_90: 
        }
        return new BlockPos(this.func_177952_p(), this.func_177956_o(), -this.func_177958_n());
    }

    @Override
    public BlockPos func_177955_d(Vector3i p_177955_1_) {
        return new BlockPos(this.func_177956_o() * p_177955_1_.func_177952_p() - this.func_177952_p() * p_177955_1_.func_177956_o(), this.func_177952_p() * p_177955_1_.func_177958_n() - this.func_177958_n() * p_177955_1_.func_177952_p(), this.func_177958_n() * p_177955_1_.func_177956_o() - this.func_177956_o() * p_177955_1_.func_177958_n());
    }

    public BlockPos func_185334_h() {
        return this;
    }

    public Mutable func_239590_i_() {
        return new Mutable(this.func_177958_n(), this.func_177956_o(), this.func_177952_p());
    }

    public static Iterable<BlockPos> func_239585_a_(final Random p_239585_0_, final int p_239585_1_, final int p_239585_2_, final int p_239585_3_, final int p_239585_4_, int p_239585_5_, int p_239585_6_, int p_239585_7_) {
        final int i = p_239585_5_ - p_239585_2_ + 1;
        final int j = p_239585_6_ - p_239585_3_ + 1;
        final int k = p_239585_7_ - p_239585_4_ + 1;
        return () -> new AbstractIterator<BlockPos>(){
            final Mutable field_218297_b = new Mutable();
            int field_239591_b_ = p_239585_1_;

            protected BlockPos computeNext() {
                if (this.field_239591_b_ <= 0) {
                    return (BlockPos)this.endOfData();
                }
                Mutable blockpos = this.field_218297_b.func_181079_c(p_239585_2_ + p_239585_0_.nextInt(i), p_239585_3_ + p_239585_0_.nextInt(j), p_239585_4_ + p_239585_0_.nextInt(k));
                --this.field_239591_b_;
                return blockpos;
            }
        };
    }

    public static Iterable<BlockPos> func_239583_a_(BlockPos p_239583_0_, final int p_239583_1_, final int p_239583_2_, final int p_239583_3_) {
        final int i = p_239583_1_ + p_239583_2_ + p_239583_3_;
        final int j = p_239583_0_.func_177958_n();
        final int k = p_239583_0_.func_177956_o();
        final int l = p_239583_0_.func_177952_p();
        return () -> new AbstractIterator<BlockPos>(){
            private final Mutable field_218298_a = new Mutable();
            private int field_239604_i_;
            private int field_239605_j_;
            private int field_239606_k_;
            private int field_239607_l_;
            private int field_239608_m_;
            private boolean field_239609_n_;

            protected BlockPos computeNext() {
                if (this.field_239609_n_) {
                    this.field_239609_n_ = false;
                    this.field_218298_a.func_223472_q(l - (this.field_218298_a.func_177952_p() - l));
                    return this.field_218298_a;
                }
                Mutable blockpos = null;
                while (blockpos == null) {
                    if (this.field_239608_m_ > this.field_239606_k_) {
                        ++this.field_239607_l_;
                        if (this.field_239607_l_ > this.field_239605_j_) {
                            ++this.field_239604_i_;
                            if (this.field_239604_i_ > i) {
                                return (BlockPos)this.endOfData();
                            }
                            this.field_239605_j_ = Math.min(p_239583_1_, this.field_239604_i_);
                            this.field_239607_l_ = -this.field_239605_j_;
                        }
                        this.field_239606_k_ = Math.min(p_239583_2_, this.field_239604_i_ - Math.abs(this.field_239607_l_));
                        this.field_239608_m_ = -this.field_239606_k_;
                    }
                    int i1 = this.field_239607_l_;
                    int j1 = this.field_239608_m_;
                    int k1 = this.field_239604_i_ - Math.abs(i1) - Math.abs(j1);
                    if (k1 <= p_239583_3_) {
                        this.field_239609_n_ = k1 != 0;
                        blockpos = this.field_218298_a.func_181079_c(j + i1, k + j1, l + k1);
                    }
                    ++this.field_239608_m_;
                }
                return blockpos;
            }
        };
    }

    public static Optional<BlockPos> func_239584_a_(BlockPos p_239584_0_, int p_239584_1_, int p_239584_2_, Predicate<BlockPos> p_239584_3_) {
        return BlockPos.func_239588_b_(p_239584_0_, p_239584_1_, p_239584_2_, p_239584_1_).filter(p_239584_3_).findFirst();
    }

    public static Stream<BlockPos> func_239588_b_(BlockPos p_239588_0_, int p_239588_1_, int p_239588_2_, int p_239588_3_) {
        return StreamSupport.stream(BlockPos.func_239583_a_(p_239588_0_, p_239588_1_, p_239588_2_, p_239588_3_).spliterator(), false);
    }

    public static Iterable<BlockPos> func_218278_a(BlockPos p_218278_0_, BlockPos p_218278_1_) {
        return BlockPos.func_191531_b(Math.min(p_218278_0_.func_177958_n(), p_218278_1_.func_177958_n()), Math.min(p_218278_0_.func_177956_o(), p_218278_1_.func_177956_o()), Math.min(p_218278_0_.func_177952_p(), p_218278_1_.func_177952_p()), Math.max(p_218278_0_.func_177958_n(), p_218278_1_.func_177958_n()), Math.max(p_218278_0_.func_177956_o(), p_218278_1_.func_177956_o()), Math.max(p_218278_0_.func_177952_p(), p_218278_1_.func_177952_p()));
    }

    public static Stream<BlockPos> func_218281_b(BlockPos p_218281_0_, BlockPos p_218281_1_) {
        return StreamSupport.stream(BlockPos.func_218278_a(p_218281_0_, p_218281_1_).spliterator(), false);
    }

    public static Stream<BlockPos> func_229383_a_(MutableBoundingBox p_229383_0_) {
        return BlockPos.func_218287_a(Math.min(p_229383_0_.field_78897_a, p_229383_0_.field_78893_d), Math.min(p_229383_0_.field_78895_b, p_229383_0_.field_78894_e), Math.min(p_229383_0_.field_78896_c, p_229383_0_.field_78892_f), Math.max(p_229383_0_.field_78897_a, p_229383_0_.field_78893_d), Math.max(p_229383_0_.field_78895_b, p_229383_0_.field_78894_e), Math.max(p_229383_0_.field_78896_c, p_229383_0_.field_78892_f));
    }

    public static Stream<BlockPos> func_239581_a_(AxisAlignedBB p_239581_0_) {
        return BlockPos.func_218287_a(MathHelper.func_76128_c((double)p_239581_0_.field_72340_a), MathHelper.func_76128_c((double)p_239581_0_.field_72338_b), MathHelper.func_76128_c((double)p_239581_0_.field_72339_c), MathHelper.func_76128_c((double)p_239581_0_.field_72336_d), MathHelper.func_76128_c((double)p_239581_0_.field_72337_e), MathHelper.func_76128_c((double)p_239581_0_.field_72334_f));
    }

    public static Stream<BlockPos> func_218287_a(int p_218287_0_, int p_218287_1_, int p_218287_2_, int p_218287_3_, int p_218287_4_, int p_218287_5_) {
        return StreamSupport.stream(BlockPos.func_191531_b(p_218287_0_, p_218287_1_, p_218287_2_, p_218287_3_, p_218287_4_, p_218287_5_).spliterator(), false);
    }

    public static Iterable<BlockPos> func_191531_b(final int p_191531_0_, final int p_191531_1_, final int p_191531_2_, int p_191531_3_, int p_191531_4_, int p_191531_5_) {
        final int i = p_191531_3_ - p_191531_0_ + 1;
        final int j = p_191531_4_ - p_191531_1_ + 1;
        int k = p_191531_5_ - p_191531_2_ + 1;
        final int l = i * j * k;
        return () -> new AbstractIterator<BlockPos>(){
            private final Mutable field_239616_g_ = new Mutable();
            private int field_239617_h_;

            protected BlockPos computeNext() {
                if (this.field_239617_h_ == l) {
                    return (BlockPos)this.endOfData();
                }
                int i1 = this.field_239617_h_ % i;
                int j1 = this.field_239617_h_ / i;
                int k1 = j1 % j;
                int l1 = j1 / j;
                ++this.field_239617_h_;
                return this.field_239616_g_.func_181079_c(p_191531_0_ + i1, p_191531_1_ + k1, p_191531_2_ + l1);
            }
        };
    }

    public static Iterable<Mutable> func_243514_a(final BlockPos p_243514_0_, final int p_243514_1_, final Direction p_243514_2_, final Direction p_243514_3_) {
        Validate.validState((p_243514_2_.func_176740_k() != p_243514_3_.func_176740_k() ? 1 : 0) != 0, (String)"The two directions cannot be on the same axis", (Object[])new Object[0]);
        return () -> new AbstractIterator<Mutable>(){
            private final Direction[] field_243520_e;
            private final Mutable field_243521_f;
            private final int field_243522_g;
            private int field_243523_h;
            private int field_243524_i;
            private int field_243525_j;
            private int field_243526_k;
            private int field_243527_l;
            private int field_243528_m;
            {
                this.field_243520_e = new Direction[]{p_243514_2_, p_243514_3_, p_243514_2_.func_176734_d(), p_243514_3_.func_176734_d()};
                this.field_243521_f = p_243514_0_.func_239590_i_().func_189536_c(p_243514_3_);
                this.field_243522_g = 4 * p_243514_1_;
                this.field_243523_h = -1;
                this.field_243526_k = this.field_243521_f.func_177958_n();
                this.field_243527_l = this.field_243521_f.func_177956_o();
                this.field_243528_m = this.field_243521_f.func_177952_p();
            }

            protected Mutable computeNext() {
                this.field_243521_f.func_181079_c(this.field_243526_k, this.field_243527_l, this.field_243528_m).func_189536_c(this.field_243520_e[(this.field_243523_h + 4) % 4]);
                this.field_243526_k = this.field_243521_f.func_177958_n();
                this.field_243527_l = this.field_243521_f.func_177956_o();
                this.field_243528_m = this.field_243521_f.func_177952_p();
                if (this.field_243525_j >= this.field_243524_i) {
                    if (this.field_243523_h >= this.field_243522_g) {
                        return (Mutable)this.endOfData();
                    }
                    ++this.field_243523_h;
                    this.field_243525_j = 0;
                    this.field_243524_i = this.field_243523_h / 2 + 1;
                }
                ++this.field_243525_j;
                return this.field_243521_f;
            }
        };
    }

    static {
        field_177991_c = field_177990_b = 1 + MathHelper.func_151239_c((int)MathHelper.func_151236_b((int)30000000));
        field_177989_d = 64 - field_177990_b - field_177991_c;
        field_177994_h = (1L << field_177990_b) - 1L;
        field_177995_i = (1L << field_177989_d) - 1L;
        field_177993_j = (1L << field_177991_c) - 1L;
        field_218292_j = field_177989_d;
        field_218293_k = field_177989_d + field_177991_c;
    }

    public static class Mutable
    extends BlockPos {
        public Mutable() {
            this(0, 0, 0);
        }

        public Mutable(int p_i46024_1_, int p_i46024_2_, int p_i46024_3_) {
            super(p_i46024_1_, p_i46024_2_, p_i46024_3_);
        }

        public Mutable(double p_i50824_1_, double p_i50824_3_, double p_i50824_5_) {
            this(MathHelper.func_76128_c((double)p_i50824_1_), MathHelper.func_76128_c((double)p_i50824_3_), MathHelper.func_76128_c((double)p_i50824_5_));
        }

        @Override
        public BlockPos func_177963_a(double p_177963_1_, double p_177963_3_, double p_177963_5_) {
            return super.func_177963_a(p_177963_1_, p_177963_3_, p_177963_5_).func_185334_h();
        }

        @Override
        public BlockPos func_177982_a(int p_177982_1_, int p_177982_2_, int p_177982_3_) {
            return super.func_177982_a(p_177982_1_, p_177982_2_, p_177982_3_).func_185334_h();
        }

        @Override
        public BlockPos func_177967_a(Direction p_177967_1_, int p_177967_2_) {
            return super.func_177967_a(p_177967_1_, p_177967_2_).func_185334_h();
        }

        @Override
        public BlockPos func_241872_a(Direction.Axis p_241872_1_, int p_241872_2_) {
            return super.func_241872_a(p_241872_1_, p_241872_2_).func_185334_h();
        }

        @Override
        public BlockPos func_190942_a(Rotation p_190942_1_) {
            return super.func_190942_a(p_190942_1_).func_185334_h();
        }

        public final Mutable setValues(int i, int j, int k) {
            return this.func_181079_c(i, j, k);
        }

        public Mutable func_181079_c(int p_181079_1_, int p_181079_2_, int p_181079_3_) {
            this.func_223471_o(p_181079_1_);
            this.func_185336_p(p_181079_2_);
            this.func_223472_q(p_181079_3_);
            return this;
        }

        public final Mutable setValues(double d0, double d1, double d2) {
            return this.func_189532_c(d0, d1, d2);
        }

        public Mutable func_189532_c(double p_189532_1_, double p_189532_3_, double p_189532_5_) {
            return this.func_181079_c(MathHelper.func_76128_c((double)p_189532_1_), MathHelper.func_76128_c((double)p_189532_3_), MathHelper.func_76128_c((double)p_189532_5_));
        }

        public Mutable func_189533_g(Vector3i p_189533_1_) {
            return this.func_181079_c(p_189533_1_.func_177958_n(), p_189533_1_.func_177956_o(), p_189533_1_.func_177952_p());
        }

        public Mutable func_218294_g(long p_218294_1_) {
            return this.func_181079_c(Mutable.func_218290_b(p_218294_1_), Mutable.func_218274_c(p_218294_1_), Mutable.func_218282_d(p_218294_1_));
        }

        public Mutable func_218295_a(AxisRotation p_218295_1_, int p_218295_2_, int p_218295_3_, int p_218295_4_) {
            return this.func_181079_c(p_218295_1_.func_197517_a(p_218295_2_, p_218295_3_, p_218295_4_, Direction.Axis.X), p_218295_1_.func_197517_a(p_218295_2_, p_218295_3_, p_218295_4_, Direction.Axis.Y), p_218295_1_.func_197517_a(p_218295_2_, p_218295_3_, p_218295_4_, Direction.Axis.Z));
        }

        public Mutable func_239622_a_(Vector3i p_239622_1_, Direction p_239622_2_) {
            return this.func_181079_c(p_239622_1_.func_177958_n() + p_239622_2_.func_82601_c(), p_239622_1_.func_177956_o() + p_239622_2_.func_96559_d(), p_239622_1_.func_177952_p() + p_239622_2_.func_82599_e());
        }

        public Mutable func_239621_a_(Vector3i p_239621_1_, int p_239621_2_, int p_239621_3_, int p_239621_4_) {
            return this.func_181079_c(p_239621_1_.func_177958_n() + p_239621_2_, p_239621_1_.func_177956_o() + p_239621_3_, p_239621_1_.func_177952_p() + p_239621_4_);
        }

        public Mutable func_189536_c(Direction p_189536_1_) {
            return this.func_189534_c(p_189536_1_, 1);
        }

        public Mutable func_189534_c(Direction p_189534_1_, int p_189534_2_) {
            return this.func_181079_c(this.func_177958_n() + p_189534_1_.func_82601_c() * p_189534_2_, this.func_177956_o() + p_189534_1_.func_96559_d() * p_189534_2_, this.func_177952_p() + p_189534_1_.func_82599_e() * p_189534_2_);
        }

        public Mutable func_196234_d(int p_196234_1_, int p_196234_2_, int p_196234_3_) {
            return this.func_181079_c(this.func_177958_n() + p_196234_1_, this.func_177956_o() + p_196234_2_, this.func_177952_p() + p_196234_3_);
        }

        public Mutable func_243531_h(Vector3i p_243531_1_) {
            return this.func_181079_c(this.func_177958_n() + p_243531_1_.func_177958_n(), this.func_177956_o() + p_243531_1_.func_177956_o(), this.func_177952_p() + p_243531_1_.func_177952_p());
        }

        public Mutable func_239620_a_(Direction.Axis p_239620_1_, int p_239620_2_, int p_239620_3_) {
            switch (p_239620_1_) {
                case X: {
                    return this.func_181079_c(MathHelper.func_76125_a((int)this.func_177958_n(), (int)p_239620_2_, (int)p_239620_3_), this.func_177956_o(), this.func_177952_p());
                }
                case Y: {
                    return this.func_181079_c(this.func_177958_n(), MathHelper.func_76125_a((int)this.func_177956_o(), (int)p_239620_2_, (int)p_239620_3_), this.func_177952_p());
                }
                case Z: {
                    return this.func_181079_c(this.func_177958_n(), this.func_177956_o(), MathHelper.func_76125_a((int)this.func_177952_p(), (int)p_239620_2_, (int)p_239620_3_));
                }
            }
            throw new IllegalStateException("Unable to clamp axis " + p_239620_1_);
        }

        @Override
        public void func_223471_o(int p_223471_1_) {
            super.func_223471_o(p_223471_1_);
        }

        @Override
        public void func_185336_p(int p_185336_1_) {
            super.func_185336_p(p_185336_1_);
        }

        @Override
        public void func_223472_q(int p_223472_1_) {
            super.func_223472_q(p_223472_1_);
        }

        @Override
        public BlockPos func_185334_h() {
            return new BlockPos(this);
        }
    }
}

