/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.palette;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mohistmc.util.i18n.i18n;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ChestBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.StemBlock;
import net.minecraft.block.StemGrownBlock;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.ChestType;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Direction8;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.palette.PalettedContainer;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkSection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class UpgradeData {
    private static final Logger field_209162_b = LogManager.getLogger();
    public static final UpgradeData field_196994_a = new UpgradeData();
    private static final Direction8[] field_208832_b = Direction8.values();
    private final EnumSet<Direction8> field_196995_b = EnumSet.noneOf(Direction8.class);
    private final int[][] field_196996_c = new int[16][];
    private static final Map<Block, IBlockFixer> field_196997_d = new IdentityHashMap<Block, IBlockFixer>();
    private static final Set<IBlockFixer> field_208833_f = Sets.newHashSet();

    private UpgradeData() {
    }

    public UpgradeData(CompoundNBT p_i47714_1_) {
        this();
        if (p_i47714_1_.func_150297_b("Indices", 10)) {
            CompoundNBT compoundnbt = p_i47714_1_.func_74775_l("Indices");
            for (int i = 0; i < this.field_196996_c.length; ++i) {
                String s = String.valueOf(i);
                if (!compoundnbt.func_150297_b(s, 11)) continue;
                this.field_196996_c[i] = compoundnbt.func_74759_k(s);
            }
        }
        int j = p_i47714_1_.func_74762_e("Sides");
        for (Direction8 direction8 : Direction8.values()) {
            if ((j & 1 << direction8.ordinal()) == 0) continue;
            this.field_196995_b.add(direction8);
        }
    }

    public void func_196990_a(Chunk p_196990_1_) {
        this.func_196989_a(p_196990_1_);
        for (Direction8 direction8 : field_208832_b) {
            UpgradeData.func_196991_a(p_196990_1_, direction8);
        }
        World world = p_196990_1_.func_177412_p();
        field_208833_f.forEach(p_208829_1_ -> p_208829_1_.func_208826_a(world));
    }

    private static void func_196991_a(Chunk p_196991_0_, Direction8 p_196991_1_) {
        World world = p_196991_0_.func_177412_p();
        if (p_196991_0_.func_196966_y().field_196995_b.remove(p_196991_1_)) {
            Set set = p_196991_1_.func_197532_a();
            boolean i = false;
            int j = 15;
            boolean flag = set.contains((Object)Direction.EAST);
            boolean flag1 = set.contains((Object)Direction.WEST);
            boolean flag2 = set.contains((Object)Direction.SOUTH);
            boolean flag3 = set.contains((Object)Direction.NORTH);
            boolean flag4 = set.size() == 1;
            ChunkPos chunkpos = p_196991_0_.func_76632_l();
            int k = chunkpos.func_180334_c() + (!flag4 || !flag3 && !flag2 ? (flag1 ? 0 : 15) : 1);
            int l = chunkpos.func_180334_c() + (!flag4 || !flag3 && !flag2 ? (flag1 ? 0 : 15) : 14);
            int i1 = chunkpos.func_180333_d() + (!flag4 || !flag && !flag1 ? (flag3 ? 0 : 15) : 1);
            int j1 = chunkpos.func_180333_d() + (!flag4 || !flag && !flag1 ? (flag3 ? 0 : 15) : 14);
            Direction[] adirection = Direction.values();
            BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
            for (BlockPos blockpos : BlockPos.func_191531_b(k, 0, i1, l, world.func_217301_I() - 1, j1)) {
                BlockState blockstate;
                BlockState blockstate1 = blockstate = world.func_180495_p(blockpos);
                for (Direction direction : adirection) {
                    blockpos$mutable.func_239622_a_(blockpos, direction);
                    blockstate1 = UpgradeData.func_196987_a(blockstate1, direction, world, blockpos, blockpos$mutable);
                }
                Block.func_196263_a(blockstate, blockstate1, world, blockpos, 18);
            }
        }
    }

    private static BlockState func_196987_a(BlockState p_196987_0_, Direction p_196987_1_, IWorld p_196987_2_, BlockPos p_196987_3_, BlockPos p_196987_4_) {
        return field_196997_d.getOrDefault((Object)p_196987_0_.func_177230_c(), BlockFixers.DEFAULT).func_196982_a(p_196987_0_, p_196987_1_, p_196987_2_.func_180495_p(p_196987_4_), p_196987_2_, p_196987_3_, p_196987_4_);
    }

    private void func_196989_a(Chunk p_196989_1_) {
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        BlockPos.Mutable blockpos$mutable1 = new BlockPos.Mutable();
        ChunkPos chunkpos = p_196989_1_.func_76632_l();
        World iworld = p_196989_1_.func_177412_p();
        for (int i = 0; i < 16; ++i) {
            ChunkSection chunksection = p_196989_1_.func_76587_i()[i];
            int[] aint = this.field_196996_c[i];
            this.field_196996_c[i] = null;
            if (chunksection == null || aint == null || aint.length <= 0) continue;
            Direction[] adirection = Direction.values();
            PalettedContainer<BlockState> palettedcontainer = chunksection.func_186049_g();
            for (int j : aint) {
                BlockState blockstate;
                int k = j & 0xF;
                int l = j >> 8 & 0xF;
                int i1 = j >> 4 & 0xF;
                blockpos$mutable.func_181079_c(chunkpos.func_180334_c() + k, (i << 4) + l, chunkpos.func_180333_d() + i1);
                BlockState blockstate1 = blockstate = palettedcontainer.func_186015_a(j);
                for (Direction direction : adirection) {
                    blockpos$mutable1.func_239622_a_(blockpos$mutable, direction);
                    if (blockpos$mutable.func_177958_n() >> 4 != chunkpos.field_77276_a || blockpos$mutable.func_177952_p() >> 4 != chunkpos.field_77275_b) continue;
                    blockstate1 = UpgradeData.func_196987_a(blockstate1, direction, iworld, blockpos$mutable, blockpos$mutable1);
                }
                Block.func_196263_a(blockstate, blockstate1, iworld, blockpos$mutable, 18);
            }
        }
        for (int j1 = 0; j1 < this.field_196996_c.length; ++j1) {
            if (this.field_196996_c[j1] != null) {
                field_209162_b.warn(i18n.get((String)"upgradedata.1", (Object[])new Object[]{j1, chunkpos.field_77276_a, chunkpos.field_77275_b}));
            }
            this.field_196996_c[j1] = null;
        }
    }

    public boolean func_196988_a() {
        for (int[] aint : this.field_196996_c) {
            if (aint == null) continue;
            return false;
        }
        return this.field_196995_b.isEmpty();
    }

    public CompoundNBT func_196992_b() {
        CompoundNBT compoundnbt = new CompoundNBT();
        CompoundNBT compoundnbt1 = new CompoundNBT();
        for (int i = 0; i < this.field_196996_c.length; ++i) {
            String s = String.valueOf(i);
            if (this.field_196996_c[i] == null || this.field_196996_c[i].length == 0) continue;
            compoundnbt1.func_74783_a(s, this.field_196996_c[i]);
        }
        if (!compoundnbt1.isEmpty()) {
            compoundnbt.func_218657_a("Indices", compoundnbt1);
        }
        int j = 0;
        for (Direction8 direction8 : this.field_196995_b) {
            j |= 1 << direction8.ordinal();
        }
        compoundnbt.func_74774_a("Sides", (byte)j);
        return compoundnbt;
    }

    public static interface IBlockFixer {
        public BlockState func_196982_a(BlockState var1, Direction var2, BlockState var3, IWorld var4, BlockPos var5, BlockPos var6);

        default public void func_208826_a(IWorld p_208826_1_) {
        }
    }

    static enum BlockFixers implements IBlockFixer
    {
        BLACKLIST(new Block[]{Blocks.field_190976_dk, Blocks.field_150427_aO, Blocks.field_196860_iS, Blocks.field_196862_iT, Blocks.field_196864_iU, Blocks.field_196866_iV, Blocks.field_196868_iW, Blocks.field_196870_iX, Blocks.field_196872_iY, Blocks.field_196874_iZ, Blocks.field_196877_ja, Blocks.field_196878_jb, Blocks.field_196879_jc, Blocks.field_196880_jd, Blocks.field_196881_je, Blocks.field_196882_jf, Blocks.field_196883_jg, Blocks.field_196884_jh, Blocks.field_150467_bQ, Blocks.field_196717_eY, Blocks.field_196718_eZ, Blocks.field_150380_bt, Blocks.field_150351_n, Blocks.field_150354_m, Blocks.field_196611_F, Blocks.field_222384_bX, Blocks.field_222385_bY, Blocks.field_222386_bZ, Blocks.field_222389_ca, Blocks.field_222390_cb, Blocks.field_222391_cc, Blocks.field_222392_ch, Blocks.field_222393_ci, Blocks.field_222394_cj, Blocks.field_222395_ck, Blocks.field_222396_cl, Blocks.field_222397_cm}){

            @Override
            public BlockState func_196982_a(BlockState p_196982_1_, Direction p_196982_2_, BlockState p_196982_3_, IWorld p_196982_4_, BlockPos p_196982_5_, BlockPos p_196982_6_) {
                return p_196982_1_;
            }
        }
        ,
        DEFAULT(new Block[0]){

            @Override
            public BlockState func_196982_a(BlockState p_196982_1_, Direction p_196982_2_, BlockState p_196982_3_, IWorld p_196982_4_, BlockPos p_196982_5_, BlockPos p_196982_6_) {
                return p_196982_1_.func_196956_a(p_196982_2_, p_196982_4_.func_180495_p(p_196982_6_), p_196982_4_, p_196982_5_, p_196982_6_);
            }
        }
        ,
        CHEST(new Block[]{Blocks.field_150486_ae, Blocks.field_150447_bR}){

            @Override
            public BlockState func_196982_a(BlockState p_196982_1_, Direction p_196982_2_, BlockState p_196982_3_, IWorld p_196982_4_, BlockPos p_196982_5_, BlockPos p_196982_6_) {
                if (p_196982_3_.func_203425_a(p_196982_1_.func_177230_c()) && p_196982_2_.func_176740_k().func_176722_c() && p_196982_1_.func_177229_b(ChestBlock.field_196314_b) == ChestType.SINGLE && p_196982_3_.func_177229_b(ChestBlock.field_196314_b) == ChestType.SINGLE) {
                    Direction direction = (Direction)((Object)p_196982_1_.func_177229_b(ChestBlock.field_176459_a));
                    if (p_196982_2_.func_176740_k() != direction.func_176740_k() && direction == p_196982_3_.func_177229_b(ChestBlock.field_176459_a)) {
                        ChestType chesttype = p_196982_2_ == direction.func_176746_e() ? ChestType.LEFT : ChestType.RIGHT;
                        p_196982_4_.func_180501_a(p_196982_6_, (BlockState)p_196982_3_.func_206870_a(ChestBlock.field_196314_b, chesttype.func_208081_a()), 18);
                        if (direction == Direction.NORTH || direction == Direction.EAST) {
                            TileEntity tileentity = p_196982_4_.func_175625_s(p_196982_5_);
                            TileEntity tileentity1 = p_196982_4_.func_175625_s(p_196982_6_);
                            if (tileentity instanceof ChestTileEntity && tileentity1 instanceof ChestTileEntity) {
                                ChestTileEntity.func_199722_a((ChestTileEntity)tileentity, (ChestTileEntity)tileentity1);
                            }
                        }
                        return (BlockState)p_196982_1_.func_206870_a(ChestBlock.field_196314_b, chesttype);
                    }
                }
                return p_196982_1_;
            }
        }
        ,
        LEAVES(true, new Block[]{Blocks.field_196572_aa, Blocks.field_196647_Y, Blocks.field_196574_ab, Blocks.field_196648_Z, Blocks.field_196642_W, Blocks.field_196645_X}){
            private final ThreadLocal<List<ObjectSet<BlockPos>>> field_208828_g = ThreadLocal.withInitial(() -> Lists.newArrayListWithCapacity((int)7));

            @Override
            public BlockState func_196982_a(BlockState p_196982_1_, Direction p_196982_2_, BlockState p_196982_3_, IWorld p_196982_4_, BlockPos p_196982_5_, BlockPos p_196982_6_) {
                BlockState blockstate = p_196982_1_.func_196956_a(p_196982_2_, p_196982_4_.func_180495_p(p_196982_6_), p_196982_4_, p_196982_5_, p_196982_6_);
                if (p_196982_1_ != blockstate) {
                    int i = blockstate.func_177229_b(BlockStateProperties.field_208514_aa);
                    List<ObjectSet<BlockPos>> list = this.field_208828_g.get();
                    if (list.isEmpty()) {
                        for (int j = 0; j < 7; ++j) {
                            list.add((ObjectSet<BlockPos>)new ObjectOpenHashSet());
                        }
                    }
                    list.get(i).add((Object)p_196982_5_.func_185334_h());
                }
                return p_196982_1_;
            }

            @Override
            public void func_208826_a(IWorld p_208826_1_) {
                BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
                List<ObjectSet<BlockPos>> list = this.field_208828_g.get();
                for (int i = 2; i < list.size(); ++i) {
                    int j = i - 1;
                    ObjectSet<BlockPos> objectset = list.get(j);
                    ObjectSet<BlockPos> objectset1 = list.get(i);
                    for (BlockPos blockpos : objectset) {
                        BlockState blockstate = p_208826_1_.func_180495_p(blockpos);
                        if (blockstate.func_177229_b(BlockStateProperties.field_208514_aa) < j) continue;
                        p_208826_1_.func_180501_a(blockpos, (BlockState)blockstate.func_206870_a(BlockStateProperties.field_208514_aa, j), 18);
                        if (i == 7) continue;
                        for (Direction direction : field_208827_f) {
                            blockpos$mutable.func_239622_a_(blockpos, direction);
                            BlockState blockstate1 = p_208826_1_.func_180495_p(blockpos$mutable);
                            if (!blockstate1.func_235901_b_(BlockStateProperties.field_208514_aa) || blockstate.func_177229_b(BlockStateProperties.field_208514_aa) <= i) continue;
                            objectset1.add((Object)blockpos$mutable.func_185334_h());
                        }
                    }
                }
                list.clear();
            }
        }
        ,
        STEM_BLOCK(new Block[]{Blocks.field_150394_bc, Blocks.field_150393_bb}){

            @Override
            public BlockState func_196982_a(BlockState p_196982_1_, Direction p_196982_2_, BlockState p_196982_3_, IWorld p_196982_4_, BlockPos p_196982_5_, BlockPos p_196982_6_) {
                StemGrownBlock stemgrownblock;
                if (p_196982_1_.func_177229_b(StemBlock.field_176484_a) == 7 && p_196982_3_.func_203425_a((Block)(stemgrownblock = ((StemBlock)p_196982_1_.func_177230_c()).func_208486_d()))) {
                    return (BlockState)stemgrownblock.func_196523_e().func_176223_P().func_206870_a(HorizontalBlock.field_185512_D, p_196982_2_);
                }
                return p_196982_1_;
            }
        };

        public static final Direction[] field_208827_f;

        private BlockFixers(Block ... p_i47847_3_) {
            this(false, p_i47847_3_);
        }

        private BlockFixers(boolean p_i49366_3_, Block ... p_i49366_4_) {
            for (Block block : p_i49366_4_) {
                field_196997_d.put(block, this);
            }
            if (p_i49366_3_) {
                field_208833_f.add(this);
            }
        }

        static {
            field_208827_f = Direction.values();
        }
    }
}

