/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.village;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mohistmc.util.i18n.i18n;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.SectionPos;
import net.minecraft.village.PointOfInterest;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.village.PointOfInterestType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;

public class PointOfInterestData {
    private static final Logger field_218255_a = LogManager.getLogger();
    private final Short2ObjectMap<PointOfInterest> field_218256_b = new Short2ObjectOpenHashMap();
    private final Map<PointOfInterestType, Set<PointOfInterest>> field_218257_c = Maps.newHashMap();
    private final Runnable field_218258_d;
    private boolean field_218259_e;

    public static Codec<PointOfInterestData> func_234158_a_(Runnable p_234158_0_) {
        return RecordCodecBuilder.create(p_234159_1_ -> p_234159_1_.group((App)RecordCodecBuilder.point((Object)p_234158_0_), (App)Codec.BOOL.optionalFieldOf("Valid", (Object)false).forGetter(p_234162_0_ -> p_234162_0_.field_218259_e), (App)PointOfInterest.func_234150_a_((Runnable)p_234158_0_).listOf().fieldOf("Records").forGetter(p_234154_0_ -> ImmutableList.copyOf((Collection)p_234154_0_.field_218256_b.values()))).apply((Applicative)p_234159_1_, PointOfInterestData::new)).orElseGet(Util.func_240982_a_("Failed to read POI section: ", arg_0 -> ((Logger)field_218255_a).error(arg_0)), () -> new PointOfInterestData(p_234158_0_, false, (List<PointOfInterest>)ImmutableList.of()));
    }

    public PointOfInterestData(Runnable p_i50293_1_) {
        this(p_i50293_1_, true, (List<PointOfInterest>)ImmutableList.of());
    }

    private PointOfInterestData(Runnable p_i231555_1_, boolean p_i231555_2_, List<PointOfInterest> p_i231555_3_) {
        this.field_218258_d = p_i231555_1_;
        this.field_218259_e = p_i231555_2_;
        p_i231555_3_.forEach(this::func_218254_a);
    }

    public Stream<PointOfInterest> func_218247_a(Predicate<PointOfInterestType> p_218247_1_, PointOfInterestManager.Status p_218247_2_) {
        return this.field_218257_c.entrySet().stream().filter(p_234161_1_ -> p_218247_1_.test((PointOfInterestType)((Object)((Object)p_234161_1_.getKey())))).flatMap(p_234160_0_ -> ((Set)p_234160_0_.getValue()).stream()).filter(p_218247_2_.func_221035_a());
    }

    public void func_218243_a(BlockPos p_218243_1_, PointOfInterestType p_218243_2_) {
        if (this.func_218254_a(new PointOfInterest(p_218243_1_, p_218243_2_, this.field_218258_d))) {
            field_218255_a.debug("Added POI of type {} @ {}", new Supplier[]{() -> p_218243_2_, () -> p_218243_1_});
            this.field_218258_d.run();
        }
    }

    private boolean func_218254_a(PointOfInterest p_218254_1_) {
        BlockPos blockpos = p_218254_1_.func_218261_f();
        PointOfInterestType pointofinteresttype = p_218254_1_.func_218260_g();
        short short1 = SectionPos.func_218150_b((BlockPos)blockpos);
        PointOfInterest pointofinterest = (PointOfInterest)this.field_218256_b.get(short1);
        if (pointofinterest != null) {
            if (((Object)((Object)pointofinteresttype)).equals((Object)pointofinterest.func_218260_g())) {
                return false;
            }
            String s = "POI data mismatch: already registered at " + blockpos;
            if (SharedConstants.field_206244_b) {
                throw Util.func_229757_c_(new IllegalStateException(s));
            }
            field_218255_a.error(s);
        }
        this.field_218256_b.put(short1, (Object)p_218254_1_);
        this.field_218257_c.computeIfAbsent(pointofinteresttype, p_234155_0_ -> Sets.newHashSet()).add(p_218254_1_);
        return true;
    }

    public void func_218248_a(BlockPos p_218248_1_) {
        PointOfInterest pointofinterest = (PointOfInterest)this.field_218256_b.remove(SectionPos.func_218150_b((BlockPos)p_218248_1_));
        if (pointofinterest == null) {
            field_218255_a.error("POI data mismatch: never registered at " + p_218248_1_);
        } else {
            this.field_218257_c.get((Object)pointofinterest.func_218260_g()).remove(pointofinterest);
            field_218255_a.debug(i18n.get((String)"pointofinterestdata.1", (Object[])new Object[]{pointofinterest.func_218260_g(), pointofinterest.func_218261_f()}));
            this.field_218258_d.run();
        }
    }

    public boolean func_218251_c(BlockPos p_218251_1_) {
        PointOfInterest pointofinterest = (PointOfInterest)this.field_218256_b.get(SectionPos.func_218150_b((BlockPos)p_218251_1_));
        if (pointofinterest == null) {
            throw Util.func_229757_c_(new IllegalStateException("POI never registered at " + p_218251_1_));
        }
        boolean flag = pointofinterest.func_218264_c();
        this.field_218258_d.run();
        return flag;
    }

    public boolean func_218245_a(BlockPos p_218245_1_, Predicate<PointOfInterestType> p_218245_2_) {
        short short1 = SectionPos.func_218150_b((BlockPos)p_218245_1_);
        PointOfInterest pointofinterest = (PointOfInterest)this.field_218256_b.get(short1);
        return pointofinterest != null && p_218245_2_.test(pointofinterest.func_218260_g());
    }

    public Optional<PointOfInterestType> func_218244_d(BlockPos p_218244_1_) {
        short short1 = SectionPos.func_218150_b((BlockPos)p_218244_1_);
        PointOfInterest pointofinterest = (PointOfInterest)this.field_218256_b.get(short1);
        return pointofinterest != null ? Optional.of(pointofinterest.func_218260_g()) : Optional.empty();
    }

    public void func_218240_a(Consumer<BiConsumer<BlockPos, PointOfInterestType>> p_218240_1_) {
        if (!this.field_218259_e) {
            Short2ObjectOpenHashMap short2objectmap = new Short2ObjectOpenHashMap(this.field_218256_b);
            this.func_218253_a();
            p_218240_1_.accept((arg_0, arg_1) -> this.func_234157_a_((Short2ObjectMap)short2objectmap, arg_0, arg_1));
            this.field_218259_e = true;
            this.field_218258_d.run();
        }
    }

    private void func_218253_a() {
        this.field_218256_b.clear();
        this.field_218257_c.clear();
    }

    boolean func_226355_a_() {
        return this.field_218259_e;
    }

    private /* synthetic */ void func_234157_a_(Short2ObjectMap short2objectmap, BlockPos p_234157_2_, PointOfInterestType p_234157_3_) {
        short short1 = SectionPos.func_218150_b((BlockPos)p_234157_2_);
        PointOfInterest pointofinterest = (PointOfInterest)short2objectmap.computeIfAbsent(short1, p_234156_3_ -> new PointOfInterest(p_234157_2_, p_234157_3_, this.field_218258_d));
        this.func_218254_a(pointofinterest);
    }
}

