/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ITickList;
import net.minecraft.world.NextTickListEntry;
import net.minecraft.world.TickPriority;

public class SerializableTickList<T>
implements ITickList<T> {
    private final List<TickHolder<T>> field_219500_a;
    private final Function<T, ResourceLocation> field_219501_b;
    private static final int MAX_TICK_DELAY = Integer.getInteger("paper.ticklist-max-tick-delay", -1);

    public SerializableTickList(Function<T, ResourceLocation> p_i231603_1_, List<NextTickListEntry<T>> p_i231603_2_, long p_i231603_3_) {
        this(p_i231603_1_, p_i231603_2_.stream().map(p_234854_2_ -> new TickHolder(p_234854_2_.func_151351_a(), p_234854_2_.field_180282_a, (int)(p_234854_2_.field_235017_b_ - p_i231603_3_), p_234854_2_.field_82754_f)).collect(Collectors.toList()));
    }

    private SerializableTickList(Function<T, ResourceLocation> p_i50010_1_, List<TickHolder<T>> p_i50010_2_) {
        this.field_219500_a = p_i50010_2_;
        this.field_219501_b = p_i50010_1_;
    }

    public boolean func_205359_a(BlockPos p_205359_1_, T p_205359_2_) {
        return false;
    }

    public void func_205362_a(BlockPos p_205362_1_, T p_205362_2_, int p_205362_3_, TickPriority p_205362_4_) {
        this.field_219500_a.add(new TickHolder(p_205362_2_, p_205362_1_, p_205362_3_, p_205362_4_));
    }

    public boolean func_205361_b(BlockPos p_205361_1_, T p_205361_2_) {
        return false;
    }

    public ListNBT func_234857_b_() {
        ListNBT listnbt = new ListNBT();
        for (TickHolder<T> tickholder : this.field_219500_a) {
            CompoundNBT compoundnbt = new CompoundNBT();
            compoundnbt.func_74778_a("i", this.field_219501_b.apply(((TickHolder)tickholder).field_234861_d_).toString());
            compoundnbt.func_74768_a("x", tickholder.field_234858_a_.func_177958_n());
            compoundnbt.func_74768_a("y", tickholder.field_234858_a_.func_177956_o());
            compoundnbt.func_74768_a("z", tickholder.field_234858_a_.func_177952_p());
            compoundnbt.func_74768_a("t", tickholder.field_234859_b_);
            compoundnbt.func_74768_a("p", tickholder.field_234860_c_.func_205398_a());
            listnbt.add((Object)compoundnbt);
        }
        return listnbt;
    }

    public static <T> SerializableTickList<T> func_222984_a(ListNBT p_222984_0_, Function<T, ResourceLocation> p_222984_1_, Function<ResourceLocation, T> p_222984_2_) {
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < p_222984_0_.size(); ++i) {
            CompoundNBT compoundnbt = p_222984_0_.func_150305_b(i);
            T t = p_222984_2_.apply(new ResourceLocation(compoundnbt.func_74779_i("i")));
            if (t == null) continue;
            BlockPos blockpos = new BlockPos(compoundnbt.func_74762_e("x"), compoundnbt.func_74762_e("y"), compoundnbt.func_74762_e("z"));
            list.add(new TickHolder(t, blockpos, compoundnbt.func_74762_e("t"), TickPriority.func_205397_a((int)compoundnbt.func_74762_e("p"))));
            int delay = compoundnbt.func_74762_e("t");
            if (MAX_TICK_DELAY > 0 && delay > MAX_TICK_DELAY) continue;
            list.add(new TickHolder(t, blockpos, delay, TickPriority.func_205397_a((int)compoundnbt.func_74762_e("p"))));
        }
        return new SerializableTickList<T>(p_222984_1_, list);
    }

    public void func_234855_a_(ITickList<T> p_234855_1_) {
        this.field_219500_a.forEach(p_234856_1_ -> p_234855_1_.func_205362_a(p_234856_1_.field_234858_a_, ((TickHolder)p_234856_1_).field_234861_d_, p_234856_1_.field_234859_b_, p_234856_1_.field_234860_c_));
    }

    static class TickHolder<T> {
        private final T field_234861_d_;
        public final BlockPos field_234858_a_;
        public final int field_234859_b_;
        public final TickPriority field_234860_c_;

        private TickHolder(T p_i231604_1_, BlockPos p_i231604_2_, int p_i231604_3_, TickPriority p_i231604_4_) {
            this.field_234861_d_ = p_i231604_1_;
            this.field_234858_a_ = p_i231604_2_;
            this.field_234859_b_ = p_i231604_3_;
            this.field_234860_c_ = p_i231604_4_;
        }

        public String toString() {
            return this.field_234861_d_ + ": " + this.field_234858_a_ + ", " + this.field_234859_b_ + ", " + this.field_234860_c_;
        }
    }
}

