/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.border;

import com.google.common.collect.Lists;
import com.mojang.serialization.DynamicLike;
import io.papermc.paper.event.world.border.WorldBorderBoundsChangeEvent;
import io.papermc.paper.event.world.border.WorldBorderBoundsChangeFinishEvent;
import io.papermc.paper.event.world.border.WorldBorderCenterChangeEvent;
import java.util.List;
import java.util.Objects;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.border.BorderStatus;
import net.minecraft.world.border.IBorderListener;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.event.Event;

public class WorldBorder {
    private final List<IBorderListener> field_177758_a = Lists.newArrayList();
    private double field_177763_i = 0.2;
    private double field_177760_j = 5.0;
    private int field_177761_k = 15;
    private int field_177759_l = 5;
    private double field_177756_b;
    private double field_177757_c;
    private int field_177762_h = 29999984;
    private IBorderInfo field_212674_i = new StationaryBorderInfo(6.0E7);
    public static final Serializer field_235925_b_ = new Serializer(0.0, 0.0, 0.2, 5.0, 5, 15, 6.0E7, 0L, 0.0);
    public ServerWorld world;

    public boolean func_177746_a(BlockPos p_177746_1_) {
        return (double)(p_177746_1_.func_177958_n() + 1) > this.func_177726_b() && (double)p_177746_1_.func_177958_n() < this.func_177728_d() && (double)(p_177746_1_.func_177952_p() + 1) > this.func_177736_c() && (double)p_177746_1_.func_177952_p() < this.func_177733_e();
    }

    public boolean func_177730_a(ChunkPos p_177730_1_) {
        return (double)p_177730_1_.func_180332_e() > this.func_177726_b() && (double)p_177730_1_.func_180334_c() < this.func_177728_d() && (double)p_177730_1_.func_180330_f() > this.func_177736_c() && (double)p_177730_1_.func_180333_d() < this.func_177733_e();
    }

    public boolean func_177743_a(AxisAlignedBB p_177743_1_) {
        return p_177743_1_.field_72336_d > this.func_177726_b() && p_177743_1_.field_72340_a < this.func_177728_d() && p_177743_1_.field_72334_f > this.func_177736_c() && p_177743_1_.field_72339_c < this.func_177733_e();
    }

    public double func_177745_a(Entity p_177745_1_) {
        return this.func_177729_b(p_177745_1_.func_226277_ct_(), p_177745_1_.func_226281_cx_());
    }

    public final VoxelShape asVoxelShape() {
        return this.func_222521_a();
    }

    public VoxelShape func_222521_a() {
        return this.field_212674_i.func_222517_m();
    }

    public double func_177729_b(double p_177729_1_, double p_177729_3_) {
        double d0 = p_177729_3_ - this.func_177736_c();
        double d1 = this.func_177733_e() - p_177729_3_;
        double d2 = p_177729_1_ - this.func_177726_b();
        double d3 = this.func_177728_d() - p_177729_1_;
        double d4 = Math.min(d2, d3);
        d4 = Math.min(d4, d0);
        return Math.min(d4, d1);
    }

    @OnlyIn(value=Dist.CLIENT)
    public BorderStatus func_177734_a() {
        return this.field_212674_i.func_212655_i();
    }

    public double func_177726_b() {
        return this.field_212674_i.func_212658_a();
    }

    public double func_177736_c() {
        return this.field_212674_i.func_212656_c();
    }

    public double func_177728_d() {
        return this.field_212674_i.func_212654_b();
    }

    public double func_177733_e() {
        return this.field_212674_i.func_212648_d();
    }

    public double func_230316_a_() {
        return this.field_177756_b;
    }

    public double func_230317_b_() {
        return this.field_177757_c;
    }

    public void func_177739_c(double p_177739_1_, double p_177739_3_) {
        WorldBorderCenterChangeEvent event = new WorldBorderCenterChangeEvent((World)this.world.getWorld(), this.world.getWorld().getWorldBorder(), new Location((World)this.world.getWorld(), this.func_230316_a_(), 0.0, this.func_230317_b_()), new Location((World)this.world.getWorld(), p_177739_1_, 0.0, p_177739_3_));
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        this.field_177756_b = event.getNewCenter().getX();
        this.field_177757_c = event.getNewCenter().getZ();
        this.field_212674_i.func_212653_k();
        for (IBorderListener iborderlistener : this.func_177735_k()) {
            iborderlistener.func_177693_a(this, event.getNewCenter().getX(), event.getNewCenter().getZ());
        }
    }

    public double func_177741_h() {
        return this.field_212674_i.func_212647_e();
    }

    public long func_177732_i() {
        return this.field_212674_i.func_212657_g();
    }

    public double func_177751_j() {
        return this.field_212674_i.func_212650_h();
    }

    public void func_177750_a(double p_177750_1_) {
        WorldBorderBoundsChangeEvent event = new WorldBorderBoundsChangeEvent((World)this.world.getWorld(), this.world.getWorld().getWorldBorder(), WorldBorderBoundsChangeEvent.Type.INSTANT_MOVE, this.func_177741_h(), p_177750_1_, 0L);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        if (event.getType() == WorldBorderBoundsChangeEvent.Type.STARTED_MOVE && event.getDuration() > 0L) {
            this.func_177738_a(event.getOldSize(), event.getNewSize(), event.getDuration());
            return;
        }
        this.field_212674_i = new StationaryBorderInfo(event.getNewSize());
        for (IBorderListener iborderlistener : this.func_177735_k()) {
            iborderlistener.func_177694_a(this, event.getNewSize());
        }
    }

    public void func_177738_a(double p_177738_1_, double p_177738_3_, long p_177738_5_) {
        WorldBorderBoundsChangeEvent.Type type = p_177738_1_ == p_177738_3_ ? WorldBorderBoundsChangeEvent.Type.INSTANT_MOVE : WorldBorderBoundsChangeEvent.Type.STARTED_MOVE;
        WorldBorderBoundsChangeEvent event = new WorldBorderBoundsChangeEvent((World)this.world.getWorld(), this.world.getWorld().getWorldBorder(), type, p_177738_1_, p_177738_3_, p_177738_5_);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        this.field_212674_i = p_177738_1_ == event.getNewSize() ? new StationaryBorderInfo(event.getNewSize()) : new MovingBorderInfo(p_177738_1_, event.getNewSize(), event.getDuration());
        for (IBorderListener iborderlistener : this.func_177735_k()) {
            iborderlistener.func_177692_a(this, p_177738_1_, event.getNewSize(), event.getDuration());
        }
    }

    protected List<IBorderListener> func_177735_k() {
        return Lists.newArrayList(this.field_177758_a);
    }

    public void func_177737_a(IBorderListener p_177737_1_) {
        if (this.field_177758_a.contains(p_177737_1_)) {
            return;
        }
        this.field_177758_a.add(p_177737_1_);
    }

    public void removeListener(IBorderListener listener) {
        this.field_177758_a.remove(listener);
    }

    public void func_177725_a(int p_177725_1_) {
        this.field_177762_h = p_177725_1_;
        this.field_212674_i.func_212652_j();
    }

    public int func_177722_l() {
        return this.field_177762_h;
    }

    public double func_177742_m() {
        return this.field_177760_j;
    }

    public void func_177724_b(double p_177724_1_) {
        this.field_177760_j = p_177724_1_;
        for (IBorderListener iborderlistener : this.func_177735_k()) {
            iborderlistener.func_177695_c(this, p_177724_1_);
        }
    }

    public double func_177727_n() {
        return this.field_177763_i;
    }

    public void func_177744_c(double p_177744_1_) {
        this.field_177763_i = p_177744_1_;
        for (IBorderListener iborderlistener : this.func_177735_k()) {
            iborderlistener.func_177696_b(this, p_177744_1_);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public double func_177749_o() {
        return this.field_212674_i.func_212649_f();
    }

    public int func_177740_p() {
        return this.field_177761_k;
    }

    public void func_177723_b(int p_177723_1_) {
        this.field_177761_k = p_177723_1_;
        for (IBorderListener iborderlistener : this.func_177735_k()) {
            iborderlistener.func_177691_a(this, p_177723_1_);
        }
    }

    public int func_177748_q() {
        return this.field_177759_l;
    }

    public void func_177747_c(int p_177747_1_) {
        this.field_177759_l = p_177747_1_;
        for (IBorderListener iborderlistener : this.func_177735_k()) {
            iborderlistener.func_177690_b(this, p_177747_1_);
        }
    }

    public void func_212673_r() {
        this.field_212674_i = this.field_212674_i.func_212651_l();
    }

    public Serializer func_235927_t_() {
        return new Serializer(this);
    }

    public void func_235926_a_(Serializer p_235926_1_) {
        this.func_177739_c(p_235926_1_.func_235937_a_(), p_235926_1_.func_235940_b_());
        this.func_177744_c(p_235926_1_.func_235941_c_());
        this.func_177724_b(p_235926_1_.func_235942_d_());
        this.func_177747_c(p_235926_1_.func_235943_e_());
        this.func_177723_b(p_235926_1_.func_235944_f_());
        if (p_235926_1_.func_235946_h_() > 0L) {
            this.func_177738_a(p_235926_1_.func_235945_g_(), p_235926_1_.func_235947_i_(), p_235926_1_.func_235946_h_());
        } else {
            this.func_177750_a(p_235926_1_.func_235945_g_());
        }
    }

    class StationaryBorderInfo
    implements IBorderInfo {
        private final double field_212667_b;
        private double field_212668_c;
        private double field_212669_d;
        private double field_212670_e;
        private double field_212671_f;
        private VoxelShape field_222518_g;

        public StationaryBorderInfo(double p_i49837_2_) {
            this.field_212667_b = p_i49837_2_;
            this.func_212665_m();
        }

        @Override
        public double func_212658_a() {
            return this.field_212668_c;
        }

        @Override
        public double func_212654_b() {
            return this.field_212670_e;
        }

        @Override
        public double func_212656_c() {
            return this.field_212669_d;
        }

        @Override
        public double func_212648_d() {
            return this.field_212671_f;
        }

        @Override
        public double func_212647_e() {
            return this.field_212667_b;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public BorderStatus func_212655_i() {
            return BorderStatus.STATIONARY;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public double func_212649_f() {
            return 0.0;
        }

        @Override
        public long func_212657_g() {
            return 0L;
        }

        @Override
        public double func_212650_h() {
            return this.field_212667_b;
        }

        private void func_212665_m() {
            this.field_212668_c = Math.max(WorldBorder.this.func_230316_a_() - this.field_212667_b / 2.0, (double)(-WorldBorder.this.field_177762_h));
            this.field_212669_d = Math.max(WorldBorder.this.func_230317_b_() - this.field_212667_b / 2.0, (double)(-WorldBorder.this.field_177762_h));
            this.field_212670_e = Math.min(WorldBorder.this.func_230316_a_() + this.field_212667_b / 2.0, (double)WorldBorder.this.field_177762_h);
            this.field_212671_f = Math.min(WorldBorder.this.func_230317_b_() + this.field_212667_b / 2.0, (double)WorldBorder.this.field_177762_h);
            this.field_222518_g = VoxelShapes.func_197878_a(VoxelShapes.field_216389_a, VoxelShapes.func_197873_a(Math.floor(this.func_212658_a()), Double.NEGATIVE_INFINITY, Math.floor(this.func_212656_c()), Math.ceil(this.func_212654_b()), Double.POSITIVE_INFINITY, Math.ceil(this.func_212648_d())), IBooleanFunction.field_223234_e_);
        }

        @Override
        public void func_212652_j() {
            this.func_212665_m();
        }

        @Override
        public void func_212653_k() {
            this.func_212665_m();
        }

        @Override
        public IBorderInfo func_212651_l() {
            return this;
        }

        @Override
        public VoxelShape func_222517_m() {
            return this.field_222518_g;
        }
    }

    public static class Serializer {
        private final double field_235928_a_;
        private final double field_235929_b_;
        private final double field_235930_c_;
        private final double field_235931_d_;
        private final int field_235932_e_;
        private final int field_235933_f_;
        private final double field_235934_g_;
        private final long field_235935_h_;
        private final double field_235936_i_;

        private Serializer(double p_i231883_1_, double p_i231883_3_, double p_i231883_5_, double p_i231883_7_, int p_i231883_9_, int p_i231883_10_, double p_i231883_11_, long p_i231883_13_, double p_i231883_15_) {
            this.field_235928_a_ = p_i231883_1_;
            this.field_235929_b_ = p_i231883_3_;
            this.field_235930_c_ = p_i231883_5_;
            this.field_235931_d_ = p_i231883_7_;
            this.field_235932_e_ = p_i231883_9_;
            this.field_235933_f_ = p_i231883_10_;
            this.field_235934_g_ = p_i231883_11_;
            this.field_235935_h_ = p_i231883_13_;
            this.field_235936_i_ = p_i231883_15_;
        }

        private Serializer(WorldBorder p_i231885_1_) {
            this.field_235928_a_ = p_i231885_1_.func_230316_a_();
            this.field_235929_b_ = p_i231885_1_.func_230317_b_();
            this.field_235930_c_ = p_i231885_1_.func_177727_n();
            this.field_235931_d_ = p_i231885_1_.func_177742_m();
            this.field_235932_e_ = p_i231885_1_.func_177748_q();
            this.field_235933_f_ = p_i231885_1_.func_177740_p();
            this.field_235934_g_ = p_i231885_1_.func_177741_h();
            this.field_235935_h_ = p_i231885_1_.func_177732_i();
            this.field_235936_i_ = p_i231885_1_.func_177751_j();
        }

        public double func_235937_a_() {
            return this.field_235928_a_;
        }

        public double func_235940_b_() {
            return this.field_235929_b_;
        }

        public double func_235941_c_() {
            return this.field_235930_c_;
        }

        public double func_235942_d_() {
            return this.field_235931_d_;
        }

        public int func_235943_e_() {
            return this.field_235932_e_;
        }

        public int func_235944_f_() {
            return this.field_235933_f_;
        }

        public double func_235945_g_() {
            return this.field_235934_g_;
        }

        public long func_235946_h_() {
            return this.field_235935_h_;
        }

        public double func_235947_i_() {
            return this.field_235936_i_;
        }

        public static Serializer func_235938_a_(DynamicLike<?> p_235938_0_, Serializer p_235938_1_) {
            double d0 = p_235938_0_.get("BorderCenterX").asDouble(p_235938_1_.field_235928_a_);
            double d1 = p_235938_0_.get("BorderCenterZ").asDouble(p_235938_1_.field_235929_b_);
            double d2 = p_235938_0_.get("BorderSize").asDouble(p_235938_1_.field_235934_g_);
            long i = p_235938_0_.get("BorderSizeLerpTime").asLong(p_235938_1_.field_235935_h_);
            double d3 = p_235938_0_.get("BorderSizeLerpTarget").asDouble(p_235938_1_.field_235936_i_);
            double d4 = p_235938_0_.get("BorderSafeZone").asDouble(p_235938_1_.field_235931_d_);
            double d5 = p_235938_0_.get("BorderDamagePerBlock").asDouble(p_235938_1_.field_235930_c_);
            int j = p_235938_0_.get("BorderWarningBlocks").asInt(p_235938_1_.field_235932_e_);
            int k = p_235938_0_.get("BorderWarningTime").asInt(p_235938_1_.field_235933_f_);
            return new Serializer(d0, d1, d5, d4, j, k, d2, i, d3);
        }

        public void func_235939_a_(CompoundNBT p_235939_1_) {
            p_235939_1_.func_74780_a("BorderCenterX", this.field_235928_a_);
            p_235939_1_.func_74780_a("BorderCenterZ", this.field_235929_b_);
            p_235939_1_.func_74780_a("BorderSize", this.field_235934_g_);
            p_235939_1_.func_74772_a("BorderSizeLerpTime", this.field_235935_h_);
            p_235939_1_.func_74780_a("BorderSafeZone", this.field_235931_d_);
            p_235939_1_.func_74780_a("BorderDamagePerBlock", this.field_235930_c_);
            p_235939_1_.func_74780_a("BorderSizeLerpTarget", this.field_235936_i_);
            p_235939_1_.func_74780_a("BorderWarningBlocks", this.field_235932_e_);
            p_235939_1_.func_74780_a("BorderWarningTime", this.field_235933_f_);
        }
    }

    class MovingBorderInfo
    implements IBorderInfo {
        private final double field_212660_b;
        private final double field_212661_c;
        private final long field_212662_d;
        private final long field_212663_e;
        private final double field_212664_f;

        private MovingBorderInfo(double p_i49838_2_, double p_i49838_4_, long p_i49838_6_) {
            this.field_212660_b = p_i49838_2_;
            this.field_212661_c = p_i49838_4_;
            this.field_212664_f = p_i49838_6_;
            this.field_212663_e = Util.func_211177_b();
            this.field_212662_d = this.field_212663_e + p_i49838_6_;
        }

        @Override
        public double func_212658_a() {
            return Math.max(WorldBorder.this.func_230316_a_() - this.func_212647_e() / 2.0, (double)(-WorldBorder.this.field_177762_h));
        }

        @Override
        public double func_212656_c() {
            return Math.max(WorldBorder.this.func_230317_b_() - this.func_212647_e() / 2.0, (double)(-WorldBorder.this.field_177762_h));
        }

        @Override
        public double func_212654_b() {
            return Math.min(WorldBorder.this.func_230316_a_() + this.func_212647_e() / 2.0, (double)WorldBorder.this.field_177762_h);
        }

        @Override
        public double func_212648_d() {
            return Math.min(WorldBorder.this.func_230317_b_() + this.func_212647_e() / 2.0, (double)WorldBorder.this.field_177762_h);
        }

        @Override
        public double func_212647_e() {
            double d0 = (double)(Util.func_211177_b() - this.field_212663_e) / this.field_212664_f;
            return d0 < 1.0 ? MathHelper.func_219803_d((double)d0, (double)this.field_212660_b, (double)this.field_212661_c) : this.field_212661_c;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public double func_212649_f() {
            return Math.abs(this.field_212660_b - this.field_212661_c) / (double)(this.field_212662_d - this.field_212663_e);
        }

        @Override
        public long func_212657_g() {
            return this.field_212662_d - Util.func_211177_b();
        }

        @Override
        public double func_212650_h() {
            return this.field_212661_c;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public BorderStatus func_212655_i() {
            return this.field_212661_c < this.field_212660_b ? BorderStatus.SHRINKING : BorderStatus.GROWING;
        }

        @Override
        public void func_212653_k() {
        }

        @Override
        public void func_212652_j() {
        }

        @Override
        public IBorderInfo func_212651_l() {
            IBorderInfo iBorderInfo;
            if (this.func_212657_g() <= 0L) {
                WorldBorderBoundsChangeFinishEvent event = new WorldBorderBoundsChangeFinishEvent((World)WorldBorder.this.world.getWorld(), WorldBorder.this.world.getWorld().getWorldBorder(), (double)this.field_212663_e, (double)this.field_212662_d, this.field_212664_f);
                Bukkit.getServer().getPluginManager().callEvent((Event)event);
            }
            if (this.func_212657_g() <= 0L) {
                WorldBorder worldBorder = WorldBorder.this;
                Objects.requireNonNull(worldBorder);
                iBorderInfo = worldBorder.new StationaryBorderInfo(this.field_212661_c);
            } else {
                iBorderInfo = this;
            }
            return iBorderInfo;
        }

        @Override
        public VoxelShape func_222517_m() {
            return VoxelShapes.func_197878_a(VoxelShapes.field_216389_a, VoxelShapes.func_197873_a(Math.floor(this.func_212658_a()), Double.NEGATIVE_INFINITY, Math.floor(this.func_212656_c()), Math.ceil(this.func_212654_b()), Double.POSITIVE_INFINITY, Math.ceil(this.func_212648_d())), IBooleanFunction.field_223234_e_);
        }
    }

    static interface IBorderInfo {
        public double func_212658_a();

        public double func_212654_b();

        public double func_212656_c();

        public double func_212648_d();

        public double func_212647_e();

        @OnlyIn(value=Dist.CLIENT)
        public double func_212649_f();

        public long func_212657_g();

        public double func_212650_h();

        @OnlyIn(value=Dist.CLIENT)
        public BorderStatus func_212655_i();

        public void func_212652_j();

        public void func_212653_k();

        public IBorderInfo func_212651_l();

        public VoxelShape func_222517_m();
    }
}

