/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage;

import com.google.common.collect.Lists;
import com.mohistmc.util.i18n.i18n;
import com.mojang.serialization.DynamicOps;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.util.datafix.codec.DatapackCodec;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldSettingsImport;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.biome.provider.OverworldBiomeProvider;
import net.minecraft.world.biome.provider.SingleBiomeProvider;
import net.minecraft.world.chunk.storage.ChunkLoaderUtil;
import net.minecraft.world.chunk.storage.RegionFile;
import net.minecraft.world.storage.FolderName;
import net.minecraft.world.storage.IServerConfiguration;
import net.minecraft.world.storage.SaveFormat;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AnvilSaveConverter {
    private static final Logger field_151480_b = LogManager.getLogger();

    static boolean func_237330_a_(SaveFormat.LevelSave p_237330_0_, IProgressUpdate p_237330_1_) {
        p_237330_1_.func_73718_a(0);
        ArrayList list = Lists.newArrayList();
        ArrayList list1 = Lists.newArrayList();
        ArrayList list2 = Lists.newArrayList();
        File file1 = p_237330_0_.func_237291_a_(World.field_234918_g_);
        File file2 = p_237330_0_.func_237291_a_(World.field_234919_h_);
        File file3 = p_237330_0_.func_237291_a_(World.field_234920_i_);
        field_151480_b.info(i18n.get((String)"anvilsaveconverter.1"));
        AnvilSaveConverter.func_215789_a(file1, list);
        if (file2.exists()) {
            AnvilSaveConverter.func_215789_a(file2, list1);
        }
        if (file3.exists()) {
            AnvilSaveConverter.func_215789_a(file3, list2);
        }
        int i = list.size() + list1.size() + list2.size();
        field_151480_b.info(i18n.get((String)"anvilsaveconverter.2", (Object[])new Object[]{i}));
        DynamicRegistries.Impl dynamicregistries$impl = DynamicRegistries.func_239770_b_();
        WorldSettingsImport worldsettingsimport = WorldSettingsImport.func_244335_a(NBTDynamicOps.field_210820_a, IResourceManager.Instance.INSTANCE, dynamicregistries$impl);
        IServerConfiguration iserverconfiguration = p_237330_0_.func_237284_a_((DynamicOps<INBT>)worldsettingsimport, DatapackCodec.field_234880_a_);
        long j = iserverconfiguration != null ? iserverconfiguration.func_230418_z_().func_236221_b_() : 0L;
        MutableRegistry<Biome> registry = dynamicregistries$impl.func_243612_b(Registry.field_239720_u_);
        OverworldBiomeProvider biomeprovider = iserverconfiguration != null && iserverconfiguration.func_230418_z_().func_236228_i_() ? new SingleBiomeProvider(registry.func_243576_d(Biomes.field_76772_c)) : new OverworldBiomeProvider(j, false, false, (Registry<Biome>)registry);
        AnvilSaveConverter.func_242983_a(dynamicregistries$impl, new File(file1, "region"), list, biomeprovider, 0, i, p_237330_1_);
        AnvilSaveConverter.func_242983_a(dynamicregistries$impl, new File(file2, "region"), list1, (BiomeProvider)new SingleBiomeProvider(registry.func_243576_d(Biomes.field_235254_j_)), list.size(), i, p_237330_1_);
        AnvilSaveConverter.func_242983_a(dynamicregistries$impl, new File(file3, "region"), list2, (BiomeProvider)new SingleBiomeProvider(registry.func_243576_d(Biomes.field_76779_k)), list.size() + list1.size(), i, p_237330_1_);
        AnvilSaveConverter.func_237329_a_(p_237330_0_);
        p_237330_0_.func_237287_a_(dynamicregistries$impl, iserverconfiguration);
        return true;
    }

    private static void func_237329_a_(SaveFormat.LevelSave p_237329_0_) {
        File file1 = p_237329_0_.func_237285_a_(FolderName.field_237249_e_).toFile();
        if (!file1.exists()) {
            field_151480_b.warn(i18n.get((String)"anvilsaveconverter.3"));
        } else {
            File file2 = new File(file1.getParent(), "level.dat_mcr");
            if (!file1.renameTo(file2)) {
                field_151480_b.warn(i18n.get((String)"anvilsaveconverter.4"));
            }
        }
    }

    private static void func_242983_a(DynamicRegistries.Impl p_242983_0_, File p_242983_1_, Iterable<File> p_242983_2_, BiomeProvider p_242983_3_, int p_242983_4_, int p_242983_5_, IProgressUpdate p_242983_6_) {
        for (File file1 : p_242983_2_) {
            AnvilSaveConverter.func_242982_a(p_242983_0_, p_242983_1_, file1, p_242983_3_, p_242983_4_, p_242983_5_, p_242983_6_);
            int i = (int)Math.round(100.0 * (double)(++p_242983_4_) / (double)p_242983_5_);
            p_242983_6_.func_73718_a(i);
        }
    }

    private static void func_242982_a(DynamicRegistries.Impl p_242982_0_, File p_242982_1_, File p_242982_2_, BiomeProvider p_242982_3_, int p_242982_4_, int p_242982_5_, IProgressUpdate p_242982_6_) {
        String s = p_242982_2_.getName();
        try (RegionFile regionfile = new RegionFile(p_242982_2_, p_242982_1_, true);
             RegionFile regionfile1 = new RegionFile(new File(p_242982_1_, s.substring(0, s.length() - ".mcr".length()) + ".mca"), p_242982_1_, true);){
            for (int i = 0; i < 32; ++i) {
                for (int j = 0; j < 32; ++j) {
                    CompoundNBT compoundnbt;
                    ChunkPos chunkpos = new ChunkPos(i, j);
                    if (!regionfile.func_222667_d(chunkpos) || regionfile1.func_222667_d(chunkpos)) continue;
                    try (DataInputStream datainputstream = regionfile.func_222666_a(chunkpos);){
                        if (datainputstream == null) {
                            field_151480_b.warn(i18n.get((String)"anvilsaveconverter.5", (Object[])new Object[]{chunkpos}));
                            continue;
                        }
                        compoundnbt = CompressedStreamTools.func_74794_a(datainputstream);
                    }
                    catch (IOException ioexception) {
                        field_151480_b.warn(i18n.get((String)"anvilsaveconverter.6", (Object[])new Object[]{chunkpos}), (Throwable)ioexception);
                        continue;
                    }
                    CompoundNBT compoundnbt3 = compoundnbt.func_74775_l("Level");
                    ChunkLoaderUtil.AnvilConverterData chunkloaderutil$anvilconverterdata = ChunkLoaderUtil.func_76691_a((CompoundNBT)compoundnbt3);
                    CompoundNBT compoundnbt1 = new CompoundNBT();
                    CompoundNBT compoundnbt2 = new CompoundNBT();
                    compoundnbt1.func_218657_a("Level", compoundnbt2);
                    ChunkLoaderUtil.func_242708_a((DynamicRegistries.Impl)p_242982_0_, (ChunkLoaderUtil.AnvilConverterData)chunkloaderutil$anvilconverterdata, (CompoundNBT)compoundnbt2, (BiomeProvider)p_242982_3_);
                    try (DataOutputStream dataoutputstream = regionfile1.func_222661_c(chunkpos);){
                        CompressedStreamTools.func_74800_a(compoundnbt1, dataoutputstream);
                        continue;
                    }
                }
                int k = (int)Math.round(100.0 * (double)(p_242982_4_ * 1024) / (double)(p_242982_5_ * 1024));
                int l = (int)Math.round(100.0 * (double)((i + 1) * 32 + p_242982_4_ * 1024) / (double)(p_242982_5_ * 1024));
                if (l <= k) continue;
                p_242982_6_.func_73718_a(l);
            }
        }
        catch (IOException ioexception1) {
            field_151480_b.error(i18n.get((String)"anvilsaveconverter.7", (Object[])new Object[]{p_242982_2_}), (Throwable)ioexception1);
        }
    }

    private static void func_215789_a(File p_215789_0_, Collection<File> p_215789_1_) {
        File file1 = new File(p_215789_0_, "region");
        File[] afile = file1.listFiles((p_215791_0_, p_215791_1_) -> p_215791_1_.endsWith(".mcr"));
        if (afile != null) {
            Collections.addAll(p_215789_1_, afile);
        }
    }
}

