/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage;

import com.google.common.collect.Maps;
import com.mohistmc.util.i18n.i18n;
import com.mojang.datafixers.DataFixer;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PushbackInputStream;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.datafix.DefaultTypeReferences;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.util.DummyWorldSaveData;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DimensionSavedDataManager {
    private static final Logger field_212776_a = LogManager.getLogger();
    public final Map<String, WorldSavedData> field_212778_c = Maps.newHashMap();
    private final DataFixer field_215758_c;
    private final File field_215759_d;

    public DimensionSavedDataManager(File p_i51279_1_, DataFixer p_i51279_2_) {
        this.field_215758_c = p_i51279_2_;
        this.field_215759_d = p_i51279_1_;
    }

    private File func_215754_a(String p_215754_1_) {
        return new File(this.field_215759_d, p_215754_1_ + ".dat");
    }

    public <T extends WorldSavedData> T func_215752_a(Supplier<T> p_215752_1_, String p_215752_2_) {
        T t = this.func_215753_b(p_215752_1_, p_215752_2_);
        if (t != null) {
            return t;
        }
        WorldSavedData t1 = (WorldSavedData)p_215752_1_.get();
        this.func_215757_a(t1);
        return (T)t1;
    }

    @Nullable
    public <T extends WorldSavedData> T func_215753_b(Supplier<T> p_215753_1_, String p_215753_2_) {
        WorldSavedData worldsaveddata = this.field_212778_c.get(p_215753_2_);
        if (worldsaveddata == DummyWorldSaveData.DUMMY) {
            return null;
        }
        if (worldsaveddata == null && !this.field_212778_c.containsKey(p_215753_2_)) {
            worldsaveddata = this.func_223409_c(p_215753_1_, p_215753_2_);
            this.field_212778_c.put(p_215753_2_, worldsaveddata);
        } else if (worldsaveddata == null) {
            this.field_212778_c.put(p_215753_2_, (WorldSavedData)DummyWorldSaveData.DUMMY);
            return null;
        }
        return (T)worldsaveddata;
    }

    @Nullable
    private <T extends WorldSavedData> T func_223409_c(Supplier<T> p_223409_1_, String p_223409_2_) {
        try {
            File file1 = this.func_215754_a(p_223409_2_);
            if (file1.exists()) {
                WorldSavedData t = (WorldSavedData)p_223409_1_.get();
                CompoundNBT compoundnbt = this.func_215755_a(p_223409_2_, SharedConstants.func_215069_a().getWorldVersion());
                t.func_76184_a(compoundnbt.func_74775_l("data"));
                return (T)t;
            }
        }
        catch (Exception exception) {
            field_212776_a.error(i18n.get((String)"dimensionsaveddatamanager.1", (Object[])new Object[]{p_223409_2_}), (Throwable)exception);
        }
        return (T)((WorldSavedData)null);
    }

    public void func_215757_a(WorldSavedData p_215757_1_) {
        this.field_212778_c.put(p_215757_1_.func_195925_e(), p_215757_1_);
    }

    public CompoundNBT func_215755_a(String p_215755_1_, int p_215755_2_) throws IOException {
        CompoundNBT compoundnbt1;
        File file1 = this.func_215754_a(p_215755_1_);
        try (FileInputStream fileinputstream = new FileInputStream(file1);
             PushbackInputStream pushbackinputstream = new PushbackInputStream(fileinputstream, 2);){
            CompoundNBT compoundnbt;
            if (this.func_215756_a(pushbackinputstream)) {
                compoundnbt = CompressedStreamTools.func_74796_a(pushbackinputstream);
            } else {
                try (DataInputStream datainputstream = new DataInputStream(pushbackinputstream);){
                    compoundnbt = CompressedStreamTools.func_74794_a(datainputstream);
                }
            }
            int i = compoundnbt.func_150297_b("DataVersion", 99) ? compoundnbt.func_74762_e("DataVersion") : 1343;
            compoundnbt1 = NBTUtil.func_210821_a(this.field_215758_c, DefaultTypeReferences.SAVED_DATA, compoundnbt, i, p_215755_2_);
        }
        return compoundnbt1;
    }

    private boolean func_215756_a(PushbackInputStream p_215756_1_) throws IOException {
        int j;
        byte[] abyte = new byte[2];
        boolean flag = false;
        int i = p_215756_1_.read(abyte, 0, 2);
        if (i == 2 && (j = (abyte[1] & 0xFF) << 8 | abyte[0] & 0xFF) == 35615) {
            flag = true;
        }
        if (i != 0) {
            p_215756_1_.unread(abyte, 0, i);
        }
        return flag;
    }

    public void func_212775_b() {
        for (WorldSavedData worldsaveddata : this.field_212778_c.values()) {
            if (worldsaveddata == null) continue;
            worldsaveddata.func_215158_a(this.func_215754_a(worldsaveddata.func_195925_e()));
        }
    }
}

