/*
 * Decompiled with CFR 0.152.
 */
package de.siegmar.fastcsv.reader;

import de.siegmar.fastcsv.reader.CsvContainer;
import de.siegmar.fastcsv.reader.CsvParser;
import de.siegmar.fastcsv.reader.CsvRow;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class CsvReader {
    private char fieldSeparator = (char)44;
    private char textDelimiter = (char)34;
    private boolean containsHeader;
    private boolean skipEmptyRows = true;
    private boolean errorOnDifferentFieldCount;

    public void setFieldSeparator(char fieldSeparator) {
        this.fieldSeparator = fieldSeparator;
    }

    public void setTextDelimiter(char textDelimiter) {
        this.textDelimiter = textDelimiter;
    }

    public void setContainsHeader(boolean containsHeader) {
        this.containsHeader = containsHeader;
    }

    public void setSkipEmptyRows(boolean skipEmptyRows) {
        this.skipEmptyRows = skipEmptyRows;
    }

    public void setErrorOnDifferentFieldCount(boolean errorOnDifferentFieldCount) {
        this.errorOnDifferentFieldCount = errorOnDifferentFieldCount;
    }

    public CsvContainer read(File file, Charset charset) throws IOException {
        return this.read(Objects.requireNonNull(file.toPath(), "file must not be null"), Objects.requireNonNull(charset, "charset must not be null"));
    }

    public CsvContainer read(Path path, Charset charset) throws IOException {
        Objects.requireNonNull(path, "path must not be null");
        Objects.requireNonNull(charset, "charset must not be null");
        try (Reader reader = CsvReader.newPathReader(path, charset);){
            CsvContainer csvContainer = this.read(reader);
            return csvContainer;
        }
    }

    public CsvContainer read(Reader reader) throws IOException {
        CsvRow csvRow;
        CsvParser csvParser = this.parse(Objects.requireNonNull(reader, "reader must not be null"));
        ArrayList<CsvRow> rows = new ArrayList<CsvRow>();
        while ((csvRow = csvParser.nextRow()) != null) {
            rows.add(csvRow);
        }
        if (rows.isEmpty()) {
            return null;
        }
        List<String> header = this.containsHeader ? csvParser.getHeader() : null;
        return new CsvContainer(header, rows);
    }

    public CsvParser parse(Path path, Charset charset) throws IOException {
        return this.parse(CsvReader.newPathReader(Objects.requireNonNull(path, "path must not be null"), Objects.requireNonNull(charset, "charset must not be null")));
    }

    public CsvParser parse(File file, Charset charset) throws IOException {
        return this.parse(Objects.requireNonNull(file, "file must not be null").toPath(), Objects.requireNonNull(charset, "charset must not be null"));
    }

    public CsvParser parse(Reader reader) throws IOException {
        return new CsvParser(Objects.requireNonNull(reader, "reader must not be null"), this.fieldSeparator, this.textDelimiter, this.containsHeader, this.skipEmptyRows, this.errorOnDifferentFieldCount);
    }

    private static Reader newPathReader(Path path, Charset charset) throws IOException {
        return new InputStreamReader(Files.newInputStream(path, StandardOpenOption.READ), charset);
    }
}

