/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.worldselection;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.gui.screens.CreateBuffetWorldScreen;
import net.minecraft.client.gui.screens.CreateFlatWorldScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.CreateWorldScreen;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.FixedBiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.DebugLevelSource;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraft.world.level.levelgen.flat.FlatLevelGeneratorSettings;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class WorldPreset {
    public static final WorldPreset f_101506_ = new WorldPreset("default"){

        @Override
        protected ChunkGenerator m_183349_(RegistryAccess p_194096_, long p_194097_) {
            return WorldGenSettings.m_190027_(p_194096_, p_194097_);
        }
    };
    private static final WorldPreset f_101510_ = new WorldPreset("flat"){

        @Override
        protected ChunkGenerator m_183349_(RegistryAccess p_194099_, long p_194100_) {
            Registry<Biome> registry = p_194099_.m_175515_(Registry.f_122885_);
            Registry<StructureSet> registry1 = p_194099_.m_175515_(Registry.f_211073_);
            return new FlatLevelSource(registry1, FlatLevelGeneratorSettings.m_211734_(registry, registry1));
        }
    };
    public static final WorldPreset f_101511_ = new WorldPreset("large_biomes"){

        @Override
        protected ChunkGenerator m_183349_(RegistryAccess p_194102_, long p_194103_) {
            return WorldGenSettings.m_190030_(p_194102_, p_194103_, NoiseGeneratorSettings.f_188869_);
        }
    };
    public static final WorldPreset f_101507_ = new WorldPreset("amplified"){

        @Override
        protected ChunkGenerator m_183349_(RegistryAccess p_194105_, long p_194106_) {
            return WorldGenSettings.m_190030_(p_194105_, p_194106_, NoiseGeneratorSettings.f_64433_);
        }
    };
    private static final WorldPreset f_101512_ = new WorldPreset("single_biome_surface"){

        @Override
        protected ChunkGenerator m_183349_(RegistryAccess p_194108_, long p_194109_) {
            return WorldPreset.m_194085_(p_194108_, p_194109_, NoiseGeneratorSettings.f_64432_);
        }
    };
    private static final WorldPreset f_101515_ = new WorldPreset("debug_all_block_states"){

        @Override
        protected ChunkGenerator m_183349_(RegistryAccess p_194111_, long p_194112_) {
            return new DebugLevelSource(p_194111_.m_175515_(Registry.f_211073_), p_194111_.m_175515_(Registry.f_122885_));
        }
    };
    protected static final List<WorldPreset> f_101508_ = Lists.newArrayList((Object[])new WorldPreset[]{f_101506_, f_101510_, f_101511_, f_101507_, f_101512_, f_101515_});
    protected static final Map<Optional<WorldPreset>, PresetEditor> f_101509_ = ImmutableMap.of(Optional.of(f_101510_), (p_205498_, p_205499_) -> {
        ChunkGenerator chunkgenerator = p_205499_.m_64666_();
        RegistryAccess registryaccess = p_205498_.f_100847_.m_205473_();
        Registry<Biome> registry = registryaccess.m_175515_(Registry.f_122885_);
        Registry<StructureSet> registry1 = registryaccess.m_175515_(Registry.f_211073_);
        Registry<DimensionType> registry2 = registryaccess.m_175515_(Registry.f_122818_);
        return new CreateFlatWorldScreen(p_205498_, p_210935_ -> p_210931_.f_100847_.m_101404_(new WorldGenSettings(p_205499_.m_64619_(), p_205499_.m_64657_(), p_205499_.m_64660_(), WorldGenSettings.m_204649_(registry2, p_205499_.m_204655_(), (ChunkGenerator)new FlatLevelSource(registry1, p_210935_)))), chunkgenerator instanceof FlatLevelSource ? ((FlatLevelSource)chunkgenerator).m_64191_() : FlatLevelGeneratorSettings.m_211734_(registry, registry1));
    }, Optional.of(f_101512_), (p_205475_, p_205476_) -> new CreateBuffetWorldScreen((Screen)p_205475_, p_205475_.f_100847_.m_205473_(), p_205484_ -> p_205482_.f_100847_.m_101404_(WorldPreset.m_205493_(p_205482_.f_100847_.m_205473_(), p_205476_, p_205484_)), WorldPreset.m_205490_(p_205475_.f_100847_.m_205473_(), p_205476_)));
    private final Component f_101516_;

    static NoiseBasedChunkGenerator m_194085_(RegistryAccess p_194086_, long p_194087_, ResourceKey<NoiseGeneratorSettings> p_194088_) {
        Registry<Biome> registry = p_194086_.m_175515_(Registry.f_122885_);
        Registry<StructureSet> registry1 = p_194086_.m_175515_(Registry.f_211073_);
        Registry<NormalNoise.NoiseParameters> registry2 = p_194086_.m_175515_(Registry.f_194568_);
        Registry<NoiseGeneratorSettings> registry3 = p_194086_.m_175515_(Registry.f_122878_);
        return new NoiseBasedChunkGenerator(registry1, registry2, (BiomeSource)new FixedBiomeSource(registry.m_203538_(Biomes.f_48202_)), p_194087_, registry3.m_203538_(p_194088_));
    }

    WorldPreset(String p_101519_) {
        this.f_101516_ = new TranslatableComponent("generator." + p_101519_);
    }

    public WorldPreset(Component displayName) {
        this.f_101516_ = displayName;
    }

    private static WorldGenSettings m_205493_(RegistryAccess p_205494_, WorldGenSettings p_205495_, Holder<Biome> p_205496_) {
        FixedBiomeSource biomesource = new FixedBiomeSource(p_205496_);
        Registry<DimensionType> registry = p_205494_.m_175515_(Registry.f_122818_);
        Registry<StructureSet> registry1 = p_205494_.m_175515_(Registry.f_211073_);
        Registry<NoiseGeneratorSettings> registry2 = p_205494_.m_175515_(Registry.f_122878_);
        Holder<NoiseGeneratorSettings> holder = registry2.m_203538_(NoiseGeneratorSettings.f_64432_);
        return new WorldGenSettings(p_205495_.m_64619_(), p_205495_.m_64657_(), p_205495_.m_64660_(), WorldGenSettings.m_204649_(registry, p_205495_.m_204655_(), new NoiseBasedChunkGenerator(registry1, p_205494_.m_175515_(Registry.f_194568_), (BiomeSource)biomesource, p_205495_.m_64619_(), holder)));
    }

    private static Holder<Biome> m_205490_(RegistryAccess p_205491_, WorldGenSettings p_205492_) {
        return p_205492_.m_64666_().m_62218_().m_207840_().stream().findFirst().orElse(p_205491_.m_175515_(Registry.f_122885_).m_203538_(Biomes.f_48202_));
    }

    public static Optional<WorldPreset> m_101524_(WorldGenSettings p_101525_) {
        ChunkGenerator chunkgenerator = p_101525_.m_64666_();
        if (chunkgenerator instanceof FlatLevelSource) {
            return Optional.of(f_101510_);
        }
        return chunkgenerator instanceof DebugLevelSource ? Optional.of(f_101515_) : Optional.empty();
    }

    public Component m_101523_() {
        return this.f_101516_;
    }

    public WorldGenSettings m_205485_(RegistryAccess p_205486_, long p_205487_, boolean p_205488_, boolean p_205489_) {
        return new WorldGenSettings(p_205487_, p_205488_, p_205489_, WorldGenSettings.m_204649_(p_205486_.m_175515_(Registry.f_122818_), DimensionType.m_204490_((RegistryAccess)p_205486_, (long)p_205487_), this.m_183349_(p_205486_, p_205487_)));
    }

    protected abstract ChunkGenerator m_183349_(RegistryAccess var1, long var2);

    public static boolean m_170301_(WorldPreset p_170302_) {
        return p_170302_ != f_101515_;
    }

    public static void registerGenerator(WorldPreset gen) {
        f_101508_.add(gen);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface PresetEditor {
        public Screen m_101642_(CreateWorldScreen var1, WorldGenSettings var2);
    }
}

