/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.chunk;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import com.google.common.primitives.Doubles;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.ChunkBufferBuilderPack;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.chunk.RenderChunkRegion;
import net.minecraft.client.renderer.chunk.RenderRegionCache;
import net.minecraft.client.renderer.chunk.VisGraph;
import net.minecraft.client.renderer.chunk.VisibilitySet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.thread.ProcessorMailbox;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.ModelDataManager;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ChunkRenderDispatcher {
    private static final Logger f_112672_ = LogUtils.getLogger();
    private static final int f_173707_ = 4;
    private static final VertexFormat f_173708_ = DefaultVertexFormat.f_85811_;
    private static final int f_194400_ = 2;
    private final PriorityBlockingQueue<RenderChunk.ChunkCompileTask> f_194401_ = Queues.newPriorityBlockingQueue();
    private final Queue<RenderChunk.ChunkCompileTask> f_194402_ = Queues.newLinkedBlockingDeque();
    private int f_194403_ = 2;
    private final Queue<ChunkBufferBuilderPack> f_112674_;
    private final Queue<Runnable> f_112675_ = Queues.newConcurrentLinkedQueue();
    private volatile int f_112676_;
    private volatile int f_112677_;
    final ChunkBufferBuilderPack f_112678_;
    private final ProcessorMailbox<Runnable> f_112679_;
    private final Executor f_112680_;
    ClientLevel f_112681_;
    final LevelRenderer f_112682_;
    private Vec3 f_112683_ = Vec3.f_82478_;

    public ChunkRenderDispatcher(ClientLevel p_194405_, LevelRenderer p_194406_, Executor p_194407_, boolean p_194408_, ChunkBufferBuilderPack p_194409_) {
        this(p_194405_, p_194406_, p_194407_, p_194408_, p_194409_, -1);
    }

    public ChunkRenderDispatcher(ClientLevel p_194405_, LevelRenderer p_194406_, Executor p_194407_, boolean p_194408_, ChunkBufferBuilderPack p_194409_, int countRenderBuilders) {
        this.f_112681_ = p_194405_;
        this.f_112682_ = p_194406_;
        int i = Math.max(1, (int)((double)Runtime.getRuntime().maxMemory() * 0.3) / (RenderType.m_110506_().stream().mapToInt(RenderType::m_110507_).sum() * 4) - 1);
        int j = Runtime.getRuntime().availableProcessors();
        int k = p_194408_ ? j : Math.min(j, 4);
        int l = countRenderBuilders < 0 ? Math.max(1, Math.min(k, i)) : countRenderBuilders;
        this.f_112678_ = p_194409_;
        ArrayList list = Lists.newArrayListWithExpectedSize((int)l);
        try {
            for (int i1 = 0; i1 < l; ++i1) {
                list.add(new ChunkBufferBuilderPack());
            }
        }
        catch (OutOfMemoryError outofmemoryerror) {
            f_112672_.warn("Allocated only {}/{} buffers", (Object)list.size(), (Object)l);
            int j1 = Math.min(list.size() * 2 / 3, list.size() - 1);
            for (int k1 = 0; k1 < j1; ++k1) {
                list.remove(list.size() - 1);
            }
            System.gc();
        }
        this.f_112674_ = Queues.newArrayDeque((Iterable)list);
        this.f_112677_ = this.f_112674_.size();
        this.f_112680_ = p_194407_;
        this.f_112679_ = ProcessorMailbox.m_18751_((Executor)p_194407_, (String)"Chunk Renderer");
        this.f_112679_.m_6937_(this::m_112734_);
    }

    public void m_194410_(ClientLevel p_194411_) {
        this.f_112681_ = p_194411_;
    }

    private void m_112734_() {
        RenderChunk.ChunkCompileTask chunkrenderdispatcher$renderchunk$chunkcompiletask;
        if (!this.f_112674_.isEmpty() && (chunkrenderdispatcher$renderchunk$chunkcompiletask = this.m_194418_()) != null) {
            ChunkBufferBuilderPack chunkbufferbuilderpack = this.f_112674_.poll();
            this.f_112676_ = this.f_194401_.size() + this.f_194402_.size();
            this.f_112677_ = this.f_112674_.size();
            ((CompletableFuture)CompletableFuture.supplyAsync(Util.m_183946_(chunkrenderdispatcher$renderchunk$chunkcompiletask.m_183497_(), () -> chunkrenderdispatcher$renderchunk$chunkcompiletask.m_5869_(chunkbufferbuilderpack)), this.f_112680_).thenCompose(p_194416_ -> p_194416_)).whenComplete((p_199943_, p_199944_) -> {
                if (p_199944_ != null) {
                    CrashReport crashreport = CrashReport.m_127521_(p_199944_, "Batching chunks");
                    Minecraft.m_91087_().m_199935_(() -> Minecraft.m_91087_().m_91354_(crashreport));
                } else {
                    this.f_112679_.m_6937_(() -> {
                        if (p_199943_ == ChunkTaskResult.SUCCESSFUL) {
                            chunkbufferbuilderpack.m_108838_();
                        } else {
                            chunkbufferbuilderpack.m_108841_();
                        }
                        this.f_112674_.add(chunkbufferbuilderpack);
                        this.f_112677_ = this.f_112674_.size();
                        this.m_112734_();
                    });
                }
            });
        }
    }

    @Nullable
    private RenderChunk.ChunkCompileTask m_194418_() {
        RenderChunk.ChunkCompileTask chunkrenderdispatcher$renderchunk$chunkcompiletask;
        if (this.f_194403_ <= 0 && (chunkrenderdispatcher$renderchunk$chunkcompiletask = this.f_194402_.poll()) != null) {
            this.f_194403_ = 2;
            return chunkrenderdispatcher$renderchunk$chunkcompiletask;
        }
        RenderChunk.ChunkCompileTask chunkrenderdispatcher$renderchunk$chunkcompiletask1 = this.f_194401_.poll();
        if (chunkrenderdispatcher$renderchunk$chunkcompiletask1 != null) {
            --this.f_194403_;
            return chunkrenderdispatcher$renderchunk$chunkcompiletask1;
        }
        this.f_194403_ = 2;
        return this.f_194402_.poll();
    }

    public String m_112719_() {
        return String.format("pC: %03d, pU: %02d, aB: %02d", this.f_112676_, this.f_112675_.size(), this.f_112677_);
    }

    public int m_173712_() {
        return this.f_112676_;
    }

    public int m_173713_() {
        return this.f_112675_.size();
    }

    public int m_173714_() {
        return this.f_112677_;
    }

    public void m_112693_(Vec3 p_112694_) {
        this.f_112683_ = p_112694_;
    }

    public Vec3 m_112727_() {
        return this.f_112683_;
    }

    public void m_194417_() {
        Runnable runnable;
        while ((runnable = this.f_112675_.poll()) != null) {
            runnable.run();
        }
    }

    public void m_200431_(RenderChunk p_200432_, RenderRegionCache p_200433_) {
        p_200432_.m_200439_(p_200433_);
    }

    public void m_112731_() {
        this.m_112735_();
    }

    public void m_112709_(RenderChunk.ChunkCompileTask p_112710_) {
        this.f_112679_.m_6937_(() -> {
            if (p_199951_.f_194420_) {
                this.f_194401_.offer(p_112710_);
            } else {
                this.f_194402_.offer(p_112710_);
            }
            this.f_112676_ = this.f_194401_.size() + this.f_194402_.size();
            this.m_112734_();
        });
    }

    public CompletableFuture<Void> m_112695_(BufferBuilder p_112696_, VertexBuffer p_112697_) {
        return CompletableFuture.runAsync(() -> {}, this.f_112675_::add).thenCompose(p_199940_ -> this.m_112720_(p_112696_, p_112697_));
    }

    private CompletableFuture<Void> m_112720_(BufferBuilder p_112721_, VertexBuffer p_112722_) {
        return p_112722_.m_85932_(p_112721_);
    }

    private void m_112735_() {
        while (!this.f_194401_.isEmpty()) {
            RenderChunk.ChunkCompileTask chunkrenderdispatcher$renderchunk$chunkcompiletask = this.f_194401_.poll();
            if (chunkrenderdispatcher$renderchunk$chunkcompiletask == null) continue;
            chunkrenderdispatcher$renderchunk$chunkcompiletask.m_6204_();
        }
        while (!this.f_194402_.isEmpty()) {
            RenderChunk.ChunkCompileTask chunkrenderdispatcher$renderchunk$chunkcompiletask1 = this.f_194402_.poll();
            if (chunkrenderdispatcher$renderchunk$chunkcompiletask1 == null) continue;
            chunkrenderdispatcher$renderchunk$chunkcompiletask1.m_6204_();
        }
        this.f_112676_ = 0;
    }

    public boolean m_112732_() {
        return this.f_112676_ == 0 && this.f_112675_.isEmpty();
    }

    public void m_112733_() {
        this.m_112735_();
        this.f_112679_.close();
        this.f_112674_.clear();
    }

    @OnlyIn(value=Dist.CLIENT)
    public class RenderChunk {
        public static final int f_173716_ = 16;
        public final int f_173717_;
        public final AtomicReference<CompiledChunk> f_112784_ = new AtomicReference<CompiledChunk>(CompiledChunk.f_112748_);
        final AtomicInteger f_202433_ = new AtomicInteger(0);
        @Nullable
        private RebuildTask f_112787_;
        @Nullable
        private ResortTransparencyTask f_112788_;
        private final Set<BlockEntity> f_112789_ = Sets.newHashSet();
        private final Map<RenderType, VertexBuffer> f_112790_ = RenderType.m_110506_().stream().collect(Collectors.toMap(p_112837_ -> p_112837_, p_112834_ -> new VertexBuffer()));
        private AABB f_112785_;
        private boolean f_112792_ = true;
        final BlockPos.MutableBlockPos f_112793_ = new BlockPos.MutableBlockPos(-1, -1, -1);
        private final BlockPos.MutableBlockPos[] f_112794_ = Util.m_137469_(new BlockPos.MutableBlockPos[6], p_112831_ -> {
            for (int i = 0; i < ((BlockPos.MutableBlockPos[])p_112831_).length; ++i) {
                p_112831_[i] = new BlockPos.MutableBlockPos();
            }
        });
        private boolean f_112795_;

        public RenderChunk(int p_202436_, int p_202437_, int p_202438_, int p_202439_) {
            this.f_173717_ = p_202436_;
            this.m_112801_(p_202437_, p_202438_, p_202439_);
        }

        private boolean m_112822_(BlockPos p_112823_) {
            return ChunkRenderDispatcher.this.f_112681_.m_6522_(SectionPos.m_123171_((int)p_112823_.m_123341_()), SectionPos.m_123171_((int)p_112823_.m_123343_()), ChunkStatus.f_62326_, false) != null;
        }

        public boolean m_112798_() {
            int i = 24;
            if (!(this.m_112832_() > 576.0)) {
                return true;
            }
            return this.m_112822_((BlockPos)this.f_112794_[Direction.WEST.ordinal()]) && this.m_112822_((BlockPos)this.f_112794_[Direction.NORTH.ordinal()]) && this.m_112822_((BlockPos)this.f_112794_[Direction.EAST.ordinal()]) && this.m_112822_((BlockPos)this.f_112794_[Direction.SOUTH.ordinal()]);
        }

        public AABB m_202440_() {
            return this.f_112785_;
        }

        public VertexBuffer m_112807_(RenderType p_112808_) {
            return this.f_112790_.get((Object)p_112808_);
        }

        public void m_112801_(int p_112802_, int p_112803_, int p_112804_) {
            this.m_112846_();
            this.f_112793_.m_122178_(p_112802_, p_112803_, p_112804_);
            this.f_112785_ = new AABB((double)p_112802_, (double)p_112803_, (double)p_112804_, (double)(p_112802_ + 16), (double)(p_112803_ + 16), (double)(p_112804_ + 16));
            for (Direction direction : Direction.values()) {
                this.f_112794_[direction.ordinal()].m_122190_((Vec3i)this.f_112793_).m_122175_(direction, 16);
            }
        }

        protected double m_112832_() {
            Camera camera = Minecraft.m_91087_().f_91063_.m_109153_();
            double d0 = this.f_112785_.f_82288_ + 8.0 - camera.m_90583_().f_82479_;
            double d1 = this.f_112785_.f_82289_ + 8.0 - camera.m_90583_().f_82480_;
            double d2 = this.f_112785_.f_82290_ + 8.0 - camera.m_90583_().f_82481_;
            return d0 * d0 + d1 * d1 + d2 * d2;
        }

        void m_112805_(BufferBuilder p_112806_) {
            p_112806_.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85811_);
        }

        public CompiledChunk m_112835_() {
            return this.f_112784_.get();
        }

        private void m_112846_() {
            this.m_194419_();
            this.f_112784_.set(CompiledChunk.f_112748_);
            this.f_112792_ = true;
        }

        public void m_112838_() {
            this.m_112846_();
            this.f_112790_.values().forEach(VertexBuffer::close);
        }

        public BlockPos m_112839_() {
            return this.f_112793_;
        }

        public void m_112828_(boolean p_112829_) {
            boolean flag = this.f_112792_;
            this.f_112792_ = true;
            this.f_112795_ = p_112829_ | (flag && this.f_112795_);
        }

        public void m_112840_() {
            this.f_112792_ = false;
            this.f_112795_ = false;
        }

        public boolean m_112841_() {
            return this.f_112792_;
        }

        public boolean m_112842_() {
            return this.f_112792_ && this.f_112795_;
        }

        public BlockPos m_112824_(Direction p_112825_) {
            return this.f_112794_[p_112825_.ordinal()];
        }

        public boolean m_112809_(RenderType p_112810_, ChunkRenderDispatcher p_112811_) {
            CompiledChunk chunkrenderdispatcher$compiledchunk = this.m_112835_();
            if (this.f_112788_ != null) {
                this.f_112788_.m_6204_();
            }
            if (!chunkrenderdispatcher$compiledchunk.f_112750_.contains((Object)p_112810_)) {
                return false;
            }
            this.f_112788_ = new ResortTransparencyTask(new ChunkPos(this.m_112839_()), this.m_112832_(), chunkrenderdispatcher$compiledchunk);
            p_112811_.m_112709_(this.f_112788_);
            return true;
        }

        protected boolean m_194419_() {
            boolean flag = false;
            if (this.f_112787_ != null) {
                this.f_112787_.m_6204_();
                this.f_112787_ = null;
                flag = true;
            }
            if (this.f_112788_ != null) {
                this.f_112788_.m_6204_();
                this.f_112788_ = null;
            }
            return flag;
        }

        public ChunkCompileTask m_200437_(RenderRegionCache p_200438_) {
            boolean flag1;
            boolean flag = this.m_194419_();
            BlockPos blockpos = this.f_112793_.m_7949_();
            boolean i = true;
            RenderChunkRegion renderchunkregion = p_200438_.m_200465_((Level)ChunkRenderDispatcher.this.f_112681_, blockpos.m_142082_(-1, -1, -1), blockpos.m_142082_(16, 16, 16), 1);
            boolean bl = flag1 = this.f_112784_.get() == CompiledChunk.f_112748_;
            if (flag1 && flag) {
                this.f_202433_.incrementAndGet();
            }
            this.f_112787_ = new RebuildTask(new ChunkPos(this.m_112839_()), this.m_112832_(), renderchunkregion, flag || this.f_112784_.get() != CompiledChunk.f_112748_);
            return this.f_112787_;
        }

        public void m_200434_(ChunkRenderDispatcher p_200435_, RenderRegionCache p_200436_) {
            ChunkCompileTask chunkrenderdispatcher$renderchunk$chunkcompiletask = this.m_200437_(p_200436_);
            p_200435_.m_112709_(chunkrenderdispatcher$renderchunk$chunkcompiletask);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void m_112826_(Set<BlockEntity> p_112827_) {
            HashSet set1;
            HashSet set = Sets.newHashSet(p_112827_);
            Set<BlockEntity> set2 = this.f_112789_;
            synchronized (set2) {
                set1 = Sets.newHashSet(this.f_112789_);
                set.removeAll(this.f_112789_);
                set1.removeAll(p_112827_);
                this.f_112789_.clear();
                this.f_112789_.addAll(p_112827_);
            }
            ChunkRenderDispatcher.this.f_112682_.m_109762_(set1, set);
        }

        public void m_200439_(RenderRegionCache p_200440_) {
            ChunkCompileTask chunkrenderdispatcher$renderchunk$chunkcompiletask = this.m_200437_(p_200440_);
            chunkrenderdispatcher$renderchunk$chunkcompiletask.m_5869_(ChunkRenderDispatcher.this.f_112678_);
        }

        @OnlyIn(value=Dist.CLIENT)
        class ResortTransparencyTask
        extends ChunkCompileTask {
            private final CompiledChunk f_112886_;

            @Deprecated
            public ResortTransparencyTask(double p_112889_, CompiledChunk p_112890_) {
                this(null, p_112889_, p_112890_);
            }

            public ResortTransparencyTask(ChunkPos pos, double p_112889_, CompiledChunk p_112890_) {
                super(pos, p_112889_, true);
                this.f_112886_ = p_112890_;
            }

            @Override
            protected String m_183497_() {
                return "rend_chk_sort";
            }

            @Override
            public CompletableFuture<ChunkTaskResult> m_5869_(ChunkBufferBuilderPack p_112893_) {
                if (this.f_112848_.get()) {
                    return CompletableFuture.completedFuture(ChunkTaskResult.CANCELLED);
                }
                if (!RenderChunk.this.m_112798_()) {
                    this.f_112848_.set(true);
                    return CompletableFuture.completedFuture(ChunkTaskResult.CANCELLED);
                }
                if (this.f_112848_.get()) {
                    return CompletableFuture.completedFuture(ChunkTaskResult.CANCELLED);
                }
                Vec3 vec3 = ChunkRenderDispatcher.this.m_112727_();
                float f = (float)vec3.f_82479_;
                float f1 = (float)vec3.f_82480_;
                float f2 = (float)vec3.f_82481_;
                BufferBuilder.SortState bufferbuilder$sortstate = this.f_112886_.f_112754_;
                if (bufferbuilder$sortstate != null && this.f_112886_.f_112749_.contains((Object)RenderType.m_110466_())) {
                    BufferBuilder bufferbuilder = p_112893_.m_108839_(RenderType.m_110466_());
                    RenderChunk.this.m_112805_(bufferbuilder);
                    bufferbuilder.m_166775_(bufferbuilder$sortstate);
                    bufferbuilder.m_166771_(f - (float)RenderChunk.this.f_112793_.m_123341_(), f1 - (float)RenderChunk.this.f_112793_.m_123342_(), f2 - (float)RenderChunk.this.f_112793_.m_123343_());
                    this.f_112886_.f_112754_ = bufferbuilder.m_166770_();
                    bufferbuilder.m_85721_();
                    if (this.f_112848_.get()) {
                        return CompletableFuture.completedFuture(ChunkTaskResult.CANCELLED);
                    }
                    CompletionStage completablefuture = ChunkRenderDispatcher.this.m_112695_(p_112893_.m_108839_(RenderType.m_110466_()), RenderChunk.this.m_112807_(RenderType.m_110466_())).thenApply(p_112898_ -> ChunkTaskResult.CANCELLED);
                    return ((CompletableFuture)completablefuture).handle((p_199960_, p_199961_) -> {
                        if (p_199961_ != null && !(p_199961_ instanceof CancellationException) && !(p_199961_ instanceof InterruptedException)) {
                            CrashReport crashreport = CrashReport.m_127521_(p_199961_, "Rendering chunk");
                            Minecraft.m_91087_().m_199935_(() -> crashreport);
                        }
                        return this.f_112848_.get() ? ChunkTaskResult.CANCELLED : ChunkTaskResult.SUCCESSFUL;
                    });
                }
                return CompletableFuture.completedFuture(ChunkTaskResult.CANCELLED);
            }

            @Override
            public void m_6204_() {
                this.f_112848_.set(true);
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        abstract class ChunkCompileTask
        implements Comparable<ChunkCompileTask> {
            protected final double f_112847_;
            protected final AtomicBoolean f_112848_ = new AtomicBoolean(false);
            protected final boolean f_194420_;
            protected Map<BlockPos, IModelData> modelData;

            public ChunkCompileTask(double p_194423_, boolean p_194424_) {
                this(null, p_194423_, p_194424_);
            }

            public ChunkCompileTask(ChunkPos pos, double p_194423_, boolean p_194424_) {
                this.f_112847_ = p_194423_;
                this.f_194420_ = p_194424_;
                this.modelData = pos == null ? Collections.emptyMap() : ModelDataManager.getModelData((Level)Minecraft.m_91087_().f_91073_, (ChunkPos)pos);
            }

            public abstract CompletableFuture<ChunkTaskResult> m_5869_(ChunkBufferBuilderPack var1);

            public abstract void m_6204_();

            protected abstract String m_183497_();

            @Override
            public int compareTo(ChunkCompileTask p_112855_) {
                return Doubles.compare((double)this.f_112847_, (double)p_112855_.f_112847_);
            }

            public IModelData getModelData(BlockPos pos) {
                return this.modelData.getOrDefault(pos, (IModelData)EmptyModelData.INSTANCE);
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        class RebuildTask
        extends ChunkCompileTask {
            @Nullable
            protected RenderChunkRegion f_112858_;

            @Deprecated
            public RebuildTask(double p_194427_, RenderChunkRegion p_194428_, boolean p_194429_) {
                this(null, p_194427_, p_194428_, p_194429_);
            }

            public RebuildTask(ChunkPos pos, @Nullable double p_194427_, RenderChunkRegion p_194428_, boolean p_194429_) {
                super(pos, p_194427_, p_194429_);
                this.f_112858_ = p_194428_;
            }

            @Override
            protected String m_183497_() {
                return "rend_chk_rebuild";
            }

            @Override
            public CompletableFuture<ChunkTaskResult> m_5869_(ChunkBufferBuilderPack p_112872_) {
                if (this.f_112848_.get()) {
                    return CompletableFuture.completedFuture(ChunkTaskResult.CANCELLED);
                }
                if (!RenderChunk.this.m_112798_()) {
                    this.f_112858_ = null;
                    RenderChunk.this.m_112828_(false);
                    this.f_112848_.set(true);
                    return CompletableFuture.completedFuture(ChunkTaskResult.CANCELLED);
                }
                if (this.f_112848_.get()) {
                    return CompletableFuture.completedFuture(ChunkTaskResult.CANCELLED);
                }
                Vec3 vec3 = ChunkRenderDispatcher.this.m_112727_();
                float f = (float)vec3.f_82479_;
                float f1 = (float)vec3.f_82480_;
                float f2 = (float)vec3.f_82481_;
                CompiledChunk chunkrenderdispatcher$compiledchunk = new CompiledChunk();
                Set<BlockEntity> set = this.m_112865_(f, f1, f2, chunkrenderdispatcher$compiledchunk, p_112872_);
                RenderChunk.this.m_112826_(set);
                if (this.f_112848_.get()) {
                    return CompletableFuture.completedFuture(ChunkTaskResult.CANCELLED);
                }
                ArrayList list = Lists.newArrayList();
                chunkrenderdispatcher$compiledchunk.f_112750_.forEach(p_112884_ -> list.add(ChunkRenderDispatcher.this.m_112695_(p_112872_.m_108839_(p_112884_), RenderChunk.this.m_112807_((RenderType)((Object)p_112884_)))));
                return Util.m_143840_(list).handle((p_199955_, p_199956_) -> {
                    if (p_199956_ != null && !(p_199956_ instanceof CancellationException) && !(p_199956_ instanceof InterruptedException)) {
                        CrashReport crashreport = CrashReport.m_127521_(p_199956_, "Rendering chunk");
                        Minecraft.m_91087_().m_199935_(() -> crashreport);
                    }
                    if (this.f_112848_.get()) {
                        return ChunkTaskResult.CANCELLED;
                    }
                    RenderChunk.this.f_112784_.set(chunkrenderdispatcher$compiledchunk);
                    RenderChunk.this.f_202433_.set(0);
                    ChunkRenderDispatcher.this.f_112682_.m_194352_(RenderChunk.this);
                    return ChunkTaskResult.SUCCESSFUL;
                });
            }

            private Set<BlockEntity> m_112865_(float p_112866_, float p_112867_, float p_112868_, CompiledChunk p_112869_, ChunkBufferBuilderPack p_112870_) {
                boolean i = true;
                BlockPos blockpos = RenderChunk.this.f_112793_.m_7949_();
                BlockPos blockpos1 = blockpos.m_142082_(15, 15, 15);
                VisGraph visgraph = new VisGraph();
                HashSet set = Sets.newHashSet();
                RenderChunkRegion renderchunkregion = this.f_112858_;
                this.f_112858_ = null;
                PoseStack posestack = new PoseStack();
                if (renderchunkregion != null) {
                    ModelBlockRenderer.m_111000_();
                    Random random = new Random();
                    BlockRenderDispatcher blockrenderdispatcher = Minecraft.m_91087_().m_91289_();
                    for (BlockPos blockpos2 : BlockPos.m_121940_((BlockPos)blockpos, (BlockPos)blockpos1)) {
                        BlockEntity blockentity;
                        BlockState blockstate = renderchunkregion.m_8055_(blockpos2);
                        if (blockstate.m_60804_((BlockGetter)renderchunkregion, blockpos2)) {
                            visgraph.m_112971_(blockpos2);
                        }
                        if (blockstate.m_155947_() && (blockentity = renderchunkregion.m_7702_(blockpos2)) != null) {
                            this.m_112877_(p_112869_, set, blockentity);
                        }
                        BlockState blockstate1 = renderchunkregion.m_8055_(blockpos2);
                        FluidState fluidstate = blockstate1.m_60819_();
                        IModelData modelData = this.getModelData(blockpos2);
                        for (RenderType rendertype : RenderType.m_110506_()) {
                            ForgeHooksClient.setRenderType((RenderType)rendertype);
                            if (!fluidstate.m_76178_() && ItemBlockRenderTypes.canRenderInLayer(fluidstate, rendertype)) {
                                BufferBuilder bufferbuilder = p_112870_.m_108839_(rendertype);
                                if (p_112869_.f_112750_.add(rendertype)) {
                                    RenderChunk.this.m_112805_(bufferbuilder);
                                }
                                if (blockrenderdispatcher.m_203143_(blockpos2, (BlockAndTintGetter)renderchunkregion, (VertexConsumer)((Object)bufferbuilder), blockstate1, fluidstate)) {
                                    p_112869_.f_112751_ = false;
                                    p_112869_.f_112749_.add(rendertype);
                                }
                            }
                            if (blockstate.m_60799_() == RenderShape.INVISIBLE || !ItemBlockRenderTypes.canRenderInLayer(blockstate, rendertype)) continue;
                            RenderType rendertype1 = rendertype;
                            BufferBuilder bufferbuilder2 = p_112870_.m_108839_(rendertype1);
                            if (p_112869_.f_112750_.add(rendertype1)) {
                                RenderChunk.this.m_112805_(bufferbuilder2);
                            }
                            posestack.m_85836_();
                            posestack.m_85837_((double)(blockpos2.m_123341_() & 0xF), (double)(blockpos2.m_123342_() & 0xF), (double)(blockpos2.m_123343_() & 0xF));
                            if (blockrenderdispatcher.renderBatched(blockstate, blockpos2, (BlockAndTintGetter)renderchunkregion, posestack, (VertexConsumer)((Object)bufferbuilder2), true, random, modelData)) {
                                p_112869_.f_112751_ = false;
                                p_112869_.f_112749_.add(rendertype1);
                            }
                            posestack.m_85849_();
                        }
                    }
                    ForgeHooksClient.setRenderType(null);
                    if (p_112869_.f_112749_.contains((Object)RenderType.m_110466_())) {
                        BufferBuilder bufferbuilder1 = p_112870_.m_108839_(RenderType.m_110466_());
                        bufferbuilder1.m_166771_(p_112866_ - (float)blockpos.m_123341_(), p_112867_ - (float)blockpos.m_123342_(), p_112868_ - (float)blockpos.m_123343_());
                        p_112869_.f_112754_ = bufferbuilder1.m_166770_();
                    }
                    p_112869_.f_112750_.stream().map(arg_0 -> ((ChunkBufferBuilderPack)p_112870_).m_108839_(arg_0)).forEach(BufferBuilder::m_85721_);
                    ModelBlockRenderer.m_111077_();
                }
                p_112869_.f_112753_ = visgraph.m_112958_();
                return set;
            }

            private <E extends BlockEntity> void m_112877_(CompiledChunk p_112878_, Set<BlockEntity> p_112879_, E p_112880_) {
                BlockEntityRenderer blockentityrenderer = Minecraft.m_91087_().m_167982_().m_112265_(p_112880_);
                if (blockentityrenderer != null) {
                    if (blockentityrenderer.m_5932_(p_112880_)) {
                        p_112879_.add(p_112880_);
                    } else {
                        p_112878_.f_112752_.add(p_112880_);
                    }
                }
            }

            @Override
            public void m_6204_() {
                this.f_112858_ = null;
                if (this.f_112848_.compareAndSet(false, true)) {
                    RenderChunk.this.m_112828_(false);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    static final class ChunkTaskResult
    extends Enum<ChunkTaskResult> {
        public static final /* enum */ ChunkTaskResult SUCCESSFUL = new ChunkTaskResult();
        public static final /* enum */ ChunkTaskResult CANCELLED = new ChunkTaskResult();
        private static final /* synthetic */ ChunkTaskResult[] $VALUES;

        public static ChunkTaskResult[] values() {
            return (ChunkTaskResult[])$VALUES.clone();
        }

        public static ChunkTaskResult valueOf(String p_112746_) {
            return Enum.valueOf(ChunkTaskResult.class, p_112746_);
        }

        private static /* synthetic */ ChunkTaskResult[] m_173715_() {
            return new ChunkTaskResult[]{SUCCESSFUL, CANCELLED};
        }

        static {
            $VALUES = ChunkTaskResult.m_173715_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class CompiledChunk {
        public static final CompiledChunk f_112748_ = new CompiledChunk(){

            @Override
            public boolean m_7259_(Direction p_112782_, Direction p_112783_) {
                return false;
            }
        };
        final Set<RenderType> f_112749_ = new ObjectArraySet();
        final Set<RenderType> f_112750_ = new ObjectArraySet();
        boolean f_112751_ = true;
        final List<BlockEntity> f_112752_ = Lists.newArrayList();
        VisibilitySet f_112753_ = new VisibilitySet();
        @Nullable
        BufferBuilder.SortState f_112754_;

        public boolean m_112757_() {
            return this.f_112751_;
        }

        public boolean m_112758_(RenderType p_112759_) {
            return !this.f_112749_.contains((Object)p_112759_);
        }

        public List<BlockEntity> m_112773_() {
            return this.f_112752_;
        }

        public boolean m_7259_(Direction p_112771_, Direction p_112772_) {
            return this.f_112753_.m_112983_(p_112771_, p_112772_);
        }
    }
}

