/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.dispenser;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.AbstractProjectileDispenseBehavior;
import net.minecraft.core.dispenser.BoatDispenseItemBehavior;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.core.dispenser.ShearsDispenseItemBehavior;
import net.minecraft.core.dispenser.ShulkerBoxDispenseBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.animal.horse.AbstractChestedHorse;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.entity.projectile.SpectralArrow;
import net.minecraft.world.entity.projectile.ThrownEgg;
import net.minecraft.world.entity.projectile.ThrownExperienceBottle;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.DispensibleContainerItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.CarvedPumpkinBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.RespawnAnchorBlock;
import net.minecraft.world.level.block.SaplingBlock;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.WitherSkullBlock;
import net.minecraft.world.level.block.entity.BeehiveBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.DispenserBlockEntity;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.TreeType;
import org.bukkit.World;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_18_R2.block.CapturedBlockState;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_18_R2.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_18_R2.projectiles.CraftBlockProjectileSource;
import org.bukkit.craftbukkit.v1_18_R2.util.DummyGeneratorAccess;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockDispenseArmorEvent;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.block.BlockFertilizeEvent;
import org.bukkit.event.world.StructureGrowEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import org.slf4j.Logger;

public interface DispenseItemBehavior {
    public static final Logger f_181892_ = LogUtils.getLogger();
    public static final DispenseItemBehavior f_123393_ = (p_123400_, p_123401_) -> p_123401_;

    public net.minecraft.world.item.ItemStack m_6115_(BlockSource var1, net.minecraft.world.item.ItemStack var2);

    public static void m_123402_() {
        DispenserBlock.m_52672_(Items.f_42412_, new AbstractProjectileDispenseBehavior(){

            @Override
            protected Projectile m_6895_(Level p_123407_, Position p_123408_, net.minecraft.world.item.ItemStack p_123409_) {
                Arrow arrow = new Arrow(p_123407_, p_123408_.m_7096_(), p_123408_.m_7098_(), p_123408_.m_7094_());
                arrow.f_36705_ = AbstractArrow.Pickup.ALLOWED;
                return arrow;
            }
        });
        DispenserBlock.m_52672_(Items.f_42738_, new AbstractProjectileDispenseBehavior(){

            @Override
            protected Projectile m_6895_(Level p_123420_, Position p_123421_, net.minecraft.world.item.ItemStack p_123422_) {
                Arrow arrow = new Arrow(p_123420_, p_123421_.m_7096_(), p_123421_.m_7098_(), p_123421_.m_7094_());
                arrow.m_36878_(p_123422_);
                arrow.f_36705_ = AbstractArrow.Pickup.ALLOWED;
                return arrow;
            }
        });
        DispenserBlock.m_52672_(Items.f_42737_, new AbstractProjectileDispenseBehavior(){

            @Override
            protected Projectile m_6895_(Level p_123456_, Position p_123457_, net.minecraft.world.item.ItemStack p_123458_) {
                SpectralArrow abstractarrow = new SpectralArrow(p_123456_, p_123457_.m_7096_(), p_123457_.m_7098_(), p_123457_.m_7094_());
                abstractarrow.f_36705_ = AbstractArrow.Pickup.ALLOWED;
                return abstractarrow;
            }
        });
        DispenserBlock.m_52672_(Items.f_42521_, new AbstractProjectileDispenseBehavior(){

            @Override
            protected Projectile m_6895_(Level p_123468_, Position p_123469_, net.minecraft.world.item.ItemStack p_123470_) {
                return Util.m_137469_(new ThrownEgg(p_123468_, p_123469_.m_7096_(), p_123469_.m_7098_(), p_123469_.m_7094_()), p_123466_ -> p_123466_.m_37446_(p_123470_));
            }
        });
        DispenserBlock.m_52672_(Items.f_42452_, new AbstractProjectileDispenseBehavior(){

            @Override
            protected Projectile m_6895_(Level p_123476_, Position p_123477_, net.minecraft.world.item.ItemStack p_123478_) {
                return (Projectile)Util.m_137469_(new Snowball(p_123476_, p_123477_.m_7096_(), p_123477_.m_7098_(), p_123477_.m_7094_()), p_123474_ -> p_123474_.m_37446_(p_123478_));
            }
        });
        DispenserBlock.m_52672_(Items.f_42612_, new AbstractProjectileDispenseBehavior(){

            @Override
            protected Projectile m_6895_(Level p_123485_, Position p_123486_, net.minecraft.world.item.ItemStack p_123487_) {
                return Util.m_137469_(new ThrownExperienceBottle(p_123485_, p_123486_.m_7096_(), p_123486_.m_7098_(), p_123486_.m_7094_()), p_123483_ -> p_123483_.m_37446_(p_123487_));
            }

            @Override
            protected float m_7101_() {
                return super.m_7101_() * 0.5f;
            }

            @Override
            protected float m_7104_() {
                return super.m_7104_() * 1.25f;
            }
        });
        DispenserBlock.m_52672_(Items.f_42736_, new DispenseItemBehavior(){

            @Override
            public net.minecraft.world.item.ItemStack m_6115_(BlockSource p_123491_, net.minecraft.world.item.ItemStack p_123492_) {
                return new AbstractProjectileDispenseBehavior(){

                    @Override
                    protected Projectile m_6895_(Level p_123501_, Position p_123502_, net.minecraft.world.item.ItemStack p_123503_) {
                        return Util.m_137469_(new ThrownPotion(p_123501_, p_123502_.m_7096_(), p_123502_.m_7098_(), p_123502_.m_7094_()), p_123499_ -> p_123499_.m_37446_(p_123503_));
                    }

                    @Override
                    protected float m_7101_() {
                        return super.m_7101_() * 0.5f;
                    }

                    @Override
                    protected float m_7104_() {
                        return super.m_7104_() * 1.25f;
                    }
                }.m_6115_(p_123491_, p_123492_);
            }
        });
        DispenserBlock.m_52672_(Items.f_42739_, new DispenseItemBehavior(){

            @Override
            public net.minecraft.world.item.ItemStack m_6115_(BlockSource p_123507_, net.minecraft.world.item.ItemStack p_123508_) {
                return new AbstractProjectileDispenseBehavior(){

                    @Override
                    protected Projectile m_6895_(Level p_123517_, Position p_123518_, net.minecraft.world.item.ItemStack p_123519_) {
                        return Util.m_137469_(new ThrownPotion(p_123517_, p_123518_.m_7096_(), p_123518_.m_7098_(), p_123518_.m_7094_()), p_123515_ -> p_123515_.m_37446_(p_123519_));
                    }

                    @Override
                    protected float m_7101_() {
                        return super.m_7101_() * 0.5f;
                    }

                    @Override
                    protected float m_7104_() {
                        return super.m_7104_() * 1.25f;
                    }
                }.m_6115_(p_123507_, p_123508_);
            }
        });
        DefaultDispenseItemBehavior defaultdispenseitembehavior = new DefaultDispenseItemBehavior(){

            @Override
            public net.minecraft.world.item.ItemStack m_7498_(BlockSource p_123523_, net.minecraft.world.item.ItemStack p_123524_) {
                Direction direction = (Direction)p_123523_.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
                EntityType<?> entitytype = ((SpawnEggItem)p_123524_.m_41720_()).m_43228_(p_123524_.m_41783_());
                ServerLevel worldserver = p_123523_.m_7727_();
                net.minecraft.world.item.ItemStack itemstack1 = p_123524_.m_41620_(1);
                org.bukkit.block.Block block = worldserver.getWorld().getBlockAt(p_123523_.m_7961_().m_123341_(), p_123523_.m_7961_().m_123342_(), p_123523_.m_7961_().m_123343_());
                CraftItemStack craftItem = CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)itemstack1);
                BlockDispenseEvent event = new BlockDispenseEvent(block, (ItemStack)craftItem.clone(), new Vector(0, 0, 0));
                if (!DispenserBlock.eventFired) {
                    Bukkit.getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    p_123524_.m_41769_(1);
                    return p_123524_;
                }
                if (!event.getItem().equals((Object)craftItem)) {
                    p_123524_.m_41769_(1);
                    net.minecraft.world.item.ItemStack eventStack = CraftItemStack.asNMSCopy((ItemStack)event.getItem());
                    DispenseItemBehavior idispensebehavior = DispenserBlock.f_52661_.get((Object)eventStack.m_41720_());
                    if (idispensebehavior != f_123393_ && idispensebehavior != this) {
                        idispensebehavior.m_6115_(p_123523_, eventStack);
                        return p_123524_;
                    }
                }
                try {
                    entitytype.m_20592_(p_123523_.m_7727_(), p_123524_, null, p_123523_.m_7961_().m_142300_(direction), MobSpawnType.DISPENSER, direction != Direction.UP, false);
                }
                catch (Exception exception) {
                    f_181892_.error("Error while dispensing spawn egg from dispenser at {}", (Object)p_123523_.m_7961_(), (Object)exception);
                    return net.minecraft.world.item.ItemStack.f_41583_;
                }
                p_123523_.m_7727_().m_151555_(GameEvent.f_157810_, p_123523_.m_7961_());
                return p_123524_;
            }
        };
        for (SpawnEggItem spawneggitem : SpawnEggItem.m_43233_()) {
            DispenserBlock.m_52672_(spawneggitem, defaultdispenseitembehavior);
        }
        DispenserBlock.m_52672_(Items.f_42650_, new DefaultDispenseItemBehavior(){

            @Override
            public net.minecraft.world.item.ItemStack m_7498_(BlockSource p_123461_, net.minecraft.world.item.ItemStack p_123462_) {
                Direction direction = (Direction)p_123461_.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
                BlockPos blockpos = p_123461_.m_7961_().m_142300_(direction);
                ServerLevel level = p_123461_.m_7727_();
                net.minecraft.world.item.ItemStack itemstack1 = p_123462_.m_41620_(1);
                org.bukkit.block.Block block = level.getWorld().getBlockAt(p_123461_.m_7961_().m_123341_(), p_123461_.m_7961_().m_123342_(), p_123461_.m_7961_().m_123343_());
                CraftItemStack craftItem = CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)itemstack1);
                BlockDispenseEvent event = new BlockDispenseEvent(block, (ItemStack)craftItem.clone(), new Vector(0, 0, 0));
                if (!DispenserBlock.eventFired) {
                    Bukkit.getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    p_123462_.m_41769_(1);
                    return p_123462_;
                }
                if (!event.getItem().equals((Object)craftItem)) {
                    p_123462_.m_41769_(1);
                    net.minecraft.world.item.ItemStack eventStack = CraftItemStack.asNMSCopy((ItemStack)event.getItem());
                    DispenseItemBehavior idispensebehavior = DispenserBlock.f_52661_.get((Object)eventStack.m_41720_());
                    if (idispensebehavior != f_123393_ && idispensebehavior != this) {
                        idispensebehavior.m_6115_(p_123461_, eventStack);
                        return p_123462_;
                    }
                }
                ArmorStand armorstand = new ArmorStand(level, (double)blockpos.m_123341_() + 0.5, blockpos.m_123342_(), (double)blockpos.m_123343_() + 0.5);
                EntityType.m_20620_(level, null, armorstand, p_123462_.m_41783_());
                armorstand.m_146922_(direction.m_122435_());
                level.m_7967_(armorstand);
                return p_123462_;
            }
        });
        DispenserBlock.m_52672_(Items.f_42450_, (DispenseItemBehavior)new OptionalDispenseItemBehavior(){

            public net.minecraft.world.item.ItemStack m_7498_(BlockSource p_123529_, net.minecraft.world.item.ItemStack p_123530_) {
                BlockPos blockpos = p_123529_.m_7961_().m_142300_((Direction)p_123529_.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
                List list = p_123529_.m_7727_().m_6443_(net.minecraft.world.entity.LivingEntity.class, new AABB(blockpos), p_123527_ -> {
                    if (!(p_123527_ instanceof Saddleable)) {
                        return false;
                    }
                    Saddleable saddleable = (Saddleable)p_123527_;
                    return !saddleable.m_6254_() && saddleable.m_6741_();
                });
                if (!list.isEmpty()) {
                    net.minecraft.world.item.ItemStack itemstack1 = p_123530_.m_41620_(1);
                    ServerLevel world = p_123529_.m_7727_();
                    org.bukkit.block.Block block = world.getWorld().getBlockAt(p_123529_.m_7961_().m_123341_(), p_123529_.m_7961_().m_123342_(), p_123529_.m_7961_().m_123343_());
                    CraftItemStack craftItem = CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)itemstack1);
                    BlockDispenseArmorEvent event = new BlockDispenseArmorEvent(block, (ItemStack)craftItem.clone(), (LivingEntity)((CraftLivingEntity)((net.minecraft.world.entity.LivingEntity)list.get(0)).getBukkitEntity()));
                    if (!DispenserBlock.eventFired) {
                        Bukkit.getPluginManager().callEvent((Event)event);
                    }
                    if (event.isCancelled()) {
                        p_123530_.m_41769_(1);
                        return p_123530_;
                    }
                    if (!event.getItem().equals((Object)craftItem)) {
                        p_123530_.m_41769_(1);
                        net.minecraft.world.item.ItemStack eventStack = CraftItemStack.asNMSCopy((ItemStack)event.getItem());
                        DispenseItemBehavior idispensebehavior = DispenserBlock.f_52661_.get((Object)eventStack.m_41720_());
                        if (idispensebehavior != f_123393_ && idispensebehavior != ArmorItem.f_40376_) {
                            idispensebehavior.m_6115_(p_123529_, eventStack);
                            return p_123530_;
                        }
                    }
                    ((Saddleable)list.get(0)).m_5853_(SoundSource.BLOCKS);
                    this.m_123573_(true);
                    return p_123530_;
                }
                return super.m_7498_(p_123529_, p_123530_);
            }
        });
        OptionalDispenseItemBehavior defaultdispenseitembehavior1 = new OptionalDispenseItemBehavior(){

            protected net.minecraft.world.item.ItemStack m_7498_(BlockSource p_123535_, net.minecraft.world.item.ItemStack p_123536_) {
                BlockPos blockpos = p_123535_.m_7961_().m_142300_((Direction)p_123535_.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
                for (AbstractHorse abstracthorse : p_123535_.m_7727_().m_6443_(AbstractHorse.class, new AABB(blockpos), p_123533_ -> p_123533_.m_6084_() && p_123533_.m_7482_())) {
                    if (!abstracthorse.m_6010_(p_123536_) || abstracthorse.m_7481_() || !abstracthorse.m_30614_()) continue;
                    net.minecraft.world.item.ItemStack itemstack1 = p_123536_.m_41620_(1);
                    ServerLevel world = p_123535_.m_7727_();
                    org.bukkit.block.Block block = world.getWorld().getBlockAt(p_123535_.m_7961_().m_123341_(), p_123535_.m_7961_().m_123342_(), p_123535_.m_7961_().m_123343_());
                    CraftItemStack craftItem = CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)itemstack1);
                    BlockDispenseArmorEvent event = new BlockDispenseArmorEvent(block, (ItemStack)craftItem.clone(), (LivingEntity)((CraftLivingEntity)abstracthorse.getBukkitEntity()));
                    if (!DispenserBlock.eventFired) {
                        Bukkit.getPluginManager().callEvent((Event)event);
                    }
                    if (event.isCancelled()) {
                        p_123536_.m_41769_(1);
                        return p_123536_;
                    }
                    if (!event.getItem().equals((Object)craftItem)) {
                        p_123536_.m_41769_(1);
                        net.minecraft.world.item.ItemStack eventStack = CraftItemStack.asNMSCopy((ItemStack)event.getItem());
                        DispenseItemBehavior idispensebehavior = DispenserBlock.f_52661_.get((Object)eventStack.m_41720_());
                        if (idispensebehavior != f_123393_ && idispensebehavior != ArmorItem.f_40376_) {
                            idispensebehavior.m_6115_(p_123535_, eventStack);
                            return p_123536_;
                        }
                    }
                    abstracthorse.m_141942_(401).m_142104_(CraftItemStack.asNMSCopy((ItemStack)event.getItem()));
                    this.m_123573_(true);
                    return p_123536_;
                }
                return super.m_7498_(p_123535_, p_123536_);
            }
        };
        DispenserBlock.m_52672_(Items.f_42654_, (DispenseItemBehavior)defaultdispenseitembehavior1);
        DispenserBlock.m_52672_(Items.f_42651_, (DispenseItemBehavior)defaultdispenseitembehavior1);
        DispenserBlock.m_52672_(Items.f_42652_, (DispenseItemBehavior)defaultdispenseitembehavior1);
        DispenserBlock.m_52672_(Items.f_42653_, (DispenseItemBehavior)defaultdispenseitembehavior1);
        DispenserBlock.m_52672_(Items.f_42130_, (DispenseItemBehavior)defaultdispenseitembehavior1);
        DispenserBlock.m_52672_(Items.f_42131_, (DispenseItemBehavior)defaultdispenseitembehavior1);
        DispenserBlock.m_52672_(Items.f_42139_, (DispenseItemBehavior)defaultdispenseitembehavior1);
        DispenserBlock.m_52672_(Items.f_42141_, (DispenseItemBehavior)defaultdispenseitembehavior1);
        DispenserBlock.m_52672_(Items.f_42142_, (DispenseItemBehavior)defaultdispenseitembehavior1);
        DispenserBlock.m_52672_(Items.f_42198_, (DispenseItemBehavior)defaultdispenseitembehavior1);
        DispenserBlock.m_52672_(Items.f_42137_, (DispenseItemBehavior)defaultdispenseitembehavior1);
        DispenserBlock.m_52672_(Items.f_42143_, (DispenseItemBehavior)defaultdispenseitembehavior1);
        DispenserBlock.m_52672_(Items.f_42133_, (DispenseItemBehavior)defaultdispenseitembehavior1);
        DispenserBlock.m_52672_(Items.f_42138_, (DispenseItemBehavior)defaultdispenseitembehavior1);
        DispenserBlock.m_52672_(Items.f_42135_, (DispenseItemBehavior)defaultdispenseitembehavior1);
        DispenserBlock.m_52672_(Items.f_42132_, (DispenseItemBehavior)defaultdispenseitembehavior1);
        DispenserBlock.m_52672_(Items.f_42136_, (DispenseItemBehavior)defaultdispenseitembehavior1);
        DispenserBlock.m_52672_(Items.f_42140_, (DispenseItemBehavior)defaultdispenseitembehavior1);
        DispenserBlock.m_52672_(Items.f_42197_, (DispenseItemBehavior)defaultdispenseitembehavior1);
        DispenserBlock.m_52672_(Items.f_42134_, (DispenseItemBehavior)defaultdispenseitembehavior1);
        DispenserBlock.m_52672_(Items.f_42009_, (DispenseItemBehavior)new OptionalDispenseItemBehavior(){

            public net.minecraft.world.item.ItemStack m_7498_(BlockSource p_123541_, net.minecraft.world.item.ItemStack p_123542_) {
                BlockPos blockpos = p_123541_.m_7961_().m_142300_((Direction)p_123541_.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
                for (AbstractChestedHorse abstractchestedhorse : p_123541_.m_7727_().m_6443_(AbstractChestedHorse.class, new AABB(blockpos), p_123539_ -> p_123539_.m_6084_() && !p_123539_.m_30502_())) {
                    net.minecraft.world.item.ItemStack eventStack;
                    DispenseItemBehavior idispensebehavior;
                    if (!abstractchestedhorse.m_30614_() || !abstractchestedhorse.m_141942_(499).m_142104_(p_123542_)) continue;
                    net.minecraft.world.item.ItemStack itemstack1 = p_123542_.m_41620_(1);
                    ServerLevel world = p_123541_.m_7727_();
                    org.bukkit.block.Block block = world.getWorld().getBlockAt(p_123541_.m_7961_().m_123341_(), p_123541_.m_7961_().m_123342_(), p_123541_.m_7961_().m_123343_());
                    CraftItemStack craftItem = CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)itemstack1);
                    BlockDispenseArmorEvent event = new BlockDispenseArmorEvent(block, (ItemStack)craftItem.clone(), (LivingEntity)((CraftLivingEntity)abstractchestedhorse.getBukkitEntity()));
                    if (!DispenserBlock.eventFired) {
                        Bukkit.getPluginManager().callEvent((Event)event);
                    }
                    if (event.isCancelled()) {
                        return p_123542_;
                    }
                    if (!event.getItem().equals((Object)craftItem) && (idispensebehavior = DispenserBlock.f_52661_.get((Object)(eventStack = CraftItemStack.asNMSCopy((ItemStack)event.getItem())).m_41720_())) != f_123393_ && idispensebehavior != ArmorItem.f_40376_) {
                        idispensebehavior.m_6115_(p_123541_, eventStack);
                        return p_123542_;
                    }
                    abstractchestedhorse.m_141942_(499).m_142104_(CraftItemStack.asNMSCopy((ItemStack)event.getItem()));
                    this.m_123573_(true);
                    return p_123542_;
                }
                return super.m_7498_(p_123541_, p_123542_);
            }
        });
        DispenserBlock.m_52672_(Items.f_42688_, new DefaultDispenseItemBehavior(){

            @Override
            public net.minecraft.world.item.ItemStack m_7498_(BlockSource p_123547_, net.minecraft.world.item.ItemStack p_123548_) {
                Direction direction = (Direction)p_123547_.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
                ServerLevel worldserver = p_123547_.m_7727_();
                net.minecraft.world.item.ItemStack itemstack1 = p_123548_.m_41620_(1);
                org.bukkit.block.Block block = worldserver.getWorld().getBlockAt(p_123547_.m_7961_().m_123341_(), p_123547_.m_7961_().m_123342_(), p_123547_.m_7961_().m_123343_());
                CraftItemStack craftItem = CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)itemstack1);
                BlockDispenseEvent event = new BlockDispenseEvent(block, (ItemStack)craftItem.clone(), new Vector(direction.m_122429_(), direction.m_122430_(), direction.m_122431_()));
                if (!DispenserBlock.eventFired) {
                    worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    p_123548_.m_41769_(1);
                    return p_123548_;
                }
                if (!event.getItem().equals((Object)craftItem)) {
                    p_123548_.m_41769_(1);
                    net.minecraft.world.item.ItemStack eventStack = CraftItemStack.asNMSCopy((ItemStack)event.getItem());
                    DispenseItemBehavior idispensebehavior = DispenserBlock.f_52661_.get((Object)eventStack.m_41720_());
                    if (idispensebehavior != f_123393_ && idispensebehavior != this) {
                        idispensebehavior.m_6115_(p_123547_, eventStack);
                        return p_123548_;
                    }
                }
                itemstack1 = CraftItemStack.asNMSCopy((ItemStack)event.getItem());
                FireworkRocketEntity fireworkrocketentity = new FireworkRocketEntity((Level)p_123547_.m_7727_(), p_123548_, p_123547_.m_7096_(), p_123547_.m_7098_(), p_123547_.m_7096_(), true);
                DispenseItemBehavior.m_123395_(p_123547_, fireworkrocketentity, direction);
                fireworkrocketentity.m_6686_(direction.m_122429_(), direction.m_122430_(), direction.m_122431_(), 0.5f, 1.0f);
                p_123547_.m_7727_().m_7967_(fireworkrocketentity);
                return p_123548_;
            }

            @Override
            protected void m_6823_(BlockSource p_123545_) {
                p_123545_.m_7727_().m_46796_(1004, p_123545_.m_7961_(), 0);
            }
        });
        DispenserBlock.m_52672_(Items.f_42613_, new DefaultDispenseItemBehavior(){

            @Override
            public net.minecraft.world.item.ItemStack m_7498_(BlockSource p_123556_, net.minecraft.world.item.ItemStack p_123557_) {
                Direction direction = (Direction)p_123556_.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
                Position position = DispenserBlock.m_52720_(p_123556_);
                double d0 = position.m_7096_() + (double)((float)direction.m_122429_() * 0.3f);
                double d1 = position.m_7098_() + (double)((float)direction.m_122430_() * 0.3f);
                double d2 = position.m_7094_() + (double)((float)direction.m_122431_() * 0.3f);
                ServerLevel level = p_123556_.m_7727_();
                Random random = level.f_46441_;
                double d3 = random.nextGaussian() * 0.05 + (double)direction.m_122429_();
                double d4 = random.nextGaussian() * 0.05 + (double)direction.m_122430_();
                double d5 = random.nextGaussian() * 0.05 + (double)direction.m_122431_();
                net.minecraft.world.item.ItemStack itemstack1 = p_123557_.m_41620_(1);
                org.bukkit.block.Block block = level.getWorld().getBlockAt(p_123556_.m_7961_().m_123341_(), p_123556_.m_7961_().m_123342_(), p_123556_.m_7961_().m_123343_());
                CraftItemStack craftItem = CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)itemstack1);
                BlockDispenseEvent event = new BlockDispenseEvent(block, (ItemStack)craftItem.clone(), new Vector(d3, d4, d5));
                if (!DispenserBlock.eventFired) {
                    Bukkit.getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    p_123557_.m_41769_(1);
                    return p_123557_;
                }
                if (!event.getItem().equals((Object)craftItem)) {
                    p_123557_.m_41769_(1);
                    net.minecraft.world.item.ItemStack eventStack = CraftItemStack.asNMSCopy((ItemStack)event.getItem());
                    DispenseItemBehavior idispensebehavior = DispenserBlock.f_52661_.get((Object)eventStack.m_41720_());
                    if (idispensebehavior != f_123393_ && idispensebehavior != this) {
                        idispensebehavior.m_6115_(p_123556_, eventStack);
                        return p_123557_;
                    }
                }
                SmallFireball entitysmallfireball = new SmallFireball(level, d0, d1, d2, event.getVelocity().getX(), event.getVelocity().getY(), event.getVelocity().getZ());
                entitysmallfireball.m_37010_(itemstack1);
                entitysmallfireball.projectileSource = new CraftBlockProjectileSource((DispenserBlockEntity)((Object)p_123556_.m_8118_()));
                level.m_7967_(entitysmallfireball);
                return p_123557_;
            }

            @Override
            protected void m_6823_(BlockSource p_123554_) {
                p_123554_.m_7727_().m_46796_(1018, p_123554_.m_7961_(), 0);
            }
        });
        DispenserBlock.m_52672_(Items.f_42453_, new BoatDispenseItemBehavior(Boat.Type.OAK));
        DispenserBlock.m_52672_(Items.f_42742_, new BoatDispenseItemBehavior(Boat.Type.SPRUCE));
        DispenserBlock.m_52672_(Items.f_42743_, new BoatDispenseItemBehavior(Boat.Type.BIRCH));
        DispenserBlock.m_52672_(Items.f_42744_, new BoatDispenseItemBehavior(Boat.Type.JUNGLE));
        DispenserBlock.m_52672_(Items.f_42746_, new BoatDispenseItemBehavior(Boat.Type.DARK_OAK));
        DispenserBlock.m_52672_(Items.f_42745_, new BoatDispenseItemBehavior(Boat.Type.ACACIA));
        DefaultDispenseItemBehavior dispenseitembehavior1 = new DefaultDispenseItemBehavior(){
            private final DefaultDispenseItemBehavior f_123558_ = new DefaultDispenseItemBehavior();

            @Override
            public net.minecraft.world.item.ItemStack m_7498_(BlockSource p_123561_, net.minecraft.world.item.ItemStack p_123562_) {
                DispensibleContainerItem dispensiblecontaineritem = (DispensibleContainerItem)((Object)p_123562_.m_41720_());
                BlockPos blockpos = p_123561_.m_7961_().m_142300_((Direction)p_123561_.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
                ServerLevel level = p_123561_.m_7727_();
                int x = blockpos.m_123341_();
                int y = blockpos.m_123342_();
                int z = blockpos.m_123343_();
                net.minecraft.world.level.block.state.BlockState iblockdata = level.m_8055_(blockpos);
                Material material = iblockdata.m_60767_();
                if (level.m_46859_(blockpos) || !material.m_76333_() || material.m_76336_() || dispensiblecontaineritem instanceof BucketItem && iblockdata.m_60734_() instanceof LiquidBlockContainer && ((LiquidBlockContainer)iblockdata.m_60734_()).m_6044_((BlockGetter)((Object)level), blockpos, iblockdata, ((BucketItem)dispensiblecontaineritem).f_40687_)) {
                    net.minecraft.world.item.ItemStack eventStack;
                    DispenseItemBehavior idispensebehavior;
                    org.bukkit.block.Block block = level.getWorld().getBlockAt(p_123561_.m_7961_().m_123341_(), p_123561_.m_7961_().m_123342_(), p_123561_.m_7961_().m_123343_());
                    CraftItemStack craftItem = CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)p_123562_);
                    BlockDispenseEvent event = new BlockDispenseEvent(block, (ItemStack)craftItem.clone(), new Vector(x, y, z));
                    if (!DispenserBlock.eventFired) {
                        level.getCraftServer().getPluginManager().callEvent((Event)event);
                    }
                    if (event.isCancelled()) {
                        return p_123562_;
                    }
                    if (!event.getItem().equals((Object)craftItem) && (idispensebehavior = DispenserBlock.f_52661_.get((Object)(eventStack = CraftItemStack.asNMSCopy((ItemStack)event.getItem())).m_41720_())) != f_123393_ && idispensebehavior != this) {
                        idispensebehavior.m_6115_(p_123561_, eventStack);
                        return p_123562_;
                    }
                    dispensiblecontaineritem = (DispensibleContainerItem)((Object)CraftItemStack.asNMSCopy((ItemStack)event.getItem()).m_41720_());
                }
                if (dispensiblecontaineritem.emptyContents(null, level, blockpos, null, p_123562_)) {
                    dispensiblecontaineritem.m_142131_(null, level, p_123562_, blockpos);
                    Item item = Items.f_42446_;
                    p_123562_.m_41774_(1);
                    if (p_123562_.m_41619_()) {
                        p_123562_.setItem(Items.f_42446_);
                        p_123562_.m_41764_(1);
                    } else if (((DispenserBlockEntity)((Object)p_123561_.m_8118_())).m_59237_(new net.minecraft.world.item.ItemStack(item)) < 0) {
                        this.f_123558_.m_6115_(p_123561_, new net.minecraft.world.item.ItemStack(item));
                    }
                    return p_123562_;
                }
                return this.f_123558_.m_6115_(p_123561_, p_123562_);
            }
        };
        DispenserBlock.m_52672_(Items.f_42448_, dispenseitembehavior1);
        DispenserBlock.m_52672_(Items.f_42447_, dispenseitembehavior1);
        DispenserBlock.m_52672_(Items.f_151055_, dispenseitembehavior1);
        DispenserBlock.m_52672_(Items.f_42457_, dispenseitembehavior1);
        DispenserBlock.m_52672_(Items.f_42458_, dispenseitembehavior1);
        DispenserBlock.m_52672_(Items.f_42456_, dispenseitembehavior1);
        DispenserBlock.m_52672_(Items.f_42459_, dispenseitembehavior1);
        DispenserBlock.m_52672_(Items.f_151057_, dispenseitembehavior1);
        DispenserBlock.m_52672_(Items.f_42446_, new DefaultDispenseItemBehavior(){
            private final DefaultDispenseItemBehavior f_123563_ = new DefaultDispenseItemBehavior();

            @Override
            public net.minecraft.world.item.ItemStack m_7498_(BlockSource p_123566_, net.minecraft.world.item.ItemStack p_123567_) {
                BlockPos blockpos;
                ServerLevel levelaccessor = p_123566_.m_7727_();
                net.minecraft.world.level.block.state.BlockState blockstate = levelaccessor.m_8055_(blockpos = p_123566_.m_7961_().m_142300_((Direction)p_123566_.m_6414_().m_61143_((Property)DispenserBlock.f_52659_)));
                Block block = blockstate.m_60734_();
                if (block instanceof BucketPickup) {
                    net.minecraft.world.item.ItemStack eventStack;
                    DispenseItemBehavior idispensebehavior;
                    net.minecraft.world.item.ItemStack itemstack = ((BucketPickup)((Object)block)).m_142598_((LevelAccessor)DummyGeneratorAccess.INSTANCE, blockpos, blockstate);
                    if (itemstack.m_41619_()) {
                        return super.m_7498_(p_123566_, p_123567_);
                    }
                    levelaccessor.m_142346_(null, GameEvent.f_157816_, blockpos);
                    Item item = itemstack.m_41720_();
                    org.bukkit.block.Block bukkitBlock = p_123566_.m_7727_().getWorld().getBlockAt(p_123566_.m_7961_().m_123341_(), p_123566_.m_7961_().m_123342_(), p_123566_.m_7961_().m_123343_());
                    CraftItemStack craftItem = CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)itemstack);
                    BlockDispenseEvent event = new BlockDispenseEvent(bukkitBlock, (ItemStack)craftItem.clone(), new Vector(blockpos.m_123341_(), blockpos.m_123342_(), blockpos.m_123343_()));
                    if (!DispenserBlock.eventFired) {
                        Bukkit.getPluginManager().callEvent((Event)event);
                    }
                    if (event.isCancelled()) {
                        return itemstack;
                    }
                    if (!event.getItem().equals((Object)craftItem) && (idispensebehavior = DispenserBlock.f_52661_.get((Object)(eventStack = CraftItemStack.asNMSCopy((ItemStack)event.getItem())).m_41720_())) != f_123393_ && idispensebehavior != this) {
                        idispensebehavior.m_6115_(p_123566_, eventStack);
                        return itemstack;
                    }
                    itemstack = ((BucketPickup)((Object)block)).m_142598_(levelaccessor, blockpos, blockstate);
                    p_123567_.m_41774_(1);
                    if (p_123567_.m_41619_()) {
                        return new net.minecraft.world.item.ItemStack(item);
                    }
                    if (((DispenserBlockEntity)((Object)p_123566_.m_8118_())).m_59237_(new net.minecraft.world.item.ItemStack(item)) < 0) {
                        this.f_123563_.m_6115_(p_123566_, new net.minecraft.world.item.ItemStack(item));
                    }
                    return p_123567_;
                }
                return super.m_7498_(p_123566_, p_123567_);
            }
        });
        DispenserBlock.m_52672_(Items.f_42409_, (DispenseItemBehavior)new OptionalDispenseItemBehavior(){

            protected net.minecraft.world.item.ItemStack m_7498_(BlockSource p_123412_, net.minecraft.world.item.ItemStack p_123413_) {
                net.minecraft.world.item.ItemStack eventStack;
                DispenseItemBehavior idispensebehavior;
                ServerLevel level = p_123412_.m_7727_();
                org.bukkit.block.Block bukkitBlock = level.getWorld().getBlockAt(p_123412_.m_7961_().m_123341_(), p_123412_.m_7961_().m_123342_(), p_123412_.m_7961_().m_123343_());
                CraftItemStack craftItem = CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)p_123413_);
                BlockDispenseEvent event = new BlockDispenseEvent(bukkitBlock, (ItemStack)craftItem.clone(), new Vector(0, 0, 0));
                if (!DispenserBlock.eventFired) {
                    Bukkit.getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    return p_123413_;
                }
                if (!event.getItem().equals((Object)craftItem) && (idispensebehavior = DispenserBlock.f_52661_.get((Object)(eventStack = CraftItemStack.asNMSCopy((ItemStack)event.getItem())).m_41720_())) != f_123393_ && idispensebehavior != this) {
                    idispensebehavior.m_6115_(p_123412_, eventStack);
                    return p_123413_;
                }
                this.m_123573_(true);
                Direction direction = (Direction)p_123412_.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
                BlockPos blockpos = p_123412_.m_7961_().m_142300_(direction);
                net.minecraft.world.level.block.state.BlockState blockstate = level.m_8055_(blockpos);
                if (BaseFireBlock.m_49255_(level, blockpos, direction)) {
                    if (!CraftEventFactory.callBlockIgniteEvent((Level)level, (BlockPos)blockpos, (BlockPos)p_123412_.m_7961_()).isCancelled()) {
                        level.m_46597_(blockpos, BaseFireBlock.m_49245_((BlockGetter)((Object)level), blockpos));
                        level.m_142346_(null, GameEvent.f_157797_, blockpos);
                    }
                } else if (!(CampfireBlock.m_51321_(blockstate) || CandleBlock.m_152845_((net.minecraft.world.level.block.state.BlockState)blockstate) || CandleCakeBlock.m_152910_((net.minecraft.world.level.block.state.BlockState)blockstate))) {
                    if (blockstate.isFlammable((BlockGetter)((Object)level), blockpos, ((Direction)p_123412_.m_6414_().m_61143_((Property)DispenserBlock.f_52659_)).m_122424_())) {
                        blockstate.onCaughtFire(level, blockpos, ((Direction)p_123412_.m_6414_().m_61143_((Property)DispenserBlock.f_52659_)).m_122424_(), null);
                        if (blockstate.m_60734_() instanceof TntBlock) {
                            level.m_7471_(blockpos, false);
                        }
                    } else {
                        this.m_123573_(false);
                    }
                } else {
                    level.m_46597_(blockpos, (net.minecraft.world.level.block.state.BlockState)((Object)blockstate.m_61124_((Property)BlockStateProperties.f_61443_, Boolean.valueOf(true))));
                    level.m_142346_(null, GameEvent.f_157792_, blockpos);
                }
                if (this.m_123570_() && p_123413_.m_41629_(1, level.f_46441_, null)) {
                    p_123413_.m_41764_(0);
                }
                return p_123413_;
            }
        });
        DispenserBlock.m_52672_(Items.f_42499_, (DispenseItemBehavior)new OptionalDispenseItemBehavior(){

            protected net.minecraft.world.item.ItemStack m_7498_(BlockSource p_123416_, net.minecraft.world.item.ItemStack p_123417_) {
                net.minecraft.world.item.ItemStack eventStack;
                DispenseItemBehavior idispensebehavior;
                this.m_123573_(true);
                ServerLevel level = p_123416_.m_7727_();
                BlockPos blockpos = p_123416_.m_7961_().m_142300_((Direction)p_123416_.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
                org.bukkit.block.Block block = level.getWorld().getBlockAt(p_123416_.m_7961_().m_123341_(), p_123416_.m_7961_().m_123342_(), p_123416_.m_7961_().m_123343_());
                CraftItemStack craftItem = CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)p_123417_);
                BlockDispenseEvent event = new BlockDispenseEvent(block, (ItemStack)craftItem.clone(), new Vector(0, 0, 0));
                if (!DispenserBlock.eventFired) {
                    Bukkit.getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    return p_123417_;
                }
                if (!event.getItem().equals((Object)craftItem) && (idispensebehavior = DispenserBlock.f_52661_.get((Object)(eventStack = CraftItemStack.asNMSCopy((ItemStack)event.getItem())).m_41720_())) != f_123393_ && idispensebehavior != this) {
                    idispensebehavior.m_6115_(p_123416_, eventStack);
                    return p_123417_;
                }
                level.captureTreeGeneration = true;
                if (!BoneMealItem.m_40627_(p_123417_, level, blockpos) && !BoneMealItem.m_40631_(p_123417_, level, blockpos, null)) {
                    this.m_123573_(false);
                } else if (!level.f_46443_) {
                    level.m_46796_(1505, blockpos, 0);
                }
                level.captureTreeGeneration = false;
                if (level.capturedBlockStates.size() > 0) {
                    TreeType treeType = SaplingBlock.treeType;
                    SaplingBlock.treeType = null;
                    Location location = new Location((World)level.getWorld(), (double)blockpos.m_123341_(), (double)blockpos.m_123342_(), (double)blockpos.m_123343_());
                    ArrayList<CapturedBlockState> blocks = new ArrayList<CapturedBlockState>(level.capturedBlockStates.values());
                    level.capturedBlockStates.clear();
                    StructureGrowEvent structureEvent = null;
                    if (treeType != null) {
                        structureEvent = new StructureGrowEvent(location, treeType, false, null, blocks);
                        Bukkit.getPluginManager().callEvent((Event)structureEvent);
                    }
                    BlockFertilizeEvent fertilizeEvent = new BlockFertilizeEvent(location.getBlock(), null, blocks);
                    fertilizeEvent.setCancelled(structureEvent != null && structureEvent.isCancelled());
                    Bukkit.getPluginManager().callEvent((Event)fertilizeEvent);
                    if (!fertilizeEvent.isCancelled()) {
                        for (BlockState blockState : blocks) {
                            blockState.update(true);
                        }
                    }
                }
                return p_123417_;
            }
        });
        DispenserBlock.m_52672_(Blocks.f_50077_, new DefaultDispenseItemBehavior(){

            @Override
            protected net.minecraft.world.item.ItemStack m_7498_(BlockSource p_123425_, net.minecraft.world.item.ItemStack p_123426_) {
                ServerLevel level = p_123425_.m_7727_();
                BlockPos blockpos = p_123425_.m_7961_().m_142300_((Direction)p_123425_.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
                net.minecraft.world.item.ItemStack itemstack1 = p_123426_.m_41620_(1);
                org.bukkit.block.Block block = level.getWorld().getBlockAt(p_123425_.m_7961_().m_123341_(), p_123425_.m_7961_().m_123342_(), p_123425_.m_7961_().m_123343_());
                CraftItemStack craftItem = CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)itemstack1);
                BlockDispenseEvent event = new BlockDispenseEvent(block, (ItemStack)craftItem.clone(), new Vector((double)blockpos.m_123341_() + 0.5, (double)blockpos.m_123342_(), (double)blockpos.m_123343_() + 0.5));
                if (!DispenserBlock.eventFired) {
                    Bukkit.getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    p_123426_.m_41769_(1);
                    return p_123426_;
                }
                if (!event.getItem().equals((Object)craftItem)) {
                    p_123426_.m_41769_(1);
                    net.minecraft.world.item.ItemStack eventStack = CraftItemStack.asNMSCopy((ItemStack)event.getItem());
                    DispenseItemBehavior idispensebehavior = DispenserBlock.f_52661_.get((Object)eventStack.m_41720_());
                    if (idispensebehavior != f_123393_ && idispensebehavior != this) {
                        idispensebehavior.m_6115_(p_123425_, eventStack);
                        return p_123426_;
                    }
                }
                PrimedTnt primedtnt = new PrimedTnt(level, event.getVelocity().getX(), event.getVelocity().getY(), event.getVelocity().getZ(), null);
                level.m_7967_(primedtnt);
                ((Level)level).m_6263_(null, primedtnt.m_20185_(), primedtnt.m_20186_(), primedtnt.m_20189_(), SoundEvents.f_12512_, SoundSource.BLOCKS, 1.0f, 1.0f);
                level.m_142346_(null, GameEvent.f_157810_, blockpos);
                return p_123426_;
            }
        });
        OptionalDispenseItemBehavior dispenseitembehavior = new OptionalDispenseItemBehavior(){

            protected net.minecraft.world.item.ItemStack m_7498_(BlockSource p_123429_, net.minecraft.world.item.ItemStack p_123430_) {
                this.m_123573_(ArmorItem.m_40398_(p_123429_, p_123430_));
                return p_123430_;
            }
        };
        DispenserBlock.m_52672_(Items.f_42682_, (DispenseItemBehavior)dispenseitembehavior);
        DispenserBlock.m_52672_(Items.f_42681_, (DispenseItemBehavior)dispenseitembehavior);
        DispenserBlock.m_52672_(Items.f_42683_, (DispenseItemBehavior)dispenseitembehavior);
        DispenserBlock.m_52672_(Items.f_42678_, (DispenseItemBehavior)dispenseitembehavior);
        DispenserBlock.m_52672_(Items.f_42680_, (DispenseItemBehavior)dispenseitembehavior);
        DispenserBlock.m_52672_(Items.f_42679_, (DispenseItemBehavior)new OptionalDispenseItemBehavior(){

            protected net.minecraft.world.item.ItemStack m_7498_(BlockSource p_123433_, net.minecraft.world.item.ItemStack p_123434_) {
                net.minecraft.world.item.ItemStack eventStack;
                DispenseItemBehavior idispensebehavior;
                ServerLevel level = p_123433_.m_7727_();
                Direction direction = (Direction)p_123433_.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
                BlockPos blockpos = p_123433_.m_7961_().m_142300_(direction);
                org.bukkit.block.Block bukkitBlock = level.getWorld().getBlockAt(p_123433_.m_7961_().m_123341_(), p_123433_.m_7961_().m_123342_(), p_123433_.m_7961_().m_123343_());
                CraftItemStack craftItem = CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)p_123434_);
                BlockDispenseEvent event = new BlockDispenseEvent(bukkitBlock, (ItemStack)craftItem.clone(), new Vector(blockpos.m_123341_(), blockpos.m_123342_(), blockpos.m_123343_()));
                if (!DispenserBlock.eventFired) {
                    Bukkit.getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    return p_123434_;
                }
                if (!event.getItem().equals((Object)craftItem) && (idispensebehavior = DispenserBlock.f_52661_.get((Object)(eventStack = CraftItemStack.asNMSCopy((ItemStack)event.getItem())).m_41720_())) != f_123393_ && idispensebehavior != this) {
                    idispensebehavior.m_6115_(p_123433_, eventStack);
                    return p_123434_;
                }
                if (level.m_46859_(blockpos) && WitherSkullBlock.m_58267_(level, blockpos, p_123434_)) {
                    level.m_7731_(blockpos, (net.minecraft.world.level.block.state.BlockState)((Object)Blocks.f_50312_.m_49966_().m_61124_(SkullBlock.f_56314_, Integer.valueOf(direction.m_122434_() == Direction.Axis.Y ? 0 : direction.m_122424_().m_122416_() * 4))), 3);
                    level.m_142346_(null, GameEvent.f_157797_, blockpos);
                    BlockEntity blockentity = level.m_7702_(blockpos);
                    if (blockentity instanceof SkullBlockEntity) {
                        WitherSkullBlock.m_58255_(level, blockpos, (SkullBlockEntity)blockentity);
                    }
                    p_123434_.m_41774_(1);
                    this.m_123573_(true);
                } else {
                    this.m_123573_(ArmorItem.m_40398_(p_123433_, p_123434_));
                }
                return p_123434_;
            }
        });
        DispenserBlock.m_52672_(Blocks.f_50143_, (DispenseItemBehavior)new OptionalDispenseItemBehavior(){

            protected net.minecraft.world.item.ItemStack m_7498_(BlockSource p_123437_, net.minecraft.world.item.ItemStack p_123438_) {
                net.minecraft.world.item.ItemStack eventStack;
                DispenseItemBehavior idispensebehavior;
                ServerLevel level = p_123437_.m_7727_();
                BlockPos blockpos = p_123437_.m_7961_().m_142300_((Direction)p_123437_.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
                CarvedPumpkinBlock carvedpumpkinblock = (CarvedPumpkinBlock)Blocks.f_50143_;
                org.bukkit.block.Block bukkitBlock = level.getWorld().getBlockAt(p_123437_.m_7961_().m_123341_(), p_123437_.m_7961_().m_123342_(), p_123437_.m_7961_().m_123343_());
                CraftItemStack craftItem = CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)p_123438_);
                BlockDispenseEvent event = new BlockDispenseEvent(bukkitBlock, (ItemStack)craftItem.clone(), new Vector(blockpos.m_123341_(), blockpos.m_123342_(), blockpos.m_123343_()));
                if (!DispenserBlock.eventFired) {
                    Bukkit.getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    return p_123438_;
                }
                if (!event.getItem().equals((Object)craftItem) && (idispensebehavior = DispenserBlock.f_52661_.get((Object)(eventStack = CraftItemStack.asNMSCopy((ItemStack)event.getItem())).m_41720_())) != f_123393_ && idispensebehavior != this) {
                    idispensebehavior.m_6115_(p_123437_, eventStack);
                    return p_123438_;
                }
                if (level.m_46859_(blockpos) && carvedpumpkinblock.m_51381_((LevelReader)((Object)level), blockpos)) {
                    if (!level.f_46443_) {
                        level.m_7731_(blockpos, carvedpumpkinblock.m_49966_(), 3);
                        level.m_142346_(null, GameEvent.f_157797_, blockpos);
                    }
                    p_123438_.m_41774_(1);
                    this.m_123573_(true);
                } else {
                    this.m_123573_(ArmorItem.m_40398_(p_123437_, p_123438_));
                }
                return p_123438_;
            }
        });
        DispenserBlock.m_52672_(Blocks.f_50456_.m_5456_(), (DispenseItemBehavior)((Object)new ShulkerBoxDispenseBehavior()));
        for (DyeColor dyecolor : DyeColor.values()) {
            DispenserBlock.m_52672_(ShulkerBoxBlock.m_56190_((DyeColor)dyecolor).m_5456_(), (DispenseItemBehavior)((Object)new ShulkerBoxDispenseBehavior()));
        }
        DispenserBlock.m_52672_(Items.f_42590_.m_5456_(), (DispenseItemBehavior)new OptionalDispenseItemBehavior(){
            private final DefaultDispenseItemBehavior f_123439_ = new DefaultDispenseItemBehavior();

            private net.minecraft.world.item.ItemStack m_123446_(BlockSource p_123447_, net.minecraft.world.item.ItemStack p_123448_, net.minecraft.world.item.ItemStack p_123449_) {
                p_123448_.m_41774_(1);
                if (p_123448_.m_41619_()) {
                    p_123447_.m_7727_().m_142346_(null, GameEvent.f_157816_, p_123447_.m_7961_());
                    return p_123449_.m_41777_();
                }
                if (((DispenserBlockEntity)((Object)p_123447_.m_8118_())).m_59237_(p_123449_.m_41777_()) < 0) {
                    this.f_123439_.m_6115_(p_123447_, p_123449_.m_41777_());
                }
                return p_123448_;
            }

            public net.minecraft.world.item.ItemStack m_7498_(BlockSource p_123444_, net.minecraft.world.item.ItemStack p_123445_) {
                net.minecraft.world.item.ItemStack eventStack;
                DispenseItemBehavior idispensebehavior;
                this.m_123573_(false);
                ServerLevel serverlevel = p_123444_.m_7727_();
                BlockPos blockpos = p_123444_.m_7961_().m_142300_((Direction)p_123444_.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
                net.minecraft.world.level.block.state.BlockState blockstate = serverlevel.m_8055_(blockpos);
                org.bukkit.block.Block bukkitBlock = serverlevel.getWorld().getBlockAt(p_123444_.m_7961_().m_123341_(), p_123444_.m_7961_().m_123342_(), p_123444_.m_7961_().m_123343_());
                CraftItemStack craftItem = CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)p_123445_);
                BlockDispenseEvent event = new BlockDispenseEvent(bukkitBlock, (ItemStack)craftItem.clone(), new Vector(blockpos.m_123341_(), blockpos.m_123342_(), blockpos.m_123343_()));
                if (!DispenserBlock.eventFired) {
                    serverlevel.getCraftServer().getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    return p_123445_;
                }
                if (!event.getItem().equals((Object)craftItem) && (idispensebehavior = DispenserBlock.f_52661_.get((Object)(eventStack = CraftItemStack.asNMSCopy((ItemStack)event.getItem())).m_41720_())) != f_123393_ && idispensebehavior != this) {
                    idispensebehavior.m_6115_(p_123444_, eventStack);
                    return p_123445_;
                }
                if (blockstate.m_204338_(BlockTags.f_13072_, p_123442_ -> p_123442_.m_61138_(BeehiveBlock.f_49564_) && p_123442_.m_60734_() instanceof BeehiveBlock) && (Integer)blockstate.m_61143_(BeehiveBlock.f_49564_) >= 5) {
                    ((BeehiveBlock)((Object)blockstate.m_60734_())).m_49594_(serverlevel, blockstate, blockpos, null, BeehiveBlockEntity.BeeReleaseStatus.BEE_RELEASED);
                    this.m_123573_(true);
                    return this.m_123446_(p_123444_, p_123445_, new net.minecraft.world.item.ItemStack(Items.f_42787_));
                }
                if (serverlevel.m_6425_(blockpos).m_205070_(FluidTags.f_13131_)) {
                    this.m_123573_(true);
                    return this.m_123446_(p_123444_, p_123445_, PotionUtils.m_43549_((net.minecraft.world.item.ItemStack)new net.minecraft.world.item.ItemStack(Items.f_42589_), (Potion)Potions.f_43599_));
                }
                return super.m_7498_(p_123444_, p_123445_);
            }
        });
        DispenserBlock.m_52672_(Items.f_42054_, (DispenseItemBehavior)new OptionalDispenseItemBehavior(){

            public net.minecraft.world.item.ItemStack m_7498_(BlockSource p_123452_, net.minecraft.world.item.ItemStack p_123453_) {
                Direction direction = (Direction)p_123452_.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
                BlockPos blockpos = p_123452_.m_7961_().m_142300_(direction);
                ServerLevel level = p_123452_.m_7727_();
                net.minecraft.world.level.block.state.BlockState blockstate = level.m_8055_(blockpos);
                this.m_123573_(true);
                if (blockstate.m_60713_(Blocks.f_50724_)) {
                    if ((Integer)blockstate.m_61143_(RespawnAnchorBlock.f_55833_) != 4) {
                        RespawnAnchorBlock.m_55855_((Level)level, (BlockPos)blockpos, (net.minecraft.world.level.block.state.BlockState)blockstate);
                        p_123453_.m_41774_(1);
                    } else {
                        this.m_123573_(false);
                    }
                    return p_123453_;
                }
                return super.m_7498_(p_123452_, p_123453_);
            }
        });
        DispenserBlock.m_52672_(Items.f_42574_.m_5456_(), (DispenseItemBehavior)((Object)new ShearsDispenseItemBehavior()));
        DispenserBlock.m_52672_(Items.f_42784_, (DispenseItemBehavior)new OptionalDispenseItemBehavior(){

            public net.minecraft.world.item.ItemStack m_7498_(BlockSource p_175747_, net.minecraft.world.item.ItemStack p_175748_) {
                BlockPos blockpos = p_175747_.m_7961_().m_142300_((Direction)p_175747_.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
                ServerLevel level = p_175747_.m_7727_();
                net.minecraft.world.level.block.state.BlockState blockstate = level.m_8055_(blockpos);
                Optional optional = HoneycombItem.m_150878_((net.minecraft.world.level.block.state.BlockState)blockstate);
                if (optional.isPresent()) {
                    level.m_46597_(blockpos, (net.minecraft.world.level.block.state.BlockState)((Object)optional.get()));
                    level.m_46796_(3003, blockpos, 0);
                    p_175748_.m_41774_(1);
                    this.m_123573_(true);
                    return p_175748_;
                }
                return super.m_7498_(p_175747_, p_175748_);
            }
        });
    }

    public static void m_123395_(BlockSource p_123396_, Entity p_123397_, Direction p_123398_) {
        p_123397_.m_6034_(p_123396_.m_7096_() + (double)p_123398_.m_122429_() * (0.5000099999997474 - (double)p_123397_.m_20205_() / 2.0), p_123396_.m_7098_() + (double)p_123398_.m_122430_() * (0.5000099999997474 - (double)p_123397_.m_20206_() / 2.0) - (double)p_123397_.m_20206_() / 2.0, p_123396_.m_7094_() + (double)p_123398_.m_122431_() * (0.5000099999997474 - (double)p_123397_.m_20205_() / 2.0));
    }
}

