/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.BaseComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.ContextAwareComponent;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TranslatableFormatException;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.internal.TextComponentMessageFormatHandler;

public class TranslatableComponent
extends BaseComponent
implements ContextAwareComponent {
    private static final Object[] f_131295_ = new Object[0];
    private static final FormattedText f_131296_ = FormattedText.m_130775_((String)"%");
    private static final FormattedText f_131297_ = FormattedText.m_130775_((String)"null");
    private final String f_131298_;
    private final Object[] f_131299_;
    @Nullable
    private Language f_131300_;
    private List<FormattedText> f_131301_ = ImmutableList.of();
    private static final Pattern f_131302_ = Pattern.compile("%(?:(\\d+)\\$)?([A-Za-z%]|$)");

    public TranslatableComponent(String p_131305_) {
        this.f_131298_ = p_131305_;
        this.f_131299_ = f_131295_;
    }

    public TranslatableComponent(String p_131307_, Object ... p_131308_) {
        this.f_131298_ = p_131307_;
        this.f_131299_ = p_131308_;
    }

    private void m_131330_() {
        Language language = Language.m_128107_();
        if (language != this.f_131300_) {
            this.f_131300_ = language;
            String s = language.m_6834_(this.f_131298_);
            try {
                ImmutableList.Builder builder = ImmutableList.builder();
                this.m_200005_(s, arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
                this.f_131301_ = builder.build();
            }
            catch (TranslatableFormatException translatableformatexception) {
                this.f_131301_ = ImmutableList.of((Object)FormattedText.m_130775_((String)s));
            }
        }
    }

    private void m_200005_(String p_200006_, Consumer<FormattedText> p_200007_) {
        Matcher matcher = f_131302_.matcher(p_200006_);
        try {
            int i = 0;
            int j = 0;
            while (matcher.find(j)) {
                int k = matcher.start();
                int l = matcher.end();
                if (k > j) {
                    String s = p_200006_.substring(j, k);
                    if (s.indexOf(37) != -1) {
                        throw new IllegalArgumentException();
                    }
                    p_200007_.accept(FormattedText.m_130775_((String)s));
                }
                String s4 = matcher.group(2);
                String s1 = p_200006_.substring(k, l);
                if ("%".equals(s4) && "%%".equals(s1)) {
                    p_200007_.accept(f_131296_);
                } else {
                    int i1;
                    if (!"s".equals(s4)) {
                        throw new TranslatableFormatException(this, "Unsupported format: '" + s1 + "'");
                    }
                    String s2 = matcher.group(1);
                    int n = i1 = s2 != null ? Integer.parseInt(s2) - 1 : i++;
                    if (i1 < this.f_131299_.length) {
                        p_200007_.accept(this.m_131313_(i1));
                    }
                }
                j = l;
            }
            if (j == 0) {
                j = TextComponentMessageFormatHandler.handle((TranslatableComponent)this, p_200007_, (Object[])this.f_131299_, (String)p_200006_);
            }
            if (j < p_200006_.length()) {
                String s3 = p_200006_.substring(j);
                if (s3.indexOf(37) != -1) {
                    throw new IllegalArgumentException();
                }
                p_200007_.accept(FormattedText.m_130775_((String)s3));
            }
        }
        catch (IllegalArgumentException illegalargumentexception) {
            throw new TranslatableFormatException(this, (Throwable)illegalargumentexception);
        }
    }

    private FormattedText m_131313_(int p_131314_) {
        if (p_131314_ >= this.f_131299_.length) {
            throw new TranslatableFormatException(this, p_131314_);
        }
        Object object = this.f_131299_[p_131314_];
        if (object instanceof Component) {
            return (Component)object;
        }
        return object == null ? f_131297_ : FormattedText.m_130775_((String)object.toString());
    }

    public TranslatableComponent m_6879_() {
        return new TranslatableComponent(this.f_131298_, this.f_131299_);
    }

    public <T> Optional<T> m_7452_(FormattedText.StyledContentConsumer<T> p_131318_, Style p_131319_) {
        this.m_131330_();
        for (FormattedText formattedtext : this.f_131301_) {
            Optional optional = formattedtext.m_7451_(p_131318_, p_131319_);
            if (!optional.isPresent()) continue;
            return optional;
        }
        return Optional.empty();
    }

    public <T> Optional<T> m_5655_(FormattedText.ContentConsumer<T> p_131316_) {
        this.m_131330_();
        for (FormattedText formattedtext : this.f_131301_) {
            Optional optional = formattedtext.m_5651_(p_131316_);
            if (!optional.isPresent()) continue;
            return optional;
        }
        return Optional.empty();
    }

    public MutableComponent m_5638_(@Nullable CommandSourceStack p_131310_, @Nullable Entity p_131311_, int p_131312_) throws CommandSyntaxException {
        Object[] aobject = new Object[this.f_131299_.length];
        for (int i = 0; i < aobject.length; ++i) {
            Object object = this.f_131299_[i];
            aobject[i] = object instanceof Component ? ComponentUtils.m_130731_((CommandSourceStack)p_131310_, (Component)((Component)object), (Entity)p_131311_, (int)p_131312_) : object;
        }
        return new TranslatableComponent(this.f_131298_, aobject);
    }

    public boolean equals(Object p_131324_) {
        if (this == p_131324_) {
            return true;
        }
        if (!(p_131324_ instanceof TranslatableComponent)) {
            return false;
        }
        TranslatableComponent translatablecomponent = (TranslatableComponent)((Object)p_131324_);
        return Arrays.equals(this.f_131299_, translatablecomponent.f_131299_) && this.f_131298_.equals(translatablecomponent.f_131298_) && super.equals(p_131324_);
    }

    public int hashCode() {
        int i = super.hashCode();
        i = 31 * i + this.f_131298_.hashCode();
        return 31 * i + Arrays.hashCode(this.f_131299_);
    }

    public String toString() {
        return "TranslatableComponent{key='" + this.f_131298_ + "', args=" + Arrays.toString(this.f_131299_) + ", siblings=" + this.f_130578_ + ", style=" + this.m_7383_() + "}";
    }

    public String m_131328_() {
        return this.f_131298_;
    }

    public Object[] m_131329_() {
        return this.f_131299_;
    }
}

