/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.repository;

import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.repository.PackCompatibility;
import net.minecraft.server.packs.repository.PackSource;
import org.slf4j.Logger;

public class Pack
implements AutoCloseable {
    private static final Logger f_10399_ = LogUtils.getLogger();
    private final String f_10401_;
    private final Supplier<PackResources> f_10402_;
    private final Component f_10403_;
    private final Component f_10404_;
    private final PackCompatibility f_10405_;
    private final Position f_10406_;
    private final boolean f_10407_;
    private final boolean f_10408_;
    private final boolean hidden;
    private final PackSource f_10409_;

    @Nullable
    public static Pack m_10430_(String p_10431_, boolean p_10432_, Supplier<PackResources> p_10433_, PackConstructor p_10434_, Position p_10435_, PackSource p_10436_) {
        try {
            Pack pack;
            block9: {
                try (PackResources packresources = p_10433_.get();){
                    PackMetadataSection packmetadatasection = packresources.m_5550_(PackMetadataSection.f_10366_);
                    if (packmetadatasection != null) {
                        pack = p_10434_.create(p_10431_, (Component)new TextComponent(packresources.m_8017_()), p_10432_, p_10433_, packmetadatasection, p_10435_, p_10436_, packresources.isHidden());
                        break block9;
                    }
                    f_10399_.warn("Couldn't find pack meta for pack {}", (Object)p_10431_);
                }
                return null;
            }
            return pack;
        }
        catch (IOException ioexception) {
            f_10399_.warn("Couldn't get pack info for: {}", (Object)ioexception.toString());
            return null;
        }
    }

    @Deprecated
    public Pack(String p_10420_, boolean p_10421_, Supplier<PackResources> p_10422_, Component p_10423_, Component p_10424_, PackCompatibility p_10425_, Position p_10426_, boolean p_10427_, PackSource p_10428_) {
        this(p_10420_, p_10421_, p_10422_, p_10423_, p_10424_, p_10425_, p_10426_, p_10427_, p_10428_, false);
    }

    public Pack(String p_10420_, boolean p_10421_, Supplier<PackResources> p_10422_, Component p_10423_, Component p_10424_, PackCompatibility p_10425_, Position p_10426_, boolean p_10427_, PackSource p_10428_, boolean hidden) {
        this.f_10401_ = p_10420_;
        this.f_10402_ = p_10422_;
        this.f_10403_ = p_10423_;
        this.f_10404_ = p_10424_;
        this.f_10405_ = p_10425_;
        this.f_10407_ = p_10421_;
        this.f_10406_ = p_10426_;
        this.f_10408_ = p_10427_;
        this.f_10409_ = p_10428_;
        this.hidden = hidden;
    }

    @Deprecated
    public Pack(String p_143865_, Component p_143866_, boolean p_143867_, Supplier<PackResources> p_143868_, PackMetadataSection p_143869_, PackType p_143870_, Position p_143871_, PackSource p_143872_) {
        this(p_143865_, p_143867_, p_143868_, p_143866_, p_143869_.m_10373_(), PackCompatibility.m_143885_(p_143869_, p_143870_), p_143871_, false, p_143872_, false);
    }

    public Pack(String p_143865_, Component p_143866_, boolean p_143867_, Supplier<PackResources> p_143868_, PackMetadataSection p_143869_, PackType p_143870_, Position p_143871_, PackSource p_143872_, boolean hidden) {
        this(p_143865_, p_143867_, p_143868_, p_143866_, p_143869_.m_10373_(), PackCompatibility.m_143885_(p_143869_, p_143870_), p_143871_, false, p_143872_, hidden);
    }

    public Component m_10429_() {
        return this.f_10403_;
    }

    public Component m_10442_() {
        return this.f_10404_;
    }

    public Component m_10437_(boolean p_10438_) {
        return ComponentUtils.m_130748_((Component)this.f_10409_.m_10540_((Component)new TextComponent(this.f_10401_))).m_130938_(p_10441_ -> p_10441_.m_131140_(p_10438_ ? ChatFormatting.GREEN : ChatFormatting.RED).m_131138_(StringArgumentType.escapeIfRequired((String)this.f_10401_)).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TextComponent("").m_7220_(this.f_10403_).m_130946_("\n").m_7220_(this.f_10404_))));
    }

    public PackCompatibility m_10443_() {
        return this.f_10405_;
    }

    public PackResources m_10445_() {
        return this.f_10402_.get();
    }

    public String m_10446_() {
        return this.f_10401_;
    }

    public boolean m_10449_() {
        return this.f_10407_;
    }

    public boolean m_10450_() {
        return this.f_10408_;
    }

    public Position m_10451_() {
        return this.f_10406_;
    }

    public PackSource m_10453_() {
        return this.f_10409_;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean equals(Object p_10448_) {
        if (this == p_10448_) {
            return true;
        }
        if (!(p_10448_ instanceof Pack)) {
            return false;
        }
        Pack pack = (Pack)p_10448_;
        return this.f_10401_.equals(pack.f_10401_);
    }

    public int hashCode() {
        return this.f_10401_.hashCode();
    }

    @Override
    public void close() {
    }

    @FunctionalInterface
    public static interface PackConstructor {
        @Deprecated
        @Nullable
        default public Pack m_143873_(String p_143874_, Component p_143875_, boolean p_143876_, Supplier<PackResources> p_143877_, PackMetadataSection p_143878_, Position p_143879_, PackSource p_143880_) {
            return this.create(p_143874_, p_143875_, p_143876_, p_143877_, p_143878_, p_143879_, p_143880_, false);
        }

        @Nullable
        public Pack create(String var1, Component var2, boolean var3, Supplier<PackResources> var4, PackMetadataSection var5, Position var6, PackSource var7, boolean var8);
    }

    public static final class Position
    extends Enum<Position> {
        public static final /* enum */ Position TOP = new Position();
        public static final /* enum */ Position BOTTOM = new Position();
        private static final /* synthetic */ Position[] $VALUES;

        public static Position[] values() {
            return (Position[])$VALUES.clone();
        }

        public static Position valueOf(String p_10476_) {
            return Enum.valueOf(Position.class, p_10476_);
        }

        public <T> int m_10470_(List<T> p_10471_, T p_10472_, Function<T, Pack> p_10473_, boolean p_10474_) {
            Pack pack;
            int i;
            Position pack$position;
            Position position = pack$position = p_10474_ ? this.m_10469_() : this;
            if (pack$position == BOTTOM) {
                Pack pack1;
                int j;
                for (j = 0; j < p_10471_.size() && (pack1 = p_10473_.apply(p_10471_.get(j))).m_10450_() && pack1.m_10451_() == this; ++j) {
                }
                p_10471_.add(j, p_10472_);
                return j;
            }
            for (i = p_10471_.size() - 1; i >= 0 && (pack = p_10473_.apply(p_10471_.get(i))).m_10450_() && pack.m_10451_() == this; --i) {
            }
            p_10471_.add(i + 1, p_10472_);
            return i + 1;
        }

        public Position m_10469_() {
            return this == TOP ? BOTTOM : TOP;
        }

        private static /* synthetic */ Position[] m_143881_() {
            return new Position[]{TOP, BOTTOM};
        }

        static {
            $VALUES = Position.m_143881_();
        }
    }
}

