/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mohistmc.bukkit.inventory.MohistSpecialRecipe;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IShapedRecipe;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftRecipe;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftShapedRecipe;
import org.bukkit.inventory.RecipeChoice;

public class ShapedRecipe
implements CraftingRecipe,
IShapedRecipe<CraftingContainer> {
    static int MAX_WIDTH = 3;
    static int MAX_HEIGHT = 3;
    final int f_44146_;
    final int f_44147_;
    final NonNullList<Ingredient> f_44148_;
    final ItemStack f_44149_;
    private final ResourceLocation f_44150_;
    final String f_44151_;

    public static void setCraftingSize(int width, int height) {
        if (MAX_WIDTH < width) {
            MAX_WIDTH = width;
        }
        if (MAX_HEIGHT < height) {
            MAX_HEIGHT = height;
        }
    }

    public ShapedRecipe(ResourceLocation p_44153_, String p_44154_, int p_44155_, int p_44156_, NonNullList<Ingredient> p_44157_, ItemStack p_44158_) {
        this.f_44150_ = p_44153_;
        this.f_44151_ = p_44154_;
        this.f_44146_ = p_44155_;
        this.f_44147_ = p_44156_;
        this.f_44148_ = p_44157_;
        this.f_44149_ = p_44158_;
    }

    public org.bukkit.inventory.Recipe toBukkitRecipe() {
        if (this.m_44220_() < 1 || this.m_44220_() > 3 || this.m_44221_() < 1 || this.m_44221_() > 3 || this.f_44149_.m_41619_()) {
            return new MohistSpecialRecipe((Recipe)((Object)this));
        }
        CraftItemStack result = CraftItemStack.asCraftMirror((ItemStack)this.f_44149_);
        CraftShapedRecipe recipe = new CraftShapedRecipe((org.bukkit.inventory.ItemStack)result, this);
        recipe.setGroup(this.f_44151_);
        block0 : switch (this.f_44147_) {
            case 1: {
                switch (this.f_44146_) {
                    case 1: {
                        recipe.shape(new String[]{"a"});
                        break;
                    }
                    case 2: {
                        recipe.shape(new String[]{"ab"});
                        break;
                    }
                    case 3: {
                        recipe.shape(new String[]{"abc"});
                    }
                }
                break;
            }
            case 2: {
                switch (this.f_44146_) {
                    case 1: {
                        recipe.shape(new String[]{"a", "b"});
                        break;
                    }
                    case 2: {
                        recipe.shape(new String[]{"ab", "cd"});
                        break;
                    }
                    case 3: {
                        recipe.shape(new String[]{"abc", "def"});
                    }
                }
                break;
            }
            case 3: {
                switch (this.f_44146_) {
                    case 1: {
                        recipe.shape(new String[]{"a", "b", "c"});
                        break block0;
                    }
                    case 2: {
                        recipe.shape(new String[]{"ab", "cd", "ef"});
                        break block0;
                    }
                    case 3: {
                        recipe.shape(new String[]{"abc", "def", "ghi"});
                    }
                }
            }
        }
        char c = 'a';
        for (Ingredient list : this.f_44148_) {
            RecipeChoice choice = CraftRecipe.toBukkit((Ingredient)list);
            if (choice != null) {
                recipe.setIngredient(c, choice);
            }
            c = (char)(c + 1);
        }
        return recipe;
    }

    public ResourceLocation m_6423_() {
        return this.f_44150_;
    }

    public RecipeSerializer<?> m_7707_() {
        return RecipeSerializer.f_44076_;
    }

    public String m_6076_() {
        return this.f_44151_;
    }

    public ItemStack m_8043_() {
        return this.f_44149_;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.f_44148_;
    }

    public boolean m_8004_(int p_44161_, int p_44162_) {
        return p_44161_ >= this.f_44146_ && p_44162_ >= this.f_44147_;
    }

    public boolean m_5818_(CraftingContainer p_44176_, Level p_44177_) {
        for (int i = 0; i <= p_44176_.m_39347_() - this.f_44146_; ++i) {
            for (int j = 0; j <= p_44176_.m_39346_() - this.f_44147_; ++j) {
                if (this.m_44170_(p_44176_, i, j, true)) {
                    return true;
                }
                if (!this.m_44170_(p_44176_, i, j, false)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean m_44170_(CraftingContainer p_44171_, int p_44172_, int p_44173_, boolean p_44174_) {
        for (int i = 0; i < p_44171_.m_39347_(); ++i) {
            for (int j = 0; j < p_44171_.m_39346_(); ++j) {
                int k = i - p_44172_;
                int l = j - p_44173_;
                Ingredient ingredient = Ingredient.f_43901_;
                if (k >= 0 && l >= 0 && k < this.f_44146_ && l < this.f_44147_) {
                    ingredient = p_44174_ ? (Ingredient)this.f_44148_.get(this.f_44146_ - k - 1 + l * this.f_44146_) : (Ingredient)this.f_44148_.get(k + l * this.f_44146_);
                }
                if (ingredient.test(p_44171_.m_8020_(i + j * p_44171_.m_39347_()))) continue;
                return false;
            }
        }
        return true;
    }

    public ItemStack m_5874_(CraftingContainer p_44169_) {
        return this.m_8043_().m_41777_();
    }

    public int m_44220_() {
        return this.f_44146_;
    }

    public int getRecipeWidth() {
        return this.m_44220_();
    }

    public int m_44221_() {
        return this.f_44147_;
    }

    public int getRecipeHeight() {
        return this.m_44221_();
    }

    static NonNullList<Ingredient> m_44202_(String[] p_44203_, Map<String, Ingredient> p_44204_, int p_44205_, int p_44206_) {
        NonNullList nonnulllist = NonNullList.m_122780_((int)(p_44205_ * p_44206_), (Object)Ingredient.f_43901_);
        HashSet set = Sets.newHashSet(p_44204_.keySet());
        set.remove(" ");
        for (int i = 0; i < p_44203_.length; ++i) {
            for (int j = 0; j < p_44203_[i].length(); ++j) {
                String s = p_44203_[i].substring(j, j + 1);
                Ingredient ingredient = p_44204_.get(s);
                if (ingredient == null) {
                    throw new JsonSyntaxException("Pattern references symbol '" + s + "' but it's not defined in the key");
                }
                set.remove(s);
                nonnulllist.set(j + p_44205_ * i, (Object)ingredient);
            }
        }
        if (!set.isEmpty()) {
            throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + set);
        }
        return nonnulllist;
    }

    @VisibleForTesting
    static String[] m_44186_(String ... p_44187_) {
        int i = Integer.MAX_VALUE;
        int j = 0;
        int k = 0;
        int l = 0;
        for (int i1 = 0; i1 < p_44187_.length; ++i1) {
            String s = p_44187_[i1];
            i = Math.min(i, ShapedRecipe.m_44184_(s));
            int j1 = ShapedRecipe.m_44200_(s);
            j = Math.max(j, j1);
            if (j1 < 0) {
                if (k == i1) {
                    ++k;
                }
                ++l;
                continue;
            }
            l = 0;
        }
        if (p_44187_.length == l) {
            return new String[0];
        }
        String[] astring = new String[p_44187_.length - l - k];
        for (int k1 = 0; k1 < astring.length; ++k1) {
            astring[k1] = p_44187_[k1 + k].substring(i, j + 1);
        }
        return astring;
    }

    public boolean m_142505_() {
        NonNullList<Ingredient> nonnulllist = this.m_7527_();
        return nonnulllist.isEmpty() || nonnulllist.stream().filter(p_151277_ -> !p_151277_.m_43947_()).anyMatch(p_151273_ -> ForgeHooks.hasNoElements((Ingredient)p_151273_));
    }

    private static int m_44184_(String p_44185_) {
        int i;
        for (i = 0; i < p_44185_.length() && p_44185_.charAt(i) == ' '; ++i) {
        }
        return i;
    }

    private static int m_44200_(String p_44201_) {
        int i;
        for (i = p_44201_.length() - 1; i >= 0 && p_44201_.charAt(i) == ' '; --i) {
        }
        return i;
    }

    static String[] m_44196_(JsonArray p_44197_) {
        String[] astring = new String[p_44197_.size()];
        if (astring.length > MAX_HEIGHT) {
            throw new JsonSyntaxException("Invalid pattern: too many rows, " + MAX_HEIGHT + " is maximum");
        }
        if (astring.length == 0) {
            throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
        }
        for (int i = 0; i < astring.length; ++i) {
            String s = GsonHelper.m_13805_((JsonElement)p_44197_.get(i), (String)("pattern[" + i + "]"));
            if (s.length() > MAX_WIDTH) {
                throw new JsonSyntaxException("Invalid pattern: too many columns, " + MAX_WIDTH + " is maximum");
            }
            if (i > 0 && astring[0].length() != s.length()) {
                throw new JsonSyntaxException("Invalid pattern: each row must be the same width");
            }
            astring[i] = s;
        }
        return astring;
    }

    static Map<String, Ingredient> m_44210_(JsonObject p_44211_) {
        HashMap map = Maps.newHashMap();
        for (Map.Entry entry : p_44211_.entrySet()) {
            if (((String)entry.getKey()).length() != 1) {
                throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
            }
            if (" ".equals(entry.getKey())) {
                throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
            }
            map.put((String)entry.getKey(), Ingredient.m_43917_((JsonElement)entry.getValue()));
        }
        map.put(" ", Ingredient.f_43901_);
        return map;
    }

    public static ItemStack m_151274_(JsonObject p_151275_) {
        return CraftingHelper.getItemStack((JsonObject)p_151275_, (boolean)true, (boolean)true);
    }

    public static Item m_151278_(JsonObject p_151279_) {
        String s = GsonHelper.m_13906_((JsonObject)p_151279_, (String)"item");
        Item item = (Item)((Object)Registry.f_122827_.m_6612_(new ResourceLocation(s)).orElseThrow(() -> new JsonSyntaxException("Unknown item '" + s + "'")));
        if (item == Items.f_41852_) {
            throw new JsonSyntaxException("Invalid item: " + s);
        }
        return item;
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<ShapedRecipe> {
        private static final ResourceLocation NAME = new ResourceLocation("minecraft", "crafting_shaped");

        @Override
        public ShapedRecipe m_6729_(ResourceLocation p_44236_, JsonObject p_44237_) {
            String s = GsonHelper.m_13851_((JsonObject)p_44237_, (String)"group", (String)"");
            Map<String, Ingredient> map = ShapedRecipe.m_44210_(GsonHelper.m_13930_((JsonObject)p_44237_, (String)"key"));
            String[] astring = ShapedRecipe.m_44186_(ShapedRecipe.m_44196_(GsonHelper.m_13933_((JsonObject)p_44237_, (String)"pattern")));
            int i = astring[0].length();
            int j = astring.length;
            NonNullList<Ingredient> nonnulllist = ShapedRecipe.m_44202_(astring, map, i, j);
            ItemStack itemstack = ShapedRecipe.m_151274_(GsonHelper.m_13930_((JsonObject)p_44237_, (String)"result"));
            return new ShapedRecipe(p_44236_, s, i, j, nonnulllist, itemstack);
        }

        @Override
        public ShapedRecipe m_8005_(ResourceLocation p_44239_, FriendlyByteBuf p_44240_) {
            int i = p_44240_.m_130242_();
            int j = p_44240_.m_130242_();
            String s = p_44240_.m_130277_();
            NonNullList nonnulllist = NonNullList.m_122780_((int)(i * j), (Object)Ingredient.f_43901_);
            for (int k = 0; k < nonnulllist.size(); ++k) {
                nonnulllist.set(k, (Object)Ingredient.m_43940_(p_44240_));
            }
            ItemStack itemstack = p_44240_.m_130267_();
            return new ShapedRecipe(p_44239_, s, i, j, (NonNullList<Ingredient>)nonnulllist, itemstack);
        }

        @Override
        public void m_6178_(FriendlyByteBuf p_44227_, ShapedRecipe p_44228_) {
            p_44227_.m_130130_(p_44228_.f_44146_);
            p_44227_.m_130130_(p_44228_.f_44147_);
            p_44227_.m_130070_(p_44228_.f_44151_);
            for (Ingredient ingredient : p_44228_.f_44148_) {
                ingredient.m_43923_(p_44227_);
            }
            p_44227_.m_130055_(p_44228_.f_44149_);
        }
    }
}

