/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mohistmc.bukkit.inventory.MohistSpecialRecipe;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeConfig;
import net.minecraftforge.common.util.RecipeMatcher;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftRecipe;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftShapelessRecipe;

public class ShapelessRecipe
implements CraftingRecipe {
    private final ResourceLocation f_44241_;
    final String f_44242_;
    final ItemStack f_44243_;
    final NonNullList<Ingredient> f_44244_;
    private final boolean isSimple;

    public ShapelessRecipe(ResourceLocation p_44246_, String p_44247_, ItemStack p_44248_, NonNullList<Ingredient> p_44249_) {
        this.f_44241_ = p_44246_;
        this.f_44242_ = p_44247_;
        this.f_44243_ = p_44248_;
        this.f_44244_ = p_44249_;
        this.isSimple = p_44249_.stream().allMatch(Ingredient::isSimple);
    }

    public org.bukkit.inventory.Recipe toBukkitRecipe() {
        if (this.f_44243_.m_41619_() || this.f_44244_.size() + 1 <= 9) {
            return new MohistSpecialRecipe((Recipe)((Object)this));
        }
        CraftItemStack result = CraftItemStack.asCraftMirror((ItemStack)this.f_44243_);
        CraftShapelessRecipe recipe = new CraftShapelessRecipe((org.bukkit.inventory.ItemStack)result, this);
        recipe.setGroup(this.f_44242_);
        for (Ingredient list : this.f_44244_) {
            recipe.addIngredient(CraftRecipe.toBukkit((Ingredient)list));
        }
        return recipe;
    }

    public ResourceLocation m_6423_() {
        return this.f_44241_;
    }

    public RecipeSerializer<?> m_7707_() {
        return RecipeSerializer.f_44077_;
    }

    public String m_6076_() {
        return this.f_44242_;
    }

    public ItemStack m_8043_() {
        return this.f_44243_;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.f_44244_;
    }

    public boolean m_5818_(CraftingContainer p_44262_, Level p_44263_) {
        StackedContents stackedcontents = new StackedContents();
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        int i = 0;
        for (int j = 0; j < p_44262_.m_6643_(); ++j) {
            ItemStack itemstack = p_44262_.m_8020_(j);
            if (itemstack.m_41619_()) continue;
            ++i;
            if (this.isSimple) {
                stackedcontents.m_36468_(itemstack, 1);
                continue;
            }
            inputs.add(itemstack);
        }
        return i == this.f_44244_.size() && (this.isSimple ? stackedcontents.m_36475_((Recipe)((Object)this), (IntList)null) : RecipeMatcher.findMatches(inputs, this.f_44244_) != null);
    }

    public ItemStack m_5874_(CraftingContainer p_44260_) {
        return this.f_44243_.m_41777_();
    }

    public boolean m_8004_(int p_44252_, int p_44253_) {
        return p_44252_ * p_44253_ >= this.f_44244_.size();
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<ShapelessRecipe> {
        private static final ResourceLocation NAME = new ResourceLocation("minecraft", "crafting_shapeless");

        @Override
        public ShapelessRecipe m_6729_(ResourceLocation p_44290_, JsonObject p_44291_) {
            String s = GsonHelper.m_13851_((JsonObject)p_44291_, (String)"group", (String)"");
            NonNullList<Ingredient> nonnulllist = Serializer.m_44275_(GsonHelper.m_13933_((JsonObject)p_44291_, (String)"ingredients"));
            if (nonnulllist.isEmpty()) {
                throw new JsonParseException("No ingredients for shapeless recipe");
            }
            if (nonnulllist.size() > ShapedRecipe.MAX_WIDTH * ShapedRecipe.MAX_HEIGHT) {
                throw new JsonParseException("Too many ingredients for shapeless recipe. The maximum is " + ShapedRecipe.MAX_WIDTH * ShapedRecipe.MAX_HEIGHT);
            }
            ItemStack itemstack = ShapedRecipe.m_151274_(GsonHelper.m_13930_((JsonObject)p_44291_, (String)"result"));
            return new ShapelessRecipe(p_44290_, s, itemstack, nonnulllist);
        }

        private static NonNullList<Ingredient> m_44275_(JsonArray p_44276_) {
            NonNullList nonnulllist = NonNullList.m_122779_();
            for (int i = 0; i < p_44276_.size(); ++i) {
                Ingredient ingredient = Ingredient.m_43917_(p_44276_.get(i));
                if (!((Boolean)ForgeConfig.SERVER.skipEmptyShapelessCheck.get()).booleanValue() && ingredient.m_43947_()) continue;
                nonnulllist.add((Object)ingredient);
            }
            return nonnulllist;
        }

        @Override
        public ShapelessRecipe m_8005_(ResourceLocation p_44293_, FriendlyByteBuf p_44294_) {
            String s = p_44294_.m_130277_();
            int i = p_44294_.m_130242_();
            NonNullList nonnulllist = NonNullList.m_122780_((int)i, (Object)Ingredient.f_43901_);
            for (int j = 0; j < nonnulllist.size(); ++j) {
                nonnulllist.set(j, (Object)Ingredient.m_43940_(p_44294_));
            }
            ItemStack itemstack = p_44294_.m_130267_();
            return new ShapelessRecipe(p_44293_, s, itemstack, (NonNullList<Ingredient>)nonnulllist);
        }

        @Override
        public void m_6178_(FriendlyByteBuf p_44281_, ShapelessRecipe p_44282_) {
            p_44281_.m_130070_(p_44282_.f_44242_);
            p_44281_.m_130130_(p_44282_.f_44244_.size());
            for (Ingredient ingredient : p_44282_.f_44244_) {
                ingredient.m_43923_(p_44281_);
            }
            p_44281_.m_130055_(p_44282_.f_44243_);
        }
    }
}

