/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.Random;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class StairBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final DirectionProperty f_56841_ = HorizontalDirectionalBlock.f_54117_;
    public static final EnumProperty<Half> f_56842_ = BlockStateProperties.f_61402_;
    public static final EnumProperty<StairsShape> f_56843_ = BlockStateProperties.f_61398_;
    public static final BooleanProperty f_56844_ = BlockStateProperties.f_61362_;
    protected static final VoxelShape f_56845_ = SlabBlock.f_56356_;
    protected static final VoxelShape f_56846_ = SlabBlock.f_56355_;
    protected static final VoxelShape f_56847_ = Block.m_49796_(0.0, 0.0, 0.0, 8.0, 8.0, 8.0);
    protected static final VoxelShape f_56848_ = Block.m_49796_(0.0, 0.0, 8.0, 8.0, 8.0, 16.0);
    protected static final VoxelShape f_56849_ = Block.m_49796_(0.0, 8.0, 0.0, 8.0, 16.0, 8.0);
    protected static final VoxelShape f_56850_ = Block.m_49796_(0.0, 8.0, 8.0, 8.0, 16.0, 16.0);
    protected static final VoxelShape f_56851_ = Block.m_49796_(8.0, 0.0, 0.0, 16.0, 8.0, 8.0);
    protected static final VoxelShape f_56852_ = Block.m_49796_(8.0, 0.0, 8.0, 16.0, 8.0, 16.0);
    protected static final VoxelShape f_56853_ = Block.m_49796_(8.0, 8.0, 0.0, 16.0, 16.0, 8.0);
    protected static final VoxelShape f_56854_ = Block.m_49796_(8.0, 8.0, 8.0, 16.0, 16.0, 16.0);
    protected static final VoxelShape[] f_56855_ = StairBlock.m_56933_(f_56845_, f_56847_, f_56851_, f_56848_, f_56852_);
    protected static final VoxelShape[] f_56856_ = StairBlock.m_56933_(f_56846_, f_56849_, f_56853_, f_56850_, f_56854_);
    private static final int[] f_56857_ = new int[]{12, 5, 3, 10, 14, 13, 7, 11, 13, 7, 11, 14, 8, 4, 1, 2, 4, 1, 2, 8};
    private final Block f_56858_;
    private final BlockState f_56859_;
    private final Supplier<BlockState> stateSupplier;

    private static VoxelShape[] m_56933_(VoxelShape p_56934_, VoxelShape p_56935_, VoxelShape p_56936_, VoxelShape p_56937_, VoxelShape p_56938_) {
        return (VoxelShape[])IntStream.range(0, 16).mapToObj(p_56945_ -> StairBlock.m_56864_(p_56945_, p_56934_, p_56935_, p_56936_, p_56937_, p_56938_)).toArray(VoxelShape[]::new);
    }

    private static VoxelShape m_56864_(int p_56865_, VoxelShape p_56866_, VoxelShape p_56867_, VoxelShape p_56868_, VoxelShape p_56869_, VoxelShape p_56870_) {
        VoxelShape voxelshape = p_56866_;
        if ((p_56865_ & 1) != 0) {
            voxelshape = Shapes.m_83110_((VoxelShape)p_56866_, (VoxelShape)p_56867_);
        }
        if ((p_56865_ & 2) != 0) {
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)p_56868_);
        }
        if ((p_56865_ & 4) != 0) {
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)p_56869_);
        }
        if ((p_56865_ & 8) != 0) {
            voxelshape = Shapes.m_83110_((VoxelShape)voxelshape, (VoxelShape)p_56870_);
        }
        return voxelshape;
    }

    @Deprecated
    public StairBlock(BlockState p_56862_, BlockBehaviour.Properties p_56863_) {
        super(p_56863_);
        this.m_49959_((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_56841_, (Comparable)Direction.NORTH))).m_61124_((Property)f_56842_, (Comparable)Half.BOTTOM))).m_61124_((Property)f_56843_, (Comparable)StairsShape.STRAIGHT))).m_61124_((Property)f_56844_, Boolean.valueOf(false))));
        this.f_56858_ = p_56862_.m_60734_();
        this.f_56859_ = p_56862_;
        this.stateSupplier = () -> p_56862_;
    }

    public StairBlock(Supplier<BlockState> state, BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)((Object)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_56841_, (Comparable)Direction.NORTH))).m_61124_((Property)f_56842_, (Comparable)Half.BOTTOM))).m_61124_((Property)f_56843_, (Comparable)StairsShape.STRAIGHT))).m_61124_((Property)f_56844_, Boolean.valueOf(false))));
        this.f_56858_ = Blocks.f_50016_;
        this.f_56859_ = Blocks.f_50016_.m_49966_();
        this.stateSupplier = state;
    }

    @Override
    public boolean m_7923_(BlockState p_56967_) {
        return true;
    }

    @Override
    public VoxelShape m_5940_(BlockState p_56956_, BlockGetter p_56957_, BlockPos p_56958_, CollisionContext p_56959_) {
        return (p_56956_.m_61143_((Property)f_56842_) == Half.TOP ? f_56855_ : f_56856_)[f_56857_[this.m_56982_(p_56956_)]];
    }

    private int m_56982_(BlockState p_56983_) {
        return ((StairsShape)p_56983_.m_61143_((Property)f_56843_)).ordinal() * 4 + ((Direction)p_56983_.m_61143_((Property)f_56841_)).m_122416_();
    }

    @Override
    public void m_7100_(BlockState p_56914_, Level p_56915_, BlockPos p_56916_, Random p_56917_) {
        this.f_56858_.m_7100_(p_56914_, p_56915_, p_56916_, p_56917_);
    }

    @Override
    public void m_6256_(BlockState p_56896_, Level p_56897_, BlockPos p_56898_, Player p_56899_) {
        this.f_56859_.m_60686_(p_56897_, p_56898_, p_56899_);
    }

    @Override
    public void m_6786_(LevelAccessor p_56882_, BlockPos p_56883_, BlockState p_56884_) {
        this.f_56858_.m_6786_(p_56882_, p_56883_, p_56884_);
    }

    @Override
    public float m_7325_() {
        return this.f_56858_.m_7325_();
    }

    @Override
    public void m_6807_(BlockState p_56961_, Level p_56962_, BlockPos p_56963_, BlockState p_56964_, boolean p_56965_) {
        if (!p_56961_.m_60713_(p_56961_.m_60734_())) {
            this.f_56859_.m_60690_(p_56962_, p_56963_, Blocks.f_50016_, p_56963_, false);
            this.f_56858_.m_6807_(this.f_56859_, p_56962_, p_56963_, p_56964_, false);
        }
    }

    @Override
    public void m_6810_(BlockState p_56908_, Level p_56909_, BlockPos p_56910_, BlockState p_56911_, boolean p_56912_) {
        if (!p_56908_.m_60713_(p_56911_.m_60734_())) {
            this.f_56859_.m_60753_(p_56909_, p_56910_, p_56911_, p_56912_);
        }
    }

    @Override
    public void m_141947_(Level p_154720_, BlockPos p_154721_, BlockState p_154722_, Entity p_154723_) {
        this.f_56858_.m_141947_(p_154720_, p_154721_, p_154722_, p_154723_);
    }

    @Override
    public boolean m_6724_(BlockState p_56947_) {
        return this.f_56858_.m_6724_(p_56947_);
    }

    @Override
    public void m_7455_(BlockState p_56951_, ServerLevel p_56952_, BlockPos p_56953_, Random p_56954_) {
        this.f_56858_.m_7455_(p_56951_, p_56952_, p_56953_, p_56954_);
    }

    @Override
    public void m_7458_(BlockState p_56886_, ServerLevel p_56887_, BlockPos p_56888_, Random p_56889_) {
        this.f_56858_.m_7458_(p_56886_, p_56887_, p_56888_, p_56889_);
    }

    @Override
    public InteractionResult m_6227_(BlockState p_56901_, Level p_56902_, BlockPos p_56903_, Player p_56904_, InteractionHand p_56905_, BlockHitResult p_56906_) {
        return this.f_56859_.m_60664_(p_56902_, p_56904_, p_56905_, p_56906_);
    }

    @Override
    public void m_7592_(Level p_56878_, BlockPos p_56879_, Explosion p_56880_) {
        this.f_56858_.m_7592_(p_56878_, p_56879_, p_56880_);
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext p_56872_) {
        Direction direction = p_56872_.m_43719_();
        BlockPos blockpos = p_56872_.m_8083_();
        FluidState fluidstate = p_56872_.m_43725_().m_6425_(blockpos);
        BlockState blockstate = (BlockState)((Object)((BlockState)((Object)((BlockState)((Object)this.m_49966_().m_61124_((Property)f_56841_, (Comparable)p_56872_.m_8125_()))).m_61124_((Property)f_56842_, (Comparable)(!(direction == Direction.DOWN || direction != Direction.UP && p_56872_.m_43720_().f_82480_ - (double)blockpos.m_123342_() > 0.5) ? Half.BOTTOM : Half.TOP)))).m_61124_((Property)f_56844_, Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_)));
        return (BlockState)((Object)blockstate.m_61124_((Property)f_56843_, (Comparable)StairBlock.m_56976_(blockstate, (BlockGetter)((Object)p_56872_.m_43725_()), blockpos)));
    }

    @Override
    public BlockState m_7417_(BlockState p_56925_, Direction p_56926_, BlockState p_56927_, LevelAccessor p_56928_, BlockPos p_56929_, BlockPos p_56930_) {
        if (((Boolean)p_56925_.m_61143_((Property)f_56844_)).booleanValue()) {
            p_56928_.m_186469_(p_56929_, Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)((Object)p_56928_)));
        }
        return p_56926_.m_122434_().m_122479_() ? (BlockState)((Object)p_56925_.m_61124_((Property)f_56843_, (Comparable)StairBlock.m_56976_(p_56925_, (BlockGetter)((Object)p_56928_), p_56929_))) : super.m_7417_(p_56925_, p_56926_, p_56927_, p_56928_, p_56929_, p_56930_);
    }

    private static StairsShape m_56976_(BlockState p_56977_, BlockGetter p_56978_, BlockPos p_56979_) {
        Direction direction2;
        Direction direction1;
        Direction direction = (Direction)p_56977_.m_61143_((Property)f_56841_);
        BlockState blockstate = p_56978_.m_8055_(p_56979_.m_142300_(direction));
        if (StairBlock.m_56980_(blockstate) && p_56977_.m_61143_((Property)f_56842_) == blockstate.m_61143_((Property)f_56842_) && (direction1 = (Direction)blockstate.m_61143_((Property)f_56841_)).m_122434_() != ((Direction)p_56977_.m_61143_((Property)f_56841_)).m_122434_() && StairBlock.m_56970_(p_56977_, p_56978_, p_56979_, direction1.m_122424_())) {
            if (direction1 == direction.m_122428_()) {
                return StairsShape.OUTER_LEFT;
            }
            return StairsShape.OUTER_RIGHT;
        }
        BlockState blockstate1 = p_56978_.m_8055_(p_56979_.m_142300_(direction.m_122424_()));
        if (StairBlock.m_56980_(blockstate1) && p_56977_.m_61143_((Property)f_56842_) == blockstate1.m_61143_((Property)f_56842_) && (direction2 = (Direction)blockstate1.m_61143_((Property)f_56841_)).m_122434_() != ((Direction)p_56977_.m_61143_((Property)f_56841_)).m_122434_() && StairBlock.m_56970_(p_56977_, p_56978_, p_56979_, direction2)) {
            if (direction2 == direction.m_122428_()) {
                return StairsShape.INNER_LEFT;
            }
            return StairsShape.INNER_RIGHT;
        }
        return StairsShape.STRAIGHT;
    }

    private static boolean m_56970_(BlockState p_56971_, BlockGetter p_56972_, BlockPos p_56973_, Direction p_56974_) {
        BlockState blockstate = p_56972_.m_8055_(p_56973_.m_142300_(p_56974_));
        return !StairBlock.m_56980_(blockstate) || blockstate.m_61143_((Property)f_56841_) != p_56971_.m_61143_((Property)f_56841_) || blockstate.m_61143_((Property)f_56842_) != p_56971_.m_61143_((Property)f_56842_);
    }

    public static boolean m_56980_(BlockState p_56981_) {
        return p_56981_.m_60734_() instanceof StairBlock;
    }

    @Override
    public BlockState m_6843_(BlockState p_56922_, Rotation p_56923_) {
        return (BlockState)((Object)p_56922_.m_61124_((Property)f_56841_, (Comparable)p_56923_.m_55954_((Direction)p_56922_.m_61143_((Property)f_56841_))));
    }

    @Override
    public BlockState m_6943_(BlockState p_56919_, Mirror p_56920_) {
        Direction direction = (Direction)p_56919_.m_61143_((Property)f_56841_);
        StairsShape stairsshape = (StairsShape)p_56919_.m_61143_((Property)f_56843_);
        switch (p_56920_) {
            case LEFT_RIGHT: {
                if (direction.m_122434_() != Direction.Axis.Z) break;
                switch (stairsshape) {
                    case INNER_LEFT: {
                        return (BlockState)((Object)p_56919_.m_60717_(Rotation.CLOCKWISE_180).m_61124_((Property)f_56843_, (Comparable)StairsShape.INNER_RIGHT));
                    }
                    case INNER_RIGHT: {
                        return (BlockState)((Object)p_56919_.m_60717_(Rotation.CLOCKWISE_180).m_61124_((Property)f_56843_, (Comparable)StairsShape.INNER_LEFT));
                    }
                    case OUTER_LEFT: {
                        return (BlockState)((Object)p_56919_.m_60717_(Rotation.CLOCKWISE_180).m_61124_((Property)f_56843_, (Comparable)StairsShape.OUTER_RIGHT));
                    }
                    case OUTER_RIGHT: {
                        return (BlockState)((Object)p_56919_.m_60717_(Rotation.CLOCKWISE_180).m_61124_((Property)f_56843_, (Comparable)StairsShape.OUTER_LEFT));
                    }
                }
                return p_56919_.m_60717_(Rotation.CLOCKWISE_180);
            }
            case FRONT_BACK: {
                if (direction.m_122434_() != Direction.Axis.X) break;
                switch (stairsshape) {
                    case INNER_LEFT: {
                        return (BlockState)((Object)p_56919_.m_60717_(Rotation.CLOCKWISE_180).m_61124_((Property)f_56843_, (Comparable)StairsShape.INNER_LEFT));
                    }
                    case INNER_RIGHT: {
                        return (BlockState)((Object)p_56919_.m_60717_(Rotation.CLOCKWISE_180).m_61124_((Property)f_56843_, (Comparable)StairsShape.INNER_RIGHT));
                    }
                    case OUTER_LEFT: {
                        return (BlockState)((Object)p_56919_.m_60717_(Rotation.CLOCKWISE_180).m_61124_((Property)f_56843_, (Comparable)StairsShape.OUTER_RIGHT));
                    }
                    case OUTER_RIGHT: {
                        return (BlockState)((Object)p_56919_.m_60717_(Rotation.CLOCKWISE_180).m_61124_((Property)f_56843_, (Comparable)StairsShape.OUTER_LEFT));
                    }
                    case STRAIGHT: {
                        return p_56919_.m_60717_(Rotation.CLOCKWISE_180);
                    }
                }
            }
        }
        return super.m_6943_(p_56919_, p_56920_);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_56932_) {
        p_56932_.m_61104_(new Property[]{f_56841_, f_56842_, f_56843_, f_56844_});
    }

    @Override
    public FluidState m_5888_(BlockState p_56969_) {
        return (Boolean)p_56969_.m_61143_((Property)f_56844_) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(p_56969_);
    }

    @Override
    public boolean m_7357_(BlockState p_56891_, BlockGetter p_56892_, BlockPos p_56893_, PathComputationType p_56894_) {
        return false;
    }

    private Block getModelBlock() {
        return this.getModelState().m_60734_();
    }

    private BlockState getModelState() {
        return this.stateSupplier.get();
    }
}

