/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;
import org.bukkit.craftbukkit.v1_18_R2.event.CraftEventFactory;

public class SugarCaneBlock
extends Block
implements IPlantable {
    public static final IntegerProperty f_57164_ = BlockStateProperties.f_61410_;
    protected static final float f_154735_ = 6.0f;
    protected static final VoxelShape f_57165_ = Block.m_49796_(2.0, 0.0, 2.0, 14.0, 16.0, 14.0);

    public SugarCaneBlock(BlockBehaviour.Properties p_57168_) {
        super(p_57168_);
        this.m_49959_((BlockState)((Object)((BlockState)this.f_49792_.m_61090_()).m_61124_(f_57164_, Integer.valueOf(0))));
    }

    @Override
    public VoxelShape m_5940_(BlockState p_57193_, BlockGetter p_57194_, BlockPos p_57195_, CollisionContext p_57196_) {
        return f_57165_;
    }

    @Override
    public void m_7458_(BlockState p_57170_, ServerLevel p_57171_, BlockPos p_57172_, Random p_57173_) {
        if (!p_57170_.m_60710_((LevelReader)((Object)p_57171_), p_57172_)) {
            p_57171_.m_46961_(p_57172_, true);
        }
    }

    @Override
    public void m_7455_(BlockState p_57188_, ServerLevel p_57189_, BlockPos p_57190_, Random p_57191_) {
        if (p_57189_.m_46859_(p_57190_.m_7494_())) {
            int i = 1;
            while (p_57189_.m_8055_(p_57190_.m_6625_(i)).m_60713_(this)) {
                ++i;
            }
            if (i < 3) {
                int j = (Integer)p_57188_.m_61143_(f_57164_);
                if (ForgeHooks.onCropsGrowPre((Level)p_57189_, (BlockPos)p_57190_, (BlockState)p_57188_, (boolean)true)) {
                    if (j == 15) {
                        CraftEventFactory.handleBlockGrowEvent((Level)p_57189_, (BlockPos)p_57190_.m_7494_(), (BlockState)this.m_49966_());
                        p_57189_.m_7731_(p_57190_, (BlockState)((Object)p_57188_.m_61124_(f_57164_, Integer.valueOf(0))), 4);
                    } else {
                        p_57189_.m_7731_(p_57190_, (BlockState)((Object)p_57188_.m_61124_(f_57164_, Integer.valueOf(j + 1))), 4);
                    }
                }
            }
        }
    }

    @Override
    public BlockState m_7417_(BlockState p_57179_, Direction p_57180_, BlockState p_57181_, LevelAccessor p_57182_, BlockPos p_57183_, BlockPos p_57184_) {
        if (!p_57179_.m_60710_((LevelReader)((Object)p_57182_), p_57183_)) {
            p_57182_.m_186460_(p_57183_, this, 1);
        }
        return super.m_7417_(p_57179_, p_57180_, p_57181_, p_57182_, p_57183_, p_57184_);
    }

    @Override
    public boolean m_7898_(BlockState p_57175_, LevelReader p_57176_, BlockPos p_57177_) {
        BlockState soil = p_57176_.m_8055_(p_57177_.m_7495_());
        if (soil.canSustainPlant((BlockGetter)((Object)p_57176_), p_57177_.m_7495_(), Direction.UP, this)) {
            return true;
        }
        BlockState blockstate = p_57176_.m_8055_(p_57177_.m_7495_());
        if (blockstate.m_60713_(this)) {
            return true;
        }
        if (blockstate.m_204336_(BlockTags.f_144274_) || blockstate.m_60713_(Blocks.f_49992_) || blockstate.m_60713_(Blocks.f_49993_)) {
            BlockPos blockpos = p_57177_.m_7495_();
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockState blockstate1 = p_57176_.m_8055_(blockpos.m_142300_(direction));
                FluidState fluidstate = p_57176_.m_6425_(blockpos.m_142300_(direction));
                if (!fluidstate.m_205070_(FluidTags.f_13131_) && !blockstate1.m_60713_(Blocks.f_50449_)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_57186_) {
        p_57186_.m_61104_(new Property[]{f_57164_});
    }

    public PlantType getPlantType(BlockGetter world, BlockPos pos) {
        return PlantType.BEACH;
    }

    public BlockState getPlant(BlockGetter world, BlockPos pos) {
        return this.m_49966_();
    }
}

