/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.state.properties;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import net.minecraft.world.level.block.state.properties.Property;

public class IntegerProperty
extends Property<Integer> {
    private final ImmutableSet<Integer> f_61621_;
    public final int min;
    public final int max;

    protected IntegerProperty(String p_61623_, int p_61624_, int p_61625_) {
        super(p_61623_, Integer.class);
        this.min = p_61624_;
        this.max = p_61625_;
        if (p_61624_ < 0) {
            throw new IllegalArgumentException("Min value of " + p_61623_ + " must be 0 or greater");
        }
        if (p_61625_ <= p_61624_) {
            throw new IllegalArgumentException("Max value of " + p_61623_ + " must be greater than min (" + p_61624_ + ")");
        }
        HashSet set = Sets.newHashSet();
        for (int i = p_61624_; i <= p_61625_; ++i) {
            set.add(i);
        }
        this.f_61621_ = ImmutableSet.copyOf((Collection)set);
    }

    public Collection<Integer> m_6908_() {
        return this.f_61621_;
    }

    public boolean equals(Object p_61639_) {
        if (this == p_61639_) {
            return true;
        }
        if (p_61639_ instanceof IntegerProperty && super.equals(p_61639_)) {
            IntegerProperty integerproperty = (IntegerProperty)((Object)p_61639_);
            return this.f_61621_.equals(integerproperty.f_61621_);
        }
        return false;
    }

    public int m_6310_() {
        return 31 * super.m_6310_() + this.f_61621_.hashCode();
    }

    public static IntegerProperty m_61631_(String p_61632_, int p_61633_, int p_61634_) {
        return new IntegerProperty(p_61632_, p_61633_, p_61634_);
    }

    public Optional<Integer> m_6215_(String p_61637_) {
        try {
            Integer integer = Integer.valueOf(p_61637_);
            return this.f_61621_.contains((Object)integer) ? Optional.of(integer) : Optional.empty();
        }
        catch (NumberFormatException numberformatexception) {
            return Optional.empty();
        }
    }

    public String m_6940_(Integer p_61630_) {
        return p_61630_.toString();
    }
}

