/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.text.DecimalFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.Mth;
import net.minecraft.util.VisibleForDebug;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.TerrainShaper;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.CarvingMask;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.Beardifier;
import net.minecraft.world.level.levelgen.BelowZeroRetrogen;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.RandomSupport;
import net.minecraft.world.level.levelgen.SurfaceSystem;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.carver.CarvingContext;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.synth.NormalNoise;

public class NoiseBasedChunkGenerator
extends ChunkGenerator {
    public static final Codec<NoiseBasedChunkGenerator> f_64314_ = RecordCodecBuilder.create(p_188643_ -> NoiseBasedChunkGenerator.m_208005_(p_188643_).and(p_188643_.group((App)RegistryOps.m_206832_(Registry.f_194568_).forGetter(p_188716_ -> p_188716_.f_188604_), (App)BiomeSource.f_47888_.fieldOf("biome_source").forGetter(p_188711_ -> p_188711_.f_62137_), (App)Codec.LONG.fieldOf("seed").stable().forGetter(p_188690_ -> p_188690_.f_64333_), (App)NoiseGeneratorSettings.f_64431_.fieldOf("settings").forGetter(p_204585_ -> p_204585_.f_64318_))).apply((Applicative)p_188643_, p_188643_.stable(NoiseBasedChunkGenerator::new)));
    private static final BlockState f_64321_ = Blocks.f_50016_.m_49966_();
    private static final BlockState[] f_158373_ = new BlockState[0];
    protected final BlockState f_64316_;
    public final Registry<NormalNoise.NoiseParameters> f_188604_;
    protected final long f_64333_;
    public final Holder<NoiseGeneratorSettings> f_64318_;
    private final NoiseRouter f_209104_;
    protected final Climate.Sampler f_158382_;
    private final SurfaceSystem f_188605_;
    private final Aquifer.FluidPicker f_188607_;

    public NoiseBasedChunkGenerator(Registry<StructureSet> p_209106_, Registry<NormalNoise.NoiseParameters> p_209107_, BiomeSource p_209108_, long p_209109_, Holder<NoiseGeneratorSettings> p_209110_) {
        this(p_209106_, p_209107_, p_209108_, p_209108_, p_209109_, p_209110_);
    }

    private NoiseBasedChunkGenerator(Registry<StructureSet> p_209112_, Registry<NormalNoise.NoiseParameters> p_209113_, BiomeSource p_209114_, BiomeSource p_209115_, long p_209116_, Holder<NoiseGeneratorSettings> p_209117_) {
        super(p_209112_, Optional.empty(), p_209114_, p_209115_, p_209116_);
        this.f_188604_ = p_209113_;
        this.f_64333_ = p_209116_;
        this.f_64318_ = p_209117_;
        NoiseGeneratorSettings noisegeneratorsettings = this.f_64318_.m_203334_();
        this.f_64316_ = noisegeneratorsettings.f_64440_();
        NoiseSettings noisesettings = noisegeneratorsettings.f_64439_();
        this.f_209104_ = noisegeneratorsettings.m_209366_(p_209113_, p_209116_);
        this.f_158382_ = new Climate.Sampler(this.f_209104_.f_209384_(), this.f_209104_.f_209385_(), this.f_209104_.f_209386_(), this.f_209104_.f_209387_(), this.f_209104_.f_209388_(), this.f_209104_.f_209389_(), this.f_209104_.f_209395_());
        Aquifer.FluidStatus aquifer$fluidstatus = new Aquifer.FluidStatus(-54, Blocks.f_49991_.m_49966_());
        int i = noisegeneratorsettings.f_64444_();
        Aquifer.FluidStatus aquifer$fluidstatus1 = new Aquifer.FluidStatus(i, noisegeneratorsettings.f_64441_());
        Aquifer.FluidStatus aquifer$fluidstatus2 = new Aquifer.FluidStatus(noisesettings.f_158688_() - 1, Blocks.f_50016_.m_49966_());
        this.f_188607_ = (p_198228_, p_198229_, p_198230_) -> p_198229_ < Math.min(-54, i) ? aquifer$fluidstatus : aquifer$fluidstatus1;
        this.f_188605_ = new SurfaceSystem(p_209113_, this.f_64316_, i, p_209116_, noisegeneratorsettings.m_188893_());
    }

    @Override
    public CompletableFuture<ChunkAccess> m_196423_(Registry<Biome> p_197005_, Executor p_197006_, Blender p_197007_, StructureFeatureManager p_197008_, ChunkAccess p_197009_) {
        return CompletableFuture.supplyAsync(Util.m_183946_("init_biomes", () -> {
            this.m_204586_(p_197007_, p_197008_, p_197009_);
            return p_197009_;
        }), Util.m_183991_());
    }

    private void m_204586_(Blender p_204587_, StructureFeatureManager p_204588_, ChunkAccess p_204589_) {
        NoiseChunk noisechunk = p_204589_.m_207937_(this.f_209104_, () -> new Beardifier(p_204588_, p_204589_), this.f_64318_.m_203334_(), this.f_188607_, p_204587_);
        BiomeResolver biomeresolver = BelowZeroRetrogen.m_204531_((BiomeResolver)p_204587_.m_183383_((BiomeResolver)this.f_62138_), (ChunkAccess)p_204589_);
        p_204589_.m_183442_(biomeresolver, noisechunk.m_209218_(this.f_209104_));
    }

    @VisibleForDebug
    public NoiseRouter m_209149_() {
        return this.f_209104_;
    }

    @Override
    public Climate.Sampler m_183403_() {
        return this.f_158382_;
    }

    @Override
    protected Codec<? extends ChunkGenerator> m_6909_() {
        return f_64314_;
    }

    @Override
    public ChunkGenerator m_6819_(long p_64374_) {
        return new NoiseBasedChunkGenerator((Registry<StructureSet>)this.f_207955_, this.f_188604_, this.f_62137_.m_7206_(p_64374_), p_64374_, this.f_64318_);
    }

    public boolean m_64375_(long p_64376_, ResourceKey<NoiseGeneratorSettings> p_64377_) {
        return this.f_64333_ == p_64376_ && this.f_64318_.m_203565_(p_64377_);
    }

    @Override
    public int m_142647_(int p_158405_, int p_158406_, Heightmap.Types p_158407_, LevelHeightAccessor p_158408_) {
        NoiseSettings noisesettings = this.f_64318_.m_203334_().f_64439_();
        int i = Math.max(noisesettings.f_158688_(), p_158408_.m_141937_());
        int j = Math.min(noisesettings.f_158688_() + noisesettings.f_64508_(), p_158408_.m_151558_());
        int k = Mth.m_14042_((int)i, (int)noisesettings.m_189212_());
        int l = Mth.m_14042_((int)(j - i), (int)noisesettings.m_189212_());
        return l <= 0 ? p_158408_.m_141937_() : this.m_158413_(p_158405_, p_158406_, null, p_158407_.m_64299_(), k, l).orElse(p_158408_.m_141937_());
    }

    @Override
    public NoiseColumn m_141914_(int p_158401_, int p_158402_, LevelHeightAccessor p_158403_) {
        NoiseSettings noisesettings = this.f_64318_.m_203334_().f_64439_();
        int i = Math.max(noisesettings.f_158688_(), p_158403_.m_141937_());
        int j = Math.min(noisesettings.f_158688_() + noisesettings.f_64508_(), p_158403_.m_151558_());
        int k = Mth.m_14042_((int)i, (int)noisesettings.m_189212_());
        int l = Mth.m_14042_((int)(j - i), (int)noisesettings.m_189212_());
        if (l <= 0) {
            return new NoiseColumn(i, f_158373_);
        }
        BlockState[] ablockstate = new BlockState[l * noisesettings.m_189212_()];
        this.m_158413_(p_158401_, p_158402_, ablockstate, null, k, l);
        return new NoiseColumn(i, ablockstate);
    }

    @Override
    public void m_207076_(List<String> p_209128_, BlockPos p_209129_) {
        DecimalFormat decimalformat = new DecimalFormat("0.000");
        DensityFunction.SinglePointContext densityfunction$singlepointcontext = new DensityFunction.SinglePointContext(p_209129_.m_123341_(), p_209129_.m_123342_(), p_209129_.m_123343_());
        double d0 = this.f_209104_.f_209389_().m_207386_((DensityFunction.FunctionContext)densityfunction$singlepointcontext);
        p_209128_.add("NoiseRouter T: " + decimalformat.format(this.f_209104_.f_209384_().m_207386_((DensityFunction.FunctionContext)densityfunction$singlepointcontext)) + " H: " + decimalformat.format(this.f_209104_.f_209385_().m_207386_((DensityFunction.FunctionContext)densityfunction$singlepointcontext)) + " C: " + decimalformat.format(this.f_209104_.f_209386_().m_207386_((DensityFunction.FunctionContext)densityfunction$singlepointcontext)) + " E: " + decimalformat.format(this.f_209104_.f_209387_().m_207386_((DensityFunction.FunctionContext)densityfunction$singlepointcontext)) + " D: " + decimalformat.format(this.f_209104_.f_209388_().m_207386_((DensityFunction.FunctionContext)densityfunction$singlepointcontext)) + " W: " + decimalformat.format(d0) + " PV: " + decimalformat.format(TerrainShaper.m_187265_((float)((float)d0))) + " AS: " + decimalformat.format(this.f_209104_.f_209390_().m_207386_((DensityFunction.FunctionContext)densityfunction$singlepointcontext)) + " N: " + decimalformat.format(this.f_209104_.f_209391_().m_207386_((DensityFunction.FunctionContext)densityfunction$singlepointcontext)));
    }

    protected OptionalInt m_158413_(int p_158414_, int p_158415_, @Nullable BlockState[] p_158416_, @Nullable Predicate<BlockState> p_158417_, int p_158418_, int p_158419_) {
        NoiseSettings noisesettings = this.f_64318_.m_203334_().f_64439_();
        int i = noisesettings.m_189213_();
        int j = noisesettings.m_189212_();
        int k = Math.floorDiv(p_158414_, i);
        int l = Math.floorDiv(p_158415_, i);
        int i1 = Math.floorMod(p_158414_, i);
        int j1 = Math.floorMod(p_158415_, i);
        int k1 = k * i;
        int l1 = l * i;
        double d0 = (double)i1 / (double)i;
        double d1 = (double)j1 / (double)i;
        NoiseChunk noisechunk = NoiseChunk.m_209194_((int)k1, (int)l1, (int)p_158418_, (int)p_158419_, (NoiseRouter)this.f_209104_, (NoiseGeneratorSettings)this.f_64318_.m_203334_(), (Aquifer.FluidPicker)this.f_188607_);
        noisechunk.m_188791_();
        noisechunk.m_188749_(0);
        for (int i2 = p_158419_ - 1; i2 >= 0; --i2) {
            noisechunk.m_188810_(i2, 0);
            for (int j2 = j - 1; j2 >= 0; --j2) {
                BlockState blockstate1;
                int k2 = (p_158418_ + i2) * j + j2;
                double d2 = (double)j2 / (double)j;
                noisechunk.m_209191_(k2, d2);
                noisechunk.m_209230_(p_158414_, d0);
                noisechunk.m_209241_(p_158415_, d1);
                BlockState blockstate = noisechunk.m_209247_();
                BlockState blockState = blockstate1 = blockstate == null ? this.f_64316_ : blockstate;
                if (p_158416_ != null) {
                    int l2 = i2 * j + j2;
                    p_158416_[l2] = blockstate1;
                }
                if (p_158417_ == null || !p_158417_.test(blockstate1)) continue;
                noisechunk.m_209248_();
                return OptionalInt.of(k2 + 1);
            }
        }
        noisechunk.m_209248_();
        return OptionalInt.empty();
    }

    @Override
    public void m_183621_(WorldGenRegion p_188636_, StructureFeatureManager p_188637_, ChunkAccess p_188638_) {
        if (!SharedConstants.m_183707_(p_188638_.m_7697_())) {
            WorldGenerationContext worldgenerationcontext = new WorldGenerationContext((ChunkGenerator)this, (LevelHeightAccessor)p_188636_);
            NoiseGeneratorSettings noisegeneratorsettings = this.f_64318_.m_203334_();
            NoiseChunk noisechunk = p_188638_.m_207937_(this.f_209104_, () -> new Beardifier(p_188637_, p_188638_), noisegeneratorsettings, this.f_188607_, Blender.m_190202_((WorldGenRegion)p_188636_));
            this.f_188605_.m_189944_(p_188636_.m_7062_(), p_188636_.m_5962_().m_175515_(Registry.f_122885_), noisegeneratorsettings.f_209354_(), worldgenerationcontext, p_188638_, noisechunk, noisegeneratorsettings.f_188871_());
        }
    }

    @Override
    public void m_183516_(WorldGenRegion p_188629_, long p_188630_, BiomeManager p_188631_, StructureFeatureManager p_188632_, ChunkAccess p_188633_, GenerationStep.Carving p_188634_) {
        BiomeManager biomemanager = p_188631_.m_186687_((p_209119_, p_209120_, p_209121_) -> this.f_62137_.m_203407_(p_209119_, p_209120_, p_209121_, this.m_183403_()));
        WorldgenRandom worldgenrandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(RandomSupport.m_189328_()));
        int i = 8;
        ChunkPos chunkpos = p_188633_.m_7697_();
        NoiseChunk noisechunk = p_188633_.m_207937_(this.f_209104_, () -> new Beardifier(p_188632_, p_188633_), this.f_64318_.m_203334_(), this.f_188607_, Blender.m_190202_((WorldGenRegion)p_188629_));
        Aquifer aquifer = noisechunk.m_188817_();
        CarvingContext carvingcontext = new CarvingContext(this, p_188629_.m_5962_(), p_188633_.m_183618_(), noisechunk);
        CarvingMask carvingmask = ((ProtoChunk)p_188633_).m_183613_(p_188634_);
        for (int j = -8; j <= 8; ++j) {
            for (int k = -8; k <= 8; ++k) {
                ChunkPos chunkpos1 = new ChunkPos(chunkpos.f_45578_ + j, chunkpos.f_45579_ + k);
                ChunkAccess chunkaccess = p_188629_.m_6325_(chunkpos1.f_45578_, chunkpos1.f_45579_);
                BiomeGenerationSettings biomegenerationsettings = chunkaccess.m_204344_(() -> this.f_62137_.m_203407_(QuartPos.m_175400_((int)chunkpos1.m_45604_()), 0, QuartPos.m_175400_((int)chunkpos1.m_45605_()), this.m_183403_())).m_203334_().m_47536_();
                Iterable<Holder<ConfiguredWorldCarver<?>>> iterable = biomegenerationsettings.m_204187_(p_188634_);
                int l = 0;
                for (Holder<ConfiguredWorldCarver<?>> holder : iterable) {
                    ConfiguredWorldCarver<?> configuredworldcarver = holder.m_203334_();
                    worldgenrandom.m_190068_(p_188630_ + (long)l, chunkpos1.f_45578_, chunkpos1.f_45579_);
                    if (configuredworldcarver.m_159273_((Random)worldgenrandom)) {
                        configuredworldcarver.m_190712_(carvingcontext, p_188633_, arg_0 -> ((BiomeManager)biomemanager).m_204214_(arg_0), (Random)worldgenrandom, aquifer, chunkpos1, carvingmask);
                    }
                    ++l;
                }
            }
        }
    }

    @Override
    public CompletableFuture<ChunkAccess> m_183489_(Executor p_188702_, Blender p_188703_, StructureFeatureManager p_188704_, ChunkAccess p_188705_) {
        NoiseSettings noisesettings = this.f_64318_.m_203334_().f_64439_();
        LevelHeightAccessor levelheightaccessor = p_188705_.m_183618_();
        int i = Math.max(noisesettings.f_158688_(), levelheightaccessor.m_141937_());
        int j = Math.min(noisesettings.f_158688_() + noisesettings.f_64508_(), levelheightaccessor.m_151558_());
        int k = Mth.m_14042_((int)i, (int)noisesettings.m_189212_());
        int l = Mth.m_14042_((int)(j - i), (int)noisesettings.m_189212_());
        if (l <= 0) {
            return CompletableFuture.completedFuture(p_188705_);
        }
        int i1 = p_188705_.m_151564_(l * noisesettings.m_189212_() - 1 + i);
        int j1 = p_188705_.m_151564_(i);
        HashSet set = Sets.newHashSet();
        for (int k1 = i1; k1 >= j1; --k1) {
            LevelChunkSection levelchunksection = p_188705_.m_183278_(k1);
            levelchunksection.m_62981_();
            set.add(levelchunksection);
        }
        return CompletableFuture.supplyAsync(Util.m_183946_("wgen_fill_noise", () -> this.m_188662_(p_188703_, p_188704_, p_188705_, k, l)), Util.m_183991_()).whenCompleteAsync((p_209132_, p_209133_) -> {
            for (LevelChunkSection levelchunksection1 : set) {
                levelchunksection1.m_63006_();
            }
        }, p_188702_);
    }

    private ChunkAccess m_188662_(Blender p_188663_, StructureFeatureManager p_188664_, ChunkAccess p_188665_, int p_188666_, int p_188667_) {
        NoiseGeneratorSettings noisegeneratorsettings = this.f_64318_.m_203334_();
        NoiseChunk noisechunk = p_188665_.m_207937_(this.f_209104_, () -> new Beardifier(p_188664_, p_188665_), noisegeneratorsettings, this.f_188607_, p_188663_);
        Heightmap heightmap = p_188665_.m_6005_(Heightmap.Types.OCEAN_FLOOR_WG);
        Heightmap heightmap1 = p_188665_.m_6005_(Heightmap.Types.WORLD_SURFACE_WG);
        ChunkPos chunkpos = p_188665_.m_7697_();
        int i = chunkpos.m_45604_();
        int j = chunkpos.m_45605_();
        Aquifer aquifer = noisechunk.m_188817_();
        noisechunk.m_188791_();
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        NoiseSettings noisesettings = noisegeneratorsettings.f_64439_();
        int k = noisesettings.m_189213_();
        int l = noisesettings.m_189212_();
        int i1 = 16 / k;
        int j1 = 16 / k;
        for (int k1 = 0; k1 < i1; ++k1) {
            noisechunk.m_188749_(k1);
            for (int l1 = 0; l1 < j1; ++l1) {
                LevelChunkSection levelchunksection = p_188665_.m_183278_(p_188665_.m_151559_() - 1);
                for (int i2 = p_188667_ - 1; i2 >= 0; --i2) {
                    noisechunk.m_188810_(i2, l1);
                    for (int j2 = l - 1; j2 >= 0; --j2) {
                        int k2 = (p_188666_ + i2) * l + j2;
                        int l2 = k2 & 0xF;
                        int i3 = p_188665_.m_151564_(k2);
                        if (p_188665_.m_151564_(levelchunksection.m_63017_()) != i3) {
                            levelchunksection = p_188665_.m_183278_(i3);
                        }
                        double d0 = (double)j2 / (double)l;
                        noisechunk.m_209191_(k2, d0);
                        for (int j3 = 0; j3 < k; ++j3) {
                            int k3 = i + k1 * k + j3;
                            int l3 = k3 & 0xF;
                            double d1 = (double)j3 / (double)k;
                            noisechunk.m_209230_(k3, d1);
                            for (int i4 = 0; i4 < k; ++i4) {
                                int j4 = j + l1 * k + i4;
                                int k4 = j4 & 0xF;
                                double d2 = (double)i4 / (double)k;
                                noisechunk.m_209241_(j4, d2);
                                BlockState blockstate = noisechunk.m_209247_();
                                if (blockstate == null) {
                                    blockstate = this.f_64316_;
                                }
                                if ((blockstate = this.m_198231_(noisechunk, k3, k2, j4, blockstate)) == f_64321_ || SharedConstants.m_183707_(p_188665_.m_7697_())) continue;
                                if (blockstate.m_60791_() != 0 && p_188665_ instanceof ProtoChunk) {
                                    blockpos$mutableblockpos.m_122178_(k3, k2, j4);
                                    ((ProtoChunk)p_188665_).m_63277_((BlockPos)blockpos$mutableblockpos);
                                }
                                levelchunksection.m_62991_(l3, l2, k4, blockstate, false);
                                heightmap.m_64249_(l3, k2, k4, blockstate);
                                heightmap1.m_64249_(l3, k2, k4, blockstate);
                                if (!aquifer.m_142203_() || blockstate.m_60819_().m_76178_()) continue;
                                blockpos$mutableblockpos.m_122178_(k3, k2, j4);
                                p_188665_.m_8113_((BlockPos)blockpos$mutableblockpos);
                            }
                        }
                    }
                }
            }
            noisechunk.m_188804_();
        }
        noisechunk.m_209248_();
        return p_188665_;
    }

    private BlockState m_198231_(NoiseChunk p_198232_, int p_198233_, int p_198234_, int p_198235_, BlockState p_198236_) {
        return p_198236_;
    }

    @Override
    public int m_6331_() {
        return this.f_64318_.m_203334_().f_64439_().f_64508_();
    }

    @Override
    public int m_6337_() {
        return this.f_64318_.m_203334_().f_64444_();
    }

    @Override
    public int m_142062_() {
        return this.f_64318_.m_203334_().f_64439_().f_158688_();
    }

    @Override
    public void m_6929_(WorldGenRegion p_64379_) {
        if (!this.f_64318_.m_203334_().f_64445_()) {
            ChunkPos chunkpos = p_64379_.m_143488_();
            Holder holder = p_64379_.m_204166_(chunkpos.m_45615_().m_175288_(p_64379_.m_151558_() - 1));
            WorldgenRandom worldgenrandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(RandomSupport.m_189328_()));
            worldgenrandom.m_64690_(p_64379_.m_7328_(), chunkpos.m_45604_(), chunkpos.m_45605_());
            NaturalSpawner.m_204175_((ServerLevelAccessor)((Object)p_64379_), holder, chunkpos, (Random)worldgenrandom);
        }
    }

    @Deprecated
    public Optional<BlockState> m_188668_(CarvingContext p_188669_, Function<BlockPos, Holder<Biome>> p_188670_, ChunkAccess p_188671_, NoiseChunk p_188672_, BlockPos p_188673_, boolean p_188674_) {
        return this.f_188605_.m_189971_(this.f_64318_.m_203334_().f_188871_(), p_188669_, p_188670_, p_188671_, p_188672_, p_188673_, p_188674_);
    }
}

