/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.dedicated.DedicatedServerProperties;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.DebugLevelSource;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.flat.FlatLevelGeneratorSettings;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.world.ForgeWorldPreset;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public class WorldGenSettings {
    public static final Codec<WorldGenSettings> f_64600_ = RecordCodecBuilder.create(p_64626_ -> p_64626_.group((App)Codec.LONG.fieldOf("seed").stable().forGetter(WorldGenSettings::m_64619_), (App)Codec.BOOL.fieldOf("generate_features").orElse((Object)true).stable().forGetter(WorldGenSettings::m_64657_), (App)Codec.BOOL.fieldOf("bonus_chest").orElse((Object)false).stable().forGetter(WorldGenSettings::m_64660_), (App)RegistryCodecs.m_206318_(Registry.f_122820_, Lifecycle.stable(), LevelStem.f_63970_).xmap(LevelStem::m_204525_, Function.identity()).fieldOf("dimensions").forGetter(WorldGenSettings::m_204655_), (App)Codec.STRING.optionalFieldOf("legacy_custom_options").stable().forGetter(p_158959_ -> p_158959_.f_64606_)).apply((Applicative)p_64626_, p_64626_.stable(WorldGenSettings::new))).xmap(ForgeHooks::loadDimensionsWithServerSeed, wgs -> wgs).comapFlatMap(WorldGenSettings::m_64674_, Function.identity());
    private static final Logger f_64601_ = LogUtils.getLogger();
    private final long f_64602_;
    private final boolean f_64603_;
    private final boolean f_64604_;
    private final Registry<LevelStem> f_64605_;
    public final Optional<String> f_64606_;

    private DataResult<WorldGenSettings> m_64674_() {
        LevelStem levelstem = this.f_64605_.m_6246_(LevelStem.f_63971_);
        if (levelstem == null) {
            return DataResult.error((String)"Overworld settings missing");
        }
        return this.m_64675_() ? DataResult.success((Object)this, (Lifecycle)Lifecycle.stable()) : DataResult.success((Object)this);
    }

    private boolean m_64675_() {
        return LevelStem.m_204522_(this.f_64602_, this.f_64605_);
    }

    public WorldGenSettings(long p_204633_, boolean p_204634_, boolean p_204635_, Registry<LevelStem> p_204636_) {
        this(p_204633_, p_204634_, p_204635_, p_204636_, Optional.empty());
        LevelStem levelstem = p_204636_.m_6246_(LevelStem.f_63971_);
        if (levelstem == null) {
            throw new IllegalStateException("Overworld settings missing");
        }
    }

    public WorldGenSettings(long p_204638_, boolean p_204639_, boolean p_204640_, Registry<LevelStem> p_204641_, Optional<String> p_204642_) {
        this.f_64602_ = p_204638_;
        this.f_64603_ = p_204639_;
        this.f_64604_ = p_204640_;
        this.f_64605_ = p_204641_;
        this.f_64606_ = p_204642_;
    }

    public static WorldGenSettings m_64645_(RegistryAccess p_64646_) {
        int i = "North Carolina".hashCode();
        return new WorldGenSettings(i, true, true, WorldGenSettings.m_204649_(p_64646_.m_175515_(Registry.f_122818_), DimensionType.m_204490_((RegistryAccess)p_64646_, (long)i), WorldGenSettings.m_190027_(p_64646_, i)));
    }

    public static WorldGenSettings m_190050_(RegistryAccess p_190051_) {
        long i = new Random().nextLong();
        return new WorldGenSettings(i, true, false, WorldGenSettings.m_204649_(p_190051_.m_175515_(Registry.f_122818_), DimensionType.m_204490_((RegistryAccess)p_190051_, (long)i), WorldGenSettings.m_190027_(p_190051_, i)));
    }

    public static NoiseBasedChunkGenerator m_190027_(RegistryAccess p_190028_, long p_190029_) {
        return WorldGenSettings.m_190039_(p_190028_, p_190029_, true);
    }

    public static NoiseBasedChunkGenerator m_190039_(RegistryAccess p_190040_, long p_190041_, boolean p_190042_) {
        return WorldGenSettings.m_190034_(p_190040_, p_190041_, NoiseGeneratorSettings.f_64432_, p_190042_);
    }

    public static NoiseBasedChunkGenerator m_190030_(RegistryAccess p_190031_, long p_190032_, ResourceKey<NoiseGeneratorSettings> p_190033_) {
        return WorldGenSettings.m_190034_(p_190031_, p_190032_, p_190033_, true);
    }

    public static NoiseBasedChunkGenerator m_190034_(RegistryAccess p_190035_, long p_190036_, ResourceKey<NoiseGeneratorSettings> p_190037_, boolean p_190038_) {
        Registry<Biome> registry = p_190035_.m_175515_(Registry.f_122885_);
        Registry<StructureSet> registry1 = p_190035_.m_175515_(Registry.f_211073_);
        Registry<NoiseGeneratorSettings> registry2 = p_190035_.m_175515_(Registry.f_122878_);
        Registry<NormalNoise.NoiseParameters> registry3 = p_190035_.m_175515_(Registry.f_194568_);
        return new NoiseBasedChunkGenerator(registry1, registry3, (BiomeSource)MultiNoiseBiomeSource.Preset.f_187087_.m_187104_(registry, p_190038_), p_190036_, registry2.m_203538_(p_190037_));
    }

    public long m_64619_() {
        return this.f_64602_;
    }

    public boolean m_64657_() {
        return this.f_64603_;
    }

    public boolean m_64660_() {
        return this.f_64604_;
    }

    public static Registry<LevelStem> m_204649_(Registry<DimensionType> p_204650_, Registry<LevelStem> p_204651_, ChunkGenerator p_204652_) {
        LevelStem levelstem = p_204651_.m_6246_(LevelStem.f_63971_);
        Holder<DimensionType> holder = levelstem == null ? p_204650_.m_203538_(DimensionType.f_63845_) : levelstem.m_204521_();
        return WorldGenSettings.m_204645_(p_204651_, holder, p_204652_);
    }

    public static Registry<LevelStem> m_204645_(Registry<LevelStem> p_204646_, Holder<DimensionType> p_204647_, ChunkGenerator p_204648_) {
        MappedRegistry<LevelStem> writableregistry = new MappedRegistry<LevelStem>(Registry.f_122820_, Lifecycle.experimental(), null);
        writableregistry.m_203505_(LevelStem.f_63971_, new LevelStem(p_204647_, p_204648_), Lifecycle.stable());
        for (Map.Entry<ResourceKey<LevelStem>, LevelStem> entry : p_204646_.m_6579_()) {
            ResourceKey<LevelStem> resourcekey = entry.getKey();
            if (resourcekey == LevelStem.f_63971_) continue;
            writableregistry.m_203505_(resourcekey, entry.getValue(), p_204646_.m_6228_(entry.getValue()));
        }
        return writableregistry;
    }

    public Registry<LevelStem> m_204655_() {
        return this.f_64605_;
    }

    public ChunkGenerator m_64666_() {
        LevelStem levelstem = this.f_64605_.m_6246_(LevelStem.f_63971_);
        if (levelstem == null) {
            throw new IllegalStateException("Overworld settings missing");
        }
        return levelstem.m_63990_();
    }

    public ImmutableSet<ResourceKey<Level>> m_64667_() {
        return (ImmutableSet)this.m_204655_().m_6579_().stream().map(Map.Entry::getKey).map(WorldGenSettings::m_190048_).collect(ImmutableSet.toImmutableSet());
    }

    public static ResourceKey<Level> m_190048_(ResourceKey<LevelStem> p_190049_) {
        return ResourceKey.m_135785_(Registry.f_122819_, p_190049_.m_135782_());
    }

    public static ResourceKey<LevelStem> m_190052_(ResourceKey<Level> p_190053_) {
        return ResourceKey.m_135785_(Registry.f_122820_, p_190053_.m_135782_());
    }

    public boolean m_64668_() {
        return this.m_64666_() instanceof DebugLevelSource;
    }

    public boolean m_64669_() {
        return this.m_64666_() instanceof FlatLevelSource;
    }

    public boolean m_64670_() {
        return this.f_64606_.isPresent();
    }

    public WorldGenSettings m_64671_() {
        return new WorldGenSettings(this.f_64602_, this.f_64603_, true, this.f_64605_, this.f_64606_);
    }

    public WorldGenSettings m_64672_() {
        return new WorldGenSettings(this.f_64602_, !this.f_64603_, this.f_64604_, this.f_64605_);
    }

    public WorldGenSettings m_64673_() {
        return new WorldGenSettings(this.f_64602_, this.f_64603_, !this.f_64604_, this.f_64605_);
    }

    public static WorldGenSettings m_209716_(RegistryAccess p_209717_, DedicatedServerProperties.WorldGenProperties p_209718_) {
        long i = WorldGenSettings.m_202192_(p_209718_.f_207542_()).orElse(new Random().nextLong());
        Registry<DimensionType> registry = p_209717_.m_175515_(Registry.f_122818_);
        Registry<Biome> registry1 = p_209717_.m_175515_(Registry.f_122885_);
        Registry<StructureSet> registry2 = p_209717_.m_175515_(Registry.f_211073_);
        Registry registry3 = DimensionType.m_204490_((RegistryAccess)p_209717_, (long)i);
        String s = p_209718_.f_207545_();
        ForgeWorldPreset type = (ForgeWorldPreset)((IForgeRegistry)ForgeRegistries.WORLD_TYPES.get()).getValue(new ResourceLocation(s));
        if (type != null) {
            return type.createSettings(p_209717_, i, p_209718_.f_207544_(), false, s);
        }
        switch (s) {
            case "flat": {
                Dynamic dynamic = new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)p_209718_.f_207543_());
                return new WorldGenSettings(i, p_209718_.f_207544_(), false, WorldGenSettings.m_204649_(registry, registry3, (ChunkGenerator)new FlatLevelSource(registry2, FlatLevelGeneratorSettings.f_70347_.parse(dynamic).resultOrPartial(arg_0 -> ((Logger)f_64601_).error(arg_0)).orElseGet(() -> FlatLevelGeneratorSettings.m_211734_(registry1, registry2)))));
            }
            case "debug_all_block_states": {
                return new WorldGenSettings(i, p_209718_.f_207544_(), false, WorldGenSettings.m_204649_(registry, registry3, new DebugLevelSource(registry2, registry1)));
            }
            case "amplified": {
                return new WorldGenSettings(i, p_209718_.f_207544_(), false, WorldGenSettings.m_204649_(registry, registry3, WorldGenSettings.m_190030_(p_209717_, i, NoiseGeneratorSettings.f_64433_)));
            }
            case "largebiomes": {
                return new WorldGenSettings(i, p_209718_.f_207544_(), false, WorldGenSettings.m_204649_(registry, registry3, WorldGenSettings.m_190030_(p_209717_, i, NoiseGeneratorSettings.f_188869_)));
            }
        }
        return new WorldGenSettings(i, p_209718_.f_207544_(), false, WorldGenSettings.m_204649_(registry, registry3, WorldGenSettings.m_190027_(p_209717_, i)));
    }

    public WorldGenSettings m_64654_(boolean p_64655_, OptionalLong p_64656_) {
        Object registry;
        long i = p_64656_.orElse(this.f_64602_);
        if (p_64656_.isPresent()) {
            MappedRegistry<LevelStem> writableregistry = new MappedRegistry<LevelStem>(Registry.f_122820_, Lifecycle.experimental(), null);
            long j = p_64656_.getAsLong();
            for (Map.Entry<ResourceKey<LevelStem>, LevelStem> entry : this.f_64605_.m_6579_()) {
                ResourceKey<LevelStem> resourcekey = entry.getKey();
                writableregistry.m_203505_(resourcekey, new LevelStem(entry.getValue().m_204521_(), entry.getValue().m_63990_().m_6819_(j)), this.f_64605_.m_6228_(entry.getValue()));
            }
            registry = writableregistry;
        } else {
            registry = this.f_64605_;
        }
        WorldGenSettings worldgensettings = this.m_64668_() ? new WorldGenSettings(i, false, false, (Registry<LevelStem>)registry) : new WorldGenSettings(i, this.m_64657_(), this.m_64660_() && !p_64655_, (Registry<LevelStem>)registry);
        return worldgensettings;
    }

    public static OptionalLong m_202192_(String p_202193_) {
        if (StringUtils.isEmpty((CharSequence)(p_202193_ = p_202193_.trim()))) {
            return OptionalLong.empty();
        }
        try {
            return OptionalLong.of(Long.parseLong(p_202193_));
        }
        catch (NumberFormatException numberformatexception) {
            return OptionalLong.of(p_202193_.hashCode());
        }
    }
}

