/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import org.slf4j.Logger;

public abstract class SimpleJsonResourceReloadListener
extends SimplePreparableReloadListener<Map<ResourceLocation, JsonElement>> {
    private static final Logger f_10762_ = LogUtils.getLogger();
    private static final String f_143936_ = ".json";
    private static final int f_10763_ = ".json".length();
    private final Gson f_10764_;
    private final String f_10765_;

    public SimpleJsonResourceReloadListener(Gson p_10768_, String p_10769_) {
        this.f_10764_ = p_10768_;
        this.f_10765_ = p_10769_;
    }

    @Override
    protected Map<ResourceLocation, JsonElement> m_5944_(ResourceManager p_10771_, ProfilerFiller p_10772_) {
        HashMap $$2 = Maps.newHashMap();
        int $$3 = this.f_10765_.length() + 1;
        for (ResourceLocation $$4 : p_10771_.m_6540_(this.f_10765_, p_10774_ -> p_10774_.endsWith(f_143936_))) {
            String $$5 = $$4.m_135815_();
            ResourceLocation $$6 = new ResourceLocation($$4.m_135827_(), $$5.substring($$3, $$5.length() - f_10763_));
            try {
                Resource $$7 = p_10771_.m_142591_($$4);
                try {
                    InputStream $$8 = $$7.m_6679_();
                    try (BufferedReader $$9 = new BufferedReader(new InputStreamReader($$8, StandardCharsets.UTF_8));){
                        JsonElement $$10 = GsonHelper.m_13776_(this.f_10764_, $$9, JsonElement.class);
                        if ($$10 != null) {
                            JsonElement $$11 = $$2.put($$6, $$10);
                            if ($$11 == null) continue;
                            throw new IllegalStateException("Duplicate data file ignored with ID " + $$6);
                        }
                        f_10762_.error("Couldn't load data file {} from {} as it's null or empty", (Object)$$6, (Object)$$4);
                    }
                    finally {
                        if ($$8 == null) continue;
                        $$8.close();
                    }
                }
                finally {
                    if ($$7 == null) continue;
                    $$7.close();
                }
            }
            catch (JsonParseException | IOException | IllegalArgumentException $$12) {
                f_10762_.error("Couldn't parse data file {} from {}", new Object[]{$$6, $$4, $$12});
            }
        }
        return $$2;
    }

    @Override
    protected /* synthetic */ Object m_5944_(ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        return this.m_5944_(resourceManager, profilerFiller);
    }
}

