/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.floats.FloatList;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.util.ToFloatFunction;
import net.minecraft.util.VisibleForDebug;
import org.apache.commons.lang3.mutable.MutableObject;

public interface CubicSpline<C>
extends ToFloatFunction<C> {
    @VisibleForDebug
    public String m_183628_();

    public float m_207241_();

    public float m_207240_();

    public CubicSpline<C> m_211396_(CoordinateVisitor<C> var1);

    public static <C> Codec<CubicSpline<C>> m_184262_(Codec<ToFloatFunction<C>> p_184263_) {
        record Point<C>(float f_184273_, CubicSpline<C> f_184274_, float f_184275_) {
            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{Point.class, "location;value;derivative", "f_184273_", "f_184274_", "f_184275_"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Point.class, "location;value;derivative", "f_184273_", "f_184274_", "f_184275_"}, this);
            }

            @Override
            public final boolean equals(Object p_184284_) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Point.class, "location;value;derivative", "f_184273_", "f_184274_", "f_184275_"}, this, p_184284_);
            }
        }
        MutableObject $$1 = new MutableObject();
        Codec $$2 = RecordCodecBuilder.create(p_184270_ -> p_184270_.group((App)Codec.FLOAT.fieldOf("location").forGetter(Point::f_184273_), (App)ExtraCodecs.m_184415_(() -> ((MutableObject)$$1).getValue()).fieldOf("value").forGetter(Point::f_184274_), (App)Codec.FLOAT.fieldOf("derivative").forGetter(Point::f_184275_)).apply((Applicative)p_184270_, (p_184242_, p_184243_, p_184244_) -> new Point((float)p_184242_, p_184243_, (float)p_184244_)));
        Codec $$3 = RecordCodecBuilder.create(p_184267_ -> p_184267_.group((App)p_184263_.fieldOf("coordinate").forGetter(Multipoint::f_184319_), (App)ExtraCodecs.m_144637_($$2.listOf()).fieldOf("points").forGetter(p_184272_ -> IntStream.range(0, p_184272_.f_184320_.length).mapToObj(p_184249_ -> new Point(p_184272_.f_184320_()[p_184249_], p_184272_.f_184321_().get(p_184249_), p_184272_.f_184322_()[p_184249_])).toList())).apply((Applicative)p_184267_, (p_184258_, p_184259_) -> {
            float[] $$2 = new float[p_184259_.size()];
            ImmutableList.Builder $$3 = ImmutableList.builder();
            float[] $$4 = new float[p_184259_.size()];
            for (int $$5 = 0; $$5 < p_184259_.size(); ++$$5) {
                Point $$6 = (Point)p_184259_.get($$5);
                $$2[$$5] = $$6.f_184273_();
                $$3.add($$6.f_184274_());
                $$4[$$5] = $$6.f_184275_();
            }
            return new Multipoint(p_184258_, $$2, $$3.build(), $$4);
        }));
        $$1.setValue((Object)Codec.either((Codec)Codec.FLOAT, (Codec)$$3).xmap(p_184261_ -> (CubicSpline)p_184261_.map(Constant::new, p_184246_ -> p_184246_), p_184251_ -> {
            Either either;
            if (p_184251_ instanceof Constant) {
                Constant $$1 = (Constant)p_184251_;
                either = Either.left((Object)Float.valueOf($$1.f_184308_()));
            } else {
                either = Either.right((Object)((Multipoint)p_184251_));
            }
            return either;
        }));
        return (Codec)$$1.getValue();
    }

    public static <C> CubicSpline<C> m_184239_(float p_184240_) {
        return new Constant(p_184240_);
    }

    public static <C> Builder<C> m_184252_(ToFloatFunction<C> p_184253_) {
        return new Builder<C>(p_184253_);
    }

    public static <C> Builder<C> m_184254_(ToFloatFunction<C> p_184255_, ToFloatFunction<Float> p_184256_) {
        return new Builder<C>(p_184255_, p_184256_);
    }

    @VisibleForDebug
    public record Constant<C>(float f_184308_) implements CubicSpline<C>
    {
        @Override
        public float m_183321_(C p_184313_) {
            return this.f_184308_;
        }

        @Override
        public String m_183628_() {
            return String.format("k=%.3f", Float.valueOf(this.f_184308_));
        }

        @Override
        public float m_207241_() {
            return this.f_184308_;
        }

        @Override
        public float m_207240_() {
            return this.f_184308_;
        }

        @Override
        public CubicSpline<C> m_211396_(CoordinateVisitor<C> p_211581_) {
            return this;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Constant.class, "value", "f_184308_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Constant.class, "value", "f_184308_"}, this);
        }

        @Override
        public final boolean equals(Object p_184316_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Constant.class, "value", "f_184308_"}, this, p_184316_);
        }
    }

    public static final class Builder<C> {
        private final ToFloatFunction<C> f_184287_;
        private final ToFloatFunction<Float> f_184288_;
        private final FloatList f_184289_ = new FloatArrayList();
        private final List<CubicSpline<C>> f_184290_ = Lists.newArrayList();
        private final FloatList f_184291_ = new FloatArrayList();

        protected Builder(ToFloatFunction<C> p_184293_) {
            this(p_184293_, p_184307_ -> p_184307_.floatValue());
        }

        protected Builder(ToFloatFunction<C> p_184295_, ToFloatFunction<Float> p_184296_) {
            this.f_184287_ = p_184295_;
            this.f_184288_ = p_184296_;
        }

        public Builder<C> m_184298_(float p_184299_, float p_184300_, float p_184301_) {
            return this.m_184302_(p_184299_, new Constant(this.f_184288_.m_183321_(Float.valueOf(p_184300_))), p_184301_);
        }

        public Builder<C> m_184302_(float p_184303_, CubicSpline<C> p_184304_, float p_184305_) {
            if (!this.f_184289_.isEmpty() && p_184303_ <= this.f_184289_.getFloat(this.f_184289_.size() - 1)) {
                throw new IllegalArgumentException("Please register points in ascending order");
            }
            this.f_184289_.add(p_184303_);
            this.f_184290_.add(p_184304_);
            this.f_184291_.add(p_184305_);
            return this;
        }

        public CubicSpline<C> m_184297_() {
            if (this.f_184289_.isEmpty()) {
                throw new IllegalStateException("No elements added");
            }
            return new Multipoint<C>(this.f_184287_, this.f_184289_.toFloatArray(), ImmutableList.copyOf(this.f_184290_), this.f_184291_.toFloatArray());
        }
    }

    @VisibleForDebug
    public record Multipoint<C>(ToFloatFunction<C> f_184319_, float[] f_184320_, List<CubicSpline<C>> f_184321_, float[] f_184322_) implements CubicSpline<C>
    {
        public Multipoint {
            if (f_184320_.length != f_184321_.size() || f_184320_.length != f_184322_.length) {
                throw new IllegalArgumentException("All lengths must be equal, got: " + f_184320_.length + " " + f_184321_.size() + " " + f_184322_.length);
            }
        }

        @Override
        public float m_183321_(C p_184340_) {
            float $$1 = this.f_184319_.m_183321_(p_184340_);
            int $$2 = Mth.m_14049_(0, this.f_184320_.length, p_184333_ -> $$1 < this.f_184320_[p_184333_]) - 1;
            int $$3 = this.f_184320_.length - 1;
            if ($$2 < 0) {
                return this.f_184321_.get(0).m_183321_(p_184340_) + this.f_184322_[0] * ($$1 - this.f_184320_[0]);
            }
            if ($$2 == $$3) {
                return this.f_184321_.get($$3).m_183321_(p_184340_) + this.f_184322_[$$3] * ($$1 - this.f_184320_[$$3]);
            }
            float $$4 = this.f_184320_[$$2];
            float $$5 = this.f_184320_[$$2 + 1];
            float $$6 = ($$1 - $$4) / ($$5 - $$4);
            ToFloatFunction $$7 = this.f_184321_.get($$2);
            ToFloatFunction $$8 = this.f_184321_.get($$2 + 1);
            float $$9 = this.f_184322_[$$2];
            float $$10 = this.f_184322_[$$2 + 1];
            float $$11 = $$7.m_183321_(p_184340_);
            float $$12 = $$8.m_183321_(p_184340_);
            float $$13 = $$9 * ($$5 - $$4) - ($$12 - $$11);
            float $$14 = -$$10 * ($$5 - $$4) + ($$12 - $$11);
            float $$15 = Mth.m_14179_($$6, $$11, $$12) + $$6 * (1.0f - $$6) * Mth.m_14179_($$6, $$13, $$14);
            return $$15;
        }

        @Override
        @VisibleForTesting
        public String m_183628_() {
            return "Spline{coordinate=" + this.f_184319_ + ", locations=" + this.m_184334_(this.f_184320_) + ", derivatives=" + this.m_184334_(this.f_184322_) + ", values=" + this.f_184321_.stream().map(CubicSpline::m_183628_).collect(Collectors.joining(", ", "[", "]")) + "}";
        }

        private String m_184334_(float[] p_184335_) {
            return "[" + IntStream.range(0, p_184335_.length).mapToDouble(p_184338_ -> p_184335_[p_184338_]).mapToObj(p_184330_ -> String.format(Locale.ROOT, "%.3f", p_184330_)).collect(Collectors.joining(", ")) + "]";
        }

        @Override
        public float m_207241_() {
            return (float)this.f_184321_().stream().mapToDouble(CubicSpline::m_207241_).min().orElseThrow();
        }

        @Override
        public float m_207240_() {
            return (float)this.f_184321_().stream().mapToDouble(CubicSpline::m_207240_).max().orElseThrow();
        }

        @Override
        public CubicSpline<C> m_211396_(CoordinateVisitor<C> p_211585_) {
            return new Multipoint<C>(p_211585_.m_211582_(this.f_184319_), this.f_184320_, this.f_184321_().stream().map(p_211588_ -> p_211588_.m_211396_(p_211585_)).toList(), this.f_184322_);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{Multipoint.class, "coordinate;locations;values;derivatives", "f_184319_", "f_184320_", "f_184321_", "f_184322_"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Multipoint.class, "coordinate;locations;values;derivatives", "f_184319_", "f_184320_", "f_184321_", "f_184322_"}, this);
        }

        @Override
        public final boolean equals(Object p_184346_) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Multipoint.class, "coordinate;locations;values;derivatives", "f_184319_", "f_184320_", "f_184321_", "f_184322_"}, this, p_184346_);
        }
    }

    public static interface CoordinateVisitor<C> {
        public ToFloatFunction<C> m_211582_(ToFloatFunction<C> var1);
    }
}

